/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ChiSquareDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class ChiSquareGen
extends RandomVariateGen {
    protected int n = -1;

    public ChiSquareGen(RandomStream s, int n) {
        super(s, new ChiSquareDist(n));
        this.setParams(n);
    }

    public ChiSquareGen(RandomStream s, ChiSquareDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getN());
        }
    }

    public static double nextDouble(RandomStream s, int n) {
        return ChiSquareDist.inverseF(n, s.nextDouble());
    }

    public int getN() {
        return this.n;
    }

    protected void setParams(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
    }
}

