/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.DiscreteDistributionInt;
import umontreal.ssj.util.Num;

public class HypergeometricDist
extends DiscreteDistributionInt {
    private int m;
    private int l;
    private int k;
    private double p0;
    public static double MAXN = 100000.0;

    public HypergeometricDist(int m, int l, int k) {
        this.setParams(m, l, k);
    }

    @Override
    public double prob(int x) {
        if (x < this.supportA || x > this.supportB) {
            return 0.0;
        }
        if (this.pdf == null || x < this.xmin || x > this.xmax) {
            return HypergeometricDist.prob(this.m, this.l, this.k, x);
        }
        return this.pdf[x - this.xmin];
    }

    @Override
    public double cdf(int x) {
        if (x < this.supportA) {
            return 0.0;
        }
        if (x >= this.supportB) {
            return 1.0;
        }
        if (this.cdf != null) {
            if (x >= this.xmax) {
                return 1.0;
            }
            if (x < this.xmin) {
                return HypergeometricDist.cdf(this.m, this.l, this.k, x);
            }
            if (x <= this.xmed) {
                return this.cdf[x - this.xmin];
            }
            return 1.0 - this.cdf[x + 1 - this.xmin];
        }
        return HypergeometricDist.cdf(this.m, this.l, this.k, x);
    }

    @Override
    public double barF(int x) {
        if (x <= this.supportA) {
            return 1.0;
        }
        if (x > this.supportB) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (x > this.xmax) {
                return HypergeometricDist.barF(this.m, this.l, this.k, x);
            }
            if (x <= this.xmin) {
                return 1.0;
            }
            if (x > this.xmed) {
                return this.cdf[x - this.xmin];
            }
            return 1.0 - this.cdf[x - 1 - this.xmin];
        }
        return HypergeometricDist.barF(this.m, this.l, this.k, x);
    }

    @Override
    public int inverseFInt(double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return Math.max(0, this.k - this.l + this.m);
        }
        if (u >= 1.0) {
            return Math.min(this.k, this.m);
        }
        double p = this.p0;
        int x = Math.max(0, this.k - this.l + this.m);
        if (u <= p) {
            return x;
        }
        do {
            p = p * (double)(this.m - x) * (double)(this.k - x) / ((double)(x + 1) * ((double)(this.l - this.m - this.k) + 1.0 + (double)x));
            ++x;
        } while ((u -= p) > p);
        return x;
    }

    @Override
    public double getMean() {
        return HypergeometricDist.getMean(this.m, this.l, this.k);
    }

    @Override
    public double getVariance() {
        return HypergeometricDist.getVariance(this.m, this.l, this.k);
    }

    @Override
    public double getStandardDeviation() {
        return HypergeometricDist.getStandardDeviation(this.m, this.l, this.k);
    }

    public static double prob(int m, int l, int k, int x) {
        int SLIM = 70;
        double MAXEXP = 709.0895657128241;
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1 <= m < l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1 <= k < l");
        }
        if (x < Math.max(0, k - l + m) || x > Math.min(k, m)) {
            return 0.0;
        }
        if (l <= 70) {
            return Num.combination(m, x) * Num.combination(l - m, k - x) / Num.combination(l, k);
        }
        double res = Num.lnFactorial(m) + Num.lnFactorial(l - m) - Num.lnFactorial(l) - Num.lnFactorial(x) - Num.lnFactorial(k - x) + Num.lnFactorial(k) - Num.lnFactorial(m - x) - Num.lnFactorial(l - m - k + x) + Num.lnFactorial(l - k);
        if (res >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        return Math.exp(res);
    }

    public static double cdf(int m, int l, int k, int x) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1 <= m < l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1 <= k < l");
        }
        int imin = Math.max(0, k - l + m);
        int imax = Math.min(k, m);
        if (x < imin) {
            return 0.0;
        }
        if (x >= imax) {
            return 1.0;
        }
        double res = 0.0;
        for (int i = imin; i <= x; ++i) {
            res += HypergeometricDist.prob(m, l, k, i);
        }
        if (res >= 1.0) {
            return 1.0;
        }
        return res;
    }

    public static double barF(int m, int l, int k, int x) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1 < =m < l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1 < =k < l");
        }
        int imin = Math.max(0, k - l + m);
        int imax = Math.min(k, m);
        if (x <= imin) {
            return 1.0;
        }
        if (x > imax) {
            return 0.0;
        }
        double res = 0.0;
        for (int i = imax; i >= x; --i) {
            res += HypergeometricDist.prob(m, l, k, i);
        }
        if (res >= 1.0) {
            return 1.0;
        }
        return res;
    }

    public static int inverseF(int m, int l, int k, double u) {
        if (u < 0.0 || u >= 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return Math.max(0, k - l + m);
        }
        if (u >= 1.0) {
            return Math.min(k, m);
        }
        double p = 0.0;
        p = k < l - m ? Math.exp(Num.lnFactorial(l - m) + Num.lnFactorial(l - k) - Num.lnFactorial(l) - Num.lnFactorial(l - m - k)) : Math.exp(Num.lnFactorial(m) + Num.lnFactorial(k) - Num.lnFactorial(k - l + m) - Num.lnFactorial(l));
        int x = Math.max(0, k - l + m);
        if (u <= p) {
            return x;
        }
        do {
            p = p * (double)(m - x) * (double)(k - x) / ((double)(x + 1) * ((double)(l - m - k) + 1.0 + (double)x));
            ++x;
        } while ((u -= p) > p && p > 0.0);
        return x;
    }

    public static double getMean(int m, int l, int k) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        return (double)k * (double)m / (double)l;
    }

    public static double getVariance(int m, int l, int k) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1<=m<l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1<=k<l");
        }
        return (double)k * (double)m / (double)l * (1.0 - (double)m / (double)l) * ((double)l - (double)k) / ((double)l - 1.0);
    }

    public static double getStandardDeviation(int m, int l, int k) {
        return Math.sqrt(HypergeometricDist.getVariance(m, l, k));
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public int getK() {
        return this.k;
    }

    private void setHypergeometric() {
        int i;
        int imin = Math.max(0, this.k - this.l + this.m);
        int imax = Math.min(this.k, this.m);
        this.supportA = imin;
        this.supportB = imax;
        int ns = imax - imin + 1;
        if ((double)ns > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int offset = imin;
        imin = 0;
        imax -= offset;
        double[] P = new double[ns];
        double[] F = new double[ns];
        int mode = (int)(((double)this.k + 1.0) * ((double)this.m + 1.0) / ((double)this.l + 2.0));
        int imid = mode - offset;
        P[imid] = HypergeometricDist.prob(this.m, this.l, this.k, mode);
        for (i = imid; i > imin && Math.abs(P[i]) > EPSILON; --i) {
            P[i - 1] = P[i] * (double)(i + offset) / (double)(this.m - i - offset + 1) * (double)(this.l - this.m - this.k + i + offset) / (double)(this.k - i - offset + 1);
        }
        imin = i;
        for (i = imid; i < imax && Math.abs(P[i]) > EPSILON; ++i) {
            P[i + 1] = P[i] * (double)(this.m - i - offset) / (double)(i + offset + 1) * (double)(this.k - i - offset) / (double)(this.l - this.m - this.k + i + offset + 1);
        }
        imax = i;
        F[imin] = P[imin];
        i = imin;
        while (i < imax && F[i] < 0.5) {
            F[++i] = F[i - 1] + P[i];
        }
        this.xmed = i;
        F[imax] = P[imax];
        for (i = imax - 1; i > this.xmed; --i) {
            F[i] = P[i] + F[i + 1];
        }
        this.xmin = imin + offset;
        this.xmax = imax + offset;
        this.xmed += offset;
        this.pdf = new double[imax + 1 - imin];
        this.cdf = new double[imax + 1 - imin];
        System.arraycopy(P, imin, this.pdf, 0, imax + 1 - imin);
        System.arraycopy(F, imin, this.cdf, 0, imax + 1 - imin);
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.m, this.l, this.k};
        return retour;
    }

    public void setParams(int m, int l, int k) {
        if (l <= 0) {
            throw new IllegalArgumentException("l must be greater than 0");
        }
        if (m <= 0 || m > l) {
            throw new IllegalArgumentException("m is invalid: 1 <= m < l");
        }
        if (k <= 0 || k > l) {
            throw new IllegalArgumentException("k is invalid: 1 <= k < l");
        }
        this.m = m;
        this.l = l;
        this.k = k;
        this.setHypergeometric();
        this.p0 = k < l - m ? Math.exp(Num.lnFactorial(l - m) + Num.lnFactorial(l - k) - Num.lnFactorial(l) - Num.lnFactorial(l - m - k)) : Math.exp(Num.lnFactorial(m) + Num.lnFactorial(k) - Num.lnFactorial(k - l + m) - Num.lnFactorial(l));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : m = " + this.m + ", l = " + this.l + ", k = " + this.k;
    }
}

