/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.mcqmctools.anova.CoordinateSet;
import umontreal.ssj.stat.Tally;

public class PartialVariance
extends Tally
implements Comparable<PartialVariance> {
    protected CoordinateSet coords;
    protected Tally totalVar;

    protected PartialVariance(CoordinateSet coords) {
        this(coords, null);
    }

    protected PartialVariance(CoordinateSet coords, Tally totalVar) {
        super("variance for coordinates " + coords);
        this.coords = coords;
        this.totalVar = totalVar;
    }

    public CoordinateSet getCoordinates() {
        return this.coords;
    }

    public double sensitivityIndex() {
        if (this.totalVar == null) {
            throw new IllegalStateException("trying to access the sensitivity index without a reference to the total variance");
        }
        return this.average() / this.totalVar.average();
    }

    @Override
    public int compareTo(PartialVariance var) {
        double vx;
        double v = this.average();
        return v > (vx = var.average()) ? 1 : (v < vx ? -1 : 0);
    }

    public String toString() {
        double varFrac;
        String s = String.format("%30s: %9.4g", this.coords.toString(), this.average());
        if (this.numberObs() > 1) {
            double dvar = Math.sqrt(this.variance() / (double)this.numberObs());
            s = s + String.format(" \u00b1 %.2g", dvar);
        }
        if (this.totalVar != null && (varFrac = this.sensitivityIndex()) >= 0.0) {
            s = s + String.format("  (%.4g %%)", 100.0 * varFrac);
        }
        return s;
    }
}

