/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import umontreal.ssj.hups.DigitalSequenceBase2;
import umontreal.ssj.util.PrintfFormat;

public class NiedXingSequenceBase2
extends DigitalSequenceBase2 {
    private static final int MAXDIM = 32;
    private static final int NUMCOLS = 30;
    private static final boolean isTrans = true;
    private static int[] NiedXingMat;
    private static int[] NiedXingMatTrans;
    private static final int MAXN = 15660;

    public NiedXingSequenceBase2(int k, int w, int dim) {
        this.init(k, w, w, dim);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Niederreiter-Xing sequence:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    private void init(int k, int r, int w, int dim) {
        if (dim < 1 || dim > 32) {
            throw new IllegalArgumentException("Dimension for NiedXingSequenceBase2 must be > 1 and <= 32");
        }
        if (r < k || w < r || w > 31 || k >= 31) {
            throw new IllegalArgumentException("One must have k < 31 and k <= r <= w <= 31 for NiedXingSequenceBase2");
        }
        this.numCols = k;
        this.numRows = r;
        this.outDigits = w;
        this.numPoints = 1 << k;
        this.dim = dim;
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
        this.genMat = new int[dim * this.numCols];
        this.initGenMat();
    }

    @Override
    public void extendSequence(int k) {
        this.init(k, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        int start = this.dim <= 4 ? 0 : (this.dim * (this.dim - 1) / 2 - 6) * 30;
        for (int j = 0; j < this.dim; ++j) {
            for (int c = 0; c < this.numCols; ++c) {
                long x = NiedXingMatTrans[start + j * 30 + c];
                this.genMat[j * this.numCols + c] = (int)((x <<= 1) >> 31 - this.outDigits);
            }
        }
    }

    static {
        NiedXingMatTrans = new int[15660];
        try {
            InputStream is = NiedXingSequenceBase2.class.getClassLoader().getResourceAsStream("umontreal/ssj/hups/dataSer/Nieder/NiedXingSequenceBase2Trans.ser");
            if (is == null) {
                throw new FileNotFoundException("Cannot find NiedXingSequenceBase2Trans.ser");
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            NiedXingMatTrans = (int[])ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

