/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.util.PrintfFormat;

public class TallyHistogram
extends Tally {
    protected int numBins;
    protected int[] count;
    protected int leftCount;
    protected int rightCount;
    protected double m_h;
    protected double m_a;
    protected double m_b;

    public TallyHistogram(double a, double b, int numBins) {
        this.init(a, b, numBins);
    }

    public TallyHistogram(String name, double a, double b, int numBins) {
        super(name);
        this.init(a, b, numBins);
    }

    public void init(double a, double b, int numBins) {
        super.init();
        if (b <= a) {
            throw new IllegalArgumentException("   b <= a");
        }
        this.count = new int[numBins];
        this.numBins = numBins;
        this.m_h = (b - a) / (double)numBins;
        this.m_a = a;
        this.m_b = b;
        this.rightCount = 0;
        this.leftCount = 0;
        for (int i = 0; i < numBins; ++i) {
            this.count[i] = 0;
        }
    }

    @Override
    public void init() {
        super.init();
        this.rightCount = 0;
        this.leftCount = 0;
        for (int i = 0; i < this.numBins; ++i) {
            this.count[i] = 0;
        }
    }

    public void fillFromArray(double[] obs, int numObs) {
        this.init();
        for (int i = 0; i < numObs; ++i) {
            this.add(obs[i]);
        }
    }

    public void fillFromArray(double[] obs) {
        this.fillFromArray(obs, obs.length);
    }

    public void fillFromTallyStore(TallyStore ts) {
        this.fillFromArray(ts.getArray(), ts.numberObs());
    }

    @Override
    public void add(double x) {
        super.add(x);
        if (x < this.m_a) {
            ++this.leftCount;
        } else if (x > this.m_b) {
            ++this.rightCount;
        } else {
            int i;
            int n = i = (int)((x - this.m_a) / this.m_h);
            this.count[n] = this.count[n] + 1;
        }
    }

    public TallyHistogram trimHistogram() {
        TallyHistogram image = (TallyHistogram)super.clone();
        int i = 0;
        int j = this.numBins - 1;
        int cpL = 0;
        int cpR = 0;
        while (this.count[i] == 0) {
            ++i;
            ++cpL;
        }
        while (this.count[j] == 0) {
            --j;
            ++cpR;
        }
        int[] coco = new int[this.numBins - cpL - cpR];
        System.arraycopy(this.count, i, coco, 0, j - i + 1);
        image.count = coco;
        image.m_h = this.m_h;
        image.m_a = this.m_a + (double)cpL * this.m_h;
        image.m_b = this.m_b - (double)cpR * this.m_h;
        image.numBins = this.numBins - cpL - cpR;
        image.leftCount = this.leftCount;
        image.rightCount = this.rightCount;
        return image;
    }

    public TallyHistogram addHistograms(TallyHistogram other) {
        if (this.numBins != other.numBins) {
            throw new IllegalArgumentException("different number of bin in two histogram to merge");
        }
        TallyHistogram image = (TallyHistogram)super.clone();
        int[] countNew = new int[this.numBins];
        System.arraycopy(this.count, 0, countNew, 0, this.numBins);
        int[] coOther = other.getCounters();
        for (int i = 0; i < countNew.length; ++i) {
            countNew[i] = countNew[i] + coOther[i];
        }
        image.count = countNew;
        image.leftCount = this.leftCount + other.leftCount;
        image.rightCount = this.rightCount + other.rightCount;
        image.m_h = this.m_h;
        image.m_a = this.m_a;
        image.m_b = this.m_b;
        image.numBins = this.numBins;
        return image;
    }

    public TallyHistogram aggregateBins(int g) {
        TallyHistogram image = (TallyHistogram)super.clone();
        int numBinsNew = (int)Math.ceil((double)this.numBins / (double)g);
        int[] countNew = new int[numBinsNew];
        int b = 0;
        for (int j = 0; j < numBinsNew - 1; ++j) {
            for (int i = b; i < b + g; ++i) {
                int n = j;
                countNew[n] = countNew[n] + this.count[i];
            }
            b += g;
        }
        while (b < this.numBins - 1) {
            int n = numBinsNew - 1;
            countNew[n] = countNew[n] + this.count[b];
            ++b;
        }
        image.count = countNew;
        image.m_h = this.m_h * (double)g;
        image.m_a = this.m_a;
        image.m_b = this.m_h * (double)numBinsNew;
        image.numBins = numBinsNew;
        image.leftCount = this.leftCount;
        image.rightCount = this.rightCount;
        return image;
    }

    public int[] getCounters() {
        return this.count;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getA() {
        return this.m_a;
    }

    public double getB() {
        return this.m_b;
    }

    public double getH() {
        return this.m_h;
    }

    @Override
    public TallyHistogram clone() {
        TallyHistogram image = (TallyHistogram)super.clone();
        int[] coco = new int[this.numBins];
        System.arraycopy(this.count, 0, coco, 0, this.numBins);
        image.count = coco;
        image.leftCount = this.leftCount;
        image.rightCount = this.rightCount;
        image.m_h = this.m_h;
        image.m_a = this.m_a;
        image.m_b = this.m_b;
        image.numBins = this.numBins;
        return image;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("---------------------------------------" + PrintfFormat.NEWLINE);
        sb.append(this.name + PrintfFormat.NEWLINE);
        sb.append("Interval = [ " + this.m_a + ", " + this.m_b + " ]" + PrintfFormat.NEWLINE);
        sb.append("Number of bins = " + this.numBins + PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.NEWLINE + "Counters = {" + PrintfFormat.NEWLINE);
        sb.append("   (-inf, " + PrintfFormat.f(6, 3, this.m_a) + ")    " + this.leftCount + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.numBins; ++i) {
            double a = this.m_a + (double)(i - 1) * this.m_h;
            double b = this.m_a + (double)i * this.m_h;
            sb.append("   (" + PrintfFormat.f(6, 3, a) + ", " + PrintfFormat.f(6, 3, b) + ")    " + this.count[i] + PrintfFormat.NEWLINE);
        }
        sb.append("   (" + PrintfFormat.f(6, 3, this.m_b) + ", inf)    " + this.rightCount + PrintfFormat.NEWLINE);
        sb.append("}" + PrintfFormat.NEWLINE);
        return sb.toString();
    }
}

