/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functions;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.functions.MathFunctionUtil;
import umontreal.ssj.functions.MathFunctionWithDerivative;
import umontreal.ssj.functions.MathFunctionWithFirstDerivative;
import umontreal.ssj.functions.MathFunctionWithIntegral;

public class ShiftedMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    MathFunction func;
    double delta;

    public ShiftedMathFunction(MathFunction func, double delta) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = func;
        this.delta = delta;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getDelta() {
        return this.delta;
    }

    @Override
    public double evaluate(double x) {
        return this.func.evaluate(x) - this.delta;
    }

    @Override
    public double derivative(double x) {
        return MathFunctionUtil.derivative(this.func, x);
    }

    @Override
    public double derivative(double x, int n) {
        return MathFunctionUtil.derivative(this.func, x, n);
    }

    @Override
    public double integral(double a, double b) {
        return MathFunctionUtil.integral(this.func, a, b) - (b - a) * this.getDelta();
    }
}

