/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.DiscShift2;
import umontreal.ssj.hups.Rank1Lattice;

public class DiscShift2Lattice
extends DiscShift2 {
    public DiscShift2Lattice(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShift2Lattice(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShift2Lattice(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShift2Lattice(Rank1Lattice set) {
        super(set);
    }

    public DiscShift2Lattice() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShift2Lattice.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double[] C1 = new double[s];
        double[] C2 = new double[s];
        DiscShift2Lattice.setC(C1, C2, gamma, s);
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int r = 0; r < s; ++r) {
                double u = points[i][r];
                double pol1 = u * (u - 1.0) + 0.16666666666666666;
                double pol2 = ((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333;
                prod *= 1.0 + C1[r] * pol1 - C2[r] * pol2;
            }
            sum += prod;
        }
        double disc = sum / (double)n - 1.0;
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        return this.compute(T, n, 1.0);
    }

    @Override
    public double compute(double[] T, int n, double gamma) {
        double[] C = DiscShift2Lattice.setC(gamma);
        double C1 = C[0];
        double C2 = C[1];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double u = T[i];
            double pol1 = u * (u - 1.0) + 0.16666666666666666;
            double pol2 = ((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333;
            sum += C1 * pol1 - C2 * pol2;
        }
        double disc = sum / (double)n;
        if (disc <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(disc);
    }
}

