/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jfree.data.xy.XYSeriesCollection;

public class PlotFormat {
    private PlotFormat() {
    }

    public static double[][] fromGNUPlot(String data) {
        int maxLineNumber = 16;
        int columnNumber = 0;
        int lineNumber = 0;
        double[][] retour = new double[1][1];
        Pattern p = Pattern.compile("\\n\\n*");
        String[] string = p.split(data);
        for (int j = 0; j < string.length; ++j) {
            int i;
            if (string[j].charAt(0) == '#' || string[j].length() == 0) continue;
            p = Pattern.compile("\\s\\s*");
            String[] result = p.split(string[j]);
            double[] line = new double[result.length];
            int k = 0;
            for (i = 0; i < result.length; ++i) {
                try {
                    line[k] = Double.valueOf(result[i]);
                    ++k;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (k == 0) continue;
            if (lineNumber == 0) {
                columnNumber = k;
                retour = new double[columnNumber][maxLineNumber];
            } else if (columnNumber != k) {
                throw new IllegalArgumentException("Each line must have the same number of values");
            }
            if (lineNumber >= maxLineNumber) {
                double[][] temp = new double[columnNumber][maxLineNumber *= 2];
                for (int i2 = 0; i2 < columnNumber; ++i2) {
                    for (int l = 0; l < retour[0].length; ++l) {
                        temp[i2][l] = retour[i2][l];
                    }
                }
                retour = temp;
            }
            for (i = 0; i < columnNumber; ++i) {
                retour[i][lineNumber] = line[i];
            }
            ++lineNumber;
        }
        double[][] temp = columnNumber == 0 ? (double[][])null : new double[columnNumber][lineNumber];
        for (int i = 0; i < columnNumber; ++i) {
            for (int l = 0; l < lineNumber; ++l) {
                temp[i][l] = retour[i][l];
            }
        }
        retour = null;
        return temp;
    }

    public static double[][] fromCSV(String data) {
        int maxLineNumber = 16;
        int columnNumber = 0;
        int lineNumber = 0;
        double[][] retour = new double[1][1];
        Pattern p = Pattern.compile("\\n\\n*");
        String[] string = p.split(data);
        for (int j = 0; j < string.length; ++j) {
            int i;
            if (string[j].length() == 0) continue;
            p = Pattern.compile(",,*");
            String[] result = p.split(string[j]);
            double[] line = new double[result.length];
            int k = 0;
            for (i = 0; i < result.length; ++i) {
                try {
                    line[k] = Double.valueOf(result[i]);
                    ++k;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (k == 0) continue;
            if (lineNumber == 0) {
                columnNumber = k;
                retour = new double[columnNumber][maxLineNumber];
            } else if (columnNumber != k) {
                throw new IllegalArgumentException("Each line must have the same number of values");
            }
            if (lineNumber >= maxLineNumber) {
                double[][] temp = new double[columnNumber][maxLineNumber *= 2];
                for (int i2 = 0; i2 < columnNumber; ++i2) {
                    for (int l = 0; l < retour[0].length; ++l) {
                        temp[i2][l] = retour[i2][l];
                    }
                }
                retour = temp;
            }
            for (i = 0; i < columnNumber; ++i) {
                retour[i][lineNumber] = line[i];
            }
            ++lineNumber;
        }
        double[][] temp = columnNumber == 0 ? (double[][])null : new double[columnNumber][lineNumber];
        for (int i = 0; i < columnNumber; ++i) {
            for (int l = 0; l < lineNumber; ++l) {
                temp[i][l] = retour[i][l];
            }
        }
        retour = null;
        return temp;
    }

    public static double[][] fromCustomizedFormat(String betweenValues, String endLine, String data) {
        int maxLineNumber = 16;
        int columnNumber = 0;
        int lineNumber = 0;
        double[][] retour = new double[1][1];
        Pattern p = Pattern.compile("(" + endLine + ")(" + endLine + ")*");
        String[] string = p.split(data);
        for (int j = 0; j < string.length; ++j) {
            int i;
            if (string[j].length() == 0) continue;
            p = Pattern.compile("(" + betweenValues + ")(" + betweenValues + ")*");
            String[] result = p.split(string[j]);
            double[] line = new double[result.length];
            int k = 0;
            for (i = 0; i < result.length; ++i) {
                try {
                    line[k] = Double.valueOf(result[i]);
                    ++k;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (k == 0) continue;
            if (lineNumber == 0) {
                columnNumber = k;
                retour = new double[columnNumber][maxLineNumber];
            } else if (columnNumber != k) {
                throw new IllegalArgumentException("Each line must have the same number of values");
            }
            if (lineNumber >= maxLineNumber) {
                double[][] temp = new double[columnNumber][maxLineNumber *= 2];
                for (int i2 = 0; i2 < columnNumber; ++i2) {
                    for (int l = 0; l < retour[0].length; ++l) {
                        temp[i2][l] = retour[i2][l];
                    }
                }
                retour = temp;
            }
            for (i = 0; i < columnNumber; ++i) {
                retour[i][lineNumber] = line[i];
            }
            ++lineNumber;
        }
        double[][] temp = columnNumber == 0 ? (double[][])null : new double[columnNumber][lineNumber];
        for (int i = 0; i < columnNumber; ++i) {
            for (int l = 0; l < lineNumber; ++l) {
                temp[i][l] = retour[i][l];
            }
        }
        retour = null;
        return temp;
    }

    public static String toGNUPlot(double[] ... data) {
        PlotFormat.checkData(data);
        Formatter formatter = new Formatter(Locale.US);
        for (int i = 0; i < data[0].length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                formatter.format("%20f", data[j][i]);
            }
            formatter.format("%n", new Object[0]);
        }
        formatter.format("%n%n", new Object[0]);
        return formatter.toString();
    }

    public static String toGNUPlot(XYSeriesCollection data) {
        return PlotFormat.toGNUPlot(PlotFormat.toTable(data));
    }

    public static String toCSV(double[] ... data) {
        PlotFormat.checkData(data);
        Formatter formatter = new Formatter(Locale.US);
        for (int i = 0; i < data[0].length; ++i) {
            for (int j = 0; j < data.length - 1; ++j) {
                formatter.format("%-20f, ", data[j][i]);
            }
            formatter.format("%-20f%n", data[data.length - 1][i]);
        }
        formatter.format("%n", new Object[0]);
        return formatter.toString();
    }

    public static String toCSV(XYSeriesCollection data) {
        return PlotFormat.toCSV(PlotFormat.toTable(data));
    }

    public static String toCustomizedFormat(String heading, String footer, String betweenValues, String endLine, int precision, double[] ... data) {
        PlotFormat.checkData(data);
        Formatter formatter = new Formatter(Locale.US);
        String myString = "%20." + precision + "f";
        formatter.format("%s", heading);
        for (int i = 0; i < data[0].length; ++i) {
            for (int j = 0; j < data.length - 1; ++j) {
                formatter.format(myString + "%s", data[j][i], betweenValues);
            }
            formatter.format(myString + "%s", data[data.length - 1][i], endLine);
        }
        formatter.format("%s", footer);
        return formatter.toString();
    }

    public static String toCustomizedFormat(String heading, String footer, String betweenValues, String endLine, int precision, XYSeriesCollection data) {
        return PlotFormat.toCustomizedFormat(heading, footer, betweenValues, endLine, precision, PlotFormat.toTable(data));
    }

    private static double[][] toTable(XYSeriesCollection data) {
        double[][] transform = new double[data.getSeriesCount() * 2][];
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            double[][] temp = data.getSeries(i).toArray();
            transform[2 * i] = temp[0];
            transform[2 * i + 1] = temp[1];
        }
        return transform;
    }

    private static void checkData(double[] ... data) {
        for (int i = 0; i < data.length - 1; ++i) {
            if (data[i].length == data[i + 1].length) continue;
            throw new IllegalArgumentException("Data tables " + i + " and " + (i + 1) + " must share the same length");
        }
    }
}

