/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import javax.swing.JFrame;
import org.jfree.chart.JFreeChart;
import umontreal.ssj.charts.Axis;
import umontreal.ssj.charts.SSJCategorySeriesCollection;

public abstract class CategoryChart {
    protected Axis YAxis;
    protected SSJCategorySeriesCollection dataset;
    protected JFreeChart chart;
    protected boolean latexDocFlag = true;
    protected boolean autoRange;
    protected double[] manualRange;
    protected boolean grid = false;
    protected double ystepGrid;
    protected final double BOR = 0.1;

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public Axis getYAxis() {
        return this.YAxis;
    }

    public abstract JFrame view(int var1, int var2);

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setAutoRange() {
        this.autoRange = true;
        double BorneMin = Math.abs(this.dataset.getRangeBounds()[0]);
        double BorneMax = Math.abs(this.dataset.getRangeBounds()[1]);
        double max = Math.max(BorneMin, BorneMax) * 0.1;
        this.YAxis.getAxis().setLowerBound(BorneMin - max);
        this.YAxis.getAxis().setUpperBound(BorneMax + max);
        this.YAxis.setLabelsAuto();
    }

    private void setManualRange(double[] range) {
        if (range.length != 2) {
            throw new IllegalArgumentException("range must have the format: [ymin, ymax]");
        }
        this.autoRange = false;
        this.YAxis.getAxis().setLowerBound(Math.min(range[0], range[1]));
        this.YAxis.getAxis().setUpperBound(Math.max(range[0], range[1]));
    }

    public void enableGrid(double xstep, double ystep) {
        this.grid = true;
        this.ystepGrid = ystep;
    }

    public void disableGrid() {
        this.grid = false;
    }

    public abstract String toLatex(double var1, double var3);

    public void setLatexDocFlag(boolean flag) {
        this.latexDocFlag = flag;
    }

    protected double computeYScale(double position) {
        double[] bounds = new double[]{this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeScale(double[] bounds) {
        int tenPowerRatio = 0;
        while (bounds[1] > 1000.0 || bounds[0] < -1000.0) {
            bounds[1] = bounds[1] / 10.0;
            bounds[0] = bounds[0] / 10.0;
            ++tenPowerRatio;
        }
        while (bounds[1] < 100.0 && bounds[0] > -100.0) {
            bounds[1] = bounds[1] * 10.0;
            bounds[0] = bounds[0] * 10.0;
            --tenPowerRatio;
        }
        return 1.0 / Math.pow(10.0, tenPowerRatio);
    }
}

