/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvarmulti;

import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.randvar.GammaAcceptanceRejectionGen;
import umontreal.ssj.randvarmulti.RandomMultivariateGen;
import umontreal.ssj.rng.RandomStream;

public class DirichletGen
extends RandomMultivariateGen {
    private GammaAcceptanceRejectionGen[] ggens;
    private double[] alphas;
    private static final double ALPHA_THRESHOLD = 0.1;
    private boolean useLogGamma = false;

    public DirichletGen(RandomStream stream, double[] alphas) {
        if (stream == null) {
            throw new NullPointerException("stream is null");
        }
        this.stream = stream;
        this.dimension = alphas.length;
        this.ggens = new GammaAcceptanceRejectionGen[alphas.length];
        for (int k = 0; k < alphas.length; ++k) {
            this.ggens[k] = new GammaAcceptanceRejectionGen(stream, new GammaDist(alphas[k], 0.5));
        }
        this.alphas = new double[alphas.length];
        System.arraycopy(alphas, 0, this.alphas, 0, alphas.length);
        this.useLogGamma = DirichletGen.canUseLogGamma(alphas);
    }

    public double getAlpha(int i) {
        return this.alphas[i];
    }

    public static void nextPoint(RandomStream stream, double[] alphas, double[] p) {
        int i;
        if (DirichletGen.canUseLogGamma(alphas)) {
            DirichletGen.nextPointUsingLog(stream, alphas, p);
            return;
        }
        double total = 0.0;
        for (i = 0; i < alphas.length; ++i) {
            p[i] = GammaAcceptanceRejectionGen.nextDouble(stream, stream, alphas[i], 0.5);
            total += p[i];
        }
        i = 0;
        while (i < alphas.length) {
            int n = i++;
            p[n] = p[n] / total;
        }
    }

    @Override
    public void nextPoint(double[] p) {
        int i;
        if (this.useLogGamma) {
            DirichletGen.nextPointUsingLog(this.stream, this.alphas, p);
            return;
        }
        int n = this.ggens.length;
        double total = 0.0;
        for (i = 0; i < n; ++i) {
            p[i] = this.ggens[i].nextDouble();
            total += p[i];
        }
        i = 0;
        while (i < n) {
            int n2 = i++;
            p[n2] = p[n2] / total;
        }
    }

    private static void nextPointUsingLog(RandomStream stream, double[] alphas, double[] p) {
        int i;
        double total = 0.0;
        double[] log = new double[p.length];
        for (i = 0; i < alphas.length; ++i) {
            log[i] = GammaAcceptanceRejectionGen.nextDoubleLog(stream, stream, alphas[i], 0.5);
        }
        for (i = 0; i < alphas.length; ++i) {
            total = 0.0;
            for (int j = 0; j < alphas.length; ++j) {
                total += Math.exp(log[j] - log[i]);
            }
            p[i] = 1.0 / total;
        }
    }

    private static boolean canUseLogGamma(double[] alphas) {
        for (int i = 0; i < alphas.length; ++i) {
            if (!(alphas[i] >= 0.1)) continue;
            return false;
        }
        return true;
    }
}

