/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public abstract class SSJCategorySeriesCollection {
    protected CategoryItemRenderer renderer;
    protected CategoryDataset seriesCollection;

    public String getCategory(int series) {
        return this.seriesCollection.getColumnKey(series).toString();
    }

    public double getValue(int series, int index) {
        return (Double)this.seriesCollection.getValue(series, index);
    }

    public CategoryDataset getSeriesCollection() {
        return this.seriesCollection;
    }

    public abstract double[] getRangeBounds();

    public abstract String toString();

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer renderer) {
        this.renderer = renderer;
    }

    public Color getColor(int series) {
        return (Color)this.renderer.getSeriesPaint(series);
    }

    public void setColor(int series, Color color) {
        this.renderer.setSeriesPaint(series, (Paint)color);
    }

    public abstract String toLatex(double var1, double var3, double var5, double var7);

    protected static String detectXColorClassic(Color color) {
        Object retour = null;
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        if (red == Color.GREEN.getRed() && blue == Color.GREEN.getBlue() && green == Color.GREEN.getGreen()) {
            return "green";
        }
        if (red == Color.RED.getRed() && blue == Color.RED.getBlue() && green == Color.RED.getGreen()) {
            return "red";
        }
        if (red == Color.WHITE.getRed() && blue == Color.WHITE.getBlue() && green == Color.WHITE.getGreen()) {
            return "white";
        }
        if (red == Color.GRAY.getRed() && blue == Color.GRAY.getBlue() && green == Color.GRAY.getGreen()) {
            return "gray";
        }
        if (red == Color.BLACK.getRed() && blue == Color.BLACK.getBlue() && green == Color.BLACK.getGreen()) {
            return "black";
        }
        if (red == Color.YELLOW.getRed() && blue == Color.YELLOW.getBlue() && green == Color.YELLOW.getGreen()) {
            return "yellow";
        }
        if (red == Color.MAGENTA.getRed() && blue == Color.MAGENTA.getBlue() && green == Color.MAGENTA.getGreen()) {
            return "magenta";
        }
        if (red == Color.CYAN.getRed() && blue == Color.CYAN.getBlue() && green == Color.CYAN.getGreen()) {
            return "cyan";
        }
        if (red == Color.BLUE.getRed() && blue == Color.BLUE.getBlue() && green == Color.BLUE.getGreen()) {
            return "blue";
        }
        if (red == Color.DARK_GRAY.getRed() && blue == Color.DARK_GRAY.getBlue() && green == Color.DARK_GRAY.getGreen()) {
            return "darkgray";
        }
        if (red == Color.LIGHT_GRAY.getRed() && blue == Color.LIGHT_GRAY.getBlue() && green == Color.LIGHT_GRAY.getGreen()) {
            return "lightgray";
        }
        if (red == Color.ORANGE.getRed() && blue == Color.ORANGE.getBlue() && green == Color.ORANGE.getGreen()) {
            return "orange";
        }
        if (red == Color.PINK.getRed() && blue == Color.PINK.getBlue() && green == Color.PINK.getGreen()) {
            return "pink";
        }
        if (red == 192 && blue == 128 && green == 64) {
            return "brown";
        }
        if (red == 128 && blue == 128 && green == 0) {
            return "olive";
        }
        if (red == 128 && blue == 0 && green == 128) {
            return "violet";
        }
        if (red == 192 && blue == 0 && green == 64) {
            return "purple";
        }
        return null;
    }

    protected static Color getDefaultColor(int index) {
        if (index % 6 == 0) {
            return Color.RED;
        }
        if (index % 6 == 1) {
            return Color.BLUE;
        }
        if (index % 6 == 2) {
            return Color.GREEN;
        }
        if (index % 6 == 3) {
            return Color.YELLOW;
        }
        if (index % 6 == 4) {
            return Color.MAGENTA;
        }
        return Color.CYAN;
    }

    protected static double max(double[] t) {
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] > aux)) continue;
            aux = t[i];
        }
        return aux;
    }

    protected static double min(double[] t) {
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] < aux)) continue;
            aux = t[i];
        }
        return aux;
    }
}

