/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXA
extends AbstractSegment {
    public RXA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Give Sub-ID Counter");
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Administration Sub-ID Counter");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time Start of Administration");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time End of Administration");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Administered Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Administered Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Dosage Form");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(XCN.class, false, 1, 200, new Object[]{this.getMessage()}, "Administering Provider");
            this.add(CM_LA1.class, false, 1, 200, new Object[]{this.getMessage()}, "Administered-at Location");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Administered Per (Time Unit)");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Administered Strength");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Strength Units");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Substance Refusal Reason");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Indication");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(322)}, "Completion Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(323)}, "Action Code-RXA");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "System Entry Date/Time");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getGiveSubIDCounter() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getRxa1_GiveSubIDCounter() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getAdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxa2_AdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimeStartOfAdministration() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getRxa3_DateTimeStartOfAdministration() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getDateTimeEndOfAdministration() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getRxa4_DateTimeEndOfAdministration() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAdministeredCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxa5_AdministeredCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getAdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxa6_AdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAdministeredUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRxa7_AdministeredUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAdministeredDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRxa8_AdministeredDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE[] getAdministrationNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxa9_AdministrationNotes() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public int getAdministrationNotesReps() {
        return this.getReps(9);
    }

    public CE getAdministrationNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getRxa9_AdministrationNotes(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxa9_AdministrationNotesReps() {
        return this.getReps(9);
    }

    public CE insertAdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertRxa9_AdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeAdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeRxa9_AdministrationNotes(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public XCN getAdministeringProvider() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public XCN getRxa10_AdministeringProvider() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_LA1 getAdministeredAtLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_LA1 getRxa11_AdministeredAtLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getAdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRxa12_AdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getAdministeredStrength() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getRxa13_AdministeredStrength() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getAdministeredStrengthUnits() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getRxa14_AdministeredStrengthUnits() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(15, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getRxa15_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(15, (Type[])new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(15);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public ST getRxa15_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRxa15_SubstanceLotNumberReps() {
        return this.getReps(15);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST insertRxa15_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ST removeRxa15_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public TS[] getSubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(16, (Type[])new TS[0]);
        return retVal;
    }

    public TS[] getRxa16_SubstanceExpirationDate() {
        TS[] retVal = (TS[])this.getTypedField(16, (Type[])new TS[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(16);
    }

    public TS getSubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(16, rep);
        return retVal;
    }

    public TS getRxa16_SubstanceExpirationDate(int rep) {
        TS retVal = (TS)this.getTypedField(16, rep);
        return retVal;
    }

    public int getRxa16_SubstanceExpirationDateReps() {
        return this.getReps(16);
    }

    public TS insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(16, rep);
    }

    public TS insertRxa16_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(16, rep);
    }

    public TS removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(16, rep);
    }

    public TS removeRxa16_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(16, rep);
    }

    public CE[] getSubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(17, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxa17_SubstanceManufacturerName() {
        CE[] retVal = (CE[])this.getTypedField(17, (Type[])new CE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(17);
    }

    public CE getSubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public CE getRxa17_SubstanceManufacturerName(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public int getRxa17_SubstanceManufacturerNameReps() {
        return this.getReps(17);
    }

    public CE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE insertRxa17_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CE removeRxa17_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CE[] getSubstanceRefusalReason() {
        CE[] retVal = (CE[])this.getTypedField(18, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxa18_SubstanceRefusalReason() {
        CE[] retVal = (CE[])this.getTypedField(18, (Type[])new CE[0]);
        return retVal;
    }

    public int getSubstanceRefusalReasonReps() {
        return this.getReps(18);
    }

    public CE getSubstanceRefusalReason(int rep) {
        CE retVal = (CE)this.getTypedField(18, rep);
        return retVal;
    }

    public CE getRxa18_SubstanceRefusalReason(int rep) {
        CE retVal = (CE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getRxa18_SubstanceRefusalReasonReps() {
        return this.getReps(18);
    }

    public CE insertSubstanceRefusalReason(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE insertRxa18_SubstanceRefusalReason(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE removeSubstanceRefusalReason(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public CE removeRxa18_SubstanceRefusalReason(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public CE[] getIndication() {
        CE[] retVal = (CE[])this.getTypedField(19, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getRxa19_Indication() {
        CE[] retVal = (CE[])this.getTypedField(19, (Type[])new CE[0]);
        return retVal;
    }

    public int getIndicationReps() {
        return this.getReps(19);
    }

    public CE getIndication(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public CE getRxa19_Indication(int rep) {
        CE retVal = (CE)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxa19_IndicationReps() {
        return this.getReps(19);
    }

    public CE insertIndication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE insertRxa19_Indication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(19, rep);
    }

    public CE removeIndication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public CE removeRxa19_Indication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(19, rep);
    }

    public ID getCompletionStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRxa20_CompletionStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getActionCodeRXA() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getRxa21_ActionCodeRXA() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getSystemEntryDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getRxa22_SystemEntryDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new CM_LA1(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new TS(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(322));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(323));
            }
            case 21: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

