package fr.ifremer.shared.application.type;

/*
 * #%L
 * Ifremer shared :: Application
 * $Id: WeightUnit.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0.1/application/src/main/java/fr/ifremer/shared/application/type/WeightUnit.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Different types of weight unit.
 * <p/>
 * Created on 09/22/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 1.0
 */
public enum WeightUnit {

    G(n_("application.common.unit.g"), n_("application.common.unit.short.g"), 1, "\\d{0,6}(\\.\\d{0,1})?") {
        @Override
        public Float fromEntity(Float weight) {
            return weight == null ? null : weight * 1000;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight == null ? null : weight / 1000.0f;
        }
    },
    KG(n_("application.common.unit.kg"), n_("application.common.unit.short.kg"), 4, "\\d{0,6}(\\.\\d{0,4})?") {
        @Override
        public Float fromEntity(Float weight) {
            return weight;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight;
        }
    };

    private final String i18nShortKey;

    private final String i18nKey;

    private final int numberDigits;

    private final String numberEditorPattern;

    WeightUnit(String i18nKey, String i18nShortKey, int numberDigits, String numberEditorPattern) {
        this.i18nKey = i18nKey;
        this.i18nShortKey = i18nShortKey;
        this.numberDigits = numberDigits;
        this.numberEditorPattern = numberEditorPattern;
    }

    public String getLabel() {
        return _(i18nKey);
    }

    public String getShortLabel() {
        return _(i18nShortKey);
    }

    public int getNumberDigits() {
        return numberDigits;
    }

    public String getNumberEditorPattern() {
        return numberEditorPattern;
    }

    /**
     * Transform the given {@code weight} coming from db to ui.
     *
     * @param weight weigth to transform
     * @return the ui representation of the given {@code weight}.
     */
    public abstract Float fromEntity(Float weight);

    /**
     * Transform the given {@code weight} coming from ui to db.
     *
     * @param weight weigth to transform
     * @return the db representation of the given {@code weight}.
     */
    public abstract Float toEntity(Float weight);

    public String decorateLabel(String label) {
        return String.format("%s (%s)", label, getShortLabel());
    }

    public String decorateTip(String tip) {
        String unit = _("application.common.unit");
        return String.format("%s (%s %s)", tip, unit, getLabel());
    }
}