/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.ListMessageMoveTasksResultEntry;
import software.amazon.awssdk.services.sqs.model.ListMessageMoveTasksResultEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMessageMoveTasksResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, ListMessageMoveTasksResponse> {
    private static final SdkField<List<ListMessageMoveTasksResultEntry>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(ListMessageMoveTasksResponse.getter(ListMessageMoveTasksResponse::results)).setter(ListMessageMoveTasksResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListMessageMoveTasksResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Results", RESULTS_FIELD);
        }
    });
    private final List<ListMessageMoveTasksResultEntry> results;

    private ListMessageMoveTasksResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<ListMessageMoveTasksResultEntry> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMessageMoveTasksResponse)) {
            return false;
        }
        ListMessageMoveTasksResponse other = (ListMessageMoveTasksResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"ListMessageMoveTasksResponse").add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMessageMoveTasksResponse, T> g) {
        return obj -> g.apply((ListMessageMoveTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private List<ListMessageMoveTasksResultEntry> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMessageMoveTasksResponse model) {
            super(model);
            this.results(model.results);
        }

        public final List<ListMessageMoveTasksResultEntry.Builder> getResults() {
            List<ListMessageMoveTasksResultEntry.Builder> result = ListMessageMoveTasksResultEntryListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<ListMessageMoveTasksResultEntry.BuilderImpl> results) {
            this.results = ListMessageMoveTasksResultEntryListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<ListMessageMoveTasksResultEntry> results) {
            this.results = ListMessageMoveTasksResultEntryListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(ListMessageMoveTasksResultEntry ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<ListMessageMoveTasksResultEntry.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (ListMessageMoveTasksResultEntry)((ListMessageMoveTasksResultEntry.Builder)ListMessageMoveTasksResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMessageMoveTasksResponse build() {
            return new ListMessageMoveTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMessageMoveTasksResponse> {
        public Builder results(Collection<ListMessageMoveTasksResultEntry> var1);

        public Builder results(ListMessageMoveTasksResultEntry ... var1);

        public Builder results(Consumer<ListMessageMoveTasksResultEntry.Builder> ... var1);
    }
}

