/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionGroup implements SdkPojo, Serializable, ToCopyableBuilder<OptionGroup.Builder, OptionGroup> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(OptionGroup::optionGroupName)).setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> OPTION_GROUP_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupDescription").getter(getter(OptionGroup::optionGroupDescription))
            .setter(setter(Builder::optionGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupDescription").build())
            .build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(OptionGroup::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(OptionGroup::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<List<Option>> OPTIONS_FIELD = SdkField
            .<List<Option>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(OptionGroup::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Option")
                            .memberFieldInfo(
                                    SdkField.<Option> builder(MarshallingType.SDK_POJO)
                                            .constructor(Option::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Option").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowsVpcAndNonVpcInstanceMemberships")
            .getter(getter(OptionGroup::allowsVpcAndNonVpcInstanceMemberships))
            .setter(setter(Builder::allowsVpcAndNonVpcInstanceMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AllowsVpcAndNonVpcInstanceMemberships").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(OptionGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> OPTION_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupArn").getter(getter(OptionGroup::optionGroupArn)).setter(setter(Builder::optionGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupArn").build()).build();

    private static final SdkField<String> SOURCE_OPTION_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceOptionGroup").getter(getter(OptionGroup::sourceOptionGroup))
            .setter(setter(Builder::sourceOptionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOptionGroup").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceAccountId").getter(getter(OptionGroup::sourceAccountId)).setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()).build();

    private static final SdkField<Instant> COPY_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CopyTimestamp").getter(getter(OptionGroup::copyTimestamp)).setter(setter(Builder::copyTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD,
            OPTION_GROUP_DESCRIPTION_FIELD, ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD, OPTIONS_FIELD,
            ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD, VPC_ID_FIELD, OPTION_GROUP_ARN_FIELD, SOURCE_OPTION_GROUP_FIELD,
            SOURCE_ACCOUNT_ID_FIELD, COPY_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String optionGroupName;

    private final String optionGroupDescription;

    private final String engineName;

    private final String majorEngineVersion;

    private final List<Option> options;

    private final Boolean allowsVpcAndNonVpcInstanceMemberships;

    private final String vpcId;

    private final String optionGroupArn;

    private final String sourceOptionGroup;

    private final String sourceAccountId;

    private final Instant copyTimestamp;

    private OptionGroup(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.optionGroupDescription = builder.optionGroupDescription;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.options = builder.options;
        this.allowsVpcAndNonVpcInstanceMemberships = builder.allowsVpcAndNonVpcInstanceMemberships;
        this.vpcId = builder.vpcId;
        this.optionGroupArn = builder.optionGroupArn;
        this.sourceOptionGroup = builder.sourceOptionGroup;
        this.sourceAccountId = builder.sourceAccountId;
        this.copyTimestamp = builder.copyTimestamp;
    }

    /**
     * <p>
     * Specifies the name of the option group.
     * </p>
     * 
     * @return Specifies the name of the option group.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * Provides a description of the option group.
     * </p>
     * 
     * @return Provides a description of the option group.
     */
    public final String optionGroupDescription() {
        return optionGroupDescription;
    }

    /**
     * <p>
     * Indicates the name of the engine that this option group can be applied to.
     * </p>
     * 
     * @return Indicates the name of the engine that this option group can be applied to.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * Indicates the major engine version associated with this option group.
     * </p>
     * 
     * @return Indicates the major engine version associated with this option group.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates what options are available in the option group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Indicates what options are available in the option group.
     */
    public final List<Option> options() {
        return options;
    }

    /**
     * <p>
     * Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code>
     * indicates the option group can be applied to both VPC and non-VPC instances.
     * </p>
     * 
     * @return Indicates whether this option group can be applied to both VPC and non-VPC instances. The value
     *         <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances.
     */
    public final Boolean allowsVpcAndNonVpcInstanceMemberships() {
        return allowsVpcAndNonVpcInstanceMemberships;
    }

    /**
     * <p>
     * If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If
     * <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group
     * can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only
     * be applied to instances that are in the VPC indicated by this field.
     * </p>
     * 
     * @return If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If
     *         <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this
     *         option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this
     *         option group can only be applied to instances that are in the VPC indicated by this field.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) for the option group.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) for the option group.
     */
    public final String optionGroupArn() {
        return optionGroupArn;
    }

    /**
     * <p>
     * Specifies the name of the option group from which this option group is copied.
     * </p>
     * 
     * @return Specifies the name of the option group from which this option group is copied.
     */
    public final String sourceOptionGroup() {
        return sourceOptionGroup;
    }

    /**
     * <p>
     * Specifies the Amazon Web Services account ID for the option group from which this option group is copied.
     * </p>
     * 
     * @return Specifies the Amazon Web Services account ID for the option group from which this option group is copied.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * Indicates when the option group was copied.
     * </p>
     * 
     * @return Indicates when the option group was copied.
     */
    public final Instant copyTimestamp() {
        return copyTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowsVpcAndNonVpcInstanceMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceOptionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(copyTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup) obj;
        return Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(optionGroupDescription(), other.optionGroupDescription())
                && Objects.equals(engineName(), other.engineName())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options())
                && Objects.equals(allowsVpcAndNonVpcInstanceMemberships(), other.allowsVpcAndNonVpcInstanceMemberships())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(optionGroupArn(), other.optionGroupArn())
                && Objects.equals(sourceOptionGroup(), other.sourceOptionGroup())
                && Objects.equals(sourceAccountId(), other.sourceAccountId())
                && Objects.equals(copyTimestamp(), other.copyTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptionGroup").add("OptionGroupName", optionGroupName())
                .add("OptionGroupDescription", optionGroupDescription()).add("EngineName", engineName())
                .add("MajorEngineVersion", majorEngineVersion()).add("Options", hasOptions() ? options() : null)
                .add("AllowsVpcAndNonVpcInstanceMemberships", allowsVpcAndNonVpcInstanceMemberships()).add("VpcId", vpcId())
                .add("OptionGroupArn", optionGroupArn()).add("SourceOptionGroup", sourceOptionGroup())
                .add("SourceAccountId", sourceAccountId()).add("CopyTimestamp", copyTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "OptionGroupDescription":
            return Optional.ofNullable(clazz.cast(optionGroupDescription()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "AllowsVpcAndNonVpcInstanceMemberships":
            return Optional.ofNullable(clazz.cast(allowsVpcAndNonVpcInstanceMemberships()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "OptionGroupArn":
            return Optional.ofNullable(clazz.cast(optionGroupArn()));
        case "SourceOptionGroup":
            return Optional.ofNullable(clazz.cast(sourceOptionGroup()));
        case "SourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "CopyTimestamp":
            return Optional.ofNullable(clazz.cast(copyTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroup, T> g) {
        return obj -> g.apply((OptionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionGroup> {
        /**
         * <p>
         * Specifies the name of the option group.
         * </p>
         * 
         * @param optionGroupName
         *        Specifies the name of the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * Provides a description of the option group.
         * </p>
         * 
         * @param optionGroupDescription
         *        Provides a description of the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupDescription(String optionGroupDescription);

        /**
         * <p>
         * Indicates the name of the engine that this option group can be applied to.
         * </p>
         * 
         * @param engineName
         *        Indicates the name of the engine that this option group can be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * Indicates the major engine version associated with this option group.
         * </p>
         * 
         * @param majorEngineVersion
         *        Indicates the major engine version associated with this option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * Indicates what options are available in the option group.
         * </p>
         * 
         * @param options
         *        Indicates what options are available in the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<Option> options);

        /**
         * <p>
         * Indicates what options are available in the option group.
         * </p>
         * 
         * @param options
         *        Indicates what options are available in the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Option... options);

        /**
         * <p>
         * Indicates what options are available in the option group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Option.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Option.Builder#build()}
         * is called immediately and its result is passed to {@link #options(List<Option>)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<Option>)
         */
        Builder options(Consumer<Option.Builder>... options);

        /**
         * <p>
         * Indicates whether this option group can be applied to both VPC and non-VPC instances. The value
         * <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances.
         * </p>
         * 
         * @param allowsVpcAndNonVpcInstanceMemberships
         *        Indicates whether this option group can be applied to both VPC and non-VPC instances. The value
         *        <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships);

        /**
         * <p>
         * If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If
         * <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option
         * group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option
         * group can only be applied to instances that are in the VPC indicated by this field.
         * </p>
         * 
         * @param vpcId
         *        If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If
         *        <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this
         *        option group can be applied to both VPC and non-VPC instances. If this field contains a value, then
         *        this option group can only be applied to instances that are in the VPC indicated by this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) for the option group.
         * </p>
         * 
         * @param optionGroupArn
         *        Specifies the Amazon Resource Name (ARN) for the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupArn(String optionGroupArn);

        /**
         * <p>
         * Specifies the name of the option group from which this option group is copied.
         * </p>
         * 
         * @param sourceOptionGroup
         *        Specifies the name of the option group from which this option group is copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOptionGroup(String sourceOptionGroup);

        /**
         * <p>
         * Specifies the Amazon Web Services account ID for the option group from which this option group is copied.
         * </p>
         * 
         * @param sourceAccountId
         *        Specifies the Amazon Web Services account ID for the option group from which this option group is
         *        copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * Indicates when the option group was copied.
         * </p>
         * 
         * @param copyTimestamp
         *        Indicates when the option group was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTimestamp(Instant copyTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String optionGroupName;

        private String optionGroupDescription;

        private String engineName;

        private String majorEngineVersion;

        private List<Option> options = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowsVpcAndNonVpcInstanceMemberships;

        private String vpcId;

        private String optionGroupArn;

        private String sourceOptionGroup;

        private String sourceAccountId;

        private Instant copyTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroup model) {
            optionGroupName(model.optionGroupName);
            optionGroupDescription(model.optionGroupDescription);
            engineName(model.engineName);
            majorEngineVersion(model.majorEngineVersion);
            options(model.options);
            allowsVpcAndNonVpcInstanceMemberships(model.allowsVpcAndNonVpcInstanceMemberships);
            vpcId(model.vpcId);
            optionGroupArn(model.optionGroupArn);
            sourceOptionGroup(model.sourceOptionGroup);
            sourceAccountId(model.sourceAccountId);
            copyTimestamp(model.copyTimestamp);
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getOptionGroupDescription() {
            return optionGroupDescription;
        }

        public final void setOptionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
        }

        @Override
        public final Builder optionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final List<Option.Builder> getOptions() {
            List<Option.Builder> result = OptionsListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<Option.BuilderImpl> options) {
            this.options = OptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<Option> options) {
            this.options = OptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Option... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<Option.Builder>... options) {
            options(Stream.of(options).map(c -> Option.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
            return allowsVpcAndNonVpcInstanceMemberships;
        }

        public final void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
        }

        @Override
        public final Builder allowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getOptionGroupArn() {
            return optionGroupArn;
        }

        public final void setOptionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
        }

        @Override
        public final Builder optionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
            return this;
        }

        public final String getSourceOptionGroup() {
            return sourceOptionGroup;
        }

        public final void setSourceOptionGroup(String sourceOptionGroup) {
            this.sourceOptionGroup = sourceOptionGroup;
        }

        @Override
        public final Builder sourceOptionGroup(String sourceOptionGroup) {
            this.sourceOptionGroup = sourceOptionGroup;
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final Instant getCopyTimestamp() {
            return copyTimestamp;
        }

        public final void setCopyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
        }

        @Override
        public final Builder copyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
            return this;
        }

        @Override
        public OptionGroup build() {
            return new OptionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
