/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.portuguese;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.IntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;

public class PortugueseIntegerToWordsConverterAdapter
extends IntegerToWordsConverter {
    public PortugueseIntegerToWordsConverterAdapter(IntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        super(hundredsToWordsConverter, pluralForms);
    }

    @Override
    protected String joinValueChunksWithForms(Iterator<Integer> chunks, Iterator<PluralForms> formsToUse) {
        ArrayList<String> result = new ArrayList<String>();
        while (chunks.hasNext() && formsToUse.hasNext()) {
            Integer currentChunkValue = chunks.next();
            PluralForms currentForms = formsToUse.next();
            if (currentChunkValue <= 0) continue;
            result.add(this.hundredsToWordsConverter.asWords(currentChunkValue, GenderType.NON_APPLICABLE));
            result.add(currentForms.formFor(currentChunkValue));
        }
        return this.joinParts(result);
    }
}

