/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.french;

import com.google.common.collect.Range;
import java.util.List;
import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.IntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;

public class FrenchIntegerToWordsConverter
extends IntegerToWordsConverter {
    private final Map<Integer, String> exceptions;

    public FrenchIntegerToWordsConverter(IntegerToStringConverter integerToStringConverter, Map<Integer, String> exceptions, List<PluralForms> pluralForms) {
        super(integerToStringConverter, pluralForms);
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        if (Range.closed((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(999999)).contains((Comparable)value)) {
            return this.thousandsAsString(value);
        }
        return super.asWords(value);
    }

    private String thousandsAsString(Integer value) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        if (this.isOneThousand(thousands)) {
            return this.getOneThousandAsWords(other);
        }
        return this.getThousandsAsWords(thousands, other);
    }

    private String getThousandsAsWords(Integer thousands, Integer other) {
        if (this.nothingComesAfter(other)) {
            return String.format("%s mille", this.asWords(thousands));
        }
        return String.format("%s mille %s", this.asWords(thousands), this.asWords(other));
    }

    private String getOneThousandAsWords(Integer other) {
        return String.format("mille %s", this.asWords(other));
    }

    private boolean nothingComesAfter(Integer other) {
        return other == 0;
    }

    private boolean isOneThousand(Integer thousands) {
        return thousands == 1;
    }
}

