/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.util;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class HttpFacesContextFilter
implements Filter {
    public static String VIEWID_KEY = "org.zkoss.jsf.zul.VIDK";
    private ServletContext servletContext;
    private String _updateURI = "/zkau";

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        String uu = config.getInitParameter("update-uri");
        if (uu != null) {
            this._updateURI = uu.trim();
        }
    }

    public void destroy() {
        this.servletContext = null;
    }

    private String findViewID(HttpServletRequest request, HttpServletResponse response) {
        Session sess;
        WebApp wapp;
        WebAppCtrl wappc;
        Desktop desktop;
        String dtid = request.getParameter("dtid");
        String viewId = null;
        if (dtid != null && (desktop = (wappc = (WebAppCtrl)(wapp = (sess = WebManager.getSession((ServletContext)this.servletContext, (HttpServletRequest)request)).getWebApp())).getDesktopCache(sess).getDesktopIfAny(dtid)) != null) {
            viewId = desktop.getRequestPath();
        }
        if (viewId == null) {
            viewId = request.getServletPath();
        }
        return viewId;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.needsInitialFacesContext((HttpServletRequest)request)) {
            this.initFacesContext((HttpServletRequest)request, (HttpServletResponse)response);
            chain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean needsInitialFacesContext(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo == null || !pathInfo.startsWith("/web/");
    }

    private FacesContext initFacesContext(HttpServletRequest request, HttpServletResponse response) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext;
        }
        FacesContextFactory contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        facesContext = contextFactory.getFacesContext((Object)this.servletContext, (Object)request, (Object)response, lifecycle);
        MyFacesContext.setFacesContextAsCurrentInstance(facesContext);
        UIViewRoot view = facesContext.getApplication().getViewHandler().createView(facesContext, this.findViewID(request, response));
        facesContext.setViewRoot(view);
        return facesContext;
    }

    private static abstract class MyFacesContext
    extends FacesContext {
        protected static void setFacesContextAsCurrentInstance(FacesContext facesContext) {
            FacesContext.setCurrentInstance((FacesContext)facesContext);
        }
    }
}

