/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.zkoss.jsf.zul.impl.AbstractComponent;
import org.zkoss.jsf.zul.impl.BranchComponent;
import org.zkoss.jsf.zul.impl.ComponentInfo;
import org.zkoss.jsf.zul.impl.RootComponent;
import org.zkoss.jsf.zul.impl.Utils;
import org.zkoss.lang.Classes;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.ModificationException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public abstract class LeafComponent
extends AbstractComponent {
    private Component _zulcomp;
    private RootComponent _rootcomp;
    private BranchComponent _parentcomp;
    private Map _compAttrMap;
    private String _use;
    private String _forward;
    private boolean _idSet = false;
    private Map _zulAttrMap = new LinkedHashMap();
    private Map _eventListenerMap = new LinkedHashMap();

    RootComponent getRootComponent() {
        return this._rootcomp;
    }

    BranchComponent getParentComponent() {
        return this._parentcomp;
    }

    protected abstract Component newComponent(Class var1) throws Exception;

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        AbstractComponent ac = (AbstractComponent)this.findAncestorWithClass((UIComponent)this, AbstractComponent.class);
        if (ac instanceof RootComponent) {
            this._rootcomp = (RootComponent)ac;
            this._parentcomp = null;
        } else if (ac instanceof BranchComponent) {
            this._parentcomp = (BranchComponent)ac;
            this._rootcomp = this._parentcomp.getRootComponent();
        } else {
            throw new IllegalStateException("Must be nested inside the page component: " + (Object)((Object)this));
        }
        ComponentInfo cinfo = this.getComponentInfo();
        if (cinfo != null) {
            if (this._parentcomp != null) {
                cinfo.addChildInfo(this._parentcomp, this);
            } else if (this._rootcomp != null) {
                cinfo.addChildInfo(this._rootcomp, this);
            }
        }
    }

    protected ComponentInfo getComponentInfo() {
        if (this._rootcomp != null) {
            return this._rootcomp.getComponentInfo();
        }
        return null;
    }

    public boolean getRendersChildren() {
        return this.isSuppressed();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered() || !this.isEffective()) {
            return;
        }
        if (this.isSuppressed()) {
            StringWriter sw = new StringWriter();
            ResponseWriter ow = context.getResponseWriter();
            context.setResponseWriter(ow.cloneWithWriter((Writer)sw));
            List children = this.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Utils.renderComponent((UIComponent)iter.next(), context);
            }
            context.setResponseWriter(ow);
            sw.close();
            String content = sw.toString();
            sw = null;
            this.setBodyContent(content);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered() || !this.isEffective()) {
            return;
        }
        if (this.isSuppressed()) {
            StringWriter writer = new StringWriter();
            this.writeComponentMark(writer);
            context.getResponseWriter().write(writer.toString());
        } else {
            this.writeComponentMark((Writer)context.getResponseWriter());
        }
    }

    protected void doZKLoading() throws IOException {
        if (!this.isRendered() || !this.isEffective()) {
            return;
        }
        this.initComponent();
        this.afterComposeComponent();
        this.setBodyContent(null);
    }

    void initComponent() {
        if (this._rootcomp == null) {
            throw new IllegalStateException("Must be nested inside the page component: " + (Object)((Object)this));
        }
        if (this._zulcomp != null) {
            this._zulcomp.detach();
            this._zulcomp = null;
        }
        try {
            this._zulcomp = this.newComponent(this._use != null ? Classes.forNameByThread((String)this._use) : null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this._idSet) {
            this._zulcomp.setId(this.getId());
        }
        if (this._parentcomp != null) {
            this._parentcomp.addChildZULComponent(this);
        } else {
            this._rootcomp.addChildZULComponent(this);
        }
    }

    Component getZULComponent() {
        return this._zulcomp;
    }

    void afterComposeComponent() {
        if (this._zulcomp == null) {
            throw new RuntimeException("newComponent() returns null");
        }
        if (this._compAttrMap != null) {
            Iterator iter = this._compAttrMap.keySet().iterator();
            while (iter.hasNext()) {
                String localName = (String)iter.next();
                Object value = this._compAttrMap.get(localName);
                if (localName.startsWith("on")) {
                    this._eventListenerMap.put(localName, value);
                    continue;
                }
                this._zulAttrMap.put(localName, value);
            }
        }
        try {
            this.evaluateDynaAttributes(this._zulcomp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this._forward != null) {
            ComponentsCtrl.applyForward((Component)this._zulcomp, (String)this._forward);
        }
        Iterator itor = this._eventListenerMap.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            ZScript zscript = ZScript.parseContent((String)((String)entry.getValue()));
            ((ComponentCtrl)this._zulcomp).addEventHandler((String)entry.getKey(), new EventHandler(zscript, null));
        }
        if (this._zulcomp instanceof AfterCompose) {
            ((AfterCompose)this._zulcomp).afterCompose();
        }
        if (Events.isListened((Component)this._zulcomp, (String)"onCreate", (boolean)false)) {
            Events.postEvent((Event)new CreateEvent("onCreate", this._zulcomp, Executions.getCurrent().getArg()));
        }
        this.afterZULComponentComposed(this._zulcomp);
    }

    private void evaluateDynaAttributes(Component target) throws ModificationException, NoSuchMethodException {
        AnnotationHelper helper = null;
        boolean hitann = false;
        Iterator itor = this._zulAttrMap.entrySet().iterator();
        while (itor.hasNext()) {
            String attval;
            int len;
            Map.Entry entry = itor.next();
            String attnm = (String)entry.getKey();
            Object value = this._zulAttrMap.get(attnm);
            if (value instanceof ValueBinding) {
                value = ((ValueBinding)value).getValue(this.getFacesContext());
            }
            hitann = false;
            if (value instanceof String && (len = (attval = (String)value).length()) >= 3 && attval.charAt(0) == '@' && attval.charAt(1) == '{' && attval.charAt(len - 1) == '}') {
                if (helper == null) {
                    helper = new AnnotationHelper();
                }
                helper.addByCompoundValue(attval.substring(2, len - 1));
                helper.applyAnnotations(target, "self".equals(attnm) ? null : attnm, true);
                hitann = true;
            }
            if (hitann) continue;
            Fields.setField((Object)target, (String)attnm, value, (boolean)true);
        }
    }

    protected void afterZULComponentComposed(Component zulcomp) {
    }

    void writeComponentMark(Writer writer) throws IOException {
        if (!this.isRendered() || !this.isEffective()) {
            return;
        }
        Utils.writeComponentMark(writer, this);
    }

    public Object getAttributeValue(String att) {
        Object value = this._compAttrMap.get(att);
        if (value instanceof ValueBinding) {
            value = ((ValueBinding)value).getValue(this.getFacesContext());
        }
        return value;
    }

    public void setAttributeValue(String att, Object value) {
        Object oldvalue = this._compAttrMap.get(att);
        if (oldvalue instanceof ValueBinding) {
            ((ValueBinding)value).setValue(this.getFacesContext(), value);
        } else {
            this._compAttrMap.put(att, value);
        }
    }

    public String getUse() {
        return this._use;
    }

    public void setUse(String use) {
        this._use = use;
    }

    public void setZULDynamicAttribute(Map map) {
        this._compAttrMap = map;
    }

    protected void addZULDynamicAttribute(String name, Object value) {
        if (this._compAttrMap == null) {
            throw new NullPointerException();
        }
        this._compAttrMap.put(name, value);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[5];
        values[0] = super.saveState(context);
        values[1] = this._use;
        Object[] m = LeafComponent.saveAttachedMapState(context, this._compAttrMap);
        values[2] = m[0];
        values[3] = m[1];
        values[4] = this._idSet ? Boolean.TRUE : Boolean.FALSE;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._use = (String)values[1];
        this._compAttrMap = LeafComponent.restoreAttachedMapState(context, values[2], values[3]);
        this._idSet = (Boolean)values[4];
    }

    public void setId(String id) {
        super.setId(id);
        this._idSet = true;
    }

    public String getForward() {
        return this._forward;
    }

    public void setForward(String forward) {
        this._forward = forward != null && forward.length() > 0 ? forward : null;
    }
}

