/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.zkoss.jsf.zul.impl.BranchOutput;
import org.zkoss.jsf.zul.impl.ClientInputSupport;
import org.zkoss.jsf.zul.impl.MessageFactory;
import org.zkoss.jsf.zul.impl.RootComponent;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;

public abstract class BranchInput
extends BranchOutput
implements EditableValueHolder,
ClientInputSupport {
    private static final Log log = Log.lookup((Class)RootComponent.class);
    private Object _submittedValue = null;
    private Boolean _required;
    private Boolean _immediate;
    private boolean _valid = true;
    private MethodBinding _validator = null;
    private MethodBinding _valueChangeListener = null;
    List _validatorList = null;
    private static final Validator[] EMPTY_VALIDATOR_ARRAY = new Validator[0];

    public Object getSubmittedValue() {
        return this._submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this._submittedValue = submittedValue;
    }

    public boolean isRequired() {
        if (this._required != null) {
            return this._required;
        }
        ValueBinding vb = this.getValueBinding("required");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean valid) {
        this._valid = valid;
    }

    public void setRequired(boolean required) {
        this._required = required ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isImmediate() {
        if (this._immediate != null) {
            return this._immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return false;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate ? Boolean.TRUE : Boolean.FALSE;
    }

    public MethodBinding getValidator() {
        return this._validator;
    }

    public void setValidator(MethodBinding validatorBinding) {
        this._validator = validatorBinding;
    }

    public MethodBinding getValueChangeListener() {
        return this._valueChangeListener;
    }

    public void setValueChangeListener(MethodBinding valueChangeMethod) {
        this._valueChangeListener = valueChangeMethod;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            try {
                this.validate(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            try {
                this.validate(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
        this.clientInputDecode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding valueChangeListenerBinding;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (valueChangeListenerBinding = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            try {
                valueChangeListenerBinding.invoke(context, new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("content");
        }
        if (!this.isValid()) {
            return;
        }
        if (!this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb == null) {
            return;
        }
        try {
            vb.setValue(context, this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (EvaluationException ee) {
            String exceptionMessage;
            Throwable cause = ee.getCause();
            if (cause != null) {
                log.warning("exception when set value(" + this.getLocalValue() + ") to Bean , please check EL and Object type. ", (Throwable)ee);
            }
            if ((exceptionMessage = ee.getMessage()) == null) {
                this.addErrorMessage(context, (UIComponent)this, "zul.jsf.conversion.message", new Object[]{this.getId()});
            } else {
                this.addErrorMessage(context, (UIComponent)this, exceptionMessage, new Object[]{this.getId()});
            }
            this.setValid(false);
        }
        catch (Exception e) {
            log.warning((Throwable)e);
            context.getExternalContext().log(e.getMessage(), (Throwable)e);
            this.addErrorMessage(context, (UIComponent)this, "zul.jsf.conversion.message", new Object[]{this.getId()});
            this.setValid(false);
        }
    }

    protected void validateValue(FacesContext context, Object convertedValue) {
        boolean empty;
        boolean bl = empty = convertedValue == null || convertedValue instanceof String && ((String)convertedValue).length() == 0;
        if (this.isRequired() && empty) {
            this.addErrorMessage(context, (UIComponent)this, "zul.jsf.required.message", new Object[]{this.getId()});
            this.setValid(false);
            return;
        }
        if (!empty) {
            BranchInput.callValidators(context, this, convertedValue);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Object convertedValue = this.getConvertedValue(context, submittedValue);
        if (!this.isValid()) {
            return;
        }
        this.validateValue(context, convertedValue);
        if (!this.isValid()) {
            return;
        }
        Object previousValue = this.getValue();
        this.setValue(convertedValue);
        this.setSubmittedValue(null);
        if (this.compareValues(previousValue, convertedValue)) {
            this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previousValue, convertedValue));
        }
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) {
        try {
            Converter converter;
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
            }
            if (submittedValue instanceof String && (converter = BranchInput.findBranchInputConverter(context, this)) != null) {
                return converter.getAsObject(context, (UIComponent)this, (String)submittedValue);
            }
        }
        catch (ConverterException e) {
            FacesMessage facesMessage = e.getFacesMessage();
            if (facesMessage != null) {
                context.addMessage(this.getClientId(context), facesMessage);
            } else {
                this.addErrorMessage(context, (UIComponent)this, "zul.jsf.conversion.message", new Object[]{this.getId()});
            }
            this.setValid(false);
        }
        return submittedValue;
    }

    protected boolean compareValues(Object previous, Object value) {
        return previous == null ? value != null : !previous.equals(value);
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        if (this._validatorList == null) {
            this._validatorList = new ArrayList();
        }
        this._validatorList.add(validator);
    }

    public Validator[] getValidators() {
        return this._validatorList != null ? this._validatorList.toArray(new Validator[this._validatorList.size()]) : EMPTY_VALIDATOR_ARRAY;
    }

    public void removeValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        if (this._validatorList != null) {
            this._validatorList.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._immediate, this._required, this._valid ? Boolean.TRUE : Boolean.FALSE, BranchInput.saveAttachedState((FacesContext)context, (Object)this._validator), BranchInput.saveAttachedState((FacesContext)context, (Object)this._valueChangeListener), BranchInput.saveAttachedState((FacesContext)context, (Object)this._validatorList)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._immediate = (Boolean)values[1];
        this._required = (Boolean)values[2];
        this._valid = (Boolean)values[3];
        this._validator = (MethodBinding)BranchInput.restoreAttachedState((FacesContext)context, (Object)values[4]);
        this._valueChangeListener = (MethodBinding)BranchInput.restoreAttachedState((FacesContext)context, (Object)values[5]);
        this._validatorList = (List)BranchInput.restoreAttachedState((FacesContext)context, (Object)values[6]);
    }

    protected void afterZULComponentComposed(Component zulcomp) {
        super.afterZULComponentComposed(zulcomp);
        if (this instanceof ClientInputSupport) {
            String name = this.getInputAttributeName();
            String value = this.getInputAttributeValue();
            try {
                Fields.setField((Object)zulcomp, (String)name, (Object)value, (boolean)true);
            }
            catch (Exception x) {
                throw new RuntimeException(x.getMessage(), x);
            }
        }
    }

    public String getInputAttributeName() {
        return "name";
    }

    public String getInputAttributeValue() {
        String cid = super.getClientId(this.getFacesContext());
        return cid;
    }

    protected void clientInputDecode(FacesContext context) {
        String clientId = this.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            String newValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
            this.setSubmittedValue(newValue);
        }
    }

    protected void addErrorMessage(FacesContext context, UIComponent component, String messageId, Object[] parms) {
        FacesMessage message = MessageFactory.getMessage(context, messageId);
        message.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(component.getClientId(context), message);
    }

    private static void callValidators(FacesContext context, BranchInput input, Object convertedValue) {
        FacesMessage facesMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, (UIComponent)input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }

    private static Converter findBranchInputConverter(FacesContext facesContext, BranchInput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if (String.class.equals(valueType)) {
            return null;
        }
        if (Object.class.equals(valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            log.debug("No Converter for type " + valueType.getName() + " found", (Throwable)e);
            return null;
        }
    }
}

