/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.text.SimpleDateFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.zkoss.jsf.zul.impl.BranchInput;
import org.zkoss.jsf.zul.impl.FormateHolder;
import org.zkoss.zk.ui.Component;

public abstract class BaseCalendar
extends BranchInput {
    protected void afterZULComponentComposed(Component zulcomp) {
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = new DateFormatConverter();
            this.setConverter(converter);
        }
        super.afterZULComponentComposed(zulcomp);
    }

    public Object transferValueForAttribute(String value) {
        if (value == null) {
            return null;
        }
        return this.getConverter().getAsObject(this.getFacesContext(), (UIComponent)this, value);
    }

    public static class DateFormatConverter
    extends FormateHolder
    implements Converter {
        private SimpleDateFormat _formater;

        public DateFormatConverter() {
            this.formatChanged();
        }

        public DateFormatConverter(String format) {
            super(format);
            this.formatChanged();
        }

        protected void formatChanged() {
            if (this._formater == null) {
                this._formater = new SimpleDateFormat();
            }
            if (this._format == null) {
                this._formater.applyLocalizedPattern("yyyy/MM/dd");
            } else {
                this._formater.applyLocalizedPattern(this._format);
            }
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            try {
                if (value == null || "".equals(value.trim())) {
                    return null;
                }
                return this._formater.parse(value);
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage());
            }
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) {
            if (value == null) {
                return null;
            }
            try {
                return this._formater.format(value);
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

