/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class HostPool {
    private final URI uri;
    private volatile InetAddress[] addresses;
    private volatile int currentAddress;
    private final AtomicLong failureCount = new AtomicLong();

    public HostPool(URI uri) {
        this.uri = uri;
    }

    public AddressResult getAddress() {
        return new AddressResult(this.failureCount.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getAddressImpl() throws UnknownHostException {
        InetAddress[] addresses;
        int currentAddress;
        do {
            addresses = this.addresses;
            currentAddress = this.currentAddress;
            if (addresses != null) continue;
            HostPool hostPool = this;
            synchronized (hostPool) {
                addresses = this.addresses;
                if (this.addresses == null) {
                    addresses = InetAddress.getAllByName(this.uri.getHost());
                    InetAddress primary = InetAddress.getByName(this.uri.getHost());
                    ArrayList<InetAddress> filtered = new ArrayList<InetAddress>();
                    for (InetAddress a : addresses) {
                        if (!primary.getClass().isAssignableFrom(a.getClass())) continue;
                        filtered.add(a);
                    }
                    addresses = this.addresses = filtered.toArray(new InetAddress[filtered.size()]);
                }
                this.currentAddress = currentAddress = new Random().nextInt(this.addresses.length);
            }
        } while (currentAddress >= addresses.length);
        return addresses[currentAddress];
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markError() {
        HostPool hostPool = this;
        synchronized (hostPool) {
            int current = this.currentAddress;
            if (++current == this.addresses.length) {
                current = 0;
            }
            this.currentAddress = current;
        }
    }

    public class AddressResult {
        private final long failCount;

        public AddressResult(long failCount) {
            this.failCount = failCount;
        }

        public InetAddress getAddress() throws UnknownHostException {
            return HostPool.this.getAddressImpl();
        }

        public URI getURI() {
            return HostPool.this.uri;
        }

        public void failed() {
            HostPool.this.markError();
        }
    }
}

