/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddLocalAuthentication
extends AbstractAddSecurityRealmSubElement {
    private final String allowedUsers;
    private final String defaultUser;
    private final Boolean skipGroupLoading;

    private AddLocalAuthentication(Builder builder) {
        super(builder);
        this.allowedUsers = builder.allowedUsers;
        this.defaultUser = builder.defaultUser;
        this.skipGroupLoading = builder.skipGroupLoading;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Operations ops = new Operations(ctx.client);
        Address securityRealmJaasAuthnAddress = this.securityRealmAddress.and("authentication", "local");
        if (this.replaceExisting) {
            ops.removeIfExists(securityRealmJaasAuthnAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(securityRealmJaasAuthnAddress, Values.empty().andOptional("allowed-users", this.allowedUsers).andOptional("default-user", this.defaultUser).andOptional("skip-group-loading", this.skipGroupLoading));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddLocalAuthentication.class).subtree("management", Subtree.management()).parameter("atrSecurityRealmName", this.securityRealmName).parameter("atrAllowedUsers", this.allowedUsers).parameter("atrDefaultUser", this.defaultUser).parameter("atrSkipGroupLoading", this.skipGroupLoading).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String allowedUsers;
        private String defaultUser;
        private Boolean skipGroupLoading;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder allowedUsers(String allowedUsers) {
            this.allowedUsers = allowedUsers;
            return this;
        }

        public Builder defaultUser(String defaultUser) {
            this.defaultUser = defaultUser;
            return this;
        }

        public Builder skipGroupLoading(Boolean skipGroupLoading) {
            this.skipGroupLoading = skipGroupLoading;
            return this;
        }

        @Override
        public AddLocalAuthentication build() {
            return new AddLocalAuthentication(this);
        }
    }
}

