/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractPeriodicRotatingFileLogHandlerCommand;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddPeriodicRotatingFileLogHandler
extends AbstractPeriodicRotatingFileLogHandlerCommand {
    private final boolean replaceExisting;

    private AddPeriodicRotatingFileLogHandler(Builder builder) {
        super(builder);
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address handlerAddress = Address.subsystem((String)"logging").and("periodic-rotating-file-handler", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(handlerAddress);
            }
            catch (OperationException e) {
                throw new CommandFailedException("Failed to remove existing periodic-rotating-file-handler " + this.name, (Throwable)e);
            }
        }
        ops.add(handlerAddress, Values.empty().andOptional("autoflush", this.autoflush).andOptional("enabled", this.enabled).andOptional("level", this.level == null ? null : this.level.value()).andOptional("filter-spec", this.filter).andOptional("encoding", this.encoding).andOptional("named-formatter", this.namedFormatter).andOptional("formatter", this.patternFormatter).andOptional("suffix", this.suffix).andOptional("append", this.append).andObject("file", Values.empty().and("path", this.file).andOptional("relative-to", this.fileRelativeTo)));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddPeriodicRotatingFileLogHandler.class).subtree("logging", Subtree.subsystem("logging")).parameter("name", this.name).parameter("autoflush", this.autoflush == null ? null : String.valueOf(this.autoflush)).parameter("enabled", this.enabled == null ? null : String.valueOf(this.enabled)).parameter("append", this.append == null ? null : String.valueOf(this.append)).parameter("filter", this.filter).parameter("encoding", this.encoding).parameter("patternFormatter", this.patternFormatter).parameter("namedFormatter", this.namedFormatter).parameter("level", this.level == null ? null : this.level.value()).parameter("filePath", this.file).parameter("fileRelativeTo", this.fileRelativeTo).parameter("suffix", this.suffix).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "AddPeriodicRotatingFileLogHandler " + this.name;
    }

    public static final class Builder
    extends AbstractPeriodicRotatingFileLogHandlerCommand.Builder<Builder> {
        private boolean replaceExisting;

        public Builder(String name, String file, String suffix) {
            super(name, file, suffix);
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        @Override
        protected void validate() {
            if (this.file == null) {
                throw new IllegalArgumentException("file can not be null!");
            }
            super.validate();
        }

        @Override
        public AddPeriodicRotatingFileLogHandler build() {
            this.validate();
            return new AddPeriodicRotatingFileLogHandler(this);
        }
    }
}

