// $ANTLR 3.4 /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g 2018-12-28 09:22:19

  package org.tmatesoft.sqljet.core.internal.lang;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class SqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABORT", "ADD", "AFTER", "ALIAS", "ALL", "ALTER", "AMPERSAND", "ANALYZE", "AND", "APOSTROPHE", "AS", "ASC", "ASTERISK", "AT", "ATTACH", "AUTOINCREMENT", "B", "BACKSLASH", "BEFORE", "BEGIN", "BETWEEN", "BIND", "BIND_NAME", "BLOB", "BLOB_LITERAL", "BY", "C", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLON", "COLUMN", "COLUMNS", "COLUMN_CONSTRAINT", "COLUMN_EXPRESSION", "COMMA", "COMMENT", "COMMIT", "CONFLICT", "CONSTRAINT", "CONSTRAINTS", "CREATE", "CREATE_INDEX", "CREATE_TABLE", "CREATE_TRIGGER", "CREATE_VIEW", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "D", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DOLLAR", "DOT", "DOUBLE_PIPE", "DROP", "DROP_INDEX", "DROP_TABLE", "E", "EACH", "ELSE", "END", "EQUALS", "EQUALS2", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXISTS", "EXPLAIN", "F", "FAIL", "FALSE", "FLOAT", "FLOAT_EXP", "FLOAT_LITERAL", "FOR", "FOREIGN", "FROM", "FUNCTION_EXPRESSION", "FUNCTION_LITERAL", "G", "GLOB", "GREATER", "GREATER_OR_EQ", "GROUP", "H", "HAVING", "I", "ID", "ID_CORE", "ID_LITERAL", "ID_PLAIN", "ID_QUOTED", "ID_QUOTED_APOSTROPHE", "ID_QUOTED_CORE", "ID_QUOTED_CORE_APOSTROPHE", "ID_QUOTED_CORE_SQUARE", "ID_QUOTED_SQUARE", "ID_START", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTEGER", "INTEGER_LITERAL", "INTERSECT", "INTO", "IN_TABLE", "IN_VALUES", "IS", "ISNULL", "IS_NOT", "IS_NULL", "J", "JOIN", "K", "KEY", "L", "LEFT", "LESS", "LESS_OR_EQ", "LIKE", "LIMIT", "LINE_COMMENT", "LPAREN", "LPAREN_SQUARE", "M", "MATCH", "MINUS", "N", "NATURAL", "NOT", "NOTNULL", "NOT_EQUALS", "NOT_EQUALS2", "NOT_NULL", "NULL", "O", "OF", "OFFSET", "ON", "OPTIONS", "OR", "ORDER", "ORDERING", "OUTER", "P", "PERCENT", "PIPE", "PLAN", "PLUS", "PRAGMA", "PRIMARY", "Q", "QUERY", "QUESTION", "QUOTE_DOUBLE", "QUOTE_SINGLE", "R", "RAISE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "ROLLBACK", "ROW", "RPAREN", "RPAREN_SQUARE", "S", "SAVEPOINT", "SELECT", "SELECT_CORE", "SEMI", "SET", "SHIFT_LEFT", "SHIFT_RIGHT", "SLASH", "STATEMENT", "STRING", "STRING_CORE", "STRING_CORE_DOUBLE", "STRING_CORE_SINGLE", "STRING_DOUBLE", "STRING_ESCAPE_DOUBLE", "STRING_ESCAPE_SINGLE", "STRING_LITERAL", "STRING_SINGLE", "T", "TABLE", "TABLE_CONSTRAINT", "TEMPORARY", "THEN", "TILDA", "TO", "TRANSACTION", "TRIGGER", "TRUE", "TYPE", "TYPE_PARAMS", "U", "UNDERSCORE", "UNION", "UNIQUE", "UPDATE", "USING", "V", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "W", "WHEN", "WHERE", "WS", "X", "Y", "Z"
    };

    public static final int EOF=-1;
    public static final int A=4;
    public static final int ABORT=5;
    public static final int ADD=6;
    public static final int AFTER=7;
    public static final int ALIAS=8;
    public static final int ALL=9;
    public static final int ALTER=10;
    public static final int AMPERSAND=11;
    public static final int ANALYZE=12;
    public static final int AND=13;
    public static final int APOSTROPHE=14;
    public static final int AS=15;
    public static final int ASC=16;
    public static final int ASTERISK=17;
    public static final int AT=18;
    public static final int ATTACH=19;
    public static final int AUTOINCREMENT=20;
    public static final int B=21;
    public static final int BACKSLASH=22;
    public static final int BEFORE=23;
    public static final int BEGIN=24;
    public static final int BETWEEN=25;
    public static final int BIND=26;
    public static final int BIND_NAME=27;
    public static final int BLOB=28;
    public static final int BLOB_LITERAL=29;
    public static final int BY=30;
    public static final int C=31;
    public static final int CASCADE=32;
    public static final int CASE=33;
    public static final int CAST=34;
    public static final int CHECK=35;
    public static final int COLLATE=36;
    public static final int COLON=37;
    public static final int COLUMN=38;
    public static final int COLUMNS=39;
    public static final int COLUMN_CONSTRAINT=40;
    public static final int COLUMN_EXPRESSION=41;
    public static final int COMMA=42;
    public static final int COMMENT=43;
    public static final int COMMIT=44;
    public static final int CONFLICT=45;
    public static final int CONSTRAINT=46;
    public static final int CONSTRAINTS=47;
    public static final int CREATE=48;
    public static final int CREATE_INDEX=49;
    public static final int CREATE_TABLE=50;
    public static final int CREATE_TRIGGER=51;
    public static final int CREATE_VIEW=52;
    public static final int CROSS=53;
    public static final int CURRENT_DATE=54;
    public static final int CURRENT_TIME=55;
    public static final int CURRENT_TIMESTAMP=56;
    public static final int D=57;
    public static final int DATABASE=58;
    public static final int DEFAULT=59;
    public static final int DEFERRABLE=60;
    public static final int DEFERRED=61;
    public static final int DELETE=62;
    public static final int DESC=63;
    public static final int DETACH=64;
    public static final int DISTINCT=65;
    public static final int DOLLAR=66;
    public static final int DOT=67;
    public static final int DOUBLE_PIPE=68;
    public static final int DROP=69;
    public static final int DROP_INDEX=70;
    public static final int DROP_TABLE=71;
    public static final int E=72;
    public static final int EACH=73;
    public static final int ELSE=74;
    public static final int END=75;
    public static final int EQUALS=76;
    public static final int EQUALS2=77;
    public static final int ESCAPE=78;
    public static final int EXCEPT=79;
    public static final int EXCLUSIVE=80;
    public static final int EXISTS=81;
    public static final int EXPLAIN=82;
    public static final int F=83;
    public static final int FAIL=84;
    public static final int FALSE=85;
    public static final int FLOAT=86;
    public static final int FLOAT_EXP=87;
    public static final int FLOAT_LITERAL=88;
    public static final int FOR=89;
    public static final int FOREIGN=90;
    public static final int FROM=91;
    public static final int FUNCTION_EXPRESSION=92;
    public static final int FUNCTION_LITERAL=93;
    public static final int G=94;
    public static final int GLOB=95;
    public static final int GREATER=96;
    public static final int GREATER_OR_EQ=97;
    public static final int GROUP=98;
    public static final int H=99;
    public static final int HAVING=100;
    public static final int I=101;
    public static final int ID=102;
    public static final int ID_CORE=103;
    public static final int ID_LITERAL=104;
    public static final int ID_PLAIN=105;
    public static final int ID_QUOTED=106;
    public static final int ID_QUOTED_APOSTROPHE=107;
    public static final int ID_QUOTED_CORE=108;
    public static final int ID_QUOTED_CORE_APOSTROPHE=109;
    public static final int ID_QUOTED_CORE_SQUARE=110;
    public static final int ID_QUOTED_SQUARE=111;
    public static final int ID_START=112;
    public static final int IF=113;
    public static final int IGNORE=114;
    public static final int IMMEDIATE=115;
    public static final int IN=116;
    public static final int INDEX=117;
    public static final int INDEXED=118;
    public static final int INITIALLY=119;
    public static final int INNER=120;
    public static final int INSERT=121;
    public static final int INSTEAD=122;
    public static final int INTEGER=123;
    public static final int INTEGER_LITERAL=124;
    public static final int INTERSECT=125;
    public static final int INTO=126;
    public static final int IN_TABLE=127;
    public static final int IN_VALUES=128;
    public static final int IS=129;
    public static final int ISNULL=130;
    public static final int IS_NOT=131;
    public static final int IS_NULL=132;
    public static final int J=133;
    public static final int JOIN=134;
    public static final int K=135;
    public static final int KEY=136;
    public static final int L=137;
    public static final int LEFT=138;
    public static final int LESS=139;
    public static final int LESS_OR_EQ=140;
    public static final int LIKE=141;
    public static final int LIMIT=142;
    public static final int LINE_COMMENT=143;
    public static final int LPAREN=144;
    public static final int LPAREN_SQUARE=145;
    public static final int M=146;
    public static final int MATCH=147;
    public static final int MINUS=148;
    public static final int N=149;
    public static final int NATURAL=150;
    public static final int NOT=151;
    public static final int NOTNULL=152;
    public static final int NOT_EQUALS=153;
    public static final int NOT_EQUALS2=154;
    public static final int NOT_NULL=155;
    public static final int NULL=156;
    public static final int O=157;
    public static final int OF=158;
    public static final int OFFSET=159;
    public static final int ON=160;
    public static final int OPTIONS=161;
    public static final int OR=162;
    public static final int ORDER=163;
    public static final int ORDERING=164;
    public static final int OUTER=165;
    public static final int P=166;
    public static final int PERCENT=167;
    public static final int PIPE=168;
    public static final int PLAN=169;
    public static final int PLUS=170;
    public static final int PRAGMA=171;
    public static final int PRIMARY=172;
    public static final int Q=173;
    public static final int QUERY=174;
    public static final int QUESTION=175;
    public static final int QUOTE_DOUBLE=176;
    public static final int QUOTE_SINGLE=177;
    public static final int R=178;
    public static final int RAISE=179;
    public static final int REFERENCES=180;
    public static final int REGEXP=181;
    public static final int REINDEX=182;
    public static final int RELEASE=183;
    public static final int RENAME=184;
    public static final int REPLACE=185;
    public static final int RESTRICT=186;
    public static final int ROLLBACK=187;
    public static final int ROW=188;
    public static final int RPAREN=189;
    public static final int RPAREN_SQUARE=190;
    public static final int S=191;
    public static final int SAVEPOINT=192;
    public static final int SELECT=193;
    public static final int SELECT_CORE=194;
    public static final int SEMI=195;
    public static final int SET=196;
    public static final int SHIFT_LEFT=197;
    public static final int SHIFT_RIGHT=198;
    public static final int SLASH=199;
    public static final int STATEMENT=200;
    public static final int STRING=201;
    public static final int STRING_CORE=202;
    public static final int STRING_CORE_DOUBLE=203;
    public static final int STRING_CORE_SINGLE=204;
    public static final int STRING_DOUBLE=205;
    public static final int STRING_ESCAPE_DOUBLE=206;
    public static final int STRING_ESCAPE_SINGLE=207;
    public static final int STRING_LITERAL=208;
    public static final int STRING_SINGLE=209;
    public static final int T=210;
    public static final int TABLE=211;
    public static final int TABLE_CONSTRAINT=212;
    public static final int TEMPORARY=213;
    public static final int THEN=214;
    public static final int TILDA=215;
    public static final int TO=216;
    public static final int TRANSACTION=217;
    public static final int TRIGGER=218;
    public static final int TRUE=219;
    public static final int TYPE=220;
    public static final int TYPE_PARAMS=221;
    public static final int U=222;
    public static final int UNDERSCORE=223;
    public static final int UNION=224;
    public static final int UNIQUE=225;
    public static final int UPDATE=226;
    public static final int USING=227;
    public static final int V=228;
    public static final int VACUUM=229;
    public static final int VALUES=230;
    public static final int VIEW=231;
    public static final int VIRTUAL=232;
    public static final int W=233;
    public static final int WHEN=234;
    public static final int WHERE=235;
    public static final int WS=236;
    public static final int X=237;
    public static final int Y=238;
    public static final int Z=239;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public SqlParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public SqlParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return SqlParser.tokenNames; }
    public String getGrammarFileName() { return "/home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g"; }



    // Disable error recovery.
    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        throw new MismatchedTokenException(ttype, input);
    }

    // Delegate error reporting to caller.
    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        final StringBuilder buffer = new StringBuilder();
        buffer.append("[").append(getErrorHeader(e)).append("] ");
        buffer.append(getErrorMessage(e, tokenNames));
        if(e.token!=null) {
          final CharStream stream = e.token.getInputStream();
          if(stream!=null) {
            int size = stream.size();
            if(size>0) {
              buffer.append("\n").append(stream.substring(0, size-1));
            }
          }
        }
        throw new SqlJetParserException(buffer.toString(), e);
    }

        // unquotes identifier
    public static String unquoteId(String id) {
      if(id==null) {
        return null;
      }
      int len = id.length();
      if(len==0) {
        return "";
      }
      char first = id.charAt(0);
      char last = id.charAt(len-1);
      switch(first) {
        case '[' :
          first = ']';
        case '\'' :
        case '"' :
        case '`' :
          if(first==last) {
            return id.substring(1,len-1);
          }
        default:
          return id;
      }
    }


    public static String quotedId(final CommonTree ast) {
      if(ast instanceof QuotedId) {
        return ((QuotedId)ast).quotedId();
      }
      return ast.getText();
    }

    public static class QuotedId extends CommonTree {
        public QuotedId(Token t) { token=t;}
        public QuotedId(QuotedId node) { super(node); }
        public Tree dupNode() { return new QuotedId(this); }
        public String toString() { return token.getText();}
        public String getText() { return unquoteId(super.getText()); }
        public String quotedId() { return super.getText(); }
    }



    public static class sql_stmt_list_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sql_stmt_list"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:1: sql_stmt_list : sql_stmt ( SEMI ! ( sql_stmt SEMI !)* )? EOF !;
    public final SqlParser.sql_stmt_list_return sql_stmt_list() throws RecognitionException {
        SqlParser.sql_stmt_list_return retval = new SqlParser.sql_stmt_list_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SEMI2=null;
        Token SEMI4=null;
        Token EOF5=null;
        SqlParser.sql_stmt_return sql_stmt1 =null;

        SqlParser.sql_stmt_return sql_stmt3 =null;


        Object SEMI2_tree=null;
        Object SEMI4_tree=null;
        Object EOF5_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:14: ( sql_stmt ( SEMI ! ( sql_stmt SEMI !)* )? EOF !)
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:16: sql_stmt ( SEMI ! ( sql_stmt SEMI !)* )? EOF !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_sql_stmt_in_sql_stmt_list223);
            sql_stmt1=sql_stmt();

            state._fsp--;

            adaptor.addChild(root_0, sql_stmt1.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:25: ( SEMI ! ( sql_stmt SEMI !)* )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==SEMI) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:26: SEMI ! ( sql_stmt SEMI !)*
                    {
                    SEMI2=(Token)match(input,SEMI,FOLLOW_SEMI_in_sql_stmt_list226); 

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:32: ( sql_stmt SEMI !)*
                    loop1:
                    do {
                        int alt1=2;
                        int LA1_0 = input.LA(1);

                        if ( (LA1_0==ALTER||LA1_0==ANALYZE||LA1_0==ATTACH||LA1_0==BEGIN||LA1_0==COMMIT||LA1_0==CREATE||LA1_0==DELETE||LA1_0==DETACH||LA1_0==DROP||LA1_0==END||LA1_0==EXPLAIN||LA1_0==INSERT||LA1_0==PRAGMA||(LA1_0 >= REINDEX && LA1_0 <= RELEASE)||LA1_0==REPLACE||LA1_0==ROLLBACK||(LA1_0 >= SAVEPOINT && LA1_0 <= SELECT)||LA1_0==UPDATE||LA1_0==VACUUM) ) {
                            alt1=1;
                        }


                        switch (alt1) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:159:33: sql_stmt SEMI !
                    	    {
                    	    pushFollow(FOLLOW_sql_stmt_in_sql_stmt_list230);
                    	    sql_stmt3=sql_stmt();

                    	    state._fsp--;

                    	    adaptor.addChild(root_0, sql_stmt3.getTree());

                    	    SEMI4=(Token)match(input,SEMI,FOLLOW_SEMI_in_sql_stmt_list232); 

                    	    }
                    	    break;

                    	default :
                    	    break loop1;
                        }
                    } while (true);


                    }
                    break;

            }


            EOF5=(Token)match(input,EOF,FOLLOW_EOF_in_sql_stmt_list240); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sql_stmt_list"


    public static class sql_stmt_itself_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sql_stmt_itself"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:161:1: sql_stmt_itself : sql_stmt ( SEMI !)? EOF !;
    public final SqlParser.sql_stmt_itself_return sql_stmt_itself() throws RecognitionException {
        SqlParser.sql_stmt_itself_return retval = new SqlParser.sql_stmt_itself_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SEMI7=null;
        Token EOF8=null;
        SqlParser.sql_stmt_return sql_stmt6 =null;


        Object SEMI7_tree=null;
        Object EOF8_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:161:16: ( sql_stmt ( SEMI !)? EOF !)
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:161:18: sql_stmt ( SEMI !)? EOF !
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_sql_stmt_in_sql_stmt_itself248);
            sql_stmt6=sql_stmt();

            state._fsp--;

            adaptor.addChild(root_0, sql_stmt6.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:161:27: ( SEMI !)?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==SEMI) ) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:161:28: SEMI !
                    {
                    SEMI7=(Token)match(input,SEMI,FOLLOW_SEMI_in_sql_stmt_itself251); 

                    }
                    break;

            }


            EOF8=(Token)match(input,EOF,FOLLOW_EOF_in_sql_stmt_itself256); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sql_stmt_itself"


    public static class sql_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sql_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:1: sql_stmt : ( EXPLAIN ( QUERY PLAN )? )? sql_stmt_core ;
    public final SqlParser.sql_stmt_return sql_stmt() throws RecognitionException {
        SqlParser.sql_stmt_return retval = new SqlParser.sql_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPLAIN9=null;
        Token QUERY10=null;
        Token PLAN11=null;
        SqlParser.sql_stmt_core_return sql_stmt_core12 =null;


        Object EXPLAIN9_tree=null;
        Object QUERY10_tree=null;
        Object PLAN11_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:9: ( ( EXPLAIN ( QUERY PLAN )? )? sql_stmt_core )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:11: ( EXPLAIN ( QUERY PLAN )? )? sql_stmt_core
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:11: ( EXPLAIN ( QUERY PLAN )? )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==EXPLAIN) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:12: EXPLAIN ( QUERY PLAN )?
                    {
                    EXPLAIN9=(Token)match(input,EXPLAIN,FOLLOW_EXPLAIN_in_sql_stmt265); 
                    EXPLAIN9_tree = 
                    (Object)adaptor.create(EXPLAIN9)
                    ;
                    adaptor.addChild(root_0, EXPLAIN9_tree);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:20: ( QUERY PLAN )?
                    int alt4=2;
                    int LA4_0 = input.LA(1);

                    if ( (LA4_0==QUERY) ) {
                        alt4=1;
                    }
                    switch (alt4) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:163:21: QUERY PLAN
                            {
                            QUERY10=(Token)match(input,QUERY,FOLLOW_QUERY_in_sql_stmt268); 
                            QUERY10_tree = 
                            (Object)adaptor.create(QUERY10)
                            ;
                            adaptor.addChild(root_0, QUERY10_tree);


                            PLAN11=(Token)match(input,PLAN,FOLLOW_PLAN_in_sql_stmt270); 
                            PLAN11_tree = 
                            (Object)adaptor.create(PLAN11)
                            ;
                            adaptor.addChild(root_0, PLAN11_tree);


                            }
                            break;

                    }


                    }
                    break;

            }


            pushFollow(FOLLOW_sql_stmt_core_in_sql_stmt276);
            sql_stmt_core12=sql_stmt_core();

            state._fsp--;

            adaptor.addChild(root_0, sql_stmt_core12.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sql_stmt"


    public static class sql_stmt_core_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sql_stmt_core"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:165:1: sql_stmt_core : ( pragma_stmt | attach_stmt | detach_stmt | analyze_stmt | reindex_stmt | vacuum_stmt | select_stmt | insert_stmt | update_stmt | delete_stmt | begin_stmt | commit_stmt | rollback_stmt | savepoint_stmt | release_stmt | create_virtual_table_stmt | create_table_stmt | drop_table_stmt | alter_table_stmt | create_view_stmt | drop_view_stmt | create_index_stmt | drop_index_stmt | create_trigger_stmt | drop_trigger_stmt );
    public final SqlParser.sql_stmt_core_return sql_stmt_core() throws RecognitionException {
        SqlParser.sql_stmt_core_return retval = new SqlParser.sql_stmt_core_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.pragma_stmt_return pragma_stmt13 =null;

        SqlParser.attach_stmt_return attach_stmt14 =null;

        SqlParser.detach_stmt_return detach_stmt15 =null;

        SqlParser.analyze_stmt_return analyze_stmt16 =null;

        SqlParser.reindex_stmt_return reindex_stmt17 =null;

        SqlParser.vacuum_stmt_return vacuum_stmt18 =null;

        SqlParser.select_stmt_return select_stmt19 =null;

        SqlParser.insert_stmt_return insert_stmt20 =null;

        SqlParser.update_stmt_return update_stmt21 =null;

        SqlParser.delete_stmt_return delete_stmt22 =null;

        SqlParser.begin_stmt_return begin_stmt23 =null;

        SqlParser.commit_stmt_return commit_stmt24 =null;

        SqlParser.rollback_stmt_return rollback_stmt25 =null;

        SqlParser.savepoint_stmt_return savepoint_stmt26 =null;

        SqlParser.release_stmt_return release_stmt27 =null;

        SqlParser.create_virtual_table_stmt_return create_virtual_table_stmt28 =null;

        SqlParser.create_table_stmt_return create_table_stmt29 =null;

        SqlParser.drop_table_stmt_return drop_table_stmt30 =null;

        SqlParser.alter_table_stmt_return alter_table_stmt31 =null;

        SqlParser.create_view_stmt_return create_view_stmt32 =null;

        SqlParser.drop_view_stmt_return drop_view_stmt33 =null;

        SqlParser.create_index_stmt_return create_index_stmt34 =null;

        SqlParser.drop_index_stmt_return drop_index_stmt35 =null;

        SqlParser.create_trigger_stmt_return create_trigger_stmt36 =null;

        SqlParser.drop_trigger_stmt_return drop_trigger_stmt37 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:166:3: ( pragma_stmt | attach_stmt | detach_stmt | analyze_stmt | reindex_stmt | vacuum_stmt | select_stmt | insert_stmt | update_stmt | delete_stmt | begin_stmt | commit_stmt | rollback_stmt | savepoint_stmt | release_stmt | create_virtual_table_stmt | create_table_stmt | drop_table_stmt | alter_table_stmt | create_view_stmt | drop_view_stmt | create_index_stmt | drop_index_stmt | create_trigger_stmt | drop_trigger_stmt )
            int alt6=25;
            switch ( input.LA(1) ) {
            case PRAGMA:
                {
                alt6=1;
                }
                break;
            case ATTACH:
                {
                alt6=2;
                }
                break;
            case DETACH:
                {
                alt6=3;
                }
                break;
            case ANALYZE:
                {
                alt6=4;
                }
                break;
            case REINDEX:
                {
                alt6=5;
                }
                break;
            case VACUUM:
                {
                alt6=6;
                }
                break;
            case SELECT:
                {
                alt6=7;
                }
                break;
            case INSERT:
            case REPLACE:
                {
                alt6=8;
                }
                break;
            case UPDATE:
                {
                alt6=9;
                }
                break;
            case DELETE:
                {
                alt6=10;
                }
                break;
            case BEGIN:
                {
                alt6=11;
                }
                break;
            case COMMIT:
            case END:
                {
                alt6=12;
                }
                break;
            case ROLLBACK:
                {
                alt6=13;
                }
                break;
            case SAVEPOINT:
                {
                alt6=14;
                }
                break;
            case RELEASE:
                {
                alt6=15;
                }
                break;
            case CREATE:
                {
                switch ( input.LA(2) ) {
                case VIRTUAL:
                    {
                    alt6=16;
                    }
                    break;
                case TEMPORARY:
                    {
                    switch ( input.LA(3) ) {
                    case TABLE:
                        {
                        alt6=17;
                        }
                        break;
                    case VIEW:
                        {
                        alt6=20;
                        }
                        break;
                    case TRIGGER:
                        {
                        alt6=24;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 6, 21, input);

                        throw nvae;

                    }

                    }
                    break;
                case TABLE:
                    {
                    alt6=17;
                    }
                    break;
                case VIEW:
                    {
                    alt6=20;
                    }
                    break;
                case INDEX:
                case UNIQUE:
                    {
                    alt6=22;
                    }
                    break;
                case TRIGGER:
                    {
                    alt6=24;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 6, 17, input);

                    throw nvae;

                }

                }
                break;
            case DROP:
                {
                switch ( input.LA(2) ) {
                case TABLE:
                    {
                    alt6=18;
                    }
                    break;
                case VIEW:
                    {
                    alt6=21;
                    }
                    break;
                case INDEX:
                    {
                    alt6=23;
                    }
                    break;
                case TRIGGER:
                    {
                    alt6=25;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 6, 18, input);

                    throw nvae;

                }

                }
                break;
            case ALTER:
                {
                alt6=19;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:166:5: pragma_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_pragma_stmt_in_sql_stmt_core286);
                    pragma_stmt13=pragma_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, pragma_stmt13.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:167:5: attach_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_attach_stmt_in_sql_stmt_core292);
                    attach_stmt14=attach_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, attach_stmt14.getTree());

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:168:5: detach_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_detach_stmt_in_sql_stmt_core298);
                    detach_stmt15=detach_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, detach_stmt15.getTree());

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:169:5: analyze_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_analyze_stmt_in_sql_stmt_core304);
                    analyze_stmt16=analyze_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, analyze_stmt16.getTree());

                    }
                    break;
                case 5 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:170:5: reindex_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_reindex_stmt_in_sql_stmt_core310);
                    reindex_stmt17=reindex_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, reindex_stmt17.getTree());

                    }
                    break;
                case 6 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:171:5: vacuum_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_vacuum_stmt_in_sql_stmt_core316);
                    vacuum_stmt18=vacuum_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, vacuum_stmt18.getTree());

                    }
                    break;
                case 7 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:173:5: select_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_select_stmt_in_sql_stmt_core323);
                    select_stmt19=select_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, select_stmt19.getTree());

                    }
                    break;
                case 8 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:174:5: insert_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_insert_stmt_in_sql_stmt_core329);
                    insert_stmt20=insert_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, insert_stmt20.getTree());

                    }
                    break;
                case 9 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:175:5: update_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_update_stmt_in_sql_stmt_core335);
                    update_stmt21=update_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, update_stmt21.getTree());

                    }
                    break;
                case 10 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:176:5: delete_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_delete_stmt_in_sql_stmt_core341);
                    delete_stmt22=delete_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, delete_stmt22.getTree());

                    }
                    break;
                case 11 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:177:5: begin_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_begin_stmt_in_sql_stmt_core347);
                    begin_stmt23=begin_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, begin_stmt23.getTree());

                    }
                    break;
                case 12 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:178:5: commit_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_commit_stmt_in_sql_stmt_core353);
                    commit_stmt24=commit_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, commit_stmt24.getTree());

                    }
                    break;
                case 13 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:179:5: rollback_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_rollback_stmt_in_sql_stmt_core359);
                    rollback_stmt25=rollback_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, rollback_stmt25.getTree());

                    }
                    break;
                case 14 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:180:5: savepoint_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_savepoint_stmt_in_sql_stmt_core365);
                    savepoint_stmt26=savepoint_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, savepoint_stmt26.getTree());

                    }
                    break;
                case 15 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:181:5: release_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_release_stmt_in_sql_stmt_core371);
                    release_stmt27=release_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, release_stmt27.getTree());

                    }
                    break;
                case 16 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:183:5: create_virtual_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_virtual_table_stmt_in_sql_stmt_core378);
                    create_virtual_table_stmt28=create_virtual_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_virtual_table_stmt28.getTree());

                    }
                    break;
                case 17 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:184:5: create_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_table_stmt_in_sql_stmt_core384);
                    create_table_stmt29=create_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_table_stmt29.getTree());

                    }
                    break;
                case 18 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:185:5: drop_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_drop_table_stmt_in_sql_stmt_core390);
                    drop_table_stmt30=drop_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, drop_table_stmt30.getTree());

                    }
                    break;
                case 19 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:186:5: alter_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_alter_table_stmt_in_sql_stmt_core396);
                    alter_table_stmt31=alter_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, alter_table_stmt31.getTree());

                    }
                    break;
                case 20 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:187:5: create_view_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_view_stmt_in_sql_stmt_core402);
                    create_view_stmt32=create_view_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_view_stmt32.getTree());

                    }
                    break;
                case 21 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:188:5: drop_view_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_drop_view_stmt_in_sql_stmt_core408);
                    drop_view_stmt33=drop_view_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, drop_view_stmt33.getTree());

                    }
                    break;
                case 22 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:189:5: create_index_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_index_stmt_in_sql_stmt_core414);
                    create_index_stmt34=create_index_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_index_stmt34.getTree());

                    }
                    break;
                case 23 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:190:5: drop_index_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_drop_index_stmt_in_sql_stmt_core420);
                    drop_index_stmt35=drop_index_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, drop_index_stmt35.getTree());

                    }
                    break;
                case 24 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:191:5: create_trigger_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_trigger_stmt_in_sql_stmt_core426);
                    create_trigger_stmt36=create_trigger_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_trigger_stmt36.getTree());

                    }
                    break;
                case 25 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:192:5: drop_trigger_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_drop_trigger_stmt_in_sql_stmt_core432);
                    drop_trigger_stmt37=drop_trigger_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, drop_trigger_stmt37.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sql_stmt_core"


    public static class schema_create_table_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "schema_create_table_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:195:1: schema_create_table_stmt : ( create_virtual_table_stmt | create_table_stmt );
    public final SqlParser.schema_create_table_stmt_return schema_create_table_stmt() throws RecognitionException {
        SqlParser.schema_create_table_stmt_return retval = new SqlParser.schema_create_table_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.create_virtual_table_stmt_return create_virtual_table_stmt38 =null;

        SqlParser.create_table_stmt_return create_table_stmt39 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:195:25: ( create_virtual_table_stmt | create_table_stmt )
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==CREATE) ) {
                int LA7_1 = input.LA(2);

                if ( (LA7_1==VIRTUAL) ) {
                    alt7=1;
                }
                else if ( (LA7_1==TABLE||LA7_1==TEMPORARY) ) {
                    alt7=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 7, 1, input);

                    throw nvae;

                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;

            }
            switch (alt7) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:195:27: create_virtual_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_virtual_table_stmt_in_schema_create_table_stmt442);
                    create_virtual_table_stmt38=create_virtual_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_virtual_table_stmt38.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:195:55: create_table_stmt
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_create_table_stmt_in_schema_create_table_stmt446);
                    create_table_stmt39=create_table_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, create_table_stmt39.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "schema_create_table_stmt"


    public static class qualified_table_name_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "qualified_table_name"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:1: qualified_table_name : (database_name= id DOT )? table_name= id ( INDEXED BY index_name= id | NOT INDEXED )? ;
    public final SqlParser.qualified_table_name_return qualified_table_name() throws RecognitionException {
        SqlParser.qualified_table_name_return retval = new SqlParser.qualified_table_name_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DOT40=null;
        Token INDEXED41=null;
        Token BY42=null;
        Token NOT43=null;
        Token INDEXED44=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.id_return index_name =null;


        Object DOT40_tree=null;
        Object INDEXED41_tree=null;
        Object BY42_tree=null;
        Object NOT43_tree=null;
        Object INDEXED44_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:21: ( (database_name= id DOT )? table_name= id ( INDEXED BY index_name= id | NOT INDEXED )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:23: (database_name= id DOT )? table_name= id ( INDEXED BY index_name= id | NOT INDEXED )?
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:23: (database_name= id DOT )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA8_1 = input.LA(2);

                    if ( (LA8_1==DOT) ) {
                        alt8=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA8_2 = input.LA(2);

                    if ( (LA8_2==DOT) ) {
                        alt8=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA8_3 = input.LA(2);

                    if ( (LA8_3==DOT) ) {
                        alt8=1;
                    }
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:24: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_qualified_table_name456);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT40=(Token)match(input,DOT,FOLLOW_DOT_in_qualified_table_name458); 
                    DOT40_tree = 
                    (Object)adaptor.create(DOT40)
                    ;
                    adaptor.addChild(root_0, DOT40_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_qualified_table_name464);
            table_name=id();

            state._fsp--;

            adaptor.addChild(root_0, table_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:61: ( INDEXED BY index_name= id | NOT INDEXED )?
            int alt9=3;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==INDEXED) ) {
                alt9=1;
            }
            else if ( (LA9_0==NOT) ) {
                alt9=2;
            }
            switch (alt9) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:62: INDEXED BY index_name= id
                    {
                    INDEXED41=(Token)match(input,INDEXED,FOLLOW_INDEXED_in_qualified_table_name467); 
                    INDEXED41_tree = 
                    (Object)adaptor.create(INDEXED41)
                    ;
                    adaptor.addChild(root_0, INDEXED41_tree);


                    BY42=(Token)match(input,BY,FOLLOW_BY_in_qualified_table_name469); 
                    BY42_tree = 
                    (Object)adaptor.create(BY42)
                    ;
                    adaptor.addChild(root_0, BY42_tree);


                    pushFollow(FOLLOW_id_in_qualified_table_name473);
                    index_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, index_name.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:197:89: NOT INDEXED
                    {
                    NOT43=(Token)match(input,NOT,FOLLOW_NOT_in_qualified_table_name477); 
                    NOT43_tree = 
                    (Object)adaptor.create(NOT43)
                    ;
                    adaptor.addChild(root_0, NOT43_tree);


                    INDEXED44=(Token)match(input,INDEXED,FOLLOW_INDEXED_in_qualified_table_name479); 
                    INDEXED44_tree = 
                    (Object)adaptor.create(INDEXED44)
                    ;
                    adaptor.addChild(root_0, INDEXED44_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "qualified_table_name"


    public static class expr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:199:1: expr : or_subexpr ( OR ^ or_subexpr )* ;
    public final SqlParser.expr_return expr() throws RecognitionException {
        SqlParser.expr_return retval = new SqlParser.expr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token OR46=null;
        SqlParser.or_subexpr_return or_subexpr45 =null;

        SqlParser.or_subexpr_return or_subexpr47 =null;


        Object OR46_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:199:5: ( or_subexpr ( OR ^ or_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:199:7: or_subexpr ( OR ^ or_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_or_subexpr_in_expr488);
            or_subexpr45=or_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, or_subexpr45.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:199:18: ( OR ^ or_subexpr )*
            loop10:
            do {
                int alt10=2;
                alt10 = dfa10.predict(input);
                switch (alt10) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:199:19: OR ^ or_subexpr
            	    {
            	    OR46=(Token)match(input,OR,FOLLOW_OR_in_expr491); 
            	    OR46_tree = 
            	    (Object)adaptor.create(OR46)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(OR46_tree, root_0);


            	    pushFollow(FOLLOW_or_subexpr_in_expr494);
            	    or_subexpr47=or_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, or_subexpr47.getTree());

            	    }
            	    break;

            	default :
            	    break loop10;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expr"


    public static class or_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "or_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:201:1: or_subexpr : and_subexpr ( AND ^ and_subexpr )* ;
    public final SqlParser.or_subexpr_return or_subexpr() throws RecognitionException {
        SqlParser.or_subexpr_return retval = new SqlParser.or_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token AND49=null;
        SqlParser.and_subexpr_return and_subexpr48 =null;

        SqlParser.and_subexpr_return and_subexpr50 =null;


        Object AND49_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:201:11: ( and_subexpr ( AND ^ and_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:201:13: and_subexpr ( AND ^ and_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_and_subexpr_in_or_subexpr503);
            and_subexpr48=and_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, and_subexpr48.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:201:25: ( AND ^ and_subexpr )*
            loop11:
            do {
                int alt11=2;
                alt11 = dfa11.predict(input);
                switch (alt11) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:201:26: AND ^ and_subexpr
            	    {
            	    AND49=(Token)match(input,AND,FOLLOW_AND_in_or_subexpr506); 
            	    AND49_tree = 
            	    (Object)adaptor.create(AND49)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(AND49_tree, root_0);


            	    pushFollow(FOLLOW_and_subexpr_in_or_subexpr509);
            	    and_subexpr50=and_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, and_subexpr50.getTree());

            	    }
            	    break;

            	default :
            	    break loop11;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "or_subexpr"


    public static class and_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "and_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:203:1: and_subexpr : eq_subexpr ( cond_expr ^)? ;
    public final SqlParser.and_subexpr_return and_subexpr() throws RecognitionException {
        SqlParser.and_subexpr_return retval = new SqlParser.and_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.eq_subexpr_return eq_subexpr51 =null;

        SqlParser.cond_expr_return cond_expr52 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:203:12: ( eq_subexpr ( cond_expr ^)? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:203:14: eq_subexpr ( cond_expr ^)?
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_eq_subexpr_in_and_subexpr518);
            eq_subexpr51=eq_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, eq_subexpr51.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:203:34: ( cond_expr ^)?
            int alt12=2;
            alt12 = dfa12.predict(input);
            switch (alt12) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:203:34: cond_expr ^
                    {
                    pushFollow(FOLLOW_cond_expr_in_and_subexpr520);
                    cond_expr52=cond_expr();

                    state._fsp--;

                    root_0 = (Object)adaptor.becomeRoot(cond_expr52.getTree(), root_0);

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "and_subexpr"


    public static class cond_expr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cond_expr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:205:1: cond_expr : ( ( NOT )? match_op match_expr= eq_subexpr ( ESCAPE escape_expr= eq_subexpr )? -> ^( match_op $match_expr ( NOT )? ( ^( ESCAPE $escape_expr) )? ) | ( NOT )? IN LPAREN expr ( COMMA expr )* RPAREN -> ^( IN_VALUES ( NOT )? ^( IN ( expr )+ ) ) | ( NOT )? IN (database_name= id DOT )? table_name= id -> ^( IN_TABLE ( NOT )? ^( IN ^( $table_name ( $database_name)? ) ) ) | ( NOT )? IN ^ LPAREN ! ( select_stmt )? RPAREN !| ( NOT )? EQUALS ^ LPAREN ! ( select_stmt )? RPAREN !| ( ISNULL -> IS_NULL | NOTNULL -> NOT_NULL | IS NULL -> IS_NULL | NOT NULL -> NOT_NULL | IS NOT NULL -> NOT_NULL ) | IS NOT ^ eq_subexpr | ( NOT )? BETWEEN e1= eq_subexpr AND e2= eq_subexpr -> ^( BETWEEN ( NOT )? ^( AND $e1 $e2) ) | ( ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr )+ );
    public final SqlParser.cond_expr_return cond_expr() throws RecognitionException {
        SqlParser.cond_expr_return retval = new SqlParser.cond_expr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token NOT53=null;
        Token ESCAPE55=null;
        Token NOT56=null;
        Token IN57=null;
        Token LPAREN58=null;
        Token COMMA60=null;
        Token RPAREN62=null;
        Token NOT63=null;
        Token IN64=null;
        Token DOT65=null;
        Token NOT66=null;
        Token IN67=null;
        Token LPAREN68=null;
        Token RPAREN70=null;
        Token NOT71=null;
        Token EQUALS72=null;
        Token LPAREN73=null;
        Token RPAREN75=null;
        Token ISNULL76=null;
        Token NOTNULL77=null;
        Token IS78=null;
        Token NULL79=null;
        Token NOT80=null;
        Token NULL81=null;
        Token IS82=null;
        Token NOT83=null;
        Token NULL84=null;
        Token IS85=null;
        Token NOT86=null;
        Token NOT88=null;
        Token BETWEEN89=null;
        Token AND90=null;
        Token set91=null;
        SqlParser.eq_subexpr_return match_expr =null;

        SqlParser.eq_subexpr_return escape_expr =null;

        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.eq_subexpr_return e1 =null;

        SqlParser.eq_subexpr_return e2 =null;

        SqlParser.match_op_return match_op54 =null;

        SqlParser.expr_return expr59 =null;

        SqlParser.expr_return expr61 =null;

        SqlParser.select_stmt_return select_stmt69 =null;

        SqlParser.select_stmt_return select_stmt74 =null;

        SqlParser.eq_subexpr_return eq_subexpr87 =null;

        SqlParser.eq_subexpr_return eq_subexpr92 =null;


        Object NOT53_tree=null;
        Object ESCAPE55_tree=null;
        Object NOT56_tree=null;
        Object IN57_tree=null;
        Object LPAREN58_tree=null;
        Object COMMA60_tree=null;
        Object RPAREN62_tree=null;
        Object NOT63_tree=null;
        Object IN64_tree=null;
        Object DOT65_tree=null;
        Object NOT66_tree=null;
        Object IN67_tree=null;
        Object LPAREN68_tree=null;
        Object RPAREN70_tree=null;
        Object NOT71_tree=null;
        Object EQUALS72_tree=null;
        Object LPAREN73_tree=null;
        Object RPAREN75_tree=null;
        Object ISNULL76_tree=null;
        Object NOTNULL77_tree=null;
        Object IS78_tree=null;
        Object NULL79_tree=null;
        Object NOT80_tree=null;
        Object NULL81_tree=null;
        Object IS82_tree=null;
        Object NOT83_tree=null;
        Object NULL84_tree=null;
        Object IS85_tree=null;
        Object NOT86_tree=null;
        Object NOT88_tree=null;
        Object BETWEEN89_tree=null;
        Object AND90_tree=null;
        Object set91_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_NOTNULL=new RewriteRuleTokenStream(adaptor,"token NOTNULL");
        RewriteRuleTokenStream stream_NULL=new RewriteRuleTokenStream(adaptor,"token NULL");
        RewriteRuleTokenStream stream_IN=new RewriteRuleTokenStream(adaptor,"token IN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_BETWEEN=new RewriteRuleTokenStream(adaptor,"token BETWEEN");
        RewriteRuleTokenStream stream_IS=new RewriteRuleTokenStream(adaptor,"token IS");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_ESCAPE=new RewriteRuleTokenStream(adaptor,"token ESCAPE");
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_AND=new RewriteRuleTokenStream(adaptor,"token AND");
        RewriteRuleTokenStream stream_ISNULL=new RewriteRuleTokenStream(adaptor,"token ISNULL");
        RewriteRuleSubtreeStream stream_eq_subexpr=new RewriteRuleSubtreeStream(adaptor,"rule eq_subexpr");
        RewriteRuleSubtreeStream stream_match_op=new RewriteRuleSubtreeStream(adaptor,"rule match_op");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:3: ( ( NOT )? match_op match_expr= eq_subexpr ( ESCAPE escape_expr= eq_subexpr )? -> ^( match_op $match_expr ( NOT )? ( ^( ESCAPE $escape_expr) )? ) | ( NOT )? IN LPAREN expr ( COMMA expr )* RPAREN -> ^( IN_VALUES ( NOT )? ^( IN ( expr )+ ) ) | ( NOT )? IN (database_name= id DOT )? table_name= id -> ^( IN_TABLE ( NOT )? ^( IN ^( $table_name ( $database_name)? ) ) ) | ( NOT )? IN ^ LPAREN ! ( select_stmt )? RPAREN !| ( NOT )? EQUALS ^ LPAREN ! ( select_stmt )? RPAREN !| ( ISNULL -> IS_NULL | NOTNULL -> NOT_NULL | IS NULL -> IS_NULL | NOT NULL -> NOT_NULL | IS NOT NULL -> NOT_NULL ) | IS NOT ^ eq_subexpr | ( NOT )? BETWEEN e1= eq_subexpr AND e2= eq_subexpr -> ^( BETWEEN ( NOT )? ^( AND $e1 $e2) ) | ( ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr )+ )
            int alt26=9;
            alt26 = dfa26.predict(input);
            switch (alt26) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:5: ( NOT )? match_op match_expr= eq_subexpr ( ESCAPE escape_expr= eq_subexpr )?
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:5: ( NOT )?
                    int alt13=2;
                    int LA13_0 = input.LA(1);

                    if ( (LA13_0==NOT) ) {
                        alt13=1;
                    }
                    switch (alt13) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:5: NOT
                            {
                            NOT53=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr532);  
                            stream_NOT.add(NOT53);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_match_op_in_cond_expr535);
                    match_op54=match_op();

                    state._fsp--;

                    stream_match_op.add(match_op54.getTree());

                    pushFollow(FOLLOW_eq_subexpr_in_cond_expr539);
                    match_expr=eq_subexpr();

                    state._fsp--;

                    stream_eq_subexpr.add(match_expr.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:41: ( ESCAPE escape_expr= eq_subexpr )?
                    int alt14=2;
                    alt14 = dfa14.predict(input);
                    switch (alt14) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:42: ESCAPE escape_expr= eq_subexpr
                            {
                            ESCAPE55=(Token)match(input,ESCAPE,FOLLOW_ESCAPE_in_cond_expr542);  
                            stream_ESCAPE.add(ESCAPE55);


                            pushFollow(FOLLOW_eq_subexpr_in_cond_expr546);
                            escape_expr=eq_subexpr();

                            state._fsp--;

                            stream_eq_subexpr.add(escape_expr.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: ESCAPE, match_expr, match_op, NOT, escape_expr
                    // token labels: 
                    // rule labels: match_expr, escape_expr, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_match_expr=new RewriteRuleSubtreeStream(adaptor,"rule match_expr",match_expr!=null?match_expr.tree:null);
                    RewriteRuleSubtreeStream stream_escape_expr=new RewriteRuleSubtreeStream(adaptor,"rule escape_expr",escape_expr!=null?escape_expr.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 206:74: -> ^( match_op $match_expr ( NOT )? ( ^( ESCAPE $escape_expr) )? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:77: ^( match_op $match_expr ( NOT )? ( ^( ESCAPE $escape_expr) )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_match_op.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_match_expr.nextTree());

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:100: ( NOT )?
                        if ( stream_NOT.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_NOT.nextNode()
                            );

                        }
                        stream_NOT.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:105: ( ^( ESCAPE $escape_expr) )?
                        if ( stream_ESCAPE.hasNext()||stream_escape_expr.hasNext() ) {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:206:105: ^( ESCAPE $escape_expr)
                            {
                            Object root_2 = (Object)adaptor.nil();
                            root_2 = (Object)adaptor.becomeRoot(
                            stream_ESCAPE.nextNode()
                            , root_2);

                            adaptor.addChild(root_2, stream_escape_expr.nextTree());

                            adaptor.addChild(root_1, root_2);
                            }

                        }
                        stream_ESCAPE.reset();
                        stream_escape_expr.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:5: ( NOT )? IN LPAREN expr ( COMMA expr )* RPAREN
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:5: ( NOT )?
                    int alt15=2;
                    int LA15_0 = input.LA(1);

                    if ( (LA15_0==NOT) ) {
                        alt15=1;
                    }
                    switch (alt15) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:5: NOT
                            {
                            NOT56=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr574);  
                            stream_NOT.add(NOT56);


                            }
                            break;

                    }


                    IN57=(Token)match(input,IN,FOLLOW_IN_in_cond_expr577);  
                    stream_IN.add(IN57);


                    LPAREN58=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_cond_expr579);  
                    stream_LPAREN.add(LPAREN58);


                    pushFollow(FOLLOW_expr_in_cond_expr581);
                    expr59=expr();

                    state._fsp--;

                    stream_expr.add(expr59.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:25: ( COMMA expr )*
                    loop16:
                    do {
                        int alt16=2;
                        int LA16_0 = input.LA(1);

                        if ( (LA16_0==COMMA) ) {
                            alt16=1;
                        }


                        switch (alt16) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:26: COMMA expr
                    	    {
                    	    COMMA60=(Token)match(input,COMMA,FOLLOW_COMMA_in_cond_expr584);  
                    	    stream_COMMA.add(COMMA60);


                    	    pushFollow(FOLLOW_expr_in_cond_expr586);
                    	    expr61=expr();

                    	    state._fsp--;

                    	    stream_expr.add(expr61.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop16;
                        }
                    } while (true);


                    RPAREN62=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_cond_expr590);  
                    stream_RPAREN.add(RPAREN62);


                    // AST REWRITE
                    // elements: expr, IN, NOT
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 207:46: -> ^( IN_VALUES ( NOT )? ^( IN ( expr )+ ) )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:49: ^( IN_VALUES ( NOT )? ^( IN ( expr )+ ) )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(IN_VALUES, "IN_VALUES")
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:61: ( NOT )?
                        if ( stream_NOT.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_NOT.nextNode()
                            );

                        }
                        stream_NOT.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:207:66: ^( IN ( expr )+ )
                        {
                        Object root_2 = (Object)adaptor.nil();
                        root_2 = (Object)adaptor.becomeRoot(
                        stream_IN.nextNode()
                        , root_2);

                        if ( !(stream_expr.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_expr.hasNext() ) {
                            adaptor.addChild(root_2, stream_expr.nextTree());

                        }
                        stream_expr.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:5: ( NOT )? IN (database_name= id DOT )? table_name= id
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:5: ( NOT )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( (LA17_0==NOT) ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:5: NOT
                            {
                            NOT63=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr612);  
                            stream_NOT.add(NOT63);


                            }
                            break;

                    }


                    IN64=(Token)match(input,IN,FOLLOW_IN_in_cond_expr615);  
                    stream_IN.add(IN64);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:13: (database_name= id DOT )?
                    int alt18=2;
                    alt18 = dfa18.predict(input);
                    switch (alt18) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:14: database_name= id DOT
                            {
                            pushFollow(FOLLOW_id_in_cond_expr620);
                            database_name=id();

                            state._fsp--;

                            stream_id.add(database_name.getTree());

                            DOT65=(Token)match(input,DOT,FOLLOW_DOT_in_cond_expr622);  
                            stream_DOT.add(DOT65);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_id_in_cond_expr628);
                    table_name=id();

                    state._fsp--;

                    stream_id.add(table_name.getTree());

                    // AST REWRITE
                    // elements: IN, database_name, table_name, NOT
                    // token labels: 
                    // rule labels: database_name, table_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
                    RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 208:51: -> ^( IN_TABLE ( NOT )? ^( IN ^( $table_name ( $database_name)? ) ) )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:54: ^( IN_TABLE ( NOT )? ^( IN ^( $table_name ( $database_name)? ) ) )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(IN_TABLE, "IN_TABLE")
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:65: ( NOT )?
                        if ( stream_NOT.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_NOT.nextNode()
                            );

                        }
                        stream_NOT.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:70: ^( IN ^( $table_name ( $database_name)? ) )
                        {
                        Object root_2 = (Object)adaptor.nil();
                        root_2 = (Object)adaptor.becomeRoot(
                        stream_IN.nextNode()
                        , root_2);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:75: ^( $table_name ( $database_name)? )
                        {
                        Object root_3 = (Object)adaptor.nil();
                        root_3 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_3);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:208:90: ( $database_name)?
                        if ( stream_database_name.hasNext() ) {
                            adaptor.addChild(root_3, stream_database_name.nextTree());

                        }
                        stream_database_name.reset();

                        adaptor.addChild(root_2, root_3);
                        }

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:209:5: ( NOT )? IN ^ LPAREN ! ( select_stmt )? RPAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:209:5: ( NOT )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==NOT) ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:209:5: NOT
                            {
                            NOT66=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr656); 
                            NOT66_tree = 
                            (Object)adaptor.create(NOT66)
                            ;
                            adaptor.addChild(root_0, NOT66_tree);


                            }
                            break;

                    }


                    IN67=(Token)match(input,IN,FOLLOW_IN_in_cond_expr659); 
                    IN67_tree = 
                    (Object)adaptor.create(IN67)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(IN67_tree, root_0);


                    LPAREN68=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_cond_expr662); 

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:209:22: ( select_stmt )?
                    int alt20=2;
                    int LA20_0 = input.LA(1);

                    if ( (LA20_0==SELECT) ) {
                        alt20=1;
                    }
                    switch (alt20) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:209:22: select_stmt
                            {
                            pushFollow(FOLLOW_select_stmt_in_cond_expr665);
                            select_stmt69=select_stmt();

                            state._fsp--;

                            adaptor.addChild(root_0, select_stmt69.getTree());

                            }
                            break;

                    }


                    RPAREN70=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_cond_expr668); 

                    }
                    break;
                case 5 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:210:5: ( NOT )? EQUALS ^ LPAREN ! ( select_stmt )? RPAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:210:5: ( NOT )?
                    int alt21=2;
                    int LA21_0 = input.LA(1);

                    if ( (LA21_0==NOT) ) {
                        alt21=1;
                    }
                    switch (alt21) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:210:5: NOT
                            {
                            NOT71=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr675); 
                            NOT71_tree = 
                            (Object)adaptor.create(NOT71)
                            ;
                            adaptor.addChild(root_0, NOT71_tree);


                            }
                            break;

                    }


                    EQUALS72=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_cond_expr678); 
                    EQUALS72_tree = 
                    (Object)adaptor.create(EQUALS72)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(EQUALS72_tree, root_0);


                    LPAREN73=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_cond_expr681); 

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:210:26: ( select_stmt )?
                    int alt22=2;
                    int LA22_0 = input.LA(1);

                    if ( (LA22_0==SELECT) ) {
                        alt22=1;
                    }
                    switch (alt22) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:210:26: select_stmt
                            {
                            pushFollow(FOLLOW_select_stmt_in_cond_expr684);
                            select_stmt74=select_stmt();

                            state._fsp--;

                            adaptor.addChild(root_0, select_stmt74.getTree());

                            }
                            break;

                    }


                    RPAREN75=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_cond_expr687); 

                    }
                    break;
                case 6 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:5: ( ISNULL -> IS_NULL | NOTNULL -> NOT_NULL | IS NULL -> IS_NULL | NOT NULL -> NOT_NULL | IS NOT NULL -> NOT_NULL )
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:5: ( ISNULL -> IS_NULL | NOTNULL -> NOT_NULL | IS NULL -> IS_NULL | NOT NULL -> NOT_NULL | IS NOT NULL -> NOT_NULL )
                    int alt23=5;
                    switch ( input.LA(1) ) {
                    case ISNULL:
                        {
                        alt23=1;
                        }
                        break;
                    case NOTNULL:
                        {
                        alt23=2;
                        }
                        break;
                    case IS:
                        {
                        int LA23_3 = input.LA(2);

                        if ( (LA23_3==NULL) ) {
                            alt23=3;
                        }
                        else if ( (LA23_3==NOT) ) {
                            alt23=5;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 23, 3, input);

                            throw nvae;

                        }
                        }
                        break;
                    case NOT:
                        {
                        alt23=4;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 23, 0, input);

                        throw nvae;

                    }

                    switch (alt23) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:6: ISNULL
                            {
                            ISNULL76=(Token)match(input,ISNULL,FOLLOW_ISNULL_in_cond_expr695);  
                            stream_ISNULL.add(ISNULL76);


                            // AST REWRITE
                            // elements: 
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 211:13: -> IS_NULL
                            {
                                adaptor.addChild(root_0, 
                                (Object)adaptor.create(IS_NULL, "IS_NULL")
                                );

                            }


                            retval.tree = root_0;

                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:26: NOTNULL
                            {
                            NOTNULL77=(Token)match(input,NOTNULL,FOLLOW_NOTNULL_in_cond_expr703);  
                            stream_NOTNULL.add(NOTNULL77);


                            // AST REWRITE
                            // elements: 
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 211:34: -> NOT_NULL
                            {
                                adaptor.addChild(root_0, 
                                (Object)adaptor.create(NOT_NULL, "NOT_NULL")
                                );

                            }


                            retval.tree = root_0;

                            }
                            break;
                        case 3 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:48: IS NULL
                            {
                            IS78=(Token)match(input,IS,FOLLOW_IS_in_cond_expr711);  
                            stream_IS.add(IS78);


                            NULL79=(Token)match(input,NULL,FOLLOW_NULL_in_cond_expr713);  
                            stream_NULL.add(NULL79);


                            // AST REWRITE
                            // elements: 
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 211:56: -> IS_NULL
                            {
                                adaptor.addChild(root_0, 
                                (Object)adaptor.create(IS_NULL, "IS_NULL")
                                );

                            }


                            retval.tree = root_0;

                            }
                            break;
                        case 4 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:69: NOT NULL
                            {
                            NOT80=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr721);  
                            stream_NOT.add(NOT80);


                            NULL81=(Token)match(input,NULL,FOLLOW_NULL_in_cond_expr723);  
                            stream_NULL.add(NULL81);


                            // AST REWRITE
                            // elements: 
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 211:78: -> NOT_NULL
                            {
                                adaptor.addChild(root_0, 
                                (Object)adaptor.create(NOT_NULL, "NOT_NULL")
                                );

                            }


                            retval.tree = root_0;

                            }
                            break;
                        case 5 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:211:92: IS NOT NULL
                            {
                            IS82=(Token)match(input,IS,FOLLOW_IS_in_cond_expr731);  
                            stream_IS.add(IS82);


                            NOT83=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr733);  
                            stream_NOT.add(NOT83);


                            NULL84=(Token)match(input,NULL,FOLLOW_NULL_in_cond_expr735);  
                            stream_NULL.add(NULL84);


                            // AST REWRITE
                            // elements: 
                            // token labels: 
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            retval.tree = root_0;
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (Object)adaptor.nil();
                            // 211:104: -> NOT_NULL
                            {
                                adaptor.addChild(root_0, 
                                (Object)adaptor.create(NOT_NULL, "NOT_NULL")
                                );

                            }


                            retval.tree = root_0;

                            }
                            break;

                    }


                    }
                    break;
                case 7 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:212:5: IS NOT ^ eq_subexpr
                    {
                    root_0 = (Object)adaptor.nil();


                    IS85=(Token)match(input,IS,FOLLOW_IS_in_cond_expr746); 
                    IS85_tree = 
                    (Object)adaptor.create(IS85)
                    ;
                    adaptor.addChild(root_0, IS85_tree);


                    NOT86=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr748); 
                    NOT86_tree = 
                    (Object)adaptor.create(NOT86)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(NOT86_tree, root_0);


                    pushFollow(FOLLOW_eq_subexpr_in_cond_expr751);
                    eq_subexpr87=eq_subexpr();

                    state._fsp--;

                    adaptor.addChild(root_0, eq_subexpr87.getTree());

                    }
                    break;
                case 8 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:5: ( NOT )? BETWEEN e1= eq_subexpr AND e2= eq_subexpr
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:5: ( NOT )?
                    int alt24=2;
                    int LA24_0 = input.LA(1);

                    if ( (LA24_0==NOT) ) {
                        alt24=1;
                    }
                    switch (alt24) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:5: NOT
                            {
                            NOT88=(Token)match(input,NOT,FOLLOW_NOT_in_cond_expr757);  
                            stream_NOT.add(NOT88);


                            }
                            break;

                    }


                    BETWEEN89=(Token)match(input,BETWEEN,FOLLOW_BETWEEN_in_cond_expr760);  
                    stream_BETWEEN.add(BETWEEN89);


                    pushFollow(FOLLOW_eq_subexpr_in_cond_expr764);
                    e1=eq_subexpr();

                    state._fsp--;

                    stream_eq_subexpr.add(e1.getTree());

                    AND90=(Token)match(input,AND,FOLLOW_AND_in_cond_expr766);  
                    stream_AND.add(AND90);


                    pushFollow(FOLLOW_eq_subexpr_in_cond_expr770);
                    e2=eq_subexpr();

                    state._fsp--;

                    stream_eq_subexpr.add(e2.getTree());

                    // AST REWRITE
                    // elements: NOT, AND, e1, BETWEEN, e2
                    // token labels: 
                    // rule labels: e1, e2, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_e1=new RewriteRuleSubtreeStream(adaptor,"rule e1",e1!=null?e1.tree:null);
                    RewriteRuleSubtreeStream stream_e2=new RewriteRuleSubtreeStream(adaptor,"rule e2",e2!=null?e2.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 213:50: -> ^( BETWEEN ( NOT )? ^( AND $e1 $e2) )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:53: ^( BETWEEN ( NOT )? ^( AND $e1 $e2) )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        stream_BETWEEN.nextNode()
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:63: ( NOT )?
                        if ( stream_NOT.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_NOT.nextNode()
                            );

                        }
                        stream_NOT.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:213:68: ^( AND $e1 $e2)
                        {
                        Object root_2 = (Object)adaptor.nil();
                        root_2 = (Object)adaptor.becomeRoot(
                        stream_AND.nextNode()
                        , root_2);

                        adaptor.addChild(root_2, stream_e1.nextTree());

                        adaptor.addChild(root_2, stream_e2.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:214:5: ( ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr )+
                    {
                    root_0 = (Object)adaptor.nil();


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:214:5: ( ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr )+
                    int cnt25=0;
                    loop25:
                    do {
                        int alt25=2;
                        int LA25_0 = input.LA(1);

                        if ( ((LA25_0 >= EQUALS && LA25_0 <= EQUALS2)||(LA25_0 >= NOT_EQUALS && LA25_0 <= NOT_EQUALS2)) ) {
                            alt25=1;
                        }


                        switch (alt25) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:214:6: ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr
                    	    {
                    	    set91=(Token)input.LT(1);

                    	    set91=(Token)input.LT(1);

                    	    if ( (input.LA(1) >= EQUALS && input.LA(1) <= EQUALS2)||(input.LA(1) >= NOT_EQUALS && input.LA(1) <= NOT_EQUALS2) ) {
                    	        input.consume();
                    	        root_0 = (Object)adaptor.becomeRoot(
                    	        (Object)adaptor.create(set91)
                    	        , root_0);
                    	        state.errorRecovery=false;
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        throw mse;
                    	    }


                    	    pushFollow(FOLLOW_eq_subexpr_in_cond_expr813);
                    	    eq_subexpr92=eq_subexpr();

                    	    state._fsp--;

                    	    adaptor.addChild(root_0, eq_subexpr92.getTree());

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt25 >= 1 ) break loop25;
                                EarlyExitException eee =
                                    new EarlyExitException(25, input);
                                throw eee;
                        }
                        cnt25++;
                    } while (true);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cond_expr"


    public static class match_op_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "match_op"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:217:1: match_op : ( LIKE | GLOB | REGEXP | MATCH );
    public final SqlParser.match_op_return match_op() throws RecognitionException {
        SqlParser.match_op_return retval = new SqlParser.match_op_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set93=null;

        Object set93_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:217:9: ( LIKE | GLOB | REGEXP | MATCH )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
            {
            root_0 = (Object)adaptor.nil();


            set93=(Token)input.LT(1);

            if ( input.LA(1)==GLOB||input.LA(1)==LIKE||input.LA(1)==MATCH||input.LA(1)==REGEXP ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set93)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "match_op"


    public static class eq_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "eq_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:219:1: eq_subexpr : neq_subexpr ( ( LESS | LESS_OR_EQ | GREATER | GREATER_OR_EQ ) ^ neq_subexpr )* ;
    public final SqlParser.eq_subexpr_return eq_subexpr() throws RecognitionException {
        SqlParser.eq_subexpr_return retval = new SqlParser.eq_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set95=null;
        SqlParser.neq_subexpr_return neq_subexpr94 =null;

        SqlParser.neq_subexpr_return neq_subexpr96 =null;


        Object set95_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:219:11: ( neq_subexpr ( ( LESS | LESS_OR_EQ | GREATER | GREATER_OR_EQ ) ^ neq_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:219:13: neq_subexpr ( ( LESS | LESS_OR_EQ | GREATER | GREATER_OR_EQ ) ^ neq_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_neq_subexpr_in_eq_subexpr846);
            neq_subexpr94=neq_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, neq_subexpr94.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:219:25: ( ( LESS | LESS_OR_EQ | GREATER | GREATER_OR_EQ ) ^ neq_subexpr )*
            loop27:
            do {
                int alt27=2;
                int LA27_0 = input.LA(1);

                if ( ((LA27_0 >= GREATER && LA27_0 <= GREATER_OR_EQ)||(LA27_0 >= LESS && LA27_0 <= LESS_OR_EQ)) ) {
                    alt27=1;
                }


                switch (alt27) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:219:26: ( LESS | LESS_OR_EQ | GREATER | GREATER_OR_EQ ) ^ neq_subexpr
            	    {
            	    set95=(Token)input.LT(1);

            	    set95=(Token)input.LT(1);

            	    if ( (input.LA(1) >= GREATER && input.LA(1) <= GREATER_OR_EQ)||(input.LA(1) >= LESS && input.LA(1) <= LESS_OR_EQ) ) {
            	        input.consume();
            	        root_0 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(set95)
            	        , root_0);
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_neq_subexpr_in_eq_subexpr866);
            	    neq_subexpr96=neq_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, neq_subexpr96.getTree());

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "eq_subexpr"


    public static class neq_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "neq_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:221:1: neq_subexpr : bit_subexpr ( ( SHIFT_LEFT | SHIFT_RIGHT | AMPERSAND | PIPE ) ^ bit_subexpr )* ;
    public final SqlParser.neq_subexpr_return neq_subexpr() throws RecognitionException {
        SqlParser.neq_subexpr_return retval = new SqlParser.neq_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set98=null;
        SqlParser.bit_subexpr_return bit_subexpr97 =null;

        SqlParser.bit_subexpr_return bit_subexpr99 =null;


        Object set98_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:221:12: ( bit_subexpr ( ( SHIFT_LEFT | SHIFT_RIGHT | AMPERSAND | PIPE ) ^ bit_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:221:14: bit_subexpr ( ( SHIFT_LEFT | SHIFT_RIGHT | AMPERSAND | PIPE ) ^ bit_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_bit_subexpr_in_neq_subexpr875);
            bit_subexpr97=bit_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, bit_subexpr97.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:221:26: ( ( SHIFT_LEFT | SHIFT_RIGHT | AMPERSAND | PIPE ) ^ bit_subexpr )*
            loop28:
            do {
                int alt28=2;
                int LA28_0 = input.LA(1);

                if ( (LA28_0==AMPERSAND||LA28_0==PIPE||(LA28_0 >= SHIFT_LEFT && LA28_0 <= SHIFT_RIGHT)) ) {
                    alt28=1;
                }


                switch (alt28) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:221:27: ( SHIFT_LEFT | SHIFT_RIGHT | AMPERSAND | PIPE ) ^ bit_subexpr
            	    {
            	    set98=(Token)input.LT(1);

            	    set98=(Token)input.LT(1);

            	    if ( input.LA(1)==AMPERSAND||input.LA(1)==PIPE||(input.LA(1) >= SHIFT_LEFT && input.LA(1) <= SHIFT_RIGHT) ) {
            	        input.consume();
            	        root_0 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(set98)
            	        , root_0);
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_bit_subexpr_in_neq_subexpr895);
            	    bit_subexpr99=bit_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, bit_subexpr99.getTree());

            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "neq_subexpr"


    public static class bit_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bit_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:223:1: bit_subexpr : add_subexpr ( ( PLUS | MINUS ) ^ add_subexpr )* ;
    public final SqlParser.bit_subexpr_return bit_subexpr() throws RecognitionException {
        SqlParser.bit_subexpr_return retval = new SqlParser.bit_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set101=null;
        SqlParser.add_subexpr_return add_subexpr100 =null;

        SqlParser.add_subexpr_return add_subexpr102 =null;


        Object set101_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:223:12: ( add_subexpr ( ( PLUS | MINUS ) ^ add_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:223:14: add_subexpr ( ( PLUS | MINUS ) ^ add_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_add_subexpr_in_bit_subexpr904);
            add_subexpr100=add_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, add_subexpr100.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:223:26: ( ( PLUS | MINUS ) ^ add_subexpr )*
            loop29:
            do {
                int alt29=2;
                int LA29_0 = input.LA(1);

                if ( (LA29_0==MINUS||LA29_0==PLUS) ) {
                    alt29=1;
                }


                switch (alt29) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:223:27: ( PLUS | MINUS ) ^ add_subexpr
            	    {
            	    set101=(Token)input.LT(1);

            	    set101=(Token)input.LT(1);

            	    if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
            	        input.consume();
            	        root_0 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(set101)
            	        , root_0);
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_add_subexpr_in_bit_subexpr916);
            	    add_subexpr102=add_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, add_subexpr102.getTree());

            	    }
            	    break;

            	default :
            	    break loop29;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bit_subexpr"


    public static class add_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "add_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:225:1: add_subexpr : mul_subexpr ( ( ASTERISK | SLASH | PERCENT ) ^ mul_subexpr )* ;
    public final SqlParser.add_subexpr_return add_subexpr() throws RecognitionException {
        SqlParser.add_subexpr_return retval = new SqlParser.add_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set104=null;
        SqlParser.mul_subexpr_return mul_subexpr103 =null;

        SqlParser.mul_subexpr_return mul_subexpr105 =null;


        Object set104_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:225:12: ( mul_subexpr ( ( ASTERISK | SLASH | PERCENT ) ^ mul_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:225:14: mul_subexpr ( ( ASTERISK | SLASH | PERCENT ) ^ mul_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_mul_subexpr_in_add_subexpr925);
            mul_subexpr103=mul_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, mul_subexpr103.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:225:26: ( ( ASTERISK | SLASH | PERCENT ) ^ mul_subexpr )*
            loop30:
            do {
                int alt30=2;
                int LA30_0 = input.LA(1);

                if ( (LA30_0==ASTERISK||LA30_0==PERCENT||LA30_0==SLASH) ) {
                    alt30=1;
                }


                switch (alt30) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:225:27: ( ASTERISK | SLASH | PERCENT ) ^ mul_subexpr
            	    {
            	    set104=(Token)input.LT(1);

            	    set104=(Token)input.LT(1);

            	    if ( input.LA(1)==ASTERISK||input.LA(1)==PERCENT||input.LA(1)==SLASH ) {
            	        input.consume();
            	        root_0 = (Object)adaptor.becomeRoot(
            	        (Object)adaptor.create(set104)
            	        , root_0);
            	        state.errorRecovery=false;
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_mul_subexpr_in_add_subexpr941);
            	    mul_subexpr105=mul_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, mul_subexpr105.getTree());

            	    }
            	    break;

            	default :
            	    break loop30;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "add_subexpr"


    public static class mul_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "mul_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:227:1: mul_subexpr : con_subexpr ( DOUBLE_PIPE ^ con_subexpr )* ;
    public final SqlParser.mul_subexpr_return mul_subexpr() throws RecognitionException {
        SqlParser.mul_subexpr_return retval = new SqlParser.mul_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DOUBLE_PIPE107=null;
        SqlParser.con_subexpr_return con_subexpr106 =null;

        SqlParser.con_subexpr_return con_subexpr108 =null;


        Object DOUBLE_PIPE107_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:227:12: ( con_subexpr ( DOUBLE_PIPE ^ con_subexpr )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:227:14: con_subexpr ( DOUBLE_PIPE ^ con_subexpr )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_con_subexpr_in_mul_subexpr950);
            con_subexpr106=con_subexpr();

            state._fsp--;

            adaptor.addChild(root_0, con_subexpr106.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:227:26: ( DOUBLE_PIPE ^ con_subexpr )*
            loop31:
            do {
                int alt31=2;
                int LA31_0 = input.LA(1);

                if ( (LA31_0==DOUBLE_PIPE) ) {
                    alt31=1;
                }


                switch (alt31) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:227:27: DOUBLE_PIPE ^ con_subexpr
            	    {
            	    DOUBLE_PIPE107=(Token)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_mul_subexpr953); 
            	    DOUBLE_PIPE107_tree = 
            	    (Object)adaptor.create(DOUBLE_PIPE107)
            	    ;
            	    root_0 = (Object)adaptor.becomeRoot(DOUBLE_PIPE107_tree, root_0);


            	    pushFollow(FOLLOW_con_subexpr_in_mul_subexpr956);
            	    con_subexpr108=con_subexpr();

            	    state._fsp--;

            	    adaptor.addChild(root_0, con_subexpr108.getTree());

            	    }
            	    break;

            	default :
            	    break loop31;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "mul_subexpr"


    public static class con_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "con_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:229:1: con_subexpr : ( unary_subexpr | unary_op unary_subexpr -> ^( unary_op unary_subexpr ) );
    public final SqlParser.con_subexpr_return con_subexpr() throws RecognitionException {
        SqlParser.con_subexpr_return retval = new SqlParser.con_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.unary_subexpr_return unary_subexpr109 =null;

        SqlParser.unary_op_return unary_op110 =null;

        SqlParser.unary_subexpr_return unary_subexpr111 =null;


        RewriteRuleSubtreeStream stream_unary_subexpr=new RewriteRuleSubtreeStream(adaptor,"rule unary_subexpr");
        RewriteRuleSubtreeStream stream_unary_op=new RewriteRuleSubtreeStream(adaptor,"rule unary_op");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:229:12: ( unary_subexpr | unary_op unary_subexpr -> ^( unary_op unary_subexpr ) )
            int alt32=2;
            switch ( input.LA(1) ) {
            case ABORT:
            case ADD:
            case AFTER:
            case ALL:
            case ALTER:
            case ANALYZE:
            case AND:
            case AS:
            case ASC:
            case AT:
            case ATTACH:
            case AUTOINCREMENT:
            case BEFORE:
            case BEGIN:
            case BETWEEN:
            case BLOB:
            case BY:
            case CASCADE:
            case CASE:
            case CAST:
            case CHECK:
            case COLLATE:
            case COLON:
            case COLUMN:
            case COMMIT:
            case CONFLICT:
            case CONSTRAINT:
            case CREATE:
            case CROSS:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DATABASE:
            case DEFAULT:
            case DEFERRABLE:
            case DEFERRED:
            case DELETE:
            case DESC:
            case DETACH:
            case DISTINCT:
            case DROP:
            case EACH:
            case ELSE:
            case END:
            case ESCAPE:
            case EXCEPT:
            case EXCLUSIVE:
            case EXISTS:
            case EXPLAIN:
            case FAIL:
            case FALSE:
            case FLOAT:
            case FOR:
            case FOREIGN:
            case FROM:
            case GROUP:
            case HAVING:
            case ID:
            case IF:
            case IGNORE:
            case IMMEDIATE:
            case INDEX:
            case INDEXED:
            case INITIALLY:
            case INNER:
            case INSERT:
            case INSTEAD:
            case INTEGER:
            case INTERSECT:
            case INTO:
            case IS:
            case JOIN:
            case KEY:
            case LEFT:
            case LIMIT:
            case LPAREN:
            case NATURAL:
            case NULL:
            case OF:
            case OFFSET:
            case ON:
            case OR:
            case ORDER:
            case OUTER:
            case PLAN:
            case PRAGMA:
            case PRIMARY:
            case QUERY:
            case QUESTION:
            case RAISE:
            case REFERENCES:
            case REINDEX:
            case RELEASE:
            case RENAME:
            case REPLACE:
            case RESTRICT:
            case ROLLBACK:
            case ROW:
            case SAVEPOINT:
            case SELECT:
            case SET:
            case STRING:
            case TABLE:
            case TEMPORARY:
            case THEN:
            case TO:
            case TRANSACTION:
            case TRIGGER:
            case TRUE:
            case UNION:
            case UNIQUE:
            case UPDATE:
            case USING:
            case VACUUM:
            case VALUES:
            case VIEW:
            case VIRTUAL:
            case WHEN:
            case WHERE:
                {
                alt32=1;
                }
                break;
            case NOT:
                {
                int LA32_17 = input.LA(2);

                if ( (LA32_17==EXISTS) ) {
                    int LA32_22 = input.LA(3);

                    if ( (LA32_22==LPAREN) ) {
                        int LA32_42 = input.LA(4);

                        if ( (LA32_42==SELECT) ) {
                            alt32=1;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 32, 42, input);

                            throw nvae;

                        }
                    }
                    else if ( (LA32_22==DOT) ) {
                        alt32=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 32, 22, input);

                        throw nvae;

                    }
                }
                else if ( ((LA32_17 >= ABORT && LA32_17 <= AFTER)||(LA32_17 >= ALL && LA32_17 <= ALTER)||(LA32_17 >= ANALYZE && LA32_17 <= AND)||(LA32_17 >= AS && LA32_17 <= ASC)||(LA32_17 >= AT && LA32_17 <= AUTOINCREMENT)||(LA32_17 >= BEFORE && LA32_17 <= BETWEEN)||LA32_17==BLOB||LA32_17==BY||(LA32_17 >= CASCADE && LA32_17 <= COLUMN)||(LA32_17 >= COMMIT && LA32_17 <= CONSTRAINT)||LA32_17==CREATE||(LA32_17 >= CROSS && LA32_17 <= CURRENT_TIMESTAMP)||(LA32_17 >= DATABASE && LA32_17 <= DISTINCT)||LA32_17==DROP||(LA32_17 >= EACH && LA32_17 <= END)||(LA32_17 >= ESCAPE && LA32_17 <= EXCLUSIVE)||LA32_17==EXPLAIN||(LA32_17 >= FAIL && LA32_17 <= FLOAT)||(LA32_17 >= FOR && LA32_17 <= FROM)||LA32_17==GROUP||LA32_17==HAVING||LA32_17==ID||(LA32_17 >= IF && LA32_17 <= IMMEDIATE)||(LA32_17 >= INDEX && LA32_17 <= INTEGER)||(LA32_17 >= INTERSECT && LA32_17 <= INTO)||LA32_17==IS||LA32_17==JOIN||LA32_17==KEY||LA32_17==LEFT||LA32_17==LIMIT||LA32_17==LPAREN||(LA32_17 >= NATURAL && LA32_17 <= NOT)||LA32_17==NULL||(LA32_17 >= OF && LA32_17 <= ON)||(LA32_17 >= OR && LA32_17 <= ORDER)||LA32_17==OUTER||LA32_17==PLAN||(LA32_17 >= PRAGMA && LA32_17 <= PRIMARY)||(LA32_17 >= QUERY && LA32_17 <= QUESTION)||(LA32_17 >= RAISE && LA32_17 <= REFERENCES)||(LA32_17 >= REINDEX && LA32_17 <= ROW)||(LA32_17 >= SAVEPOINT && LA32_17 <= SELECT)||LA32_17==SET||LA32_17==STRING||LA32_17==TABLE||(LA32_17 >= TEMPORARY && LA32_17 <= THEN)||(LA32_17 >= TO && LA32_17 <= TRUE)||(LA32_17 >= UNION && LA32_17 <= USING)||(LA32_17 >= VACUUM && LA32_17 <= VIRTUAL)||(LA32_17 >= WHEN && LA32_17 <= WHERE)) ) {
                    alt32=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 32, 17, input);

                    throw nvae;

                }
                }
                break;
            case MINUS:
            case PLUS:
            case TILDA:
                {
                alt32=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;

            }

            switch (alt32) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:229:14: unary_subexpr
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_unary_subexpr_in_con_subexpr965);
                    unary_subexpr109=unary_subexpr();

                    state._fsp--;

                    adaptor.addChild(root_0, unary_subexpr109.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:229:30: unary_op unary_subexpr
                    {
                    pushFollow(FOLLOW_unary_op_in_con_subexpr969);
                    unary_op110=unary_op();

                    state._fsp--;

                    stream_unary_op.add(unary_op110.getTree());

                    pushFollow(FOLLOW_unary_subexpr_in_con_subexpr971);
                    unary_subexpr111=unary_subexpr();

                    state._fsp--;

                    stream_unary_subexpr.add(unary_subexpr111.getTree());

                    // AST REWRITE
                    // elements: unary_subexpr, unary_op
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 229:53: -> ^( unary_op unary_subexpr )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:229:56: ^( unary_op unary_subexpr )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(stream_unary_op.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_unary_subexpr.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "con_subexpr"


    public static class unary_op_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unary_op"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:231:1: unary_op : ( PLUS | MINUS | TILDA | NOT );
    public final SqlParser.unary_op_return unary_op() throws RecognitionException {
        SqlParser.unary_op_return retval = new SqlParser.unary_op_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set112=null;

        Object set112_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:231:9: ( PLUS | MINUS | TILDA | NOT )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
            {
            root_0 = (Object)adaptor.nil();


            set112=(Token)input.LT(1);

            if ( input.LA(1)==MINUS||input.LA(1)==NOT||input.LA(1)==PLUS||input.LA(1)==TILDA ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set112)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unary_op"


    public static class unary_subexpr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unary_subexpr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:233:1: unary_subexpr : atom_expr ( COLLATE ^collation_name= ID )? ;
    public final SqlParser.unary_subexpr_return unary_subexpr() throws RecognitionException {
        SqlParser.unary_subexpr_return retval = new SqlParser.unary_subexpr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token collation_name=null;
        Token COLLATE114=null;
        SqlParser.atom_expr_return atom_expr113 =null;


        Object collation_name_tree=null;
        Object COLLATE114_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:233:14: ( atom_expr ( COLLATE ^collation_name= ID )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:233:16: atom_expr ( COLLATE ^collation_name= ID )?
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_atom_expr_in_unary_subexpr1005);
            atom_expr113=atom_expr();

            state._fsp--;

            adaptor.addChild(root_0, atom_expr113.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:233:26: ( COLLATE ^collation_name= ID )?
            int alt33=2;
            alt33 = dfa33.predict(input);
            switch (alt33) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:233:27: COLLATE ^collation_name= ID
                    {
                    COLLATE114=(Token)match(input,COLLATE,FOLLOW_COLLATE_in_unary_subexpr1008); 
                    COLLATE114_tree = 
                    (Object)adaptor.create(COLLATE114)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(COLLATE114_tree, root_0);


                    collation_name=(Token)match(input,ID,FOLLOW_ID_in_unary_subexpr1013); 
                    collation_name_tree = 
                    (Object)adaptor.create(collation_name)
                    ;
                    adaptor.addChild(root_0, collation_name_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unary_subexpr"


    public static class atom_expr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "atom_expr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:235:1: atom_expr : ( literal_value | bind_parameter | ( (database_name= id DOT )? table_name= id DOT )? column_name= ID -> ^( COLUMN_EXPRESSION ^( $column_name ( ^( $table_name ( $database_name)? ) )? ) ) |name= ID LPAREN ( ( DISTINCT )? args+= expr ( COMMA args+= expr )* | ASTERISK )? RPAREN -> ^( FUNCTION_EXPRESSION $name ( DISTINCT )? ( $args)* ( ASTERISK )? ) | LPAREN ! expr RPAREN !| CAST ^ LPAREN ! expr AS ! type_name RPAREN !| ( ( NOT )? EXISTS )? LPAREN select_stmt RPAREN | CASE (case_expr= expr )? ( when_expr )+ ( ELSE else_expr= expr )? END -> ^( CASE ( $case_expr)? ( when_expr )+ ( $else_expr)? ) | raise_function );
    public final SqlParser.atom_expr_return atom_expr() throws RecognitionException {
        SqlParser.atom_expr_return retval = new SqlParser.atom_expr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token column_name=null;
        Token name=null;
        Token DOT117=null;
        Token DOT118=null;
        Token LPAREN119=null;
        Token DISTINCT120=null;
        Token COMMA121=null;
        Token ASTERISK122=null;
        Token RPAREN123=null;
        Token LPAREN124=null;
        Token RPAREN126=null;
        Token CAST127=null;
        Token LPAREN128=null;
        Token AS130=null;
        Token RPAREN132=null;
        Token NOT133=null;
        Token EXISTS134=null;
        Token LPAREN135=null;
        Token RPAREN137=null;
        Token CASE138=null;
        Token ELSE140=null;
        Token END141=null;
        List list_args=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.expr_return case_expr =null;

        SqlParser.expr_return else_expr =null;

        SqlParser.literal_value_return literal_value115 =null;

        SqlParser.bind_parameter_return bind_parameter116 =null;

        SqlParser.expr_return expr125 =null;

        SqlParser.expr_return expr129 =null;

        SqlParser.type_name_return type_name131 =null;

        SqlParser.select_stmt_return select_stmt136 =null;

        SqlParser.when_expr_return when_expr139 =null;

        SqlParser.raise_function_return raise_function142 =null;

        RuleReturnScope args = null;
        Object column_name_tree=null;
        Object name_tree=null;
        Object DOT117_tree=null;
        Object DOT118_tree=null;
        Object LPAREN119_tree=null;
        Object DISTINCT120_tree=null;
        Object COMMA121_tree=null;
        Object ASTERISK122_tree=null;
        Object RPAREN123_tree=null;
        Object LPAREN124_tree=null;
        Object RPAREN126_tree=null;
        Object CAST127_tree=null;
        Object LPAREN128_tree=null;
        Object AS130_tree=null;
        Object RPAREN132_tree=null;
        Object NOT133_tree=null;
        Object EXISTS134_tree=null;
        Object LPAREN135_tree=null;
        Object RPAREN137_tree=null;
        Object CASE138_tree=null;
        Object ELSE140_tree=null;
        Object END141_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
        RewriteRuleTokenStream stream_ELSE=new RewriteRuleTokenStream(adaptor,"token ELSE");
        RewriteRuleTokenStream stream_END=new RewriteRuleTokenStream(adaptor,"token END");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_CASE=new RewriteRuleTokenStream(adaptor,"token CASE");
        RewriteRuleSubtreeStream stream_when_expr=new RewriteRuleSubtreeStream(adaptor,"rule when_expr");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:236:3: ( literal_value | bind_parameter | ( (database_name= id DOT )? table_name= id DOT )? column_name= ID -> ^( COLUMN_EXPRESSION ^( $column_name ( ^( $table_name ( $database_name)? ) )? ) ) |name= ID LPAREN ( ( DISTINCT )? args+= expr ( COMMA args+= expr )* | ASTERISK )? RPAREN -> ^( FUNCTION_EXPRESSION $name ( DISTINCT )? ( $args)* ( ASTERISK )? ) | LPAREN ! expr RPAREN !| CAST ^ LPAREN ! expr AS ! type_name RPAREN !| ( ( NOT )? EXISTS )? LPAREN select_stmt RPAREN | CASE (case_expr= expr )? ( when_expr )+ ( ELSE else_expr= expr )? END -> ^( CASE ( $case_expr)? ( when_expr )+ ( $else_expr)? ) | raise_function )
            int alt44=9;
            alt44 = dfa44.predict(input);
            switch (alt44) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:236:5: literal_value
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_literal_value_in_atom_expr1025);
                    literal_value115=literal_value();

                    state._fsp--;

                    adaptor.addChild(root_0, literal_value115.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:237:5: bind_parameter
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_bind_parameter_in_atom_expr1031);
                    bind_parameter116=bind_parameter();

                    state._fsp--;

                    adaptor.addChild(root_0, bind_parameter116.getTree());

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:5: ( (database_name= id DOT )? table_name= id DOT )? column_name= ID
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:5: ( (database_name= id DOT )? table_name= id DOT )?
                    int alt35=2;
                    int LA35_0 = input.LA(1);

                    if ( (LA35_0==ID) ) {
                        int LA35_1 = input.LA(2);

                        if ( (LA35_1==DOT) ) {
                            alt35=1;
                        }
                    }
                    else if ( ((LA35_0 >= ABORT && LA35_0 <= AFTER)||(LA35_0 >= ALL && LA35_0 <= ALTER)||(LA35_0 >= ANALYZE && LA35_0 <= AND)||(LA35_0 >= AS && LA35_0 <= ASC)||(LA35_0 >= ATTACH && LA35_0 <= AUTOINCREMENT)||(LA35_0 >= BEFORE && LA35_0 <= BETWEEN)||LA35_0==BY||(LA35_0 >= CASCADE && LA35_0 <= COLLATE)||LA35_0==COLUMN||(LA35_0 >= COMMIT && LA35_0 <= CONSTRAINT)||LA35_0==CREATE||(LA35_0 >= CROSS && LA35_0 <= CURRENT_TIMESTAMP)||(LA35_0 >= DATABASE && LA35_0 <= DISTINCT)||LA35_0==DROP||(LA35_0 >= EACH && LA35_0 <= END)||(LA35_0 >= ESCAPE && LA35_0 <= EXPLAIN)||LA35_0==FAIL||(LA35_0 >= FOR && LA35_0 <= FROM)||LA35_0==GROUP||LA35_0==HAVING||(LA35_0 >= IF && LA35_0 <= IMMEDIATE)||(LA35_0 >= INDEX && LA35_0 <= INSTEAD)||(LA35_0 >= INTERSECT && LA35_0 <= INTO)||LA35_0==IS||LA35_0==JOIN||LA35_0==KEY||LA35_0==LEFT||LA35_0==LIMIT||LA35_0==NATURAL||LA35_0==NULL||(LA35_0 >= OF && LA35_0 <= ON)||(LA35_0 >= OR && LA35_0 <= ORDER)||LA35_0==OUTER||LA35_0==PLAN||(LA35_0 >= PRAGMA && LA35_0 <= PRIMARY)||LA35_0==QUERY||(LA35_0 >= RAISE && LA35_0 <= REFERENCES)||(LA35_0 >= REINDEX && LA35_0 <= ROW)||(LA35_0 >= SAVEPOINT && LA35_0 <= SELECT)||LA35_0==SET||LA35_0==STRING||LA35_0==TABLE||(LA35_0 >= TEMPORARY && LA35_0 <= THEN)||(LA35_0 >= TO && LA35_0 <= TRIGGER)||(LA35_0 >= UNION && LA35_0 <= USING)||(LA35_0 >= VACUUM && LA35_0 <= VIRTUAL)||(LA35_0 >= WHEN && LA35_0 <= WHERE)) ) {
                        alt35=1;
                    }
                    switch (alt35) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:6: (database_name= id DOT )? table_name= id DOT
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:6: (database_name= id DOT )?
                            int alt34=2;
                            alt34 = dfa34.predict(input);
                            switch (alt34) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:7: database_name= id DOT
                                    {
                                    pushFollow(FOLLOW_id_in_atom_expr1041);
                                    database_name=id();

                                    state._fsp--;

                                    stream_id.add(database_name.getTree());

                                    DOT117=(Token)match(input,DOT,FOLLOW_DOT_in_atom_expr1043);  
                                    stream_DOT.add(DOT117);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_id_in_atom_expr1049);
                            table_name=id();

                            state._fsp--;

                            stream_id.add(table_name.getTree());

                            DOT118=(Token)match(input,DOT,FOLLOW_DOT_in_atom_expr1051);  
                            stream_DOT.add(DOT118);


                            }
                            break;

                    }


                    column_name=(Token)match(input,ID,FOLLOW_ID_in_atom_expr1057);  
                    stream_ID.add(column_name);


                    // AST REWRITE
                    // elements: column_name, table_name, database_name
                    // token labels: column_name
                    // rule labels: database_name, table_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_column_name=new RewriteRuleTokenStream(adaptor,"token column_name",column_name);
                    RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
                    RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 238:65: -> ^( COLUMN_EXPRESSION ^( $column_name ( ^( $table_name ( $database_name)? ) )? ) )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:68: ^( COLUMN_EXPRESSION ^( $column_name ( ^( $table_name ( $database_name)? ) )? ) )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(COLUMN_EXPRESSION, "COLUMN_EXPRESSION")
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:88: ^( $column_name ( ^( $table_name ( $database_name)? ) )? )
                        {
                        Object root_2 = (Object)adaptor.nil();
                        root_2 = (Object)adaptor.becomeRoot(stream_column_name.nextNode(), root_2);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:103: ( ^( $table_name ( $database_name)? ) )?
                        if ( stream_table_name.hasNext()||stream_database_name.hasNext() ) {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:103: ^( $table_name ( $database_name)? )
                            {
                            Object root_3 = (Object)adaptor.nil();
                            root_3 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_3);

                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:238:118: ( $database_name)?
                            if ( stream_database_name.hasNext() ) {
                                adaptor.addChild(root_3, stream_database_name.nextTree());

                            }
                            stream_database_name.reset();

                            adaptor.addChild(root_2, root_3);
                            }

                        }
                        stream_table_name.reset();
                        stream_database_name.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:5: name= ID LPAREN ( ( DISTINCT )? args+= expr ( COMMA args+= expr )* | ASTERISK )? RPAREN
                    {
                    name=(Token)match(input,ID,FOLLOW_ID_in_atom_expr1086);  
                    stream_ID.add(name);


                    LPAREN119=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_atom_expr1088);  
                    stream_LPAREN.add(LPAREN119);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:20: ( ( DISTINCT )? args+= expr ( COMMA args+= expr )* | ASTERISK )?
                    int alt38=3;
                    int LA38_0 = input.LA(1);

                    if ( ((LA38_0 >= ABORT && LA38_0 <= AFTER)||(LA38_0 >= ALL && LA38_0 <= ALTER)||(LA38_0 >= ANALYZE && LA38_0 <= AND)||(LA38_0 >= AS && LA38_0 <= ASC)||(LA38_0 >= AT && LA38_0 <= AUTOINCREMENT)||(LA38_0 >= BEFORE && LA38_0 <= BETWEEN)||LA38_0==BLOB||LA38_0==BY||(LA38_0 >= CASCADE && LA38_0 <= COLUMN)||(LA38_0 >= COMMIT && LA38_0 <= CONSTRAINT)||LA38_0==CREATE||(LA38_0 >= CROSS && LA38_0 <= CURRENT_TIMESTAMP)||(LA38_0 >= DATABASE && LA38_0 <= DISTINCT)||LA38_0==DROP||(LA38_0 >= EACH && LA38_0 <= END)||(LA38_0 >= ESCAPE && LA38_0 <= EXPLAIN)||(LA38_0 >= FAIL && LA38_0 <= FLOAT)||(LA38_0 >= FOR && LA38_0 <= FROM)||LA38_0==GROUP||LA38_0==HAVING||LA38_0==ID||(LA38_0 >= IF && LA38_0 <= IMMEDIATE)||(LA38_0 >= INDEX && LA38_0 <= INTEGER)||(LA38_0 >= INTERSECT && LA38_0 <= INTO)||LA38_0==IS||LA38_0==JOIN||LA38_0==KEY||LA38_0==LEFT||LA38_0==LIMIT||LA38_0==LPAREN||LA38_0==MINUS||(LA38_0 >= NATURAL && LA38_0 <= NOT)||LA38_0==NULL||(LA38_0 >= OF && LA38_0 <= ON)||(LA38_0 >= OR && LA38_0 <= ORDER)||LA38_0==OUTER||(LA38_0 >= PLAN && LA38_0 <= PRIMARY)||(LA38_0 >= QUERY && LA38_0 <= QUESTION)||(LA38_0 >= RAISE && LA38_0 <= REFERENCES)||(LA38_0 >= REINDEX && LA38_0 <= ROW)||(LA38_0 >= SAVEPOINT && LA38_0 <= SELECT)||LA38_0==SET||LA38_0==STRING||LA38_0==TABLE||(LA38_0 >= TEMPORARY && LA38_0 <= TRUE)||(LA38_0 >= UNION && LA38_0 <= USING)||(LA38_0 >= VACUUM && LA38_0 <= VIRTUAL)||(LA38_0 >= WHEN && LA38_0 <= WHERE)) ) {
                        alt38=1;
                    }
                    else if ( (LA38_0==ASTERISK) ) {
                        alt38=2;
                    }
                    switch (alt38) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:21: ( DISTINCT )? args+= expr ( COMMA args+= expr )*
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:21: ( DISTINCT )?
                            int alt36=2;
                            int LA36_0 = input.LA(1);

                            if ( (LA36_0==DISTINCT) ) {
                                int LA36_1 = input.LA(2);

                                if ( ((LA36_1 >= ABORT && LA36_1 <= AFTER)||(LA36_1 >= ALL && LA36_1 <= ALTER)||(LA36_1 >= ANALYZE && LA36_1 <= AND)||(LA36_1 >= AS && LA36_1 <= ASC)||(LA36_1 >= AT && LA36_1 <= AUTOINCREMENT)||(LA36_1 >= BEFORE && LA36_1 <= BETWEEN)||LA36_1==BLOB||LA36_1==BY||(LA36_1 >= CASCADE && LA36_1 <= COLUMN)||(LA36_1 >= COMMIT && LA36_1 <= CONSTRAINT)||LA36_1==CREATE||(LA36_1 >= CROSS && LA36_1 <= CURRENT_TIMESTAMP)||(LA36_1 >= DATABASE && LA36_1 <= DISTINCT)||LA36_1==DROP||(LA36_1 >= EACH && LA36_1 <= END)||(LA36_1 >= ESCAPE && LA36_1 <= EXPLAIN)||(LA36_1 >= FAIL && LA36_1 <= FLOAT)||(LA36_1 >= FOR && LA36_1 <= FROM)||LA36_1==GROUP||LA36_1==HAVING||LA36_1==ID||(LA36_1 >= IF && LA36_1 <= IMMEDIATE)||(LA36_1 >= INDEX && LA36_1 <= INTEGER)||(LA36_1 >= INTERSECT && LA36_1 <= INTO)||LA36_1==IS||LA36_1==JOIN||LA36_1==KEY||LA36_1==LEFT||LA36_1==LIMIT||LA36_1==LPAREN||LA36_1==MINUS||(LA36_1 >= NATURAL && LA36_1 <= NOT)||LA36_1==NULL||(LA36_1 >= OF && LA36_1 <= ON)||(LA36_1 >= OR && LA36_1 <= ORDER)||LA36_1==OUTER||(LA36_1 >= PLAN && LA36_1 <= PRIMARY)||(LA36_1 >= QUERY && LA36_1 <= QUESTION)||(LA36_1 >= RAISE && LA36_1 <= REFERENCES)||(LA36_1 >= REINDEX && LA36_1 <= ROW)||(LA36_1 >= SAVEPOINT && LA36_1 <= SELECT)||LA36_1==SET||LA36_1==STRING||LA36_1==TABLE||(LA36_1 >= TEMPORARY && LA36_1 <= TRUE)||(LA36_1 >= UNION && LA36_1 <= USING)||(LA36_1 >= VACUUM && LA36_1 <= VIRTUAL)||(LA36_1 >= WHEN && LA36_1 <= WHERE)) ) {
                                    alt36=1;
                                }
                            }
                            switch (alt36) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:21: DISTINCT
                                    {
                                    DISTINCT120=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_atom_expr1091);  
                                    stream_DISTINCT.add(DISTINCT120);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_expr_in_atom_expr1096);
                            args=expr();

                            state._fsp--;

                            stream_expr.add(args.getTree());
                            if (list_args==null) list_args=new ArrayList();
                            list_args.add(args.getTree());


                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:42: ( COMMA args+= expr )*
                            loop37:
                            do {
                                int alt37=2;
                                int LA37_0 = input.LA(1);

                                if ( (LA37_0==COMMA) ) {
                                    alt37=1;
                                }


                                switch (alt37) {
                            	case 1 :
                            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:43: COMMA args+= expr
                            	    {
                            	    COMMA121=(Token)match(input,COMMA,FOLLOW_COMMA_in_atom_expr1099);  
                            	    stream_COMMA.add(COMMA121);


                            	    pushFollow(FOLLOW_expr_in_atom_expr1103);
                            	    args=expr();

                            	    state._fsp--;

                            	    stream_expr.add(args.getTree());
                            	    if (list_args==null) list_args=new ArrayList();
                            	    list_args.add(args.getTree());


                            	    }
                            	    break;

                            	default :
                            	    break loop37;
                                }
                            } while (true);


                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:64: ASTERISK
                            {
                            ASTERISK122=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_atom_expr1109);  
                            stream_ASTERISK.add(ASTERISK122);


                            }
                            break;

                    }


                    RPAREN123=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_atom_expr1113);  
                    stream_RPAREN.add(RPAREN123);


                    // AST REWRITE
                    // elements: ASTERISK, DISTINCT, args, name
                    // token labels: name
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: args
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_name=new RewriteRuleTokenStream(adaptor,"token name",name);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_args=new RewriteRuleSubtreeStream(adaptor,"token args",list_args);
                    root_0 = (Object)adaptor.nil();
                    // 239:82: -> ^( FUNCTION_EXPRESSION $name ( DISTINCT )? ( $args)* ( ASTERISK )? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:85: ^( FUNCTION_EXPRESSION $name ( DISTINCT )? ( $args)* ( ASTERISK )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FUNCTION_EXPRESSION, "FUNCTION_EXPRESSION")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextNode());

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:113: ( DISTINCT )?
                        if ( stream_DISTINCT.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_DISTINCT.nextNode()
                            );

                        }
                        stream_DISTINCT.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:124: ( $args)*
                        while ( stream_args.hasNext() ) {
                            adaptor.addChild(root_1, stream_args.nextTree());

                        }
                        stream_args.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:239:130: ( ASTERISK )?
                        if ( stream_ASTERISK.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_ASTERISK.nextNode()
                            );

                        }
                        stream_ASTERISK.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:240:5: LPAREN ! expr RPAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    LPAREN124=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_atom_expr1138); 

                    pushFollow(FOLLOW_expr_in_atom_expr1141);
                    expr125=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr125.getTree());

                    RPAREN126=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_atom_expr1143); 

                    }
                    break;
                case 6 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:241:5: CAST ^ LPAREN ! expr AS ! type_name RPAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    CAST127=(Token)match(input,CAST,FOLLOW_CAST_in_atom_expr1150); 
                    CAST127_tree = 
                    (Object)adaptor.create(CAST127)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(CAST127_tree, root_0);


                    LPAREN128=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_atom_expr1153); 

                    pushFollow(FOLLOW_expr_in_atom_expr1156);
                    expr129=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr129.getTree());

                    AS130=(Token)match(input,AS,FOLLOW_AS_in_atom_expr1158); 

                    pushFollow(FOLLOW_type_name_in_atom_expr1161);
                    type_name131=type_name();

                    state._fsp--;

                    adaptor.addChild(root_0, type_name131.getTree());

                    RPAREN132=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_atom_expr1163); 

                    }
                    break;
                case 7 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:242:5: ( ( NOT )? EXISTS )? LPAREN select_stmt RPAREN
                    {
                    root_0 = (Object)adaptor.nil();


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:242:5: ( ( NOT )? EXISTS )?
                    int alt40=2;
                    int LA40_0 = input.LA(1);

                    if ( (LA40_0==EXISTS||LA40_0==NOT) ) {
                        alt40=1;
                    }
                    switch (alt40) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:242:6: ( NOT )? EXISTS
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:242:6: ( NOT )?
                            int alt39=2;
                            int LA39_0 = input.LA(1);

                            if ( (LA39_0==NOT) ) {
                                alt39=1;
                            }
                            switch (alt39) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:242:7: NOT
                                    {
                                    NOT133=(Token)match(input,NOT,FOLLOW_NOT_in_atom_expr1172); 
                                    NOT133_tree = 
                                    (Object)adaptor.create(NOT133)
                                    ;
                                    adaptor.addChild(root_0, NOT133_tree);


                                    }
                                    break;

                            }


                            EXISTS134=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_atom_expr1176); 
                            EXISTS134_tree = 
                            (Object)adaptor.create(EXISTS134)
                            ;
                            adaptor.addChild(root_0, EXISTS134_tree);


                            }
                            break;

                    }


                    LPAREN135=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_atom_expr1180); 
                    LPAREN135_tree = 
                    (Object)adaptor.create(LPAREN135)
                    ;
                    adaptor.addChild(root_0, LPAREN135_tree);


                    pushFollow(FOLLOW_select_stmt_in_atom_expr1182);
                    select_stmt136=select_stmt();

                    state._fsp--;

                    adaptor.addChild(root_0, select_stmt136.getTree());

                    RPAREN137=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_atom_expr1184); 
                    RPAREN137_tree = 
                    (Object)adaptor.create(RPAREN137)
                    ;
                    adaptor.addChild(root_0, RPAREN137_tree);


                    }
                    break;
                case 8 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:5: CASE (case_expr= expr )? ( when_expr )+ ( ELSE else_expr= expr )? END
                    {
                    CASE138=(Token)match(input,CASE,FOLLOW_CASE_in_atom_expr1190);  
                    stream_CASE.add(CASE138);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:10: (case_expr= expr )?
                    int alt41=2;
                    int LA41_0 = input.LA(1);

                    if ( ((LA41_0 >= ABORT && LA41_0 <= AFTER)||(LA41_0 >= ALL && LA41_0 <= ALTER)||(LA41_0 >= ANALYZE && LA41_0 <= AND)||(LA41_0 >= AS && LA41_0 <= ASC)||(LA41_0 >= AT && LA41_0 <= AUTOINCREMENT)||(LA41_0 >= BEFORE && LA41_0 <= BETWEEN)||LA41_0==BLOB||LA41_0==BY||(LA41_0 >= CASCADE && LA41_0 <= COLUMN)||(LA41_0 >= COMMIT && LA41_0 <= CONSTRAINT)||LA41_0==CREATE||(LA41_0 >= CROSS && LA41_0 <= CURRENT_TIMESTAMP)||(LA41_0 >= DATABASE && LA41_0 <= DISTINCT)||LA41_0==DROP||(LA41_0 >= EACH && LA41_0 <= END)||(LA41_0 >= ESCAPE && LA41_0 <= EXPLAIN)||(LA41_0 >= FAIL && LA41_0 <= FLOAT)||(LA41_0 >= FOR && LA41_0 <= FROM)||LA41_0==GROUP||LA41_0==HAVING||LA41_0==ID||(LA41_0 >= IF && LA41_0 <= IMMEDIATE)||(LA41_0 >= INDEX && LA41_0 <= INTEGER)||(LA41_0 >= INTERSECT && LA41_0 <= INTO)||LA41_0==IS||LA41_0==JOIN||LA41_0==KEY||LA41_0==LEFT||LA41_0==LIMIT||LA41_0==LPAREN||LA41_0==MINUS||(LA41_0 >= NATURAL && LA41_0 <= NOT)||LA41_0==NULL||(LA41_0 >= OF && LA41_0 <= ON)||(LA41_0 >= OR && LA41_0 <= ORDER)||LA41_0==OUTER||(LA41_0 >= PLAN && LA41_0 <= PRIMARY)||(LA41_0 >= QUERY && LA41_0 <= QUESTION)||(LA41_0 >= RAISE && LA41_0 <= REFERENCES)||(LA41_0 >= REINDEX && LA41_0 <= ROW)||(LA41_0 >= SAVEPOINT && LA41_0 <= SELECT)||LA41_0==SET||LA41_0==STRING||LA41_0==TABLE||(LA41_0 >= TEMPORARY && LA41_0 <= TRUE)||(LA41_0 >= UNION && LA41_0 <= USING)||(LA41_0 >= VACUUM && LA41_0 <= VIRTUAL)||LA41_0==WHERE) ) {
                        alt41=1;
                    }
                    else if ( (LA41_0==WHEN) ) {
                        int LA41_20 = input.LA(2);

                        if ( (LA41_20==DOT) ) {
                            alt41=1;
                        }
                    }
                    switch (alt41) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:11: case_expr= expr
                            {
                            pushFollow(FOLLOW_expr_in_atom_expr1195);
                            case_expr=expr();

                            state._fsp--;

                            stream_expr.add(case_expr.getTree());

                            }
                            break;

                    }


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:28: ( when_expr )+
                    int cnt42=0;
                    loop42:
                    do {
                        int alt42=2;
                        int LA42_0 = input.LA(1);

                        if ( (LA42_0==WHEN) ) {
                            alt42=1;
                        }


                        switch (alt42) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:28: when_expr
                    	    {
                    	    pushFollow(FOLLOW_when_expr_in_atom_expr1199);
                    	    when_expr139=when_expr();

                    	    state._fsp--;

                    	    stream_when_expr.add(when_expr139.getTree());

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt42 >= 1 ) break loop42;
                                EarlyExitException eee =
                                    new EarlyExitException(42, input);
                                throw eee;
                        }
                        cnt42++;
                    } while (true);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:39: ( ELSE else_expr= expr )?
                    int alt43=2;
                    int LA43_0 = input.LA(1);

                    if ( (LA43_0==ELSE) ) {
                        alt43=1;
                    }
                    switch (alt43) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:40: ELSE else_expr= expr
                            {
                            ELSE140=(Token)match(input,ELSE,FOLLOW_ELSE_in_atom_expr1203);  
                            stream_ELSE.add(ELSE140);


                            pushFollow(FOLLOW_expr_in_atom_expr1207);
                            else_expr=expr();

                            state._fsp--;

                            stream_expr.add(else_expr.getTree());

                            }
                            break;

                    }


                    END141=(Token)match(input,END,FOLLOW_END_in_atom_expr1211);  
                    stream_END.add(END141);


                    // AST REWRITE
                    // elements: CASE, when_expr, else_expr, case_expr
                    // token labels: 
                    // rule labels: else_expr, case_expr, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_else_expr=new RewriteRuleSubtreeStream(adaptor,"rule else_expr",else_expr!=null?else_expr.tree:null);
                    RewriteRuleSubtreeStream stream_case_expr=new RewriteRuleSubtreeStream(adaptor,"rule case_expr",case_expr!=null?case_expr.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 243:66: -> ^( CASE ( $case_expr)? ( when_expr )+ ( $else_expr)? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:69: ^( CASE ( $case_expr)? ( when_expr )+ ( $else_expr)? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        stream_CASE.nextNode()
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:77: ( $case_expr)?
                        if ( stream_case_expr.hasNext() ) {
                            adaptor.addChild(root_1, stream_case_expr.nextTree());

                        }
                        stream_case_expr.reset();

                        if ( !(stream_when_expr.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_when_expr.hasNext() ) {
                            adaptor.addChild(root_1, stream_when_expr.nextTree());

                        }
                        stream_when_expr.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:243:100: ( $else_expr)?
                        if ( stream_else_expr.hasNext() ) {
                            adaptor.addChild(root_1, stream_else_expr.nextTree());

                        }
                        stream_else_expr.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:244:5: raise_function
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_raise_function_in_atom_expr1234);
                    raise_function142=raise_function();

                    state._fsp--;

                    adaptor.addChild(root_0, raise_function142.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "atom_expr"


    public static class when_expr_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "when_expr"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:247:1: when_expr : WHEN e1= expr THEN e2= expr -> ^( WHEN $e1 $e2) ;
    public final SqlParser.when_expr_return when_expr() throws RecognitionException {
        SqlParser.when_expr_return retval = new SqlParser.when_expr_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token WHEN143=null;
        Token THEN144=null;
        SqlParser.expr_return e1 =null;

        SqlParser.expr_return e2 =null;


        Object WHEN143_tree=null;
        Object THEN144_tree=null;
        RewriteRuleTokenStream stream_WHEN=new RewriteRuleTokenStream(adaptor,"token WHEN");
        RewriteRuleTokenStream stream_THEN=new RewriteRuleTokenStream(adaptor,"token THEN");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:247:10: ( WHEN e1= expr THEN e2= expr -> ^( WHEN $e1 $e2) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:247:12: WHEN e1= expr THEN e2= expr
            {
            WHEN143=(Token)match(input,WHEN,FOLLOW_WHEN_in_when_expr1244);  
            stream_WHEN.add(WHEN143);


            pushFollow(FOLLOW_expr_in_when_expr1248);
            e1=expr();

            state._fsp--;

            stream_expr.add(e1.getTree());

            THEN144=(Token)match(input,THEN,FOLLOW_THEN_in_when_expr1250);  
            stream_THEN.add(THEN144);


            pushFollow(FOLLOW_expr_in_when_expr1254);
            e2=expr();

            state._fsp--;

            stream_expr.add(e2.getTree());

            // AST REWRITE
            // elements: e2, e1, WHEN
            // token labels: 
            // rule labels: e1, e2, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_e1=new RewriteRuleSubtreeStream(adaptor,"rule e1",e1!=null?e1.tree:null);
            RewriteRuleSubtreeStream stream_e2=new RewriteRuleSubtreeStream(adaptor,"rule e2",e2!=null?e2.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 247:38: -> ^( WHEN $e1 $e2)
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:247:41: ^( WHEN $e1 $e2)
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_WHEN.nextNode()
                , root_1);

                adaptor.addChild(root_1, stream_e1.nextTree());

                adaptor.addChild(root_1, stream_e2.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "when_expr"


    public static class literal_value_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal_value"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:249:1: literal_value : ( INTEGER -> ^( INTEGER_LITERAL INTEGER ) | FLOAT -> ^( FLOAT_LITERAL FLOAT ) | STRING -> ^( STRING_LITERAL STRING ) | BLOB -> ^( BLOB_LITERAL BLOB ) | NULL | CURRENT_TIME -> ^( FUNCTION_LITERAL CURRENT_TIME ) | CURRENT_DATE -> ^( FUNCTION_LITERAL CURRENT_DATE ) | CURRENT_TIMESTAMP -> ^( FUNCTION_LITERAL CURRENT_TIMESTAMP ) | bool );
    public final SqlParser.literal_value_return literal_value() throws RecognitionException {
        SqlParser.literal_value_return retval = new SqlParser.literal_value_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTEGER145=null;
        Token FLOAT146=null;
        Token STRING147=null;
        Token BLOB148=null;
        Token NULL149=null;
        Token CURRENT_TIME150=null;
        Token CURRENT_DATE151=null;
        Token CURRENT_TIMESTAMP152=null;
        SqlParser.bool_return bool153 =null;


        Object INTEGER145_tree=null;
        Object FLOAT146_tree=null;
        Object STRING147_tree=null;
        Object BLOB148_tree=null;
        Object NULL149_tree=null;
        Object CURRENT_TIME150_tree=null;
        Object CURRENT_DATE151_tree=null;
        Object CURRENT_TIMESTAMP152_tree=null;
        RewriteRuleTokenStream stream_FLOAT=new RewriteRuleTokenStream(adaptor,"token FLOAT");
        RewriteRuleTokenStream stream_BLOB=new RewriteRuleTokenStream(adaptor,"token BLOB");
        RewriteRuleTokenStream stream_CURRENT_TIMESTAMP=new RewriteRuleTokenStream(adaptor,"token CURRENT_TIMESTAMP");
        RewriteRuleTokenStream stream_STRING=new RewriteRuleTokenStream(adaptor,"token STRING");
        RewriteRuleTokenStream stream_CURRENT_TIME=new RewriteRuleTokenStream(adaptor,"token CURRENT_TIME");
        RewriteRuleTokenStream stream_CURRENT_DATE=new RewriteRuleTokenStream(adaptor,"token CURRENT_DATE");
        RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:250:3: ( INTEGER -> ^( INTEGER_LITERAL INTEGER ) | FLOAT -> ^( FLOAT_LITERAL FLOAT ) | STRING -> ^( STRING_LITERAL STRING ) | BLOB -> ^( BLOB_LITERAL BLOB ) | NULL | CURRENT_TIME -> ^( FUNCTION_LITERAL CURRENT_TIME ) | CURRENT_DATE -> ^( FUNCTION_LITERAL CURRENT_DATE ) | CURRENT_TIMESTAMP -> ^( FUNCTION_LITERAL CURRENT_TIMESTAMP ) | bool )
            int alt45=9;
            switch ( input.LA(1) ) {
            case INTEGER:
                {
                alt45=1;
                }
                break;
            case FLOAT:
                {
                alt45=2;
                }
                break;
            case STRING:
                {
                alt45=3;
                }
                break;
            case BLOB:
                {
                alt45=4;
                }
                break;
            case NULL:
                {
                alt45=5;
                }
                break;
            case CURRENT_TIME:
                {
                alt45=6;
                }
                break;
            case CURRENT_DATE:
                {
                alt45=7;
                }
                break;
            case CURRENT_TIMESTAMP:
                {
                alt45=8;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt45=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;

            }

            switch (alt45) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:250:5: INTEGER
                    {
                    INTEGER145=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_literal_value1276);  
                    stream_INTEGER.add(INTEGER145);


                    // AST REWRITE
                    // elements: INTEGER
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 250:13: -> ^( INTEGER_LITERAL INTEGER )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:250:16: ^( INTEGER_LITERAL INTEGER )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(INTEGER_LITERAL, "INTEGER_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_INTEGER.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:251:5: FLOAT
                    {
                    FLOAT146=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_literal_value1290);  
                    stream_FLOAT.add(FLOAT146);


                    // AST REWRITE
                    // elements: FLOAT
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 251:11: -> ^( FLOAT_LITERAL FLOAT )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:251:14: ^( FLOAT_LITERAL FLOAT )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FLOAT_LITERAL, "FLOAT_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_FLOAT.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:252:5: STRING
                    {
                    STRING147=(Token)match(input,STRING,FOLLOW_STRING_in_literal_value1304);  
                    stream_STRING.add(STRING147);


                    // AST REWRITE
                    // elements: STRING
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 252:12: -> ^( STRING_LITERAL STRING )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:252:15: ^( STRING_LITERAL STRING )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(STRING_LITERAL, "STRING_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_STRING.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:253:5: BLOB
                    {
                    BLOB148=(Token)match(input,BLOB,FOLLOW_BLOB_in_literal_value1318);  
                    stream_BLOB.add(BLOB148);


                    // AST REWRITE
                    // elements: BLOB
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 253:10: -> ^( BLOB_LITERAL BLOB )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:253:13: ^( BLOB_LITERAL BLOB )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BLOB_LITERAL, "BLOB_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_BLOB.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:254:5: NULL
                    {
                    root_0 = (Object)adaptor.nil();


                    NULL149=(Token)match(input,NULL,FOLLOW_NULL_in_literal_value1332); 
                    NULL149_tree = 
                    (Object)adaptor.create(NULL149)
                    ;
                    adaptor.addChild(root_0, NULL149_tree);


                    }
                    break;
                case 6 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:255:5: CURRENT_TIME
                    {
                    CURRENT_TIME150=(Token)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_literal_value1338);  
                    stream_CURRENT_TIME.add(CURRENT_TIME150);


                    // AST REWRITE
                    // elements: CURRENT_TIME
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 255:18: -> ^( FUNCTION_LITERAL CURRENT_TIME )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:255:21: ^( FUNCTION_LITERAL CURRENT_TIME )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FUNCTION_LITERAL, "FUNCTION_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_CURRENT_TIME.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:256:5: CURRENT_DATE
                    {
                    CURRENT_DATE151=(Token)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_literal_value1352);  
                    stream_CURRENT_DATE.add(CURRENT_DATE151);


                    // AST REWRITE
                    // elements: CURRENT_DATE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 256:18: -> ^( FUNCTION_LITERAL CURRENT_DATE )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:256:21: ^( FUNCTION_LITERAL CURRENT_DATE )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FUNCTION_LITERAL, "FUNCTION_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_CURRENT_DATE.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:257:5: CURRENT_TIMESTAMP
                    {
                    CURRENT_TIMESTAMP152=(Token)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_literal_value1366);  
                    stream_CURRENT_TIMESTAMP.add(CURRENT_TIMESTAMP152);


                    // AST REWRITE
                    // elements: CURRENT_TIMESTAMP
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 257:23: -> ^( FUNCTION_LITERAL CURRENT_TIMESTAMP )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:257:26: ^( FUNCTION_LITERAL CURRENT_TIMESTAMP )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FUNCTION_LITERAL, "FUNCTION_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_CURRENT_TIMESTAMP.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:258:5: bool
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_bool_in_literal_value1380);
                    bool153=bool();

                    state._fsp--;

                    adaptor.addChild(root_0, bool153.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal_value"


    public static class bind_parameter_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bind_parameter"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:261:1: bind_parameter : ( QUESTION -> BIND | QUESTION position= INTEGER -> ^( BIND $position) | COLON name= id -> ^( BIND_NAME $name) | AT name= id -> ^( BIND_NAME $name) );
    public final SqlParser.bind_parameter_return bind_parameter() throws RecognitionException {
        SqlParser.bind_parameter_return retval = new SqlParser.bind_parameter_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token position=null;
        Token QUESTION154=null;
        Token QUESTION155=null;
        Token COLON156=null;
        Token AT157=null;
        SqlParser.id_return name =null;


        Object position_tree=null;
        Object QUESTION154_tree=null;
        Object QUESTION155_tree=null;
        Object COLON156_tree=null;
        Object AT157_tree=null;
        RewriteRuleTokenStream stream_AT=new RewriteRuleTokenStream(adaptor,"token AT");
        RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
        RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");
        RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:262:3: ( QUESTION -> BIND | QUESTION position= INTEGER -> ^( BIND $position) | COLON name= id -> ^( BIND_NAME $name) | AT name= id -> ^( BIND_NAME $name) )
            int alt46=4;
            switch ( input.LA(1) ) {
            case QUESTION:
                {
                int LA46_1 = input.LA(2);

                if ( (LA46_1==INTEGER) ) {
                    alt46=2;
                }
                else if ( (LA46_1==EOF||(LA46_1 >= ABORT && LA46_1 <= AFTER)||(LA46_1 >= ALL && LA46_1 <= AND)||(LA46_1 >= AS && LA46_1 <= ASTERISK)||(LA46_1 >= ATTACH && LA46_1 <= AUTOINCREMENT)||(LA46_1 >= BEFORE && LA46_1 <= BETWEEN)||LA46_1==BY||(LA46_1 >= CASCADE && LA46_1 <= COLLATE)||LA46_1==COLUMN||LA46_1==COMMA||(LA46_1 >= COMMIT && LA46_1 <= CONSTRAINT)||LA46_1==CREATE||(LA46_1 >= CROSS && LA46_1 <= CURRENT_TIMESTAMP)||(LA46_1 >= DATABASE && LA46_1 <= DISTINCT)||(LA46_1 >= DOUBLE_PIPE && LA46_1 <= DROP)||(LA46_1 >= EACH && LA46_1 <= EXPLAIN)||LA46_1==FAIL||(LA46_1 >= FOR && LA46_1 <= FROM)||(LA46_1 >= GLOB && LA46_1 <= GROUP)||LA46_1==HAVING||LA46_1==ID||(LA46_1 >= IF && LA46_1 <= INSTEAD)||(LA46_1 >= INTERSECT && LA46_1 <= INTO)||(LA46_1 >= IS && LA46_1 <= ISNULL)||LA46_1==JOIN||LA46_1==KEY||(LA46_1 >= LEFT && LA46_1 <= LIMIT)||(LA46_1 >= MATCH && LA46_1 <= MINUS)||(LA46_1 >= NATURAL && LA46_1 <= NOT_EQUALS2)||LA46_1==NULL||(LA46_1 >= OF && LA46_1 <= ON)||(LA46_1 >= OR && LA46_1 <= ORDER)||LA46_1==OUTER||(LA46_1 >= PERCENT && LA46_1 <= PRIMARY)||LA46_1==QUERY||(LA46_1 >= RAISE && LA46_1 <= RPAREN)||(LA46_1 >= SAVEPOINT && LA46_1 <= SELECT)||(LA46_1 >= SEMI && LA46_1 <= SLASH)||LA46_1==STRING||LA46_1==TABLE||(LA46_1 >= TEMPORARY && LA46_1 <= THEN)||(LA46_1 >= TO && LA46_1 <= TRIGGER)||(LA46_1 >= UNION && LA46_1 <= USING)||(LA46_1 >= VACUUM && LA46_1 <= VIRTUAL)||(LA46_1 >= WHEN && LA46_1 <= WHERE)) ) {
                    alt46=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 46, 1, input);

                    throw nvae;

                }
                }
                break;
            case COLON:
                {
                alt46=3;
                }
                break;
            case AT:
                {
                alt46=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;

            }

            switch (alt46) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:262:5: QUESTION
                    {
                    QUESTION154=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_bind_parameter1393);  
                    stream_QUESTION.add(QUESTION154);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 262:14: -> BIND
                    {
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(BIND, "BIND")
                        );

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:263:5: QUESTION position= INTEGER
                    {
                    QUESTION155=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_bind_parameter1403);  
                    stream_QUESTION.add(QUESTION155);


                    position=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_bind_parameter1407);  
                    stream_INTEGER.add(position);


                    // AST REWRITE
                    // elements: position
                    // token labels: position
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_position=new RewriteRuleTokenStream(adaptor,"token position",position);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 263:31: -> ^( BIND $position)
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:263:34: ^( BIND $position)
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BIND, "BIND")
                        , root_1);

                        adaptor.addChild(root_1, stream_position.nextNode());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:264:5: COLON name= id
                    {
                    COLON156=(Token)match(input,COLON,FOLLOW_COLON_in_bind_parameter1422);  
                    stream_COLON.add(COLON156);


                    pushFollow(FOLLOW_id_in_bind_parameter1426);
                    name=id();

                    state._fsp--;

                    stream_id.add(name.getTree());

                    // AST REWRITE
                    // elements: name
                    // token labels: 
                    // rule labels: name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 264:19: -> ^( BIND_NAME $name)
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:264:22: ^( BIND_NAME $name)
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BIND_NAME, "BIND_NAME")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:265:5: AT name= id
                    {
                    AT157=(Token)match(input,AT,FOLLOW_AT_in_bind_parameter1441);  
                    stream_AT.add(AT157);


                    pushFollow(FOLLOW_id_in_bind_parameter1445);
                    name=id();

                    state._fsp--;

                    stream_id.add(name.getTree());

                    // AST REWRITE
                    // elements: name
                    // token labels: 
                    // rule labels: name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 265:16: -> ^( BIND_NAME $name)
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:265:19: ^( BIND_NAME $name)
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(BIND_NAME, "BIND_NAME")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bind_parameter"


    public static class raise_function_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "raise_function"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:1: raise_function : RAISE ^ LPAREN ! ( IGNORE | ( ROLLBACK | ABORT | FAIL ) COMMA !error_message= STRING ) RPAREN !;
    public final SqlParser.raise_function_return raise_function() throws RecognitionException {
        SqlParser.raise_function_return retval = new SqlParser.raise_function_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token error_message=null;
        Token RAISE158=null;
        Token LPAREN159=null;
        Token IGNORE160=null;
        Token set161=null;
        Token COMMA162=null;
        Token RPAREN163=null;

        Object error_message_tree=null;
        Object RAISE158_tree=null;
        Object LPAREN159_tree=null;
        Object IGNORE160_tree=null;
        Object set161_tree=null;
        Object COMMA162_tree=null;
        Object RPAREN163_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:15: ( RAISE ^ LPAREN ! ( IGNORE | ( ROLLBACK | ABORT | FAIL ) COMMA !error_message= STRING ) RPAREN !)
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:17: RAISE ^ LPAREN ! ( IGNORE | ( ROLLBACK | ABORT | FAIL ) COMMA !error_message= STRING ) RPAREN !
            {
            root_0 = (Object)adaptor.nil();


            RAISE158=(Token)match(input,RAISE,FOLLOW_RAISE_in_raise_function1466); 
            RAISE158_tree = 
            (Object)adaptor.create(RAISE158)
            ;
            root_0 = (Object)adaptor.becomeRoot(RAISE158_tree, root_0);


            LPAREN159=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_raise_function1469); 

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:32: ( IGNORE | ( ROLLBACK | ABORT | FAIL ) COMMA !error_message= STRING )
            int alt47=2;
            int LA47_0 = input.LA(1);

            if ( (LA47_0==IGNORE) ) {
                alt47=1;
            }
            else if ( (LA47_0==ABORT||LA47_0==FAIL||LA47_0==ROLLBACK) ) {
                alt47=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;

            }
            switch (alt47) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:33: IGNORE
                    {
                    IGNORE160=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_raise_function1473); 
                    IGNORE160_tree = 
                    (Object)adaptor.create(IGNORE160)
                    ;
                    adaptor.addChild(root_0, IGNORE160_tree);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:270:42: ( ROLLBACK | ABORT | FAIL ) COMMA !error_message= STRING
                    {
                    set161=(Token)input.LT(1);

                    if ( input.LA(1)==ABORT||input.LA(1)==FAIL||input.LA(1)==ROLLBACK ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set161)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    COMMA162=(Token)match(input,COMMA,FOLLOW_COMMA_in_raise_function1489); 

                    error_message=(Token)match(input,STRING,FOLLOW_STRING_in_raise_function1494); 
                    error_message_tree = 
                    (Object)adaptor.create(error_message)
                    ;
                    adaptor.addChild(root_0, error_message_tree);


                    }
                    break;

            }


            RPAREN163=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_raise_function1497); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "raise_function"


    public static class type_name_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "type_name"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:1: type_name : (names+= ID )+ ( LPAREN size1= signed_number ( COMMA size2= signed_number )? RPAREN )? -> ^( TYPE ^( TYPE_PARAMS ( $size1)? ( $size2)? ) ( $names)+ ) ;
    public final SqlParser.type_name_return type_name() throws RecognitionException {
        SqlParser.type_name_return retval = new SqlParser.type_name_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LPAREN164=null;
        Token COMMA165=null;
        Token RPAREN166=null;
        Token names=null;
        List list_names=null;
        SqlParser.signed_number_return size1 =null;

        SqlParser.signed_number_return size2 =null;


        Object LPAREN164_tree=null;
        Object COMMA165_tree=null;
        Object RPAREN166_tree=null;
        Object names_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_signed_number=new RewriteRuleSubtreeStream(adaptor,"rule signed_number");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:10: ( (names+= ID )+ ( LPAREN size1= signed_number ( COMMA size2= signed_number )? RPAREN )? -> ^( TYPE ^( TYPE_PARAMS ( $size1)? ( $size2)? ) ( $names)+ ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:12: (names+= ID )+ ( LPAREN size1= signed_number ( COMMA size2= signed_number )? RPAREN )?
            {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:17: (names+= ID )+
            int cnt48=0;
            loop48:
            do {
                int alt48=2;
                int LA48_0 = input.LA(1);

                if ( (LA48_0==ID) ) {
                    alt48=1;
                }


                switch (alt48) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:17: names+= ID
            	    {
            	    names=(Token)match(input,ID,FOLLOW_ID_in_type_name1507);  
            	    stream_ID.add(names);

            	    if (list_names==null) list_names=new ArrayList();
            	    list_names.add(names);


            	    }
            	    break;

            	default :
            	    if ( cnt48 >= 1 ) break loop48;
                        EarlyExitException eee =
                            new EarlyExitException(48, input);
                        throw eee;
                }
                cnt48++;
            } while (true);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:23: ( LPAREN size1= signed_number ( COMMA size2= signed_number )? RPAREN )?
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==LPAREN) ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:24: LPAREN size1= signed_number ( COMMA size2= signed_number )? RPAREN
                    {
                    LPAREN164=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_type_name1511);  
                    stream_LPAREN.add(LPAREN164);


                    pushFollow(FOLLOW_signed_number_in_type_name1515);
                    size1=signed_number();

                    state._fsp--;

                    stream_signed_number.add(size1.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:51: ( COMMA size2= signed_number )?
                    int alt49=2;
                    int LA49_0 = input.LA(1);

                    if ( (LA49_0==COMMA) ) {
                        alt49=1;
                    }
                    switch (alt49) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:272:52: COMMA size2= signed_number
                            {
                            COMMA165=(Token)match(input,COMMA,FOLLOW_COMMA_in_type_name1518);  
                            stream_COMMA.add(COMMA165);


                            pushFollow(FOLLOW_signed_number_in_type_name1522);
                            size2=signed_number();

                            state._fsp--;

                            stream_signed_number.add(size2.getTree());

                            }
                            break;

                    }


                    RPAREN166=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_type_name1526);  
                    stream_RPAREN.add(RPAREN166);


                    }
                    break;

            }


            // AST REWRITE
            // elements: names, size1, size2
            // token labels: 
            // rule labels: size1, size2, retval
            // token list labels: names
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_names=new RewriteRuleTokenStream(adaptor,"token names", list_names);
            RewriteRuleSubtreeStream stream_size1=new RewriteRuleSubtreeStream(adaptor,"rule size1",size1!=null?size1.tree:null);
            RewriteRuleSubtreeStream stream_size2=new RewriteRuleSubtreeStream(adaptor,"rule size2",size2!=null?size2.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 273:50: -> ^( TYPE ^( TYPE_PARAMS ( $size1)? ( $size2)? ) ( $names)+ )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:273:4: ^( TYPE ^( TYPE_PARAMS ( $size1)? ( $size2)? ) ( $names)+ )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(TYPE, "TYPE")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:273:11: ^( TYPE_PARAMS ( $size1)? ( $size2)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(TYPE_PARAMS, "TYPE_PARAMS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:273:26: ( $size1)?
                if ( stream_size1.hasNext() ) {
                    adaptor.addChild(root_2, stream_size1.nextTree());

                }
                stream_size1.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:273:34: ( $size2)?
                if ( stream_size2.hasNext() ) {
                    adaptor.addChild(root_2, stream_size2.nextTree());

                }
                stream_size2.reset();

                adaptor.addChild(root_1, root_2);
                }

                if ( !(stream_names.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_names.hasNext() ) {
                    adaptor.addChild(root_1, stream_names.nextNode());

                }
                stream_names.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "type_name"


    public static class signed_number_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "signed_number"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:275:1: signed_number : ( PLUS | MINUS )? ( INTEGER | FLOAT ) ;
    public final SqlParser.signed_number_return signed_number() throws RecognitionException {
        SqlParser.signed_number_return retval = new SqlParser.signed_number_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set167=null;
        Token set168=null;

        Object set167_tree=null;
        Object set168_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:275:14: ( ( PLUS | MINUS )? ( INTEGER | FLOAT ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:275:16: ( PLUS | MINUS )? ( INTEGER | FLOAT )
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:275:16: ( PLUS | MINUS )?
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( (LA51_0==MINUS||LA51_0==PLUS) ) {
                alt51=1;
            }
            switch (alt51) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
                    {
                    set167=(Token)input.LT(1);

                    if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set167)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    }
                    break;

            }


            set168=(Token)input.LT(1);

            if ( input.LA(1)==FLOAT||input.LA(1)==INTEGER ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set168)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "signed_number"


    public static class pragma_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pragma_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:1: pragma_stmt : PRAGMA (database_name= id DOT )? pragma_name= id ( EQUALS pragma_value | LPAREN pragma_value RPAREN )? -> ^( PRAGMA ^( $pragma_name ( $database_name)? ) ( pragma_value )? ) ;
    public final SqlParser.pragma_stmt_return pragma_stmt() throws RecognitionException {
        SqlParser.pragma_stmt_return retval = new SqlParser.pragma_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PRAGMA169=null;
        Token DOT170=null;
        Token EQUALS171=null;
        Token LPAREN173=null;
        Token RPAREN175=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return pragma_name =null;

        SqlParser.pragma_value_return pragma_value172 =null;

        SqlParser.pragma_value_return pragma_value174 =null;


        Object PRAGMA169_tree=null;
        Object DOT170_tree=null;
        Object EQUALS171_tree=null;
        Object LPAREN173_tree=null;
        Object RPAREN175_tree=null;
        RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_PRAGMA=new RewriteRuleTokenStream(adaptor,"token PRAGMA");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_pragma_value=new RewriteRuleSubtreeStream(adaptor,"rule pragma_value");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:12: ( PRAGMA (database_name= id DOT )? pragma_name= id ( EQUALS pragma_value | LPAREN pragma_value RPAREN )? -> ^( PRAGMA ^( $pragma_name ( $database_name)? ) ( pragma_value )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:14: PRAGMA (database_name= id DOT )? pragma_name= id ( EQUALS pragma_value | LPAREN pragma_value RPAREN )?
            {
            PRAGMA169=(Token)match(input,PRAGMA,FOLLOW_PRAGMA_in_pragma_stmt1580);  
            stream_PRAGMA.add(PRAGMA169);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:21: (database_name= id DOT )?
            int alt52=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA52_1 = input.LA(2);

                    if ( (LA52_1==DOT) ) {
                        alt52=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA52_2 = input.LA(2);

                    if ( (LA52_2==DOT) ) {
                        alt52=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA52_3 = input.LA(2);

                    if ( (LA52_3==DOT) ) {
                        alt52=1;
                    }
                    }
                    break;
            }

            switch (alt52) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:22: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_pragma_stmt1585);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT170=(Token)match(input,DOT,FOLLOW_DOT_in_pragma_stmt1587);  
                    stream_DOT.add(DOT170);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_pragma_stmt1593);
            pragma_name=id();

            state._fsp--;

            stream_id.add(pragma_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:60: ( EQUALS pragma_value | LPAREN pragma_value RPAREN )?
            int alt53=3;
            int LA53_0 = input.LA(1);

            if ( (LA53_0==EQUALS) ) {
                alt53=1;
            }
            else if ( (LA53_0==LPAREN) ) {
                alt53=2;
            }
            switch (alt53) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:61: EQUALS pragma_value
                    {
                    EQUALS171=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_pragma_stmt1596);  
                    stream_EQUALS.add(EQUALS171);


                    pushFollow(FOLLOW_pragma_value_in_pragma_stmt1598);
                    pragma_value172=pragma_value();

                    state._fsp--;

                    stream_pragma_value.add(pragma_value172.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:278:83: LPAREN pragma_value RPAREN
                    {
                    LPAREN173=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_pragma_stmt1602);  
                    stream_LPAREN.add(LPAREN173);


                    pushFollow(FOLLOW_pragma_value_in_pragma_stmt1604);
                    pragma_value174=pragma_value();

                    state._fsp--;

                    stream_pragma_value.add(pragma_value174.getTree());

                    RPAREN175=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_pragma_stmt1606);  
                    stream_RPAREN.add(RPAREN175);


                    }
                    break;

            }


            // AST REWRITE
            // elements: PRAGMA, pragma_value, pragma_name, database_name
            // token labels: 
            // rule labels: database_name, pragma_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_pragma_name=new RewriteRuleSubtreeStream(adaptor,"rule pragma_name",pragma_name!=null?pragma_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 279:59: -> ^( PRAGMA ^( $pragma_name ( $database_name)? ) ( pragma_value )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:279:4: ^( PRAGMA ^( $pragma_name ( $database_name)? ) ( pragma_value )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_PRAGMA.nextNode()
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:279:13: ^( $pragma_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_pragma_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:279:29: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:279:45: ( pragma_value )?
                if ( stream_pragma_value.hasNext() ) {
                    adaptor.addChild(root_1, stream_pragma_value.nextTree());

                }
                stream_pragma_value.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pragma_stmt"


    public static class pragma_value_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pragma_value"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:281:1: pragma_value : ( signed_number -> ^( FLOAT_LITERAL signed_number ) | ID -> ^( ID_LITERAL ID ) | STRING -> ^( STRING_LITERAL STRING ) | bool );
    public final SqlParser.pragma_value_return pragma_value() throws RecognitionException {
        SqlParser.pragma_value_return retval = new SqlParser.pragma_value_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ID177=null;
        Token STRING178=null;
        SqlParser.signed_number_return signed_number176 =null;

        SqlParser.bool_return bool179 =null;


        Object ID177_tree=null;
        Object STRING178_tree=null;
        RewriteRuleTokenStream stream_STRING=new RewriteRuleTokenStream(adaptor,"token STRING");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleSubtreeStream stream_signed_number=new RewriteRuleSubtreeStream(adaptor,"rule signed_number");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:282:2: ( signed_number -> ^( FLOAT_LITERAL signed_number ) | ID -> ^( ID_LITERAL ID ) | STRING -> ^( STRING_LITERAL STRING ) | bool )
            int alt54=4;
            switch ( input.LA(1) ) {
            case FLOAT:
            case INTEGER:
            case MINUS:
            case PLUS:
                {
                alt54=1;
                }
                break;
            case ID:
                {
                alt54=2;
                }
                break;
            case STRING:
                {
                alt54=3;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt54=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;

            }

            switch (alt54) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:282:4: signed_number
                    {
                    pushFollow(FOLLOW_signed_number_in_pragma_value1635);
                    signed_number176=signed_number();

                    state._fsp--;

                    stream_signed_number.add(signed_number176.getTree());

                    // AST REWRITE
                    // elements: signed_number
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 282:18: -> ^( FLOAT_LITERAL signed_number )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:282:21: ^( FLOAT_LITERAL signed_number )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FLOAT_LITERAL, "FLOAT_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, stream_signed_number.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:283:4: ID
                    {
                    ID177=(Token)match(input,ID,FOLLOW_ID_in_pragma_value1648);  
                    stream_ID.add(ID177);


                    // AST REWRITE
                    // elements: ID
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 283:7: -> ^( ID_LITERAL ID )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:283:10: ^( ID_LITERAL ID )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(ID_LITERAL, "ID_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_ID.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:284:4: STRING
                    {
                    STRING178=(Token)match(input,STRING,FOLLOW_STRING_in_pragma_value1661);  
                    stream_STRING.add(STRING178);


                    // AST REWRITE
                    // elements: STRING
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 284:11: -> ^( STRING_LITERAL STRING )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:284:14: ^( STRING_LITERAL STRING )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(STRING_LITERAL, "STRING_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_STRING.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:285:4: bool
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_bool_in_pragma_value1674);
                    bool179=bool();

                    state._fsp--;

                    adaptor.addChild(root_0, bool179.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pragma_value"


    public static class attach_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "attach_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:289:1: attach_stmt : ATTACH ( DATABASE )? filename= id AS database_name= id ;
    public final SqlParser.attach_stmt_return attach_stmt() throws RecognitionException {
        SqlParser.attach_stmt_return retval = new SqlParser.attach_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ATTACH180=null;
        Token DATABASE181=null;
        Token AS182=null;
        SqlParser.id_return filename =null;

        SqlParser.id_return database_name =null;


        Object ATTACH180_tree=null;
        Object DATABASE181_tree=null;
        Object AS182_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:289:12: ( ATTACH ( DATABASE )? filename= id AS database_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:289:14: ATTACH ( DATABASE )? filename= id AS database_name= id
            {
            root_0 = (Object)adaptor.nil();


            ATTACH180=(Token)match(input,ATTACH,FOLLOW_ATTACH_in_attach_stmt1684); 
            ATTACH180_tree = 
            (Object)adaptor.create(ATTACH180)
            ;
            adaptor.addChild(root_0, ATTACH180_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:289:21: ( DATABASE )?
            int alt55=2;
            int LA55_0 = input.LA(1);

            if ( (LA55_0==DATABASE) ) {
                int LA55_1 = input.LA(2);

                if ( ((LA55_1 >= ABORT && LA55_1 <= AFTER)||(LA55_1 >= ALL && LA55_1 <= ALTER)||(LA55_1 >= ANALYZE && LA55_1 <= AND)||LA55_1==ASC||(LA55_1 >= ATTACH && LA55_1 <= AUTOINCREMENT)||(LA55_1 >= BEFORE && LA55_1 <= BETWEEN)||LA55_1==BY||(LA55_1 >= CASCADE && LA55_1 <= COLLATE)||LA55_1==COLUMN||(LA55_1 >= COMMIT && LA55_1 <= CONSTRAINT)||LA55_1==CREATE||(LA55_1 >= CROSS && LA55_1 <= CURRENT_TIMESTAMP)||(LA55_1 >= DATABASE && LA55_1 <= DISTINCT)||LA55_1==DROP||(LA55_1 >= EACH && LA55_1 <= END)||(LA55_1 >= ESCAPE && LA55_1 <= EXPLAIN)||LA55_1==FAIL||(LA55_1 >= FOR && LA55_1 <= FROM)||LA55_1==GROUP||LA55_1==HAVING||LA55_1==ID||(LA55_1 >= IF && LA55_1 <= IMMEDIATE)||(LA55_1 >= INDEX && LA55_1 <= INSTEAD)||(LA55_1 >= INTERSECT && LA55_1 <= INTO)||LA55_1==IS||LA55_1==JOIN||LA55_1==KEY||LA55_1==LEFT||LA55_1==LIMIT||LA55_1==NATURAL||LA55_1==NULL||(LA55_1 >= OF && LA55_1 <= ON)||(LA55_1 >= OR && LA55_1 <= ORDER)||LA55_1==OUTER||LA55_1==PLAN||(LA55_1 >= PRAGMA && LA55_1 <= PRIMARY)||LA55_1==QUERY||(LA55_1 >= RAISE && LA55_1 <= REFERENCES)||(LA55_1 >= REINDEX && LA55_1 <= ROW)||(LA55_1 >= SAVEPOINT && LA55_1 <= SELECT)||LA55_1==SET||LA55_1==STRING||LA55_1==TABLE||(LA55_1 >= TEMPORARY && LA55_1 <= THEN)||(LA55_1 >= TO && LA55_1 <= TRIGGER)||(LA55_1 >= UNION && LA55_1 <= USING)||(LA55_1 >= VACUUM && LA55_1 <= VIRTUAL)||(LA55_1 >= WHEN && LA55_1 <= WHERE)) ) {
                    alt55=1;
                }
                else if ( (LA55_1==AS) ) {
                    int LA55_7 = input.LA(3);

                    if ( (LA55_7==AS) ) {
                        int LA55_9 = input.LA(4);

                        if ( ((LA55_9 >= ABORT && LA55_9 <= AFTER)||(LA55_9 >= ALL && LA55_9 <= ALTER)||(LA55_9 >= ANALYZE && LA55_9 <= AND)||(LA55_9 >= AS && LA55_9 <= ASC)||(LA55_9 >= ATTACH && LA55_9 <= AUTOINCREMENT)||(LA55_9 >= BEFORE && LA55_9 <= BETWEEN)||LA55_9==BY||(LA55_9 >= CASCADE && LA55_9 <= COLLATE)||LA55_9==COLUMN||(LA55_9 >= COMMIT && LA55_9 <= CONSTRAINT)||LA55_9==CREATE||(LA55_9 >= CROSS && LA55_9 <= CURRENT_TIMESTAMP)||(LA55_9 >= DATABASE && LA55_9 <= DISTINCT)||LA55_9==DROP||(LA55_9 >= EACH && LA55_9 <= END)||(LA55_9 >= ESCAPE && LA55_9 <= EXPLAIN)||LA55_9==FAIL||(LA55_9 >= FOR && LA55_9 <= FROM)||LA55_9==GROUP||LA55_9==HAVING||LA55_9==ID||(LA55_9 >= IF && LA55_9 <= IMMEDIATE)||(LA55_9 >= INDEX && LA55_9 <= INSTEAD)||(LA55_9 >= INTERSECT && LA55_9 <= INTO)||LA55_9==IS||LA55_9==JOIN||LA55_9==KEY||LA55_9==LEFT||LA55_9==LIMIT||LA55_9==NATURAL||LA55_9==NULL||(LA55_9 >= OF && LA55_9 <= ON)||(LA55_9 >= OR && LA55_9 <= ORDER)||LA55_9==OUTER||LA55_9==PLAN||(LA55_9 >= PRAGMA && LA55_9 <= PRIMARY)||LA55_9==QUERY||(LA55_9 >= RAISE && LA55_9 <= REFERENCES)||(LA55_9 >= REINDEX && LA55_9 <= ROW)||(LA55_9 >= SAVEPOINT && LA55_9 <= SELECT)||LA55_9==SET||LA55_9==STRING||LA55_9==TABLE||(LA55_9 >= TEMPORARY && LA55_9 <= THEN)||(LA55_9 >= TO && LA55_9 <= TRIGGER)||(LA55_9 >= UNION && LA55_9 <= USING)||(LA55_9 >= VACUUM && LA55_9 <= VIRTUAL)||(LA55_9 >= WHEN && LA55_9 <= WHERE)) ) {
                            alt55=1;
                        }
                    }
                }
            }
            switch (alt55) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:289:22: DATABASE
                    {
                    DATABASE181=(Token)match(input,DATABASE,FOLLOW_DATABASE_in_attach_stmt1687); 
                    DATABASE181_tree = 
                    (Object)adaptor.create(DATABASE181)
                    ;
                    adaptor.addChild(root_0, DATABASE181_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_attach_stmt1693);
            filename=id();

            state._fsp--;

            adaptor.addChild(root_0, filename.getTree());

            AS182=(Token)match(input,AS,FOLLOW_AS_in_attach_stmt1695); 
            AS182_tree = 
            (Object)adaptor.create(AS182)
            ;
            adaptor.addChild(root_0, AS182_tree);


            pushFollow(FOLLOW_id_in_attach_stmt1699);
            database_name=id();

            state._fsp--;

            adaptor.addChild(root_0, database_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "attach_stmt"


    public static class detach_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "detach_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:292:1: detach_stmt : DETACH ( DATABASE )? database_name= id ;
    public final SqlParser.detach_stmt_return detach_stmt() throws RecognitionException {
        SqlParser.detach_stmt_return retval = new SqlParser.detach_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DETACH183=null;
        Token DATABASE184=null;
        SqlParser.id_return database_name =null;


        Object DETACH183_tree=null;
        Object DATABASE184_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:292:12: ( DETACH ( DATABASE )? database_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:292:14: DETACH ( DATABASE )? database_name= id
            {
            root_0 = (Object)adaptor.nil();


            DETACH183=(Token)match(input,DETACH,FOLLOW_DETACH_in_detach_stmt1707); 
            DETACH183_tree = 
            (Object)adaptor.create(DETACH183)
            ;
            adaptor.addChild(root_0, DETACH183_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:292:21: ( DATABASE )?
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==DATABASE) ) {
                int LA56_1 = input.LA(2);

                if ( ((LA56_1 >= ABORT && LA56_1 <= AFTER)||(LA56_1 >= ALL && LA56_1 <= ALTER)||(LA56_1 >= ANALYZE && LA56_1 <= AND)||(LA56_1 >= AS && LA56_1 <= ASC)||(LA56_1 >= ATTACH && LA56_1 <= AUTOINCREMENT)||(LA56_1 >= BEFORE && LA56_1 <= BETWEEN)||LA56_1==BY||(LA56_1 >= CASCADE && LA56_1 <= COLLATE)||LA56_1==COLUMN||(LA56_1 >= COMMIT && LA56_1 <= CONSTRAINT)||LA56_1==CREATE||(LA56_1 >= CROSS && LA56_1 <= CURRENT_TIMESTAMP)||(LA56_1 >= DATABASE && LA56_1 <= DISTINCT)||LA56_1==DROP||(LA56_1 >= EACH && LA56_1 <= END)||(LA56_1 >= ESCAPE && LA56_1 <= EXPLAIN)||LA56_1==FAIL||(LA56_1 >= FOR && LA56_1 <= FROM)||LA56_1==GROUP||LA56_1==HAVING||LA56_1==ID||(LA56_1 >= IF && LA56_1 <= IMMEDIATE)||(LA56_1 >= INDEX && LA56_1 <= INSTEAD)||(LA56_1 >= INTERSECT && LA56_1 <= INTO)||LA56_1==IS||LA56_1==JOIN||LA56_1==KEY||LA56_1==LEFT||LA56_1==LIMIT||LA56_1==NATURAL||LA56_1==NULL||(LA56_1 >= OF && LA56_1 <= ON)||(LA56_1 >= OR && LA56_1 <= ORDER)||LA56_1==OUTER||LA56_1==PLAN||(LA56_1 >= PRAGMA && LA56_1 <= PRIMARY)||LA56_1==QUERY||(LA56_1 >= RAISE && LA56_1 <= REFERENCES)||(LA56_1 >= REINDEX && LA56_1 <= ROW)||(LA56_1 >= SAVEPOINT && LA56_1 <= SELECT)||LA56_1==SET||LA56_1==STRING||LA56_1==TABLE||(LA56_1 >= TEMPORARY && LA56_1 <= THEN)||(LA56_1 >= TO && LA56_1 <= TRIGGER)||(LA56_1 >= UNION && LA56_1 <= USING)||(LA56_1 >= VACUUM && LA56_1 <= VIRTUAL)||(LA56_1 >= WHEN && LA56_1 <= WHERE)) ) {
                    alt56=1;
                }
            }
            switch (alt56) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:292:22: DATABASE
                    {
                    DATABASE184=(Token)match(input,DATABASE,FOLLOW_DATABASE_in_detach_stmt1710); 
                    DATABASE184_tree = 
                    (Object)adaptor.create(DATABASE184)
                    ;
                    adaptor.addChild(root_0, DATABASE184_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_detach_stmt1716);
            database_name=id();

            state._fsp--;

            adaptor.addChild(root_0, database_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "detach_stmt"


    public static class analyze_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "analyze_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:1: analyze_stmt : ANALYZE (database_or_table_name= id |database_name= id DOT table_name= id )? ;
    public final SqlParser.analyze_stmt_return analyze_stmt() throws RecognitionException {
        SqlParser.analyze_stmt_return retval = new SqlParser.analyze_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ANALYZE185=null;
        Token DOT186=null;
        SqlParser.id_return database_or_table_name =null;

        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;


        Object ANALYZE185_tree=null;
        Object DOT186_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:13: ( ANALYZE (database_or_table_name= id |database_name= id DOT table_name= id )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:15: ANALYZE (database_or_table_name= id |database_name= id DOT table_name= id )?
            {
            root_0 = (Object)adaptor.nil();


            ANALYZE185=(Token)match(input,ANALYZE,FOLLOW_ANALYZE_in_analyze_stmt1724); 
            ANALYZE185_tree = 
            (Object)adaptor.create(ANALYZE185)
            ;
            adaptor.addChild(root_0, ANALYZE185_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:23: (database_or_table_name= id |database_name= id DOT table_name= id )?
            int alt57=3;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA57_1 = input.LA(2);

                    if ( (LA57_1==EOF||LA57_1==SEMI) ) {
                        alt57=1;
                    }
                    else if ( (LA57_1==DOT) ) {
                        alt57=2;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA57_2 = input.LA(2);

                    if ( (LA57_2==EOF||LA57_2==SEMI) ) {
                        alt57=1;
                    }
                    else if ( (LA57_2==DOT) ) {
                        alt57=2;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA57_3 = input.LA(2);

                    if ( (LA57_3==EOF||LA57_3==SEMI) ) {
                        alt57=1;
                    }
                    else if ( (LA57_3==DOT) ) {
                        alt57=2;
                    }
                    }
                    break;
            }

            switch (alt57) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:24: database_or_table_name= id
                    {
                    pushFollow(FOLLOW_id_in_analyze_stmt1729);
                    database_or_table_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_or_table_name.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:295:52: database_name= id DOT table_name= id
                    {
                    pushFollow(FOLLOW_id_in_analyze_stmt1735);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT186=(Token)match(input,DOT,FOLLOW_DOT_in_analyze_stmt1737); 
                    DOT186_tree = 
                    (Object)adaptor.create(DOT186)
                    ;
                    adaptor.addChild(root_0, DOT186_tree);


                    pushFollow(FOLLOW_id_in_analyze_stmt1741);
                    table_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, table_name.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "analyze_stmt"


    public static class reindex_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "reindex_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:298:1: reindex_stmt : REINDEX (database_name= id DOT )? collation_or_table_or_index_name= id ;
    public final SqlParser.reindex_stmt_return reindex_stmt() throws RecognitionException {
        SqlParser.reindex_stmt_return retval = new SqlParser.reindex_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REINDEX187=null;
        Token DOT188=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return collation_or_table_or_index_name =null;


        Object REINDEX187_tree=null;
        Object DOT188_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:298:13: ( REINDEX (database_name= id DOT )? collation_or_table_or_index_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:298:15: REINDEX (database_name= id DOT )? collation_or_table_or_index_name= id
            {
            root_0 = (Object)adaptor.nil();


            REINDEX187=(Token)match(input,REINDEX,FOLLOW_REINDEX_in_reindex_stmt1751); 
            REINDEX187_tree = 
            (Object)adaptor.create(REINDEX187)
            ;
            adaptor.addChild(root_0, REINDEX187_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:298:23: (database_name= id DOT )?
            int alt58=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA58_1 = input.LA(2);

                    if ( (LA58_1==DOT) ) {
                        alt58=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA58_2 = input.LA(2);

                    if ( (LA58_2==DOT) ) {
                        alt58=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA58_3 = input.LA(2);

                    if ( (LA58_3==DOT) ) {
                        alt58=1;
                    }
                    }
                    break;
            }

            switch (alt58) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:298:24: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_reindex_stmt1756);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT188=(Token)match(input,DOT,FOLLOW_DOT_in_reindex_stmt1758); 
                    DOT188_tree = 
                    (Object)adaptor.create(DOT188)
                    ;
                    adaptor.addChild(root_0, DOT188_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_reindex_stmt1764);
            collation_or_table_or_index_name=id();

            state._fsp--;

            adaptor.addChild(root_0, collation_or_table_or_index_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "reindex_stmt"


    public static class vacuum_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "vacuum_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:301:1: vacuum_stmt : VACUUM ;
    public final SqlParser.vacuum_stmt_return vacuum_stmt() throws RecognitionException {
        SqlParser.vacuum_stmt_return retval = new SqlParser.vacuum_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token VACUUM189=null;

        Object VACUUM189_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:301:12: ( VACUUM )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:301:14: VACUUM
            {
            root_0 = (Object)adaptor.nil();


            VACUUM189=(Token)match(input,VACUUM,FOLLOW_VACUUM_in_vacuum_stmt1772); 
            VACUUM189_tree = 
            (Object)adaptor.create(VACUUM189)
            ;
            adaptor.addChild(root_0, VACUUM189_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "vacuum_stmt"


    public static class operation_conflict_clause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "operation_conflict_clause"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:307:1: operation_conflict_clause : OR ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE ) ;
    public final SqlParser.operation_conflict_clause_return operation_conflict_clause() throws RecognitionException {
        SqlParser.operation_conflict_clause_return retval = new SqlParser.operation_conflict_clause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token OR190=null;
        Token set191=null;

        Object OR190_tree=null;
        Object set191_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:307:26: ( OR ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:307:28: OR ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE )
            {
            root_0 = (Object)adaptor.nil();


            OR190=(Token)match(input,OR,FOLLOW_OR_in_operation_conflict_clause1783); 
            OR190_tree = 
            (Object)adaptor.create(OR190)
            ;
            adaptor.addChild(root_0, OR190_tree);


            set191=(Token)input.LT(1);

            if ( input.LA(1)==ABORT||input.LA(1)==FAIL||input.LA(1)==IGNORE||input.LA(1)==REPLACE||input.LA(1)==ROLLBACK ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set191)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "operation_conflict_clause"


    public static class ordering_term_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ordering_term"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:1: ordering_term : expr ( ASC | DESC )? -> ^( ORDERING expr ( ASC )? ( DESC )? ) ;
    public final SqlParser.ordering_term_return ordering_term() throws RecognitionException {
        SqlParser.ordering_term_return retval = new SqlParser.ordering_term_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ASC193=null;
        Token DESC194=null;
        SqlParser.expr_return expr192 =null;


        Object ASC193_tree=null;
        Object DESC194_tree=null;
        RewriteRuleTokenStream stream_ASC=new RewriteRuleTokenStream(adaptor,"token ASC");
        RewriteRuleTokenStream stream_DESC=new RewriteRuleTokenStream(adaptor,"token DESC");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:14: ( expr ( ASC | DESC )? -> ^( ORDERING expr ( ASC )? ( DESC )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:16: expr ( ASC | DESC )?
            {
            pushFollow(FOLLOW_expr_in_ordering_term1810);
            expr192=expr();

            state._fsp--;

            stream_expr.add(expr192.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:82: ( ASC | DESC )?
            int alt59=3;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==ASC) ) {
                alt59=1;
            }
            else if ( (LA59_0==DESC) ) {
                alt59=2;
            }
            switch (alt59) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:83: ASC
                    {
                    ASC193=(Token)match(input,ASC,FOLLOW_ASC_in_ordering_term1815);  
                    stream_ASC.add(ASC193);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:309:89: DESC
                    {
                    DESC194=(Token)match(input,DESC,FOLLOW_DESC_in_ordering_term1819);  
                    stream_DESC.add(DESC194);


                    }
                    break;

            }


            // AST REWRITE
            // elements: expr, DESC, ASC
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 310:35: -> ^( ORDERING expr ( ASC )? ( DESC )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:310:4: ^( ORDERING expr ( ASC )? ( DESC )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(ORDERING, "ORDERING")
                , root_1);

                adaptor.addChild(root_1, stream_expr.nextTree());

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:310:20: ( ASC )?
                if ( stream_ASC.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_ASC.nextNode()
                    );

                }
                stream_ASC.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:310:27: ( DESC )?
                if ( stream_DESC.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_DESC.nextNode()
                    );

                }
                stream_DESC.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ordering_term"


    public static class operation_limited_clause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "operation_limited_clause"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:312:1: operation_limited_clause : ( ORDER BY ordering_term ( COMMA ordering_term )* )? LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? ;
    public final SqlParser.operation_limited_clause_return operation_limited_clause() throws RecognitionException {
        SqlParser.operation_limited_clause_return retval = new SqlParser.operation_limited_clause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token limit=null;
        Token offset=null;
        Token ORDER195=null;
        Token BY196=null;
        Token COMMA198=null;
        Token LIMIT200=null;
        Token set201=null;
        SqlParser.ordering_term_return ordering_term197 =null;

        SqlParser.ordering_term_return ordering_term199 =null;


        Object limit_tree=null;
        Object offset_tree=null;
        Object ORDER195_tree=null;
        Object BY196_tree=null;
        Object COMMA198_tree=null;
        Object LIMIT200_tree=null;
        Object set201_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:312:25: ( ( ORDER BY ordering_term ( COMMA ordering_term )* )? LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:313:3: ( ORDER BY ordering_term ( COMMA ordering_term )* )? LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )?
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:313:3: ( ORDER BY ordering_term ( COMMA ordering_term )* )?
            int alt61=2;
            int LA61_0 = input.LA(1);

            if ( (LA61_0==ORDER) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:313:4: ORDER BY ordering_term ( COMMA ordering_term )*
                    {
                    ORDER195=(Token)match(input,ORDER,FOLLOW_ORDER_in_operation_limited_clause1849); 
                    ORDER195_tree = 
                    (Object)adaptor.create(ORDER195)
                    ;
                    adaptor.addChild(root_0, ORDER195_tree);


                    BY196=(Token)match(input,BY,FOLLOW_BY_in_operation_limited_clause1851); 
                    BY196_tree = 
                    (Object)adaptor.create(BY196)
                    ;
                    adaptor.addChild(root_0, BY196_tree);


                    pushFollow(FOLLOW_ordering_term_in_operation_limited_clause1853);
                    ordering_term197=ordering_term();

                    state._fsp--;

                    adaptor.addChild(root_0, ordering_term197.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:313:27: ( COMMA ordering_term )*
                    loop60:
                    do {
                        int alt60=2;
                        int LA60_0 = input.LA(1);

                        if ( (LA60_0==COMMA) ) {
                            alt60=1;
                        }


                        switch (alt60) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:313:28: COMMA ordering_term
                    	    {
                    	    COMMA198=(Token)match(input,COMMA,FOLLOW_COMMA_in_operation_limited_clause1856); 
                    	    COMMA198_tree = 
                    	    (Object)adaptor.create(COMMA198)
                    	    ;
                    	    adaptor.addChild(root_0, COMMA198_tree);


                    	    pushFollow(FOLLOW_ordering_term_in_operation_limited_clause1858);
                    	    ordering_term199=ordering_term();

                    	    state._fsp--;

                    	    adaptor.addChild(root_0, ordering_term199.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop60;
                        }
                    } while (true);


                    }
                    break;

            }


            LIMIT200=(Token)match(input,LIMIT,FOLLOW_LIMIT_in_operation_limited_clause1866); 
            LIMIT200_tree = 
            (Object)adaptor.create(LIMIT200)
            ;
            adaptor.addChild(root_0, LIMIT200_tree);


            limit=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_operation_limited_clause1870); 
            limit_tree = 
            (Object)adaptor.create(limit)
            ;
            adaptor.addChild(root_0, limit_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:314:23: ( ( OFFSET | COMMA ) offset= INTEGER )?
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==COMMA||LA62_0==OFFSET) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:314:24: ( OFFSET | COMMA ) offset= INTEGER
                    {
                    set201=(Token)input.LT(1);

                    if ( input.LA(1)==COMMA||input.LA(1)==OFFSET ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set201)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    offset=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_operation_limited_clause1883); 
                    offset_tree = 
                    (Object)adaptor.create(offset)
                    ;
                    adaptor.addChild(root_0, offset_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "operation_limited_clause"


    public static class select_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "select_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:317:1: select_stmt : select_list ( ORDER BY ordering_term ( COMMA ordering_term )* )? ( LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? )? -> ^( SELECT select_list ( ^( ORDER ( ordering_term )+ ) )? ( ^( LIMIT $limit ( $offset)? ) )? ) ;
    public final SqlParser.select_stmt_return select_stmt() throws RecognitionException {
        SqlParser.select_stmt_return retval = new SqlParser.select_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token limit=null;
        Token offset=null;
        Token ORDER203=null;
        Token BY204=null;
        Token COMMA206=null;
        Token LIMIT208=null;
        Token OFFSET209=null;
        Token COMMA210=null;
        SqlParser.select_list_return select_list202 =null;

        SqlParser.ordering_term_return ordering_term205 =null;

        SqlParser.ordering_term_return ordering_term207 =null;


        Object limit_tree=null;
        Object offset_tree=null;
        Object ORDER203_tree=null;
        Object BY204_tree=null;
        Object COMMA206_tree=null;
        Object LIMIT208_tree=null;
        Object OFFSET209_tree=null;
        Object COMMA210_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_ORDER=new RewriteRuleTokenStream(adaptor,"token ORDER");
        RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
        RewriteRuleTokenStream stream_OFFSET=new RewriteRuleTokenStream(adaptor,"token OFFSET");
        RewriteRuleTokenStream stream_LIMIT=new RewriteRuleTokenStream(adaptor,"token LIMIT");
        RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
        RewriteRuleSubtreeStream stream_select_list=new RewriteRuleSubtreeStream(adaptor,"rule select_list");
        RewriteRuleSubtreeStream stream_ordering_term=new RewriteRuleSubtreeStream(adaptor,"rule ordering_term");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:317:12: ( select_list ( ORDER BY ordering_term ( COMMA ordering_term )* )? ( LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? )? -> ^( SELECT select_list ( ^( ORDER ( ordering_term )+ ) )? ( ^( LIMIT $limit ( $offset)? ) )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:317:14: select_list ( ORDER BY ordering_term ( COMMA ordering_term )* )? ( LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? )?
            {
            pushFollow(FOLLOW_select_list_in_select_stmt1893);
            select_list202=select_list();

            state._fsp--;

            stream_select_list.add(select_list202.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:318:3: ( ORDER BY ordering_term ( COMMA ordering_term )* )?
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0==ORDER) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:318:4: ORDER BY ordering_term ( COMMA ordering_term )*
                    {
                    ORDER203=(Token)match(input,ORDER,FOLLOW_ORDER_in_select_stmt1898);  
                    stream_ORDER.add(ORDER203);


                    BY204=(Token)match(input,BY,FOLLOW_BY_in_select_stmt1900);  
                    stream_BY.add(BY204);


                    pushFollow(FOLLOW_ordering_term_in_select_stmt1902);
                    ordering_term205=ordering_term();

                    state._fsp--;

                    stream_ordering_term.add(ordering_term205.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:318:27: ( COMMA ordering_term )*
                    loop63:
                    do {
                        int alt63=2;
                        int LA63_0 = input.LA(1);

                        if ( (LA63_0==COMMA) ) {
                            alt63=1;
                        }


                        switch (alt63) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:318:28: COMMA ordering_term
                    	    {
                    	    COMMA206=(Token)match(input,COMMA,FOLLOW_COMMA_in_select_stmt1905);  
                    	    stream_COMMA.add(COMMA206);


                    	    pushFollow(FOLLOW_ordering_term_in_select_stmt1907);
                    	    ordering_term207=ordering_term();

                    	    state._fsp--;

                    	    stream_ordering_term.add(ordering_term207.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop63;
                        }
                    } while (true);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:3: ( LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )? )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==LIMIT) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:4: LIMIT limit= INTEGER ( ( OFFSET | COMMA ) offset= INTEGER )?
                    {
                    LIMIT208=(Token)match(input,LIMIT,FOLLOW_LIMIT_in_select_stmt1916);  
                    stream_LIMIT.add(LIMIT208);


                    limit=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_select_stmt1920);  
                    stream_INTEGER.add(limit);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:24: ( ( OFFSET | COMMA ) offset= INTEGER )?
                    int alt66=2;
                    int LA66_0 = input.LA(1);

                    if ( (LA66_0==COMMA||LA66_0==OFFSET) ) {
                        alt66=1;
                    }
                    switch (alt66) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:25: ( OFFSET | COMMA ) offset= INTEGER
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:25: ( OFFSET | COMMA )
                            int alt65=2;
                            int LA65_0 = input.LA(1);

                            if ( (LA65_0==OFFSET) ) {
                                alt65=1;
                            }
                            else if ( (LA65_0==COMMA) ) {
                                alt65=2;
                            }
                            else {
                                NoViableAltException nvae =
                                    new NoViableAltException("", 65, 0, input);

                                throw nvae;

                            }
                            switch (alt65) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:26: OFFSET
                                    {
                                    OFFSET209=(Token)match(input,OFFSET,FOLLOW_OFFSET_in_select_stmt1924);  
                                    stream_OFFSET.add(OFFSET209);


                                    }
                                    break;
                                case 2 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:319:35: COMMA
                                    {
                                    COMMA210=(Token)match(input,COMMA,FOLLOW_COMMA_in_select_stmt1928);  
                                    stream_COMMA.add(COMMA210);


                                    }
                                    break;

                            }


                            offset=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_select_stmt1933);  
                            stream_INTEGER.add(offset);


                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: ORDER, ordering_term, select_list, limit, offset, LIMIT
            // token labels: offset, limit
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_offset=new RewriteRuleTokenStream(adaptor,"token offset",offset);
            RewriteRuleTokenStream stream_limit=new RewriteRuleTokenStream(adaptor,"token limit",limit);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 320:2: -> ^( SELECT select_list ( ^( ORDER ( ordering_term )+ ) )? ( ^( LIMIT $limit ( $offset)? ) )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:320:4: ^( SELECT select_list ( ^( ORDER ( ordering_term )+ ) )? ( ^( LIMIT $limit ( $offset)? ) )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT, "SELECT")
                , root_1);

                adaptor.addChild(root_1, stream_select_list.nextTree());

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:321:22: ( ^( ORDER ( ordering_term )+ ) )?
                if ( stream_ORDER.hasNext()||stream_ordering_term.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:321:22: ^( ORDER ( ordering_term )+ )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_ORDER.nextNode()
                    , root_2);

                    if ( !(stream_ordering_term.hasNext()) ) {
                        throw new RewriteEarlyExitException();
                    }
                    while ( stream_ordering_term.hasNext() ) {
                        adaptor.addChild(root_2, stream_ordering_term.nextTree());

                    }
                    stream_ordering_term.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_ORDER.reset();
                stream_ordering_term.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:321:47: ( ^( LIMIT $limit ( $offset)? ) )?
                if ( stream_limit.hasNext()||stream_offset.hasNext()||stream_LIMIT.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:321:47: ^( LIMIT $limit ( $offset)? )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_LIMIT.nextNode()
                    , root_2);

                    adaptor.addChild(root_2, stream_limit.nextNode());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:321:63: ( $offset)?
                    if ( stream_offset.hasNext() ) {
                        adaptor.addChild(root_2, stream_offset.nextNode());

                    }
                    stream_offset.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_limit.reset();
                stream_offset.reset();
                stream_LIMIT.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "select_stmt"


    public static class select_list_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "select_list"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:324:1: select_list : select_core ( select_op ^ select_core )* ;
    public final SqlParser.select_list_return select_list() throws RecognitionException {
        SqlParser.select_list_return retval = new SqlParser.select_list_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.select_core_return select_core211 =null;

        SqlParser.select_op_return select_op212 =null;

        SqlParser.select_core_return select_core213 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:324:12: ( select_core ( select_op ^ select_core )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:325:3: select_core ( select_op ^ select_core )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_select_core_in_select_list1978);
            select_core211=select_core();

            state._fsp--;

            adaptor.addChild(root_0, select_core211.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:325:15: ( select_op ^ select_core )*
            loop68:
            do {
                int alt68=2;
                int LA68_0 = input.LA(1);

                if ( (LA68_0==EXCEPT||LA68_0==INTERSECT||LA68_0==UNION) ) {
                    alt68=1;
                }


                switch (alt68) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:325:16: select_op ^ select_core
            	    {
            	    pushFollow(FOLLOW_select_op_in_select_list1981);
            	    select_op212=select_op();

            	    state._fsp--;

            	    root_0 = (Object)adaptor.becomeRoot(select_op212.getTree(), root_0);

            	    pushFollow(FOLLOW_select_core_in_select_list1984);
            	    select_core213=select_core();

            	    state._fsp--;

            	    adaptor.addChild(root_0, select_core213.getTree());

            	    }
            	    break;

            	default :
            	    break loop68;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "select_list"


    public static class select_op_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "select_op"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:1: select_op : ( UNION ^ ( ALL )? | INTERSECT | EXCEPT );
    public final SqlParser.select_op_return select_op() throws RecognitionException {
        SqlParser.select_op_return retval = new SqlParser.select_op_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token UNION214=null;
        Token ALL215=null;
        Token INTERSECT216=null;
        Token EXCEPT217=null;

        Object UNION214_tree=null;
        Object ALL215_tree=null;
        Object INTERSECT216_tree=null;
        Object EXCEPT217_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:10: ( UNION ^ ( ALL )? | INTERSECT | EXCEPT )
            int alt70=3;
            switch ( input.LA(1) ) {
            case UNION:
                {
                alt70=1;
                }
                break;
            case INTERSECT:
                {
                alt70=2;
                }
                break;
            case EXCEPT:
                {
                alt70=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }

            switch (alt70) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:12: UNION ^ ( ALL )?
                    {
                    root_0 = (Object)adaptor.nil();


                    UNION214=(Token)match(input,UNION,FOLLOW_UNION_in_select_op1993); 
                    UNION214_tree = 
                    (Object)adaptor.create(UNION214)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(UNION214_tree, root_0);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:19: ( ALL )?
                    int alt69=2;
                    int LA69_0 = input.LA(1);

                    if ( (LA69_0==ALL) ) {
                        alt69=1;
                    }
                    switch (alt69) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:20: ALL
                            {
                            ALL215=(Token)match(input,ALL,FOLLOW_ALL_in_select_op1997); 
                            ALL215_tree = 
                            (Object)adaptor.create(ALL215)
                            ;
                            adaptor.addChild(root_0, ALL215_tree);


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:28: INTERSECT
                    {
                    root_0 = (Object)adaptor.nil();


                    INTERSECT216=(Token)match(input,INTERSECT,FOLLOW_INTERSECT_in_select_op2003); 
                    INTERSECT216_tree = 
                    (Object)adaptor.create(INTERSECT216)
                    ;
                    adaptor.addChild(root_0, INTERSECT216_tree);


                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:327:40: EXCEPT
                    {
                    root_0 = (Object)adaptor.nil();


                    EXCEPT217=(Token)match(input,EXCEPT,FOLLOW_EXCEPT_in_select_op2007); 
                    EXCEPT217_tree = 
                    (Object)adaptor.create(EXCEPT217)
                    ;
                    adaptor.addChild(root_0, EXCEPT217_tree);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "select_op"


    public static class select_core_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "select_core"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:329:1: select_core : SELECT ( ALL | DISTINCT )? result_column ( COMMA result_column )* ( FROM join_source )? ( WHERE where_expr= expr )? ( GROUP BY ordering_term ( COMMA ordering_term )* ( HAVING having_expr= expr )? )? -> ^( SELECT_CORE ( DISTINCT )? ^( COLUMNS ( result_column )+ ) ( ^( FROM join_source ) )? ( ^( WHERE $where_expr) )? ( ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? ) )? ) ;
    public final SqlParser.select_core_return select_core() throws RecognitionException {
        SqlParser.select_core_return retval = new SqlParser.select_core_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SELECT218=null;
        Token ALL219=null;
        Token DISTINCT220=null;
        Token COMMA222=null;
        Token FROM224=null;
        Token WHERE226=null;
        Token GROUP227=null;
        Token BY228=null;
        Token COMMA230=null;
        Token HAVING232=null;
        SqlParser.expr_return where_expr =null;

        SqlParser.expr_return having_expr =null;

        SqlParser.result_column_return result_column221 =null;

        SqlParser.result_column_return result_column223 =null;

        SqlParser.join_source_return join_source225 =null;

        SqlParser.ordering_term_return ordering_term229 =null;

        SqlParser.ordering_term_return ordering_term231 =null;


        Object SELECT218_tree=null;
        Object ALL219_tree=null;
        Object DISTINCT220_tree=null;
        Object COMMA222_tree=null;
        Object FROM224_tree=null;
        Object WHERE226_tree=null;
        Object GROUP227_tree=null;
        Object BY228_tree=null;
        Object COMMA230_tree=null;
        Object HAVING232_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_ALL=new RewriteRuleTokenStream(adaptor,"token ALL");
        RewriteRuleTokenStream stream_GROUP=new RewriteRuleTokenStream(adaptor,"token GROUP");
        RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
        RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
        RewriteRuleTokenStream stream_FROM=new RewriteRuleTokenStream(adaptor,"token FROM");
        RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
        RewriteRuleTokenStream stream_HAVING=new RewriteRuleTokenStream(adaptor,"token HAVING");
        RewriteRuleTokenStream stream_SELECT=new RewriteRuleTokenStream(adaptor,"token SELECT");
        RewriteRuleSubtreeStream stream_ordering_term=new RewriteRuleSubtreeStream(adaptor,"rule ordering_term");
        RewriteRuleSubtreeStream stream_result_column=new RewriteRuleSubtreeStream(adaptor,"rule result_column");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        RewriteRuleSubtreeStream stream_join_source=new RewriteRuleSubtreeStream(adaptor,"rule join_source");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:329:12: ( SELECT ( ALL | DISTINCT )? result_column ( COMMA result_column )* ( FROM join_source )? ( WHERE where_expr= expr )? ( GROUP BY ordering_term ( COMMA ordering_term )* ( HAVING having_expr= expr )? )? -> ^( SELECT_CORE ( DISTINCT )? ^( COLUMNS ( result_column )+ ) ( ^( FROM join_source ) )? ( ^( WHERE $where_expr) )? ( ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? ) )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:3: SELECT ( ALL | DISTINCT )? result_column ( COMMA result_column )* ( FROM join_source )? ( WHERE where_expr= expr )? ( GROUP BY ordering_term ( COMMA ordering_term )* ( HAVING having_expr= expr )? )?
            {
            SELECT218=(Token)match(input,SELECT,FOLLOW_SELECT_in_select_core2016);  
            stream_SELECT.add(SELECT218);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:10: ( ALL | DISTINCT )?
            int alt71=3;
            alt71 = dfa71.predict(input);
            switch (alt71) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:11: ALL
                    {
                    ALL219=(Token)match(input,ALL,FOLLOW_ALL_in_select_core2019);  
                    stream_ALL.add(ALL219);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:17: DISTINCT
                    {
                    DISTINCT220=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_select_core2023);  
                    stream_DISTINCT.add(DISTINCT220);


                    }
                    break;

            }


            pushFollow(FOLLOW_result_column_in_select_core2027);
            result_column221=result_column();

            state._fsp--;

            stream_result_column.add(result_column221.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:42: ( COMMA result_column )*
            loop72:
            do {
                int alt72=2;
                int LA72_0 = input.LA(1);

                if ( (LA72_0==COMMA) ) {
                    alt72=1;
                }


                switch (alt72) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:43: COMMA result_column
            	    {
            	    COMMA222=(Token)match(input,COMMA,FOLLOW_COMMA_in_select_core2030);  
            	    stream_COMMA.add(COMMA222);


            	    pushFollow(FOLLOW_result_column_in_select_core2032);
            	    result_column223=result_column();

            	    state._fsp--;

            	    stream_result_column.add(result_column223.getTree());

            	    }
            	    break;

            	default :
            	    break loop72;
                }
            } while (true);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:65: ( FROM join_source )?
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==FROM) ) {
                alt73=1;
            }
            switch (alt73) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:66: FROM join_source
                    {
                    FROM224=(Token)match(input,FROM,FOLLOW_FROM_in_select_core2037);  
                    stream_FROM.add(FROM224);


                    pushFollow(FOLLOW_join_source_in_select_core2039);
                    join_source225=join_source();

                    state._fsp--;

                    stream_join_source.add(join_source225.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:85: ( WHERE where_expr= expr )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==WHERE) ) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:330:86: WHERE where_expr= expr
                    {
                    WHERE226=(Token)match(input,WHERE,FOLLOW_WHERE_in_select_core2044);  
                    stream_WHERE.add(WHERE226);


                    pushFollow(FOLLOW_expr_in_select_core2048);
                    where_expr=expr();

                    state._fsp--;

                    stream_expr.add(where_expr.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:3: ( GROUP BY ordering_term ( COMMA ordering_term )* ( HAVING having_expr= expr )? )?
            int alt77=2;
            int LA77_0 = input.LA(1);

            if ( (LA77_0==GROUP) ) {
                alt77=1;
            }
            switch (alt77) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:5: GROUP BY ordering_term ( COMMA ordering_term )* ( HAVING having_expr= expr )?
                    {
                    GROUP227=(Token)match(input,GROUP,FOLLOW_GROUP_in_select_core2056);  
                    stream_GROUP.add(GROUP227);


                    BY228=(Token)match(input,BY,FOLLOW_BY_in_select_core2058);  
                    stream_BY.add(BY228);


                    pushFollow(FOLLOW_ordering_term_in_select_core2060);
                    ordering_term229=ordering_term();

                    state._fsp--;

                    stream_ordering_term.add(ordering_term229.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:28: ( COMMA ordering_term )*
                    loop75:
                    do {
                        int alt75=2;
                        int LA75_0 = input.LA(1);

                        if ( (LA75_0==COMMA) ) {
                            alt75=1;
                        }


                        switch (alt75) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:29: COMMA ordering_term
                    	    {
                    	    COMMA230=(Token)match(input,COMMA,FOLLOW_COMMA_in_select_core2063);  
                    	    stream_COMMA.add(COMMA230);


                    	    pushFollow(FOLLOW_ordering_term_in_select_core2065);
                    	    ordering_term231=ordering_term();

                    	    state._fsp--;

                    	    stream_ordering_term.add(ordering_term231.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop75;
                        }
                    } while (true);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:51: ( HAVING having_expr= expr )?
                    int alt76=2;
                    int LA76_0 = input.LA(1);

                    if ( (LA76_0==HAVING) ) {
                        alt76=1;
                    }
                    switch (alt76) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:331:52: HAVING having_expr= expr
                            {
                            HAVING232=(Token)match(input,HAVING,FOLLOW_HAVING_in_select_core2070);  
                            stream_HAVING.add(HAVING232);


                            pushFollow(FOLLOW_expr_in_select_core2074);
                            having_expr=expr();

                            state._fsp--;

                            stream_expr.add(having_expr.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: HAVING, result_column, WHERE, join_source, where_expr, DISTINCT, ordering_term, GROUP, having_expr, FROM
            // token labels: 
            // rule labels: having_expr, where_expr, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_having_expr=new RewriteRuleSubtreeStream(adaptor,"rule having_expr",having_expr!=null?having_expr.tree:null);
            RewriteRuleSubtreeStream stream_where_expr=new RewriteRuleSubtreeStream(adaptor,"rule where_expr",where_expr!=null?where_expr.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 332:2: -> ^( SELECT_CORE ( DISTINCT )? ^( COLUMNS ( result_column )+ ) ( ^( FROM join_source ) )? ( ^( WHERE $where_expr) )? ( ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? ) )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:332:4: ^( SELECT_CORE ( DISTINCT )? ^( COLUMNS ( result_column )+ ) ( ^( FROM join_source ) )? ( ^( WHERE $where_expr) )? ( ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? ) )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(SELECT_CORE, "SELECT_CORE")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:15: ( DISTINCT )?
                if ( stream_DISTINCT.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_DISTINCT.nextNode()
                    );

                }
                stream_DISTINCT.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:27: ^( COLUMNS ( result_column )+ )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMNS, "COLUMNS")
                , root_2);

                if ( !(stream_result_column.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_result_column.hasNext() ) {
                    adaptor.addChild(root_2, stream_result_column.nextTree());

                }
                stream_result_column.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:53: ( ^( FROM join_source ) )?
                if ( stream_join_source.hasNext()||stream_FROM.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:53: ^( FROM join_source )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_FROM.nextNode()
                    , root_2);

                    adaptor.addChild(root_2, stream_join_source.nextTree());

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_join_source.reset();
                stream_FROM.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:74: ( ^( WHERE $where_expr) )?
                if ( stream_WHERE.hasNext()||stream_where_expr.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:333:74: ^( WHERE $where_expr)
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_WHERE.nextNode()
                    , root_2);

                    adaptor.addChild(root_2, stream_where_expr.nextTree());

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_WHERE.reset();
                stream_where_expr.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:334:3: ( ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? ) )?
                if ( stream_HAVING.hasNext()||stream_ordering_term.hasNext()||stream_GROUP.hasNext()||stream_having_expr.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:334:3: ^( GROUP ( ordering_term )+ ( ^( HAVING $having_expr) )? )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_GROUP.nextNode()
                    , root_2);

                    if ( !(stream_ordering_term.hasNext()) ) {
                        throw new RewriteEarlyExitException();
                    }
                    while ( stream_ordering_term.hasNext() ) {
                        adaptor.addChild(root_2, stream_ordering_term.nextTree());

                    }
                    stream_ordering_term.reset();

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:334:26: ( ^( HAVING $having_expr) )?
                    if ( stream_HAVING.hasNext()||stream_having_expr.hasNext() ) {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:334:26: ^( HAVING $having_expr)
                        {
                        Object root_3 = (Object)adaptor.nil();
                        root_3 = (Object)adaptor.becomeRoot(
                        stream_HAVING.nextNode()
                        , root_3);

                        adaptor.addChild(root_3, stream_having_expr.nextTree());

                        adaptor.addChild(root_2, root_3);
                        }

                    }
                    stream_HAVING.reset();
                    stream_having_expr.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_HAVING.reset();
                stream_ordering_term.reset();
                stream_GROUP.reset();
                stream_having_expr.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "select_core"


    public static class result_column_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "result_column"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:337:1: result_column : ( ASTERISK |table_name= id DOT ASTERISK -> ^( ASTERISK $table_name) | expr ( ( AS )? column_alias= id )? -> ^( ALIAS expr ( $column_alias)? ) );
    public final SqlParser.result_column_return result_column() throws RecognitionException {
        SqlParser.result_column_return retval = new SqlParser.result_column_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ASTERISK233=null;
        Token DOT234=null;
        Token ASTERISK235=null;
        Token AS237=null;
        SqlParser.id_return table_name =null;

        SqlParser.id_return column_alias =null;

        SqlParser.expr_return expr236 =null;


        Object ASTERISK233_tree=null;
        Object DOT234_tree=null;
        Object ASTERISK235_tree=null;
        Object AS237_tree=null;
        RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:338:3: ( ASTERISK |table_name= id DOT ASTERISK -> ^( ASTERISK $table_name) | expr ( ( AS )? column_alias= id )? -> ^( ALIAS expr ( $column_alias)? ) )
            int alt80=3;
            alt80 = dfa80.predict(input);
            switch (alt80) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:338:5: ASTERISK
                    {
                    root_0 = (Object)adaptor.nil();


                    ASTERISK233=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_result_column2144); 
                    ASTERISK233_tree = 
                    (Object)adaptor.create(ASTERISK233)
                    ;
                    adaptor.addChild(root_0, ASTERISK233_tree);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:339:5: table_name= id DOT ASTERISK
                    {
                    pushFollow(FOLLOW_id_in_result_column2152);
                    table_name=id();

                    state._fsp--;

                    stream_id.add(table_name.getTree());

                    DOT234=(Token)match(input,DOT,FOLLOW_DOT_in_result_column2154);  
                    stream_DOT.add(DOT234);


                    ASTERISK235=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_result_column2156);  
                    stream_ASTERISK.add(ASTERISK235);


                    // AST REWRITE
                    // elements: ASTERISK, table_name
                    // token labels: 
                    // rule labels: table_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 339:32: -> ^( ASTERISK $table_name)
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:339:35: ^( ASTERISK $table_name)
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        stream_ASTERISK.nextNode()
                        , root_1);

                        adaptor.addChild(root_1, stream_table_name.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:5: expr ( ( AS )? column_alias= id )?
                    {
                    pushFollow(FOLLOW_expr_in_result_column2171);
                    expr236=expr();

                    state._fsp--;

                    stream_expr.add(expr236.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:10: ( ( AS )? column_alias= id )?
                    int alt79=2;
                    alt79 = dfa79.predict(input);
                    switch (alt79) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:11: ( AS )? column_alias= id
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:11: ( AS )?
                            int alt78=2;
                            alt78 = dfa78.predict(input);
                            switch (alt78) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:12: AS
                                    {
                                    AS237=(Token)match(input,AS,FOLLOW_AS_in_result_column2175);  
                                    stream_AS.add(AS237);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_id_in_result_column2181);
                            column_alias=id();

                            state._fsp--;

                            stream_id.add(column_alias.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: column_alias, expr
                    // token labels: 
                    // rule labels: column_alias, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_column_alias=new RewriteRuleSubtreeStream(adaptor,"rule column_alias",column_alias!=null?column_alias.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 340:35: -> ^( ALIAS expr ( $column_alias)? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:38: ^( ALIAS expr ( $column_alias)? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(ALIAS, "ALIAS")
                        , root_1);

                        adaptor.addChild(root_1, stream_expr.nextTree());

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:340:52: ( $column_alias)?
                        if ( stream_column_alias.hasNext() ) {
                            adaptor.addChild(root_1, stream_column_alias.nextTree());

                        }
                        stream_column_alias.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "result_column"


    public static class join_source_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "join_source"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:1: join_source : single_source ( join_op ^ single_source ( join_constraint )? )* ;
    public final SqlParser.join_source_return join_source() throws RecognitionException {
        SqlParser.join_source_return retval = new SqlParser.join_source_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.single_source_return single_source238 =null;

        SqlParser.join_op_return join_op239 =null;

        SqlParser.single_source_return single_source240 =null;

        SqlParser.join_constraint_return join_constraint241 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:12: ( single_source ( join_op ^ single_source ( join_constraint )? )* )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:14: single_source ( join_op ^ single_source ( join_constraint )? )*
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_single_source_in_join_source2202);
            single_source238=single_source();

            state._fsp--;

            adaptor.addChild(root_0, single_source238.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:28: ( join_op ^ single_source ( join_constraint )? )*
            loop82:
            do {
                int alt82=2;
                int LA82_0 = input.LA(1);

                if ( (LA82_0==COMMA||LA82_0==CROSS||LA82_0==INNER||LA82_0==JOIN||LA82_0==LEFT||LA82_0==NATURAL||LA82_0==OUTER) ) {
                    alt82=1;
                }


                switch (alt82) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:29: join_op ^ single_source ( join_constraint )?
            	    {
            	    pushFollow(FOLLOW_join_op_in_join_source2205);
            	    join_op239=join_op();

            	    state._fsp--;

            	    root_0 = (Object)adaptor.becomeRoot(join_op239.getTree(), root_0);

            	    pushFollow(FOLLOW_single_source_in_join_source2208);
            	    single_source240=single_source();

            	    state._fsp--;

            	    adaptor.addChild(root_0, single_source240.getTree());

            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:52: ( join_constraint )?
            	    int alt81=2;
            	    int LA81_0 = input.LA(1);

            	    if ( (LA81_0==ON||LA81_0==USING) ) {
            	        alt81=1;
            	    }
            	    switch (alt81) {
            	        case 1 :
            	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:342:53: join_constraint
            	            {
            	            pushFollow(FOLLOW_join_constraint_in_join_source2211);
            	            join_constraint241=join_constraint();

            	            state._fsp--;

            	            adaptor.addChild(root_0, join_constraint241.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop82;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "join_source"


    public static class single_source_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "single_source"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:344:1: single_source : ( (database_name= id DOT )? table_name= ID ( ( AS )? table_alias= ID )? ( INDEXED BY index_name= id | NOT INDEXED )? -> ^( ALIAS ^( $table_name ( $database_name)? ) ( $table_alias)? ( ^( INDEXED ( NOT )? ( $index_name)? ) )? ) | LPAREN select_stmt RPAREN ( ( AS )? table_alias= ID )? -> ^( ALIAS select_stmt ( $table_alias)? ) | LPAREN ! join_source RPAREN !);
    public final SqlParser.single_source_return single_source() throws RecognitionException {
        SqlParser.single_source_return retval = new SqlParser.single_source_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token table_name=null;
        Token table_alias=null;
        Token DOT242=null;
        Token AS243=null;
        Token INDEXED244=null;
        Token BY245=null;
        Token NOT246=null;
        Token INDEXED247=null;
        Token LPAREN248=null;
        Token RPAREN250=null;
        Token AS251=null;
        Token LPAREN252=null;
        Token RPAREN254=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return index_name =null;

        SqlParser.select_stmt_return select_stmt249 =null;

        SqlParser.join_source_return join_source253 =null;


        Object table_name_tree=null;
        Object table_alias_tree=null;
        Object DOT242_tree=null;
        Object AS243_tree=null;
        Object INDEXED244_tree=null;
        Object BY245_tree=null;
        Object NOT246_tree=null;
        Object INDEXED247_tree=null;
        Object LPAREN248_tree=null;
        Object RPAREN250_tree=null;
        Object AS251_tree=null;
        Object LPAREN252_tree=null;
        Object RPAREN254_tree=null;
        RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_INDEXED=new RewriteRuleTokenStream(adaptor,"token INDEXED");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_select_stmt=new RewriteRuleSubtreeStream(adaptor,"rule select_stmt");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:3: ( (database_name= id DOT )? table_name= ID ( ( AS )? table_alias= ID )? ( INDEXED BY index_name= id | NOT INDEXED )? -> ^( ALIAS ^( $table_name ( $database_name)? ) ( $table_alias)? ( ^( INDEXED ( NOT )? ( $index_name)? ) )? ) | LPAREN select_stmt RPAREN ( ( AS )? table_alias= ID )? -> ^( ALIAS select_stmt ( $table_alias)? ) | LPAREN ! join_source RPAREN !)
            int alt89=3;
            int LA89_0 = input.LA(1);

            if ( ((LA89_0 >= ABORT && LA89_0 <= AFTER)||(LA89_0 >= ALL && LA89_0 <= ALTER)||(LA89_0 >= ANALYZE && LA89_0 <= AND)||(LA89_0 >= AS && LA89_0 <= ASC)||(LA89_0 >= ATTACH && LA89_0 <= AUTOINCREMENT)||(LA89_0 >= BEFORE && LA89_0 <= BETWEEN)||LA89_0==BY||(LA89_0 >= CASCADE && LA89_0 <= COLLATE)||LA89_0==COLUMN||(LA89_0 >= COMMIT && LA89_0 <= CONSTRAINT)||LA89_0==CREATE||(LA89_0 >= CROSS && LA89_0 <= CURRENT_TIMESTAMP)||(LA89_0 >= DATABASE && LA89_0 <= DISTINCT)||LA89_0==DROP||(LA89_0 >= EACH && LA89_0 <= END)||(LA89_0 >= ESCAPE && LA89_0 <= EXPLAIN)||LA89_0==FAIL||(LA89_0 >= FOR && LA89_0 <= FROM)||LA89_0==GROUP||LA89_0==HAVING||LA89_0==ID||(LA89_0 >= IF && LA89_0 <= IMMEDIATE)||(LA89_0 >= INDEX && LA89_0 <= INSTEAD)||(LA89_0 >= INTERSECT && LA89_0 <= INTO)||LA89_0==IS||LA89_0==JOIN||LA89_0==KEY||LA89_0==LEFT||LA89_0==LIMIT||LA89_0==NATURAL||LA89_0==NULL||(LA89_0 >= OF && LA89_0 <= ON)||(LA89_0 >= OR && LA89_0 <= ORDER)||LA89_0==OUTER||LA89_0==PLAN||(LA89_0 >= PRAGMA && LA89_0 <= PRIMARY)||LA89_0==QUERY||(LA89_0 >= RAISE && LA89_0 <= REFERENCES)||(LA89_0 >= REINDEX && LA89_0 <= ROW)||(LA89_0 >= SAVEPOINT && LA89_0 <= SELECT)||LA89_0==SET||LA89_0==STRING||LA89_0==TABLE||(LA89_0 >= TEMPORARY && LA89_0 <= THEN)||(LA89_0 >= TO && LA89_0 <= TRIGGER)||(LA89_0 >= UNION && LA89_0 <= USING)||(LA89_0 >= VACUUM && LA89_0 <= VIRTUAL)||(LA89_0 >= WHEN && LA89_0 <= WHERE)) ) {
                alt89=1;
            }
            else if ( (LA89_0==LPAREN) ) {
                int LA89_4 = input.LA(2);

                if ( (LA89_4==SELECT) ) {
                    int LA89_5 = input.LA(3);

                    if ( ((LA89_5 >= ABORT && LA89_5 <= AFTER)||(LA89_5 >= ALL && LA89_5 <= ALTER)||(LA89_5 >= ANALYZE && LA89_5 <= AND)||(LA89_5 >= AS && LA89_5 <= AUTOINCREMENT)||(LA89_5 >= BEFORE && LA89_5 <= BETWEEN)||LA89_5==BLOB||LA89_5==BY||(LA89_5 >= CASCADE && LA89_5 <= COLUMN)||(LA89_5 >= COMMIT && LA89_5 <= CONSTRAINT)||LA89_5==CREATE||(LA89_5 >= CROSS && LA89_5 <= CURRENT_TIMESTAMP)||(LA89_5 >= DATABASE && LA89_5 <= DISTINCT)||LA89_5==DROP||(LA89_5 >= EACH && LA89_5 <= END)||(LA89_5 >= ESCAPE && LA89_5 <= EXPLAIN)||(LA89_5 >= FAIL && LA89_5 <= FLOAT)||(LA89_5 >= FOR && LA89_5 <= FROM)||LA89_5==GROUP||LA89_5==HAVING||LA89_5==ID||(LA89_5 >= IF && LA89_5 <= IMMEDIATE)||(LA89_5 >= INDEX && LA89_5 <= INTEGER)||(LA89_5 >= INTERSECT && LA89_5 <= INTO)||LA89_5==IS||LA89_5==JOIN||LA89_5==KEY||LA89_5==LEFT||LA89_5==LIMIT||LA89_5==LPAREN||LA89_5==MINUS||(LA89_5 >= NATURAL && LA89_5 <= NOT)||LA89_5==NULL||(LA89_5 >= OF && LA89_5 <= ON)||(LA89_5 >= OR && LA89_5 <= ORDER)||LA89_5==OUTER||(LA89_5 >= PLAN && LA89_5 <= PRIMARY)||(LA89_5 >= QUERY && LA89_5 <= QUESTION)||(LA89_5 >= RAISE && LA89_5 <= REFERENCES)||(LA89_5 >= REINDEX && LA89_5 <= ROW)||(LA89_5 >= SAVEPOINT && LA89_5 <= SELECT)||LA89_5==SET||LA89_5==STRING||LA89_5==TABLE||(LA89_5 >= TEMPORARY && LA89_5 <= TRUE)||(LA89_5 >= UNION && LA89_5 <= USING)||(LA89_5 >= VACUUM && LA89_5 <= VIRTUAL)||(LA89_5 >= WHEN && LA89_5 <= WHERE)) ) {
                        alt89=2;
                    }
                    else if ( (LA89_5==DOT) ) {
                        alt89=3;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 89, 5, input);

                        throw nvae;

                    }
                }
                else if ( ((LA89_4 >= ABORT && LA89_4 <= AFTER)||(LA89_4 >= ALL && LA89_4 <= ALTER)||(LA89_4 >= ANALYZE && LA89_4 <= AND)||(LA89_4 >= AS && LA89_4 <= ASC)||(LA89_4 >= ATTACH && LA89_4 <= AUTOINCREMENT)||(LA89_4 >= BEFORE && LA89_4 <= BETWEEN)||LA89_4==BY||(LA89_4 >= CASCADE && LA89_4 <= COLLATE)||LA89_4==COLUMN||(LA89_4 >= COMMIT && LA89_4 <= CONSTRAINT)||LA89_4==CREATE||(LA89_4 >= CROSS && LA89_4 <= CURRENT_TIMESTAMP)||(LA89_4 >= DATABASE && LA89_4 <= DISTINCT)||LA89_4==DROP||(LA89_4 >= EACH && LA89_4 <= END)||(LA89_4 >= ESCAPE && LA89_4 <= EXPLAIN)||LA89_4==FAIL||(LA89_4 >= FOR && LA89_4 <= FROM)||LA89_4==GROUP||LA89_4==HAVING||LA89_4==ID||(LA89_4 >= IF && LA89_4 <= IMMEDIATE)||(LA89_4 >= INDEX && LA89_4 <= INSTEAD)||(LA89_4 >= INTERSECT && LA89_4 <= INTO)||LA89_4==IS||LA89_4==JOIN||LA89_4==KEY||LA89_4==LEFT||LA89_4==LIMIT||LA89_4==LPAREN||LA89_4==NATURAL||LA89_4==NULL||(LA89_4 >= OF && LA89_4 <= ON)||(LA89_4 >= OR && LA89_4 <= ORDER)||LA89_4==OUTER||LA89_4==PLAN||(LA89_4 >= PRAGMA && LA89_4 <= PRIMARY)||LA89_4==QUERY||(LA89_4 >= RAISE && LA89_4 <= REFERENCES)||(LA89_4 >= REINDEX && LA89_4 <= ROW)||LA89_4==SAVEPOINT||LA89_4==SET||LA89_4==STRING||LA89_4==TABLE||(LA89_4 >= TEMPORARY && LA89_4 <= THEN)||(LA89_4 >= TO && LA89_4 <= TRIGGER)||(LA89_4 >= UNION && LA89_4 <= USING)||(LA89_4 >= VACUUM && LA89_4 <= VIRTUAL)||(LA89_4 >= WHEN && LA89_4 <= WHERE)) ) {
                    alt89=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 89, 4, input);

                    throw nvae;

                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;

            }
            switch (alt89) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:5: (database_name= id DOT )? table_name= ID ( ( AS )? table_alias= ID )? ( INDEXED BY index_name= id | NOT INDEXED )?
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:5: (database_name= id DOT )?
                    int alt83=2;
                    int LA83_0 = input.LA(1);

                    if ( (LA83_0==ID) ) {
                        int LA83_1 = input.LA(2);

                        if ( (LA83_1==DOT) ) {
                            alt83=1;
                        }
                    }
                    else if ( ((LA83_0 >= ABORT && LA83_0 <= AFTER)||(LA83_0 >= ALL && LA83_0 <= ALTER)||(LA83_0 >= ANALYZE && LA83_0 <= AND)||(LA83_0 >= AS && LA83_0 <= ASC)||(LA83_0 >= ATTACH && LA83_0 <= AUTOINCREMENT)||(LA83_0 >= BEFORE && LA83_0 <= BETWEEN)||LA83_0==BY||(LA83_0 >= CASCADE && LA83_0 <= COLLATE)||LA83_0==COLUMN||(LA83_0 >= COMMIT && LA83_0 <= CONSTRAINT)||LA83_0==CREATE||(LA83_0 >= CROSS && LA83_0 <= CURRENT_TIMESTAMP)||(LA83_0 >= DATABASE && LA83_0 <= DISTINCT)||LA83_0==DROP||(LA83_0 >= EACH && LA83_0 <= END)||(LA83_0 >= ESCAPE && LA83_0 <= EXPLAIN)||LA83_0==FAIL||(LA83_0 >= FOR && LA83_0 <= FROM)||LA83_0==GROUP||LA83_0==HAVING||(LA83_0 >= IF && LA83_0 <= IMMEDIATE)||(LA83_0 >= INDEX && LA83_0 <= INSTEAD)||(LA83_0 >= INTERSECT && LA83_0 <= INTO)||LA83_0==IS||LA83_0==JOIN||LA83_0==KEY||LA83_0==LEFT||LA83_0==LIMIT||LA83_0==NATURAL||LA83_0==NULL||(LA83_0 >= OF && LA83_0 <= ON)||(LA83_0 >= OR && LA83_0 <= ORDER)||LA83_0==OUTER||LA83_0==PLAN||(LA83_0 >= PRAGMA && LA83_0 <= PRIMARY)||LA83_0==QUERY||(LA83_0 >= RAISE && LA83_0 <= REFERENCES)||(LA83_0 >= REINDEX && LA83_0 <= ROW)||(LA83_0 >= SAVEPOINT && LA83_0 <= SELECT)||LA83_0==SET||LA83_0==STRING||LA83_0==TABLE||(LA83_0 >= TEMPORARY && LA83_0 <= THEN)||(LA83_0 >= TO && LA83_0 <= TRIGGER)||(LA83_0 >= UNION && LA83_0 <= USING)||(LA83_0 >= VACUUM && LA83_0 <= VIRTUAL)||(LA83_0 >= WHEN && LA83_0 <= WHERE)) ) {
                        alt83=1;
                    }
                    switch (alt83) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:6: database_name= id DOT
                            {
                            pushFollow(FOLLOW_id_in_single_source2228);
                            database_name=id();

                            state._fsp--;

                            stream_id.add(database_name.getTree());

                            DOT242=(Token)match(input,DOT,FOLLOW_DOT_in_single_source2230);  
                            stream_DOT.add(DOT242);


                            }
                            break;

                    }


                    table_name=(Token)match(input,ID,FOLLOW_ID_in_single_source2236);  
                    stream_ID.add(table_name);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:43: ( ( AS )? table_alias= ID )?
                    int alt85=2;
                    int LA85_0 = input.LA(1);

                    if ( (LA85_0==AS||LA85_0==ID) ) {
                        alt85=1;
                    }
                    switch (alt85) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:44: ( AS )? table_alias= ID
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:44: ( AS )?
                            int alt84=2;
                            int LA84_0 = input.LA(1);

                            if ( (LA84_0==AS) ) {
                                alt84=1;
                            }
                            switch (alt84) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:45: AS
                                    {
                                    AS243=(Token)match(input,AS,FOLLOW_AS_in_single_source2240);  
                                    stream_AS.add(AS243);


                                    }
                                    break;

                            }


                            table_alias=(Token)match(input,ID,FOLLOW_ID_in_single_source2246);  
                            stream_ID.add(table_alias);


                            }
                            break;

                    }


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:67: ( INDEXED BY index_name= id | NOT INDEXED )?
                    int alt86=3;
                    int LA86_0 = input.LA(1);

                    if ( (LA86_0==INDEXED) ) {
                        alt86=1;
                    }
                    else if ( (LA86_0==NOT) ) {
                        alt86=2;
                    }
                    switch (alt86) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:68: INDEXED BY index_name= id
                            {
                            INDEXED244=(Token)match(input,INDEXED,FOLLOW_INDEXED_in_single_source2251);  
                            stream_INDEXED.add(INDEXED244);


                            BY245=(Token)match(input,BY,FOLLOW_BY_in_single_source2253);  
                            stream_BY.add(BY245);


                            pushFollow(FOLLOW_id_in_single_source2257);
                            index_name=id();

                            state._fsp--;

                            stream_id.add(index_name.getTree());

                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:345:95: NOT INDEXED
                            {
                            NOT246=(Token)match(input,NOT,FOLLOW_NOT_in_single_source2261);  
                            stream_NOT.add(NOT246);


                            INDEXED247=(Token)match(input,INDEXED,FOLLOW_INDEXED_in_single_source2263);  
                            stream_INDEXED.add(INDEXED247);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: NOT, table_name, database_name, INDEXED, index_name, table_alias
                    // token labels: table_name, table_alias
                    // rule labels: database_name, index_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_table_name=new RewriteRuleTokenStream(adaptor,"token table_name",table_name);
                    RewriteRuleTokenStream stream_table_alias=new RewriteRuleTokenStream(adaptor,"token table_alias",table_alias);
                    RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
                    RewriteRuleSubtreeStream stream_index_name=new RewriteRuleSubtreeStream(adaptor,"rule index_name",index_name!=null?index_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 346:3: -> ^( ALIAS ^( $table_name ( $database_name)? ) ( $table_alias)? ( ^( INDEXED ( NOT )? ( $index_name)? ) )? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:6: ^( ALIAS ^( $table_name ( $database_name)? ) ( $table_alias)? ( ^( INDEXED ( NOT )? ( $index_name)? ) )? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(ALIAS, "ALIAS")
                        , root_1);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:14: ^( $table_name ( $database_name)? )
                        {
                        Object root_2 = (Object)adaptor.nil();
                        root_2 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_2);

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:29: ( $database_name)?
                        if ( stream_database_name.hasNext() ) {
                            adaptor.addChild(root_2, stream_database_name.nextTree());

                        }
                        stream_database_name.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:46: ( $table_alias)?
                        if ( stream_table_alias.hasNext() ) {
                            adaptor.addChild(root_1, stream_table_alias.nextNode());

                        }
                        stream_table_alias.reset();

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:59: ( ^( INDEXED ( NOT )? ( $index_name)? ) )?
                        if ( stream_NOT.hasNext()||stream_INDEXED.hasNext()||stream_index_name.hasNext() ) {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:59: ^( INDEXED ( NOT )? ( $index_name)? )
                            {
                            Object root_2 = (Object)adaptor.nil();
                            root_2 = (Object)adaptor.becomeRoot(
                            stream_INDEXED.nextNode()
                            , root_2);

                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:69: ( NOT )?
                            if ( stream_NOT.hasNext() ) {
                                adaptor.addChild(root_2, 
                                stream_NOT.nextNode()
                                );

                            }
                            stream_NOT.reset();

                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:346:75: ( $index_name)?
                            if ( stream_index_name.hasNext() ) {
                                adaptor.addChild(root_2, stream_index_name.nextTree());

                            }
                            stream_index_name.reset();

                            adaptor.addChild(root_1, root_2);
                            }

                        }
                        stream_NOT.reset();
                        stream_INDEXED.reset();
                        stream_index_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:347:5: LPAREN select_stmt RPAREN ( ( AS )? table_alias= ID )?
                    {
                    LPAREN248=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_single_source2304);  
                    stream_LPAREN.add(LPAREN248);


                    pushFollow(FOLLOW_select_stmt_in_single_source2306);
                    select_stmt249=select_stmt();

                    state._fsp--;

                    stream_select_stmt.add(select_stmt249.getTree());

                    RPAREN250=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_single_source2308);  
                    stream_RPAREN.add(RPAREN250);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:347:31: ( ( AS )? table_alias= ID )?
                    int alt88=2;
                    int LA88_0 = input.LA(1);

                    if ( (LA88_0==AS||LA88_0==ID) ) {
                        alt88=1;
                    }
                    switch (alt88) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:347:32: ( AS )? table_alias= ID
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:347:32: ( AS )?
                            int alt87=2;
                            int LA87_0 = input.LA(1);

                            if ( (LA87_0==AS) ) {
                                alt87=1;
                            }
                            switch (alt87) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:347:33: AS
                                    {
                                    AS251=(Token)match(input,AS,FOLLOW_AS_in_single_source2312);  
                                    stream_AS.add(AS251);


                                    }
                                    break;

                            }


                            table_alias=(Token)match(input,ID,FOLLOW_ID_in_single_source2318);  
                            stream_ID.add(table_alias);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: table_alias, select_stmt
                    // token labels: table_alias
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_table_alias=new RewriteRuleTokenStream(adaptor,"token table_alias",table_alias);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 348:3: -> ^( ALIAS select_stmt ( $table_alias)? )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:348:6: ^( ALIAS select_stmt ( $table_alias)? )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(ALIAS, "ALIAS")
                        , root_1);

                        adaptor.addChild(root_1, stream_select_stmt.nextTree());

                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:348:27: ( $table_alias)?
                        if ( stream_table_alias.hasNext() ) {
                            adaptor.addChild(root_1, stream_table_alias.nextNode());

                        }
                        stream_table_alias.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:349:5: LPAREN ! join_source RPAREN !
                    {
                    root_0 = (Object)adaptor.nil();


                    LPAREN252=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_single_source2340); 

                    pushFollow(FOLLOW_join_source_in_single_source2343);
                    join_source253=join_source();

                    state._fsp--;

                    adaptor.addChild(root_0, join_source253.getTree());

                    RPAREN254=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_single_source2345); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "single_source"


    public static class join_op_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "join_op"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:351:1: join_op : ( COMMA | ( NATURAL )? ( ( LEFT )? ( OUTER )? | INNER | CROSS ) JOIN ^);
    public final SqlParser.join_op_return join_op() throws RecognitionException {
        SqlParser.join_op_return retval = new SqlParser.join_op_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COMMA255=null;
        Token NATURAL256=null;
        Token LEFT257=null;
        Token OUTER258=null;
        Token INNER259=null;
        Token CROSS260=null;
        Token JOIN261=null;

        Object COMMA255_tree=null;
        Object NATURAL256_tree=null;
        Object LEFT257_tree=null;
        Object OUTER258_tree=null;
        Object INNER259_tree=null;
        Object CROSS260_tree=null;
        Object JOIN261_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:352:3: ( COMMA | ( NATURAL )? ( ( LEFT )? ( OUTER )? | INNER | CROSS ) JOIN ^)
            int alt94=2;
            int LA94_0 = input.LA(1);

            if ( (LA94_0==COMMA) ) {
                alt94=1;
            }
            else if ( (LA94_0==CROSS||LA94_0==INNER||LA94_0==JOIN||LA94_0==LEFT||LA94_0==NATURAL||LA94_0==OUTER) ) {
                alt94=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;

            }
            switch (alt94) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:352:5: COMMA
                    {
                    root_0 = (Object)adaptor.nil();


                    COMMA255=(Token)match(input,COMMA,FOLLOW_COMMA_in_join_op2356); 
                    COMMA255_tree = 
                    (Object)adaptor.create(COMMA255)
                    ;
                    adaptor.addChild(root_0, COMMA255_tree);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:5: ( NATURAL )? ( ( LEFT )? ( OUTER )? | INNER | CROSS ) JOIN ^
                    {
                    root_0 = (Object)adaptor.nil();


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:5: ( NATURAL )?
                    int alt90=2;
                    int LA90_0 = input.LA(1);

                    if ( (LA90_0==NATURAL) ) {
                        alt90=1;
                    }
                    switch (alt90) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:6: NATURAL
                            {
                            NATURAL256=(Token)match(input,NATURAL,FOLLOW_NATURAL_in_join_op2363); 
                            NATURAL256_tree = 
                            (Object)adaptor.create(NATURAL256)
                            ;
                            adaptor.addChild(root_0, NATURAL256_tree);


                            }
                            break;

                    }


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:16: ( ( LEFT )? ( OUTER )? | INNER | CROSS )
                    int alt93=3;
                    switch ( input.LA(1) ) {
                    case JOIN:
                    case LEFT:
                    case OUTER:
                        {
                        alt93=1;
                        }
                        break;
                    case INNER:
                        {
                        alt93=2;
                        }
                        break;
                    case CROSS:
                        {
                        alt93=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 93, 0, input);

                        throw nvae;

                    }

                    switch (alt93) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:17: ( LEFT )? ( OUTER )?
                            {
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:17: ( LEFT )?
                            int alt91=2;
                            int LA91_0 = input.LA(1);

                            if ( (LA91_0==LEFT) ) {
                                alt91=1;
                            }
                            switch (alt91) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:18: LEFT
                                    {
                                    LEFT257=(Token)match(input,LEFT,FOLLOW_LEFT_in_join_op2369); 
                                    LEFT257_tree = 
                                    (Object)adaptor.create(LEFT257)
                                    ;
                                    adaptor.addChild(root_0, LEFT257_tree);


                                    }
                                    break;

                            }


                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:25: ( OUTER )?
                            int alt92=2;
                            int LA92_0 = input.LA(1);

                            if ( (LA92_0==OUTER) ) {
                                alt92=1;
                            }
                            switch (alt92) {
                                case 1 :
                                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:26: OUTER
                                    {
                                    OUTER258=(Token)match(input,OUTER,FOLLOW_OUTER_in_join_op2374); 
                                    OUTER258_tree = 
                                    (Object)adaptor.create(OUTER258)
                                    ;
                                    adaptor.addChild(root_0, OUTER258_tree);


                                    }
                                    break;

                            }


                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:36: INNER
                            {
                            INNER259=(Token)match(input,INNER,FOLLOW_INNER_in_join_op2380); 
                            INNER259_tree = 
                            (Object)adaptor.create(INNER259)
                            ;
                            adaptor.addChild(root_0, INNER259_tree);


                            }
                            break;
                        case 3 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:353:44: CROSS
                            {
                            CROSS260=(Token)match(input,CROSS,FOLLOW_CROSS_in_join_op2384); 
                            CROSS260_tree = 
                            (Object)adaptor.create(CROSS260)
                            ;
                            adaptor.addChild(root_0, CROSS260_tree);


                            }
                            break;

                    }


                    JOIN261=(Token)match(input,JOIN,FOLLOW_JOIN_in_join_op2387); 
                    JOIN261_tree = 
                    (Object)adaptor.create(JOIN261)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(JOIN261_tree, root_0);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "join_op"


    public static class join_constraint_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "join_constraint"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:355:1: join_constraint : ( ON ^ expr | USING LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN -> ^( USING ( $column_names)+ ) );
    public final SqlParser.join_constraint_return join_constraint() throws RecognitionException {
        SqlParser.join_constraint_return retval = new SqlParser.join_constraint_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ON262=null;
        Token USING264=null;
        Token LPAREN265=null;
        Token COMMA266=null;
        Token RPAREN267=null;
        List list_column_names=null;
        SqlParser.expr_return expr263 =null;

        RuleReturnScope column_names = null;
        Object ON262_tree=null;
        Object USING264_tree=null;
        Object LPAREN265_tree=null;
        Object COMMA266_tree=null;
        Object RPAREN267_tree=null;
        RewriteRuleTokenStream stream_USING=new RewriteRuleTokenStream(adaptor,"token USING");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:356:3: ( ON ^ expr | USING LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN -> ^( USING ( $column_names)+ ) )
            int alt96=2;
            int LA96_0 = input.LA(1);

            if ( (LA96_0==ON) ) {
                alt96=1;
            }
            else if ( (LA96_0==USING) ) {
                alt96=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;

            }
            switch (alt96) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:356:5: ON ^ expr
                    {
                    root_0 = (Object)adaptor.nil();


                    ON262=(Token)match(input,ON,FOLLOW_ON_in_join_constraint2398); 
                    ON262_tree = 
                    (Object)adaptor.create(ON262)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(ON262_tree, root_0);


                    pushFollow(FOLLOW_expr_in_join_constraint2401);
                    expr263=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr263.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:357:5: USING LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN
                    {
                    USING264=(Token)match(input,USING,FOLLOW_USING_in_join_constraint2407);  
                    stream_USING.add(USING264);


                    LPAREN265=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_join_constraint2409);  
                    stream_LPAREN.add(LPAREN265);


                    pushFollow(FOLLOW_id_in_join_constraint2413);
                    column_names=id();

                    state._fsp--;

                    stream_id.add(column_names.getTree());
                    if (list_column_names==null) list_column_names=new ArrayList();
                    list_column_names.add(column_names.getTree());


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:357:35: ( COMMA column_names+= id )*
                    loop95:
                    do {
                        int alt95=2;
                        int LA95_0 = input.LA(1);

                        if ( (LA95_0==COMMA) ) {
                            alt95=1;
                        }


                        switch (alt95) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:357:36: COMMA column_names+= id
                    	    {
                    	    COMMA266=(Token)match(input,COMMA,FOLLOW_COMMA_in_join_constraint2416);  
                    	    stream_COMMA.add(COMMA266);


                    	    pushFollow(FOLLOW_id_in_join_constraint2420);
                    	    column_names=id();

                    	    state._fsp--;

                    	    stream_id.add(column_names.getTree());
                    	    if (list_column_names==null) list_column_names=new ArrayList();
                    	    list_column_names.add(column_names.getTree());


                    	    }
                    	    break;

                    	default :
                    	    break loop95;
                        }
                    } while (true);


                    RPAREN267=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_join_constraint2424);  
                    stream_RPAREN.add(RPAREN267);


                    // AST REWRITE
                    // elements: USING, column_names
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: column_names
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_column_names=new RewriteRuleSubtreeStream(adaptor,"token column_names",list_column_names);
                    root_0 = (Object)adaptor.nil();
                    // 357:68: -> ^( USING ( $column_names)+ )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:357:71: ^( USING ( $column_names)+ )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        stream_USING.nextNode()
                        , root_1);

                        if ( !(stream_column_names.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_column_names.hasNext() ) {
                            adaptor.addChild(root_1, stream_column_names.nextTree());

                        }
                        stream_column_names.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "join_constraint"


    public static class insert_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insert_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:1: insert_stmt : ( INSERT ( operation_conflict_clause )? | REPLACE ) INTO (database_name= id DOT )? table_name= id ( ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt ) | DEFAULT VALUES ) ;
    public final SqlParser.insert_stmt_return insert_stmt() throws RecognitionException {
        SqlParser.insert_stmt_return retval = new SqlParser.insert_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INSERT268=null;
        Token REPLACE270=null;
        Token INTO271=null;
        Token DOT272=null;
        Token LPAREN273=null;
        Token COMMA274=null;
        Token RPAREN275=null;
        Token VALUES276=null;
        Token LPAREN277=null;
        Token COMMA278=null;
        Token RPAREN279=null;
        Token DEFAULT281=null;
        Token VALUES282=null;
        List list_column_names=null;
        List list_values=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.operation_conflict_clause_return operation_conflict_clause269 =null;

        SqlParser.select_stmt_return select_stmt280 =null;

        RuleReturnScope column_names = null;
        RuleReturnScope values = null;
        Object INSERT268_tree=null;
        Object REPLACE270_tree=null;
        Object INTO271_tree=null;
        Object DOT272_tree=null;
        Object LPAREN273_tree=null;
        Object COMMA274_tree=null;
        Object RPAREN275_tree=null;
        Object VALUES276_tree=null;
        Object LPAREN277_tree=null;
        Object COMMA278_tree=null;
        Object RPAREN279_tree=null;
        Object DEFAULT281_tree=null;
        Object VALUES282_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:12: ( ( INSERT ( operation_conflict_clause )? | REPLACE ) INTO (database_name= id DOT )? table_name= id ( ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt ) | DEFAULT VALUES ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:14: ( INSERT ( operation_conflict_clause )? | REPLACE ) INTO (database_name= id DOT )? table_name= id ( ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt ) | DEFAULT VALUES )
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:14: ( INSERT ( operation_conflict_clause )? | REPLACE )
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( (LA98_0==INSERT) ) {
                alt98=1;
            }
            else if ( (LA98_0==REPLACE) ) {
                alt98=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 98, 0, input);

                throw nvae;

            }
            switch (alt98) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:15: INSERT ( operation_conflict_clause )?
                    {
                    INSERT268=(Token)match(input,INSERT,FOLLOW_INSERT_in_insert_stmt2443); 
                    INSERT268_tree = 
                    (Object)adaptor.create(INSERT268)
                    ;
                    adaptor.addChild(root_0, INSERT268_tree);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:22: ( operation_conflict_clause )?
                    int alt97=2;
                    int LA97_0 = input.LA(1);

                    if ( (LA97_0==OR) ) {
                        alt97=1;
                    }
                    switch (alt97) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:23: operation_conflict_clause
                            {
                            pushFollow(FOLLOW_operation_conflict_clause_in_insert_stmt2446);
                            operation_conflict_clause269=operation_conflict_clause();

                            state._fsp--;

                            adaptor.addChild(root_0, operation_conflict_clause269.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:53: REPLACE
                    {
                    REPLACE270=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_insert_stmt2452); 
                    REPLACE270_tree = 
                    (Object)adaptor.create(REPLACE270)
                    ;
                    adaptor.addChild(root_0, REPLACE270_tree);


                    }
                    break;

            }


            INTO271=(Token)match(input,INTO,FOLLOW_INTO_in_insert_stmt2455); 
            INTO271_tree = 
            (Object)adaptor.create(INTO271)
            ;
            adaptor.addChild(root_0, INTO271_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:67: (database_name= id DOT )?
            int alt99=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA99_1 = input.LA(2);

                    if ( (LA99_1==DOT) ) {
                        alt99=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA99_2 = input.LA(2);

                    if ( (LA99_2==DOT) ) {
                        alt99=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA99_3 = input.LA(2);

                    if ( (LA99_3==DOT) ) {
                        alt99=1;
                    }
                    }
                    break;
            }

            switch (alt99) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:360:68: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_insert_stmt2460);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT272=(Token)match(input,DOT,FOLLOW_DOT_in_insert_stmt2462); 
                    DOT272_tree = 
                    (Object)adaptor.create(DOT272)
                    ;
                    adaptor.addChild(root_0, DOT272_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_insert_stmt2468);
            table_name=id();

            state._fsp--;

            adaptor.addChild(root_0, table_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:3: ( ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt ) | DEFAULT VALUES )
            int alt104=2;
            int LA104_0 = input.LA(1);

            if ( (LA104_0==LPAREN||LA104_0==SELECT||LA104_0==VALUES) ) {
                alt104=1;
            }
            else if ( (LA104_0==DEFAULT) ) {
                alt104=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;

            }
            switch (alt104) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:5: ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt )
                    {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:5: ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )?
                    int alt101=2;
                    int LA101_0 = input.LA(1);

                    if ( (LA101_0==LPAREN) ) {
                        alt101=1;
                    }
                    switch (alt101) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:6: LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN
                            {
                            LPAREN273=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_insert_stmt2475); 
                            LPAREN273_tree = 
                            (Object)adaptor.create(LPAREN273)
                            ;
                            adaptor.addChild(root_0, LPAREN273_tree);


                            pushFollow(FOLLOW_id_in_insert_stmt2479);
                            column_names=id();

                            state._fsp--;

                            adaptor.addChild(root_0, column_names.getTree());
                            if (list_column_names==null) list_column_names=new ArrayList();
                            list_column_names.add(column_names.getTree());


                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:30: ( COMMA column_names+= id )*
                            loop100:
                            do {
                                int alt100=2;
                                int LA100_0 = input.LA(1);

                                if ( (LA100_0==COMMA) ) {
                                    alt100=1;
                                }


                                switch (alt100) {
                            	case 1 :
                            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:361:31: COMMA column_names+= id
                            	    {
                            	    COMMA274=(Token)match(input,COMMA,FOLLOW_COMMA_in_insert_stmt2482); 
                            	    COMMA274_tree = 
                            	    (Object)adaptor.create(COMMA274)
                            	    ;
                            	    adaptor.addChild(root_0, COMMA274_tree);


                            	    pushFollow(FOLLOW_id_in_insert_stmt2486);
                            	    column_names=id();

                            	    state._fsp--;

                            	    adaptor.addChild(root_0, column_names.getTree());
                            	    if (list_column_names==null) list_column_names=new ArrayList();
                            	    list_column_names.add(column_names.getTree());


                            	    }
                            	    break;

                            	default :
                            	    break loop100;
                                }
                            } while (true);


                            RPAREN275=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_insert_stmt2490); 
                            RPAREN275_tree = 
                            (Object)adaptor.create(RPAREN275)
                            ;
                            adaptor.addChild(root_0, RPAREN275_tree);


                            }
                            break;

                    }


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:362:5: ( VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN | select_stmt )
                    int alt103=2;
                    int LA103_0 = input.LA(1);

                    if ( (LA103_0==VALUES) ) {
                        alt103=1;
                    }
                    else if ( (LA103_0==SELECT) ) {
                        alt103=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 103, 0, input);

                        throw nvae;

                    }
                    switch (alt103) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:362:6: VALUES LPAREN values+= expr ( COMMA values+= expr )* RPAREN
                            {
                            VALUES276=(Token)match(input,VALUES,FOLLOW_VALUES_in_insert_stmt2499); 
                            VALUES276_tree = 
                            (Object)adaptor.create(VALUES276)
                            ;
                            adaptor.addChild(root_0, VALUES276_tree);


                            LPAREN277=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_insert_stmt2501); 
                            LPAREN277_tree = 
                            (Object)adaptor.create(LPAREN277)
                            ;
                            adaptor.addChild(root_0, LPAREN277_tree);


                            pushFollow(FOLLOW_expr_in_insert_stmt2505);
                            values=expr();

                            state._fsp--;

                            adaptor.addChild(root_0, values.getTree());
                            if (list_values==null) list_values=new ArrayList();
                            list_values.add(values.getTree());


                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:362:33: ( COMMA values+= expr )*
                            loop102:
                            do {
                                int alt102=2;
                                int LA102_0 = input.LA(1);

                                if ( (LA102_0==COMMA) ) {
                                    alt102=1;
                                }


                                switch (alt102) {
                            	case 1 :
                            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:362:34: COMMA values+= expr
                            	    {
                            	    COMMA278=(Token)match(input,COMMA,FOLLOW_COMMA_in_insert_stmt2508); 
                            	    COMMA278_tree = 
                            	    (Object)adaptor.create(COMMA278)
                            	    ;
                            	    adaptor.addChild(root_0, COMMA278_tree);


                            	    pushFollow(FOLLOW_expr_in_insert_stmt2512);
                            	    values=expr();

                            	    state._fsp--;

                            	    adaptor.addChild(root_0, values.getTree());
                            	    if (list_values==null) list_values=new ArrayList();
                            	    list_values.add(values.getTree());


                            	    }
                            	    break;

                            	default :
                            	    break loop102;
                                }
                            } while (true);


                            RPAREN279=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_insert_stmt2516); 
                            RPAREN279_tree = 
                            (Object)adaptor.create(RPAREN279)
                            ;
                            adaptor.addChild(root_0, RPAREN279_tree);


                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:362:64: select_stmt
                            {
                            pushFollow(FOLLOW_select_stmt_in_insert_stmt2520);
                            select_stmt280=select_stmt();

                            state._fsp--;

                            adaptor.addChild(root_0, select_stmt280.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:363:5: DEFAULT VALUES
                    {
                    DEFAULT281=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_insert_stmt2527); 
                    DEFAULT281_tree = 
                    (Object)adaptor.create(DEFAULT281)
                    ;
                    adaptor.addChild(root_0, DEFAULT281_tree);


                    VALUES282=(Token)match(input,VALUES,FOLLOW_VALUES_in_insert_stmt2529); 
                    VALUES282_tree = 
                    (Object)adaptor.create(VALUES282)
                    ;
                    adaptor.addChild(root_0, VALUES282_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insert_stmt"


    public static class update_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "update_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:366:1: update_stmt : UPDATE ( operation_conflict_clause )? qualified_table_name SET values+= update_set ( COMMA values+= update_set )* ( WHERE expr )? ( operation_limited_clause )? ;
    public final SqlParser.update_stmt_return update_stmt() throws RecognitionException {
        SqlParser.update_stmt_return retval = new SqlParser.update_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token UPDATE283=null;
        Token SET286=null;
        Token COMMA287=null;
        Token WHERE288=null;
        List list_values=null;
        SqlParser.operation_conflict_clause_return operation_conflict_clause284 =null;

        SqlParser.qualified_table_name_return qualified_table_name285 =null;

        SqlParser.expr_return expr289 =null;

        SqlParser.operation_limited_clause_return operation_limited_clause290 =null;

        RuleReturnScope values = null;
        Object UPDATE283_tree=null;
        Object SET286_tree=null;
        Object COMMA287_tree=null;
        Object WHERE288_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:366:12: ( UPDATE ( operation_conflict_clause )? qualified_table_name SET values+= update_set ( COMMA values+= update_set )* ( WHERE expr )? ( operation_limited_clause )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:366:14: UPDATE ( operation_conflict_clause )? qualified_table_name SET values+= update_set ( COMMA values+= update_set )* ( WHERE expr )? ( operation_limited_clause )?
            {
            root_0 = (Object)adaptor.nil();


            UPDATE283=(Token)match(input,UPDATE,FOLLOW_UPDATE_in_update_stmt2539); 
            UPDATE283_tree = 
            (Object)adaptor.create(UPDATE283)
            ;
            adaptor.addChild(root_0, UPDATE283_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:366:21: ( operation_conflict_clause )?
            int alt105=2;
            int LA105_0 = input.LA(1);

            if ( (LA105_0==OR) ) {
                int LA105_1 = input.LA(2);

                if ( (LA105_1==ABORT||LA105_1==FAIL||LA105_1==IGNORE||LA105_1==REPLACE||LA105_1==ROLLBACK) ) {
                    alt105=1;
                }
            }
            switch (alt105) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:366:22: operation_conflict_clause
                    {
                    pushFollow(FOLLOW_operation_conflict_clause_in_update_stmt2542);
                    operation_conflict_clause284=operation_conflict_clause();

                    state._fsp--;

                    adaptor.addChild(root_0, operation_conflict_clause284.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_qualified_table_name_in_update_stmt2546);
            qualified_table_name285=qualified_table_name();

            state._fsp--;

            adaptor.addChild(root_0, qualified_table_name285.getTree());

            SET286=(Token)match(input,SET,FOLLOW_SET_in_update_stmt2550); 
            SET286_tree = 
            (Object)adaptor.create(SET286)
            ;
            adaptor.addChild(root_0, SET286_tree);


            pushFollow(FOLLOW_update_set_in_update_stmt2554);
            values=update_set();

            state._fsp--;

            adaptor.addChild(root_0, values.getTree());
            if (list_values==null) list_values=new ArrayList();
            list_values.add(values.getTree());


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:26: ( COMMA values+= update_set )*
            loop106:
            do {
                int alt106=2;
                int LA106_0 = input.LA(1);

                if ( (LA106_0==COMMA) ) {
                    alt106=1;
                }


                switch (alt106) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:27: COMMA values+= update_set
            	    {
            	    COMMA287=(Token)match(input,COMMA,FOLLOW_COMMA_in_update_stmt2557); 
            	    COMMA287_tree = 
            	    (Object)adaptor.create(COMMA287)
            	    ;
            	    adaptor.addChild(root_0, COMMA287_tree);


            	    pushFollow(FOLLOW_update_set_in_update_stmt2561);
            	    values=update_set();

            	    state._fsp--;

            	    adaptor.addChild(root_0, values.getTree());
            	    if (list_values==null) list_values=new ArrayList();
            	    list_values.add(values.getTree());


            	    }
            	    break;

            	default :
            	    break loop106;
                }
            } while (true);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:54: ( WHERE expr )?
            int alt107=2;
            int LA107_0 = input.LA(1);

            if ( (LA107_0==WHERE) ) {
                alt107=1;
            }
            switch (alt107) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:55: WHERE expr
                    {
                    WHERE288=(Token)match(input,WHERE,FOLLOW_WHERE_in_update_stmt2566); 
                    WHERE288_tree = 
                    (Object)adaptor.create(WHERE288)
                    ;
                    adaptor.addChild(root_0, WHERE288_tree);


                    pushFollow(FOLLOW_expr_in_update_stmt2568);
                    expr289=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr289.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:68: ( operation_limited_clause )?
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==LIMIT||LA108_0==ORDER) ) {
                alt108=1;
            }
            switch (alt108) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:367:69: operation_limited_clause
                    {
                    pushFollow(FOLLOW_operation_limited_clause_in_update_stmt2573);
                    operation_limited_clause290=operation_limited_clause();

                    state._fsp--;

                    adaptor.addChild(root_0, operation_limited_clause290.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "update_stmt"


    public static class update_set_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "update_set"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:369:1: update_set : column_name= id EQUALS expr ;
    public final SqlParser.update_set_return update_set() throws RecognitionException {
        SqlParser.update_set_return retval = new SqlParser.update_set_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EQUALS291=null;
        SqlParser.id_return column_name =null;

        SqlParser.expr_return expr292 =null;


        Object EQUALS291_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:369:11: (column_name= id EQUALS expr )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:369:13: column_name= id EQUALS expr
            {
            root_0 = (Object)adaptor.nil();


            pushFollow(FOLLOW_id_in_update_set2584);
            column_name=id();

            state._fsp--;

            adaptor.addChild(root_0, column_name.getTree());

            EQUALS291=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_update_set2586); 
            EQUALS291_tree = 
            (Object)adaptor.create(EQUALS291)
            ;
            adaptor.addChild(root_0, EQUALS291_tree);


            pushFollow(FOLLOW_expr_in_update_set2588);
            expr292=expr();

            state._fsp--;

            adaptor.addChild(root_0, expr292.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "update_set"


    public static class delete_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "delete_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:1: delete_stmt : DELETE FROM qualified_table_name ( WHERE expr )? ( operation_limited_clause )? ;
    public final SqlParser.delete_stmt_return delete_stmt() throws RecognitionException {
        SqlParser.delete_stmt_return retval = new SqlParser.delete_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DELETE293=null;
        Token FROM294=null;
        Token WHERE296=null;
        SqlParser.qualified_table_name_return qualified_table_name295 =null;

        SqlParser.expr_return expr297 =null;

        SqlParser.operation_limited_clause_return operation_limited_clause298 =null;


        Object DELETE293_tree=null;
        Object FROM294_tree=null;
        Object WHERE296_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:12: ( DELETE FROM qualified_table_name ( WHERE expr )? ( operation_limited_clause )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:14: DELETE FROM qualified_table_name ( WHERE expr )? ( operation_limited_clause )?
            {
            root_0 = (Object)adaptor.nil();


            DELETE293=(Token)match(input,DELETE,FOLLOW_DELETE_in_delete_stmt2596); 
            DELETE293_tree = 
            (Object)adaptor.create(DELETE293)
            ;
            adaptor.addChild(root_0, DELETE293_tree);


            FROM294=(Token)match(input,FROM,FOLLOW_FROM_in_delete_stmt2598); 
            FROM294_tree = 
            (Object)adaptor.create(FROM294)
            ;
            adaptor.addChild(root_0, FROM294_tree);


            pushFollow(FOLLOW_qualified_table_name_in_delete_stmt2600);
            qualified_table_name295=qualified_table_name();

            state._fsp--;

            adaptor.addChild(root_0, qualified_table_name295.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:47: ( WHERE expr )?
            int alt109=2;
            int LA109_0 = input.LA(1);

            if ( (LA109_0==WHERE) ) {
                alt109=1;
            }
            switch (alt109) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:48: WHERE expr
                    {
                    WHERE296=(Token)match(input,WHERE,FOLLOW_WHERE_in_delete_stmt2603); 
                    WHERE296_tree = 
                    (Object)adaptor.create(WHERE296)
                    ;
                    adaptor.addChild(root_0, WHERE296_tree);


                    pushFollow(FOLLOW_expr_in_delete_stmt2605);
                    expr297=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr297.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:61: ( operation_limited_clause )?
            int alt110=2;
            int LA110_0 = input.LA(1);

            if ( (LA110_0==LIMIT||LA110_0==ORDER) ) {
                alt110=1;
            }
            switch (alt110) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:372:62: operation_limited_clause
                    {
                    pushFollow(FOLLOW_operation_limited_clause_in_delete_stmt2610);
                    operation_limited_clause298=operation_limited_clause();

                    state._fsp--;

                    adaptor.addChild(root_0, operation_limited_clause298.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "delete_stmt"


    public static class begin_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "begin_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:1: begin_stmt : BEGIN ( DEFERRED | IMMEDIATE | EXCLUSIVE )? ( TRANSACTION )? ;
    public final SqlParser.begin_stmt_return begin_stmt() throws RecognitionException {
        SqlParser.begin_stmt_return retval = new SqlParser.begin_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token BEGIN299=null;
        Token set300=null;
        Token TRANSACTION301=null;

        Object BEGIN299_tree=null;
        Object set300_tree=null;
        Object TRANSACTION301_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:11: ( BEGIN ( DEFERRED | IMMEDIATE | EXCLUSIVE )? ( TRANSACTION )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:13: BEGIN ( DEFERRED | IMMEDIATE | EXCLUSIVE )? ( TRANSACTION )?
            {
            root_0 = (Object)adaptor.nil();


            BEGIN299=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_begin_stmt2620); 
            BEGIN299_tree = 
            (Object)adaptor.create(BEGIN299)
            ;
            adaptor.addChild(root_0, BEGIN299_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:19: ( DEFERRED | IMMEDIATE | EXCLUSIVE )?
            int alt111=2;
            int LA111_0 = input.LA(1);

            if ( (LA111_0==DEFERRED||LA111_0==EXCLUSIVE||LA111_0==IMMEDIATE) ) {
                alt111=1;
            }
            switch (alt111) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
                    {
                    set300=(Token)input.LT(1);

                    if ( input.LA(1)==DEFERRED||input.LA(1)==EXCLUSIVE||input.LA(1)==IMMEDIATE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set300)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:55: ( TRANSACTION )?
            int alt112=2;
            int LA112_0 = input.LA(1);

            if ( (LA112_0==TRANSACTION) ) {
                alt112=1;
            }
            switch (alt112) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:375:56: TRANSACTION
                    {
                    TRANSACTION301=(Token)match(input,TRANSACTION,FOLLOW_TRANSACTION_in_begin_stmt2636); 
                    TRANSACTION301_tree = 
                    (Object)adaptor.create(TRANSACTION301)
                    ;
                    adaptor.addChild(root_0, TRANSACTION301_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "begin_stmt"


    public static class commit_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commit_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:378:1: commit_stmt : ( COMMIT | END ) ( TRANSACTION )? ;
    public final SqlParser.commit_stmt_return commit_stmt() throws RecognitionException {
        SqlParser.commit_stmt_return retval = new SqlParser.commit_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set302=null;
        Token TRANSACTION303=null;

        Object set302_tree=null;
        Object TRANSACTION303_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:378:12: ( ( COMMIT | END ) ( TRANSACTION )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:378:14: ( COMMIT | END ) ( TRANSACTION )?
            {
            root_0 = (Object)adaptor.nil();


            set302=(Token)input.LT(1);

            if ( input.LA(1)==COMMIT||input.LA(1)==END ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set302)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:378:29: ( TRANSACTION )?
            int alt113=2;
            int LA113_0 = input.LA(1);

            if ( (LA113_0==TRANSACTION) ) {
                alt113=1;
            }
            switch (alt113) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:378:30: TRANSACTION
                    {
                    TRANSACTION303=(Token)match(input,TRANSACTION,FOLLOW_TRANSACTION_in_commit_stmt2655); 
                    TRANSACTION303_tree = 
                    (Object)adaptor.create(TRANSACTION303)
                    ;
                    adaptor.addChild(root_0, TRANSACTION303_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commit_stmt"


    public static class rollback_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollback_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:1: rollback_stmt : ROLLBACK ( TRANSACTION )? ( TO ( SAVEPOINT )? savepoint_name= id )? ;
    public final SqlParser.rollback_stmt_return rollback_stmt() throws RecognitionException {
        SqlParser.rollback_stmt_return retval = new SqlParser.rollback_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ROLLBACK304=null;
        Token TRANSACTION305=null;
        Token TO306=null;
        Token SAVEPOINT307=null;
        SqlParser.id_return savepoint_name =null;


        Object ROLLBACK304_tree=null;
        Object TRANSACTION305_tree=null;
        Object TO306_tree=null;
        Object SAVEPOINT307_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:14: ( ROLLBACK ( TRANSACTION )? ( TO ( SAVEPOINT )? savepoint_name= id )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:16: ROLLBACK ( TRANSACTION )? ( TO ( SAVEPOINT )? savepoint_name= id )?
            {
            root_0 = (Object)adaptor.nil();


            ROLLBACK304=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollback_stmt2665); 
            ROLLBACK304_tree = 
            (Object)adaptor.create(ROLLBACK304)
            ;
            adaptor.addChild(root_0, ROLLBACK304_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:25: ( TRANSACTION )?
            int alt114=2;
            int LA114_0 = input.LA(1);

            if ( (LA114_0==TRANSACTION) ) {
                alt114=1;
            }
            switch (alt114) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:26: TRANSACTION
                    {
                    TRANSACTION305=(Token)match(input,TRANSACTION,FOLLOW_TRANSACTION_in_rollback_stmt2668); 
                    TRANSACTION305_tree = 
                    (Object)adaptor.create(TRANSACTION305)
                    ;
                    adaptor.addChild(root_0, TRANSACTION305_tree);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:40: ( TO ( SAVEPOINT )? savepoint_name= id )?
            int alt116=2;
            int LA116_0 = input.LA(1);

            if ( (LA116_0==TO) ) {
                alt116=1;
            }
            switch (alt116) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:41: TO ( SAVEPOINT )? savepoint_name= id
                    {
                    TO306=(Token)match(input,TO,FOLLOW_TO_in_rollback_stmt2673); 
                    TO306_tree = 
                    (Object)adaptor.create(TO306)
                    ;
                    adaptor.addChild(root_0, TO306_tree);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:44: ( SAVEPOINT )?
                    int alt115=2;
                    int LA115_0 = input.LA(1);

                    if ( (LA115_0==SAVEPOINT) ) {
                        int LA115_1 = input.LA(2);

                        if ( ((LA115_1 >= ABORT && LA115_1 <= AFTER)||(LA115_1 >= ALL && LA115_1 <= ALTER)||(LA115_1 >= ANALYZE && LA115_1 <= AND)||(LA115_1 >= AS && LA115_1 <= ASC)||(LA115_1 >= ATTACH && LA115_1 <= AUTOINCREMENT)||(LA115_1 >= BEFORE && LA115_1 <= BETWEEN)||LA115_1==BY||(LA115_1 >= CASCADE && LA115_1 <= COLLATE)||LA115_1==COLUMN||(LA115_1 >= COMMIT && LA115_1 <= CONSTRAINT)||LA115_1==CREATE||(LA115_1 >= CROSS && LA115_1 <= CURRENT_TIMESTAMP)||(LA115_1 >= DATABASE && LA115_1 <= DISTINCT)||LA115_1==DROP||(LA115_1 >= EACH && LA115_1 <= END)||(LA115_1 >= ESCAPE && LA115_1 <= EXPLAIN)||LA115_1==FAIL||(LA115_1 >= FOR && LA115_1 <= FROM)||LA115_1==GROUP||LA115_1==HAVING||LA115_1==ID||(LA115_1 >= IF && LA115_1 <= IMMEDIATE)||(LA115_1 >= INDEX && LA115_1 <= INSTEAD)||(LA115_1 >= INTERSECT && LA115_1 <= INTO)||LA115_1==IS||LA115_1==JOIN||LA115_1==KEY||LA115_1==LEFT||LA115_1==LIMIT||LA115_1==NATURAL||LA115_1==NULL||(LA115_1 >= OF && LA115_1 <= ON)||(LA115_1 >= OR && LA115_1 <= ORDER)||LA115_1==OUTER||LA115_1==PLAN||(LA115_1 >= PRAGMA && LA115_1 <= PRIMARY)||LA115_1==QUERY||(LA115_1 >= RAISE && LA115_1 <= REFERENCES)||(LA115_1 >= REINDEX && LA115_1 <= ROW)||(LA115_1 >= SAVEPOINT && LA115_1 <= SELECT)||LA115_1==SET||LA115_1==STRING||LA115_1==TABLE||(LA115_1 >= TEMPORARY && LA115_1 <= THEN)||(LA115_1 >= TO && LA115_1 <= TRIGGER)||(LA115_1 >= UNION && LA115_1 <= USING)||(LA115_1 >= VACUUM && LA115_1 <= VIRTUAL)||(LA115_1 >= WHEN && LA115_1 <= WHERE)) ) {
                            alt115=1;
                        }
                    }
                    switch (alt115) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:381:45: SAVEPOINT
                            {
                            SAVEPOINT307=(Token)match(input,SAVEPOINT,FOLLOW_SAVEPOINT_in_rollback_stmt2676); 
                            SAVEPOINT307_tree = 
                            (Object)adaptor.create(SAVEPOINT307)
                            ;
                            adaptor.addChild(root_0, SAVEPOINT307_tree);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_id_in_rollback_stmt2682);
                    savepoint_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, savepoint_name.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollback_stmt"


    public static class savepoint_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "savepoint_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:384:1: savepoint_stmt : SAVEPOINT savepoint_name= id ;
    public final SqlParser.savepoint_stmt_return savepoint_stmt() throws RecognitionException {
        SqlParser.savepoint_stmt_return retval = new SqlParser.savepoint_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SAVEPOINT308=null;
        SqlParser.id_return savepoint_name =null;


        Object SAVEPOINT308_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:384:15: ( SAVEPOINT savepoint_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:384:17: SAVEPOINT savepoint_name= id
            {
            root_0 = (Object)adaptor.nil();


            SAVEPOINT308=(Token)match(input,SAVEPOINT,FOLLOW_SAVEPOINT_in_savepoint_stmt2692); 
            SAVEPOINT308_tree = 
            (Object)adaptor.create(SAVEPOINT308)
            ;
            adaptor.addChild(root_0, SAVEPOINT308_tree);


            pushFollow(FOLLOW_id_in_savepoint_stmt2696);
            savepoint_name=id();

            state._fsp--;

            adaptor.addChild(root_0, savepoint_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "savepoint_stmt"


    public static class release_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "release_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:387:1: release_stmt : RELEASE ( SAVEPOINT )? savepoint_name= id ;
    public final SqlParser.release_stmt_return release_stmt() throws RecognitionException {
        SqlParser.release_stmt_return retval = new SqlParser.release_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token RELEASE309=null;
        Token SAVEPOINT310=null;
        SqlParser.id_return savepoint_name =null;


        Object RELEASE309_tree=null;
        Object SAVEPOINT310_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:387:13: ( RELEASE ( SAVEPOINT )? savepoint_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:387:15: RELEASE ( SAVEPOINT )? savepoint_name= id
            {
            root_0 = (Object)adaptor.nil();


            RELEASE309=(Token)match(input,RELEASE,FOLLOW_RELEASE_in_release_stmt2704); 
            RELEASE309_tree = 
            (Object)adaptor.create(RELEASE309)
            ;
            adaptor.addChild(root_0, RELEASE309_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:387:23: ( SAVEPOINT )?
            int alt117=2;
            int LA117_0 = input.LA(1);

            if ( (LA117_0==SAVEPOINT) ) {
                int LA117_1 = input.LA(2);

                if ( ((LA117_1 >= ABORT && LA117_1 <= AFTER)||(LA117_1 >= ALL && LA117_1 <= ALTER)||(LA117_1 >= ANALYZE && LA117_1 <= AND)||(LA117_1 >= AS && LA117_1 <= ASC)||(LA117_1 >= ATTACH && LA117_1 <= AUTOINCREMENT)||(LA117_1 >= BEFORE && LA117_1 <= BETWEEN)||LA117_1==BY||(LA117_1 >= CASCADE && LA117_1 <= COLLATE)||LA117_1==COLUMN||(LA117_1 >= COMMIT && LA117_1 <= CONSTRAINT)||LA117_1==CREATE||(LA117_1 >= CROSS && LA117_1 <= CURRENT_TIMESTAMP)||(LA117_1 >= DATABASE && LA117_1 <= DISTINCT)||LA117_1==DROP||(LA117_1 >= EACH && LA117_1 <= END)||(LA117_1 >= ESCAPE && LA117_1 <= EXPLAIN)||LA117_1==FAIL||(LA117_1 >= FOR && LA117_1 <= FROM)||LA117_1==GROUP||LA117_1==HAVING||LA117_1==ID||(LA117_1 >= IF && LA117_1 <= IMMEDIATE)||(LA117_1 >= INDEX && LA117_1 <= INSTEAD)||(LA117_1 >= INTERSECT && LA117_1 <= INTO)||LA117_1==IS||LA117_1==JOIN||LA117_1==KEY||LA117_1==LEFT||LA117_1==LIMIT||LA117_1==NATURAL||LA117_1==NULL||(LA117_1 >= OF && LA117_1 <= ON)||(LA117_1 >= OR && LA117_1 <= ORDER)||LA117_1==OUTER||LA117_1==PLAN||(LA117_1 >= PRAGMA && LA117_1 <= PRIMARY)||LA117_1==QUERY||(LA117_1 >= RAISE && LA117_1 <= REFERENCES)||(LA117_1 >= REINDEX && LA117_1 <= ROW)||(LA117_1 >= SAVEPOINT && LA117_1 <= SELECT)||LA117_1==SET||LA117_1==STRING||LA117_1==TABLE||(LA117_1 >= TEMPORARY && LA117_1 <= THEN)||(LA117_1 >= TO && LA117_1 <= TRIGGER)||(LA117_1 >= UNION && LA117_1 <= USING)||(LA117_1 >= VACUUM && LA117_1 <= VIRTUAL)||(LA117_1 >= WHEN && LA117_1 <= WHERE)) ) {
                    alt117=1;
                }
            }
            switch (alt117) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:387:24: SAVEPOINT
                    {
                    SAVEPOINT310=(Token)match(input,SAVEPOINT,FOLLOW_SAVEPOINT_in_release_stmt2707); 
                    SAVEPOINT310_tree = 
                    (Object)adaptor.create(SAVEPOINT310)
                    ;
                    adaptor.addChild(root_0, SAVEPOINT310_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_release_stmt2713);
            savepoint_name=id();

            state._fsp--;

            adaptor.addChild(root_0, savepoint_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "release_stmt"


    public static class table_conflict_clause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_conflict_clause"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:394:1: table_conflict_clause : ON ! CONFLICT ^ ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE ) ;
    public final SqlParser.table_conflict_clause_return table_conflict_clause() throws RecognitionException {
        SqlParser.table_conflict_clause_return retval = new SqlParser.table_conflict_clause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ON311=null;
        Token CONFLICT312=null;
        Token set313=null;

        Object ON311_tree=null;
        Object CONFLICT312_tree=null;
        Object set313_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:394:22: ( ON ! CONFLICT ^ ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:394:24: ON ! CONFLICT ^ ( ROLLBACK | ABORT | FAIL | IGNORE | REPLACE )
            {
            root_0 = (Object)adaptor.nil();


            ON311=(Token)match(input,ON,FOLLOW_ON_in_table_conflict_clause2725); 

            CONFLICT312=(Token)match(input,CONFLICT,FOLLOW_CONFLICT_in_table_conflict_clause2728); 
            CONFLICT312_tree = 
            (Object)adaptor.create(CONFLICT312)
            ;
            root_0 = (Object)adaptor.becomeRoot(CONFLICT312_tree, root_0);


            set313=(Token)input.LT(1);

            if ( input.LA(1)==ABORT||input.LA(1)==FAIL||input.LA(1)==IGNORE||input.LA(1)==REPLACE||input.LA(1)==ROLLBACK ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set313)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_conflict_clause"


    public static class create_virtual_table_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "create_virtual_table_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:398:1: create_virtual_table_stmt : CREATE VIRTUAL TABLE (database_name= id DOT )? table_name= id USING module_name= id ( LPAREN column_def ( COMMA column_def )* RPAREN )? -> ^( CREATE_TABLE ^( OPTIONS VIRTUAL ) ^( $table_name ( $database_name)? ) ^( $module_name) ( ^( COLUMNS ( column_def )+ ) )? ) ;
    public final SqlParser.create_virtual_table_stmt_return create_virtual_table_stmt() throws RecognitionException {
        SqlParser.create_virtual_table_stmt_return retval = new SqlParser.create_virtual_table_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CREATE314=null;
        Token VIRTUAL315=null;
        Token TABLE316=null;
        Token DOT317=null;
        Token USING318=null;
        Token LPAREN319=null;
        Token COMMA321=null;
        Token RPAREN323=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.id_return module_name =null;

        SqlParser.column_def_return column_def320 =null;

        SqlParser.column_def_return column_def322 =null;


        Object CREATE314_tree=null;
        Object VIRTUAL315_tree=null;
        Object TABLE316_tree=null;
        Object DOT317_tree=null;
        Object USING318_tree=null;
        Object LPAREN319_tree=null;
        Object COMMA321_tree=null;
        Object RPAREN323_tree=null;
        RewriteRuleTokenStream stream_TABLE=new RewriteRuleTokenStream(adaptor,"token TABLE");
        RewriteRuleTokenStream stream_USING=new RewriteRuleTokenStream(adaptor,"token USING");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_VIRTUAL=new RewriteRuleTokenStream(adaptor,"token VIRTUAL");
        RewriteRuleSubtreeStream stream_column_def=new RewriteRuleSubtreeStream(adaptor,"rule column_def");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:398:26: ( CREATE VIRTUAL TABLE (database_name= id DOT )? table_name= id USING module_name= id ( LPAREN column_def ( COMMA column_def )* RPAREN )? -> ^( CREATE_TABLE ^( OPTIONS VIRTUAL ) ^( $table_name ( $database_name)? ) ^( $module_name) ( ^( COLUMNS ( column_def )+ ) )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:398:28: CREATE VIRTUAL TABLE (database_name= id DOT )? table_name= id USING module_name= id ( LPAREN column_def ( COMMA column_def )* RPAREN )?
            {
            CREATE314=(Token)match(input,CREATE,FOLLOW_CREATE_in_create_virtual_table_stmt2758);  
            stream_CREATE.add(CREATE314);


            VIRTUAL315=(Token)match(input,VIRTUAL,FOLLOW_VIRTUAL_in_create_virtual_table_stmt2760);  
            stream_VIRTUAL.add(VIRTUAL315);


            TABLE316=(Token)match(input,TABLE,FOLLOW_TABLE_in_create_virtual_table_stmt2762);  
            stream_TABLE.add(TABLE316);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:398:49: (database_name= id DOT )?
            int alt118=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA118_1 = input.LA(2);

                    if ( (LA118_1==DOT) ) {
                        alt118=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA118_2 = input.LA(2);

                    if ( (LA118_2==DOT) ) {
                        alt118=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA118_3 = input.LA(2);

                    if ( (LA118_3==DOT) ) {
                        alt118=1;
                    }
                    }
                    break;
            }

            switch (alt118) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:398:50: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_create_virtual_table_stmt2767);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT317=(Token)match(input,DOT,FOLLOW_DOT_in_create_virtual_table_stmt2769);  
                    stream_DOT.add(DOT317);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_create_virtual_table_stmt2775);
            table_name=id();

            state._fsp--;

            stream_id.add(table_name.getTree());

            USING318=(Token)match(input,USING,FOLLOW_USING_in_create_virtual_table_stmt2779);  
            stream_USING.add(USING318);


            pushFollow(FOLLOW_id_in_create_virtual_table_stmt2783);
            module_name=id();

            state._fsp--;

            stream_id.add(module_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:399:24: ( LPAREN column_def ( COMMA column_def )* RPAREN )?
            int alt120=2;
            int LA120_0 = input.LA(1);

            if ( (LA120_0==LPAREN) ) {
                alt120=1;
            }
            switch (alt120) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:399:25: LPAREN column_def ( COMMA column_def )* RPAREN
                    {
                    LPAREN319=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_create_virtual_table_stmt2786);  
                    stream_LPAREN.add(LPAREN319);


                    pushFollow(FOLLOW_column_def_in_create_virtual_table_stmt2788);
                    column_def320=column_def();

                    state._fsp--;

                    stream_column_def.add(column_def320.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:399:43: ( COMMA column_def )*
                    loop119:
                    do {
                        int alt119=2;
                        int LA119_0 = input.LA(1);

                        if ( (LA119_0==COMMA) ) {
                            alt119=1;
                        }


                        switch (alt119) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:399:44: COMMA column_def
                    	    {
                    	    COMMA321=(Token)match(input,COMMA,FOLLOW_COMMA_in_create_virtual_table_stmt2791);  
                    	    stream_COMMA.add(COMMA321);


                    	    pushFollow(FOLLOW_column_def_in_create_virtual_table_stmt2793);
                    	    column_def322=column_def();

                    	    state._fsp--;

                    	    stream_column_def.add(column_def322.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop119;
                        }
                    } while (true);


                    RPAREN323=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_create_virtual_table_stmt2797);  
                    stream_RPAREN.add(RPAREN323);


                    }
                    break;

            }


            // AST REWRITE
            // elements: module_name, database_name, column_def, VIRTUAL, table_name
            // token labels: 
            // rule labels: database_name, module_name, table_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_module_name=new RewriteRuleSubtreeStream(adaptor,"rule module_name",module_name!=null?module_name.tree:null);
            RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 400:3: -> ^( CREATE_TABLE ^( OPTIONS VIRTUAL ) ^( $table_name ( $database_name)? ) ^( $module_name) ( ^( COLUMNS ( column_def )+ ) )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:6: ^( CREATE_TABLE ^( OPTIONS VIRTUAL ) ^( $table_name ( $database_name)? ) ^( $module_name) ( ^( COLUMNS ( column_def )+ ) )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CREATE_TABLE, "CREATE_TABLE")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:21: ^( OPTIONS VIRTUAL )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                adaptor.addChild(root_2, 
                stream_VIRTUAL.nextNode()
                );

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:40: ^( $table_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:55: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:71: ^( $module_name)
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_module_name.nextNode(), root_2);

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:87: ( ^( COLUMNS ( column_def )+ ) )?
                if ( stream_column_def.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:400:87: ^( COLUMNS ( column_def )+ )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    (Object)adaptor.create(COLUMNS, "COLUMNS")
                    , root_2);

                    if ( !(stream_column_def.hasNext()) ) {
                        throw new RewriteEarlyExitException();
                    }
                    while ( stream_column_def.hasNext() ) {
                        adaptor.addChild(root_2, stream_column_def.nextTree());

                    }
                    stream_column_def.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_column_def.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "create_virtual_table_stmt"


    public static class create_table_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "create_table_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:1: create_table_stmt : CREATE ( TEMPORARY )? TABLE ( IF NOT EXISTS )? (database_name= id DOT )? table_name= id ( LPAREN column_def ( COMMA column_def )* ( ( COMMA )? table_constraint )* RPAREN | AS select_stmt ) -> ^( CREATE_TABLE ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $table_name ( $database_name)? ) ( ^( COLUMNS ( column_def )+ ) )? ( ^( CONSTRAINTS ( table_constraint )* ) )? ( select_stmt )? ) ;
    public final SqlParser.create_table_stmt_return create_table_stmt() throws RecognitionException {
        SqlParser.create_table_stmt_return retval = new SqlParser.create_table_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CREATE324=null;
        Token TEMPORARY325=null;
        Token TABLE326=null;
        Token IF327=null;
        Token NOT328=null;
        Token EXISTS329=null;
        Token DOT330=null;
        Token LPAREN331=null;
        Token COMMA333=null;
        Token COMMA335=null;
        Token RPAREN337=null;
        Token AS338=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.column_def_return column_def332 =null;

        SqlParser.column_def_return column_def334 =null;

        SqlParser.table_constraint_return table_constraint336 =null;

        SqlParser.select_stmt_return select_stmt339 =null;


        Object CREATE324_tree=null;
        Object TEMPORARY325_tree=null;
        Object TABLE326_tree=null;
        Object IF327_tree=null;
        Object NOT328_tree=null;
        Object EXISTS329_tree=null;
        Object DOT330_tree=null;
        Object LPAREN331_tree=null;
        Object COMMA333_tree=null;
        Object COMMA335_tree=null;
        Object RPAREN337_tree=null;
        Object AS338_tree=null;
        RewriteRuleTokenStream stream_TABLE=new RewriteRuleTokenStream(adaptor,"token TABLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
        RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token TEMPORARY");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleSubtreeStream stream_column_def=new RewriteRuleSubtreeStream(adaptor,"rule column_def");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_table_constraint=new RewriteRuleSubtreeStream(adaptor,"rule table_constraint");
        RewriteRuleSubtreeStream stream_select_stmt=new RewriteRuleSubtreeStream(adaptor,"rule select_stmt");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:18: ( CREATE ( TEMPORARY )? TABLE ( IF NOT EXISTS )? (database_name= id DOT )? table_name= id ( LPAREN column_def ( COMMA column_def )* ( ( COMMA )? table_constraint )* RPAREN | AS select_stmt ) -> ^( CREATE_TABLE ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $table_name ( $database_name)? ) ( ^( COLUMNS ( column_def )+ ) )? ( ^( CONSTRAINTS ( table_constraint )* ) )? ( select_stmt )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:20: CREATE ( TEMPORARY )? TABLE ( IF NOT EXISTS )? (database_name= id DOT )? table_name= id ( LPAREN column_def ( COMMA column_def )* ( ( COMMA )? table_constraint )* RPAREN | AS select_stmt )
            {
            CREATE324=(Token)match(input,CREATE,FOLLOW_CREATE_in_create_table_stmt2843);  
            stream_CREATE.add(CREATE324);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:27: ( TEMPORARY )?
            int alt121=2;
            int LA121_0 = input.LA(1);

            if ( (LA121_0==TEMPORARY) ) {
                alt121=1;
            }
            switch (alt121) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:27: TEMPORARY
                    {
                    TEMPORARY325=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_table_stmt2845);  
                    stream_TEMPORARY.add(TEMPORARY325);


                    }
                    break;

            }


            TABLE326=(Token)match(input,TABLE,FOLLOW_TABLE_in_create_table_stmt2848);  
            stream_TABLE.add(TABLE326);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:44: ( IF NOT EXISTS )?
            int alt122=2;
            int LA122_0 = input.LA(1);

            if ( (LA122_0==IF) ) {
                int LA122_1 = input.LA(2);

                if ( (LA122_1==NOT) ) {
                    alt122=1;
                }
            }
            switch (alt122) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:45: IF NOT EXISTS
                    {
                    IF327=(Token)match(input,IF,FOLLOW_IF_in_create_table_stmt2851);  
                    stream_IF.add(IF327);


                    NOT328=(Token)match(input,NOT,FOLLOW_NOT_in_create_table_stmt2853);  
                    stream_NOT.add(NOT328);


                    EXISTS329=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_stmt2855);  
                    stream_EXISTS.add(EXISTS329);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:61: (database_name= id DOT )?
            int alt123=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA123_1 = input.LA(2);

                    if ( (LA123_1==DOT) ) {
                        alt123=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA123_2 = input.LA(2);

                    if ( (LA123_2==DOT) ) {
                        alt123=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA123_3 = input.LA(2);

                    if ( (LA123_3==DOT) ) {
                        alt123=1;
                    }
                    }
                    break;
            }

            switch (alt123) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:403:62: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_create_table_stmt2862);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT330=(Token)match(input,DOT,FOLLOW_DOT_in_create_table_stmt2864);  
                    stream_DOT.add(DOT330);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_create_table_stmt2870);
            table_name=id();

            state._fsp--;

            stream_id.add(table_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:3: ( LPAREN column_def ( COMMA column_def )* ( ( COMMA )? table_constraint )* RPAREN | AS select_stmt )
            int alt127=2;
            int LA127_0 = input.LA(1);

            if ( (LA127_0==LPAREN) ) {
                alt127=1;
            }
            else if ( (LA127_0==AS) ) {
                alt127=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 127, 0, input);

                throw nvae;

            }
            switch (alt127) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:5: LPAREN column_def ( COMMA column_def )* ( ( COMMA )? table_constraint )* RPAREN
                    {
                    LPAREN331=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_create_table_stmt2876);  
                    stream_LPAREN.add(LPAREN331);


                    pushFollow(FOLLOW_column_def_in_create_table_stmt2878);
                    column_def332=column_def();

                    state._fsp--;

                    stream_column_def.add(column_def332.getTree());

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:23: ( COMMA column_def )*
                    loop124:
                    do {
                        int alt124=2;
                        alt124 = dfa124.predict(input);
                        switch (alt124) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:24: COMMA column_def
                    	    {
                    	    COMMA333=(Token)match(input,COMMA,FOLLOW_COMMA_in_create_table_stmt2881);  
                    	    stream_COMMA.add(COMMA333);


                    	    pushFollow(FOLLOW_column_def_in_create_table_stmt2883);
                    	    column_def334=column_def();

                    	    state._fsp--;

                    	    stream_column_def.add(column_def334.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop124;
                        }
                    } while (true);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:43: ( ( COMMA )? table_constraint )*
                    loop126:
                    do {
                        int alt126=2;
                        int LA126_0 = input.LA(1);

                        if ( (LA126_0==CHECK||LA126_0==COMMA||LA126_0==CONSTRAINT||LA126_0==FOREIGN||LA126_0==PRIMARY||LA126_0==UNIQUE) ) {
                            alt126=1;
                        }


                        switch (alt126) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:44: ( COMMA )? table_constraint
                    	    {
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:44: ( COMMA )?
                    	    int alt125=2;
                    	    int LA125_0 = input.LA(1);

                    	    if ( (LA125_0==COMMA) ) {
                    	        alt125=1;
                    	    }
                    	    switch (alt125) {
                    	        case 1 :
                    	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:404:44: COMMA
                    	            {
                    	            COMMA335=(Token)match(input,COMMA,FOLLOW_COMMA_in_create_table_stmt2888);  
                    	            stream_COMMA.add(COMMA335);


                    	            }
                    	            break;

                    	    }


                    	    pushFollow(FOLLOW_table_constraint_in_create_table_stmt2891);
                    	    table_constraint336=table_constraint();

                    	    state._fsp--;

                    	    stream_table_constraint.add(table_constraint336.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop126;
                        }
                    } while (true);


                    RPAREN337=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_create_table_stmt2895);  
                    stream_RPAREN.add(RPAREN337);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:405:5: AS select_stmt
                    {
                    AS338=(Token)match(input,AS,FOLLOW_AS_in_create_table_stmt2901);  
                    stream_AS.add(AS338);


                    pushFollow(FOLLOW_select_stmt_in_create_table_stmt2903);
                    select_stmt339=select_stmt();

                    state._fsp--;

                    stream_select_stmt.add(select_stmt339.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: column_def, table_constraint, EXISTS, select_stmt, TEMPORARY, database_name, table_name
            // token labels: 
            // rule labels: database_name, table_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 406:74: -> ^( CREATE_TABLE ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $table_name ( $database_name)? ) ( ^( COLUMNS ( column_def )+ ) )? ( ^( CONSTRAINTS ( table_constraint )* ) )? ( select_stmt )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:4: ^( CREATE_TABLE ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $table_name ( $database_name)? ) ( ^( COLUMNS ( column_def )+ ) )? ( ^( CONSTRAINTS ( table_constraint )* ) )? ( select_stmt )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CREATE_TABLE, "CREATE_TABLE")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:19: ^( OPTIONS ( TEMPORARY )? ( EXISTS )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:29: ( TEMPORARY )?
                if ( stream_TEMPORARY.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_TEMPORARY.nextNode()
                    );

                }
                stream_TEMPORARY.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:40: ( EXISTS )?
                if ( stream_EXISTS.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_EXISTS.nextNode()
                    );

                }
                stream_EXISTS.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:49: ^( $table_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:406:64: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:3: ( ^( COLUMNS ( column_def )+ ) )?
                if ( stream_column_def.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:3: ^( COLUMNS ( column_def )+ )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    (Object)adaptor.create(COLUMNS, "COLUMNS")
                    , root_2);

                    if ( !(stream_column_def.hasNext()) ) {
                        throw new RewriteEarlyExitException();
                    }
                    while ( stream_column_def.hasNext() ) {
                        adaptor.addChild(root_2, stream_column_def.nextTree());

                    }
                    stream_column_def.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_column_def.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:27: ( ^( CONSTRAINTS ( table_constraint )* ) )?
                if ( stream_table_constraint.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:27: ^( CONSTRAINTS ( table_constraint )* )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    (Object)adaptor.create(CONSTRAINTS, "CONSTRAINTS")
                    , root_2);

                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:41: ( table_constraint )*
                    while ( stream_table_constraint.hasNext() ) {
                        adaptor.addChild(root_2, stream_table_constraint.nextTree());

                    }
                    stream_table_constraint.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_table_constraint.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:407:61: ( select_stmt )?
                if ( stream_select_stmt.hasNext() ) {
                    adaptor.addChild(root_1, stream_select_stmt.nextTree());

                }
                stream_select_stmt.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "create_table_stmt"


    public static class column_def_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_def"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:1: column_def : name= id_column_def ( type_name )? ( column_constraint )* -> ^( $name ^( CONSTRAINTS ( column_constraint )* ) ( type_name )? ) ;
    public final SqlParser.column_def_return column_def() throws RecognitionException {
        SqlParser.column_def_return retval = new SqlParser.column_def_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.id_column_def_return name =null;

        SqlParser.type_name_return type_name340 =null;

        SqlParser.column_constraint_return column_constraint341 =null;


        RewriteRuleSubtreeStream stream_type_name=new RewriteRuleSubtreeStream(adaptor,"rule type_name");
        RewriteRuleSubtreeStream stream_column_constraint=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint");
        RewriteRuleSubtreeStream stream_id_column_def=new RewriteRuleSubtreeStream(adaptor,"rule id_column_def");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:11: (name= id_column_def ( type_name )? ( column_constraint )* -> ^( $name ^( CONSTRAINTS ( column_constraint )* ) ( type_name )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:13: name= id_column_def ( type_name )? ( column_constraint )*
            {
            pushFollow(FOLLOW_id_column_def_in_column_def2959);
            name=id_column_def();

            state._fsp--;

            stream_id_column_def.add(name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:32: ( type_name )?
            int alt128=2;
            int LA128_0 = input.LA(1);

            if ( (LA128_0==ID) ) {
                alt128=1;
            }
            switch (alt128) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:32: type_name
                    {
                    pushFollow(FOLLOW_type_name_in_column_def2961);
                    type_name340=type_name();

                    state._fsp--;

                    stream_type_name.add(type_name340.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:43: ( column_constraint )*
            loop129:
            do {
                int alt129=2;
                alt129 = dfa129.predict(input);
                switch (alt129) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:409:43: column_constraint
            	    {
            	    pushFollow(FOLLOW_column_constraint_in_column_def2964);
            	    column_constraint341=column_constraint();

            	    state._fsp--;

            	    stream_column_constraint.add(column_constraint341.getTree());

            	    }
            	    break;

            	default :
            	    break loop129;
                }
            } while (true);


            // AST REWRITE
            // elements: type_name, column_constraint, name
            // token labels: 
            // rule labels: name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 410:57: -> ^( $name ^( CONSTRAINTS ( column_constraint )* ) ( type_name )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:410:4: ^( $name ^( CONSTRAINTS ( column_constraint )* ) ( type_name )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_name.nextNode(), root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:410:12: ^( CONSTRAINTS ( column_constraint )* )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CONSTRAINTS, "CONSTRAINTS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:410:26: ( column_constraint )*
                while ( stream_column_constraint.hasNext() ) {
                    adaptor.addChild(root_2, stream_column_constraint.nextTree());

                }
                stream_column_constraint.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:410:46: ( type_name )?
                if ( stream_type_name.hasNext() ) {
                    adaptor.addChild(root_1, stream_type_name.nextTree());

                }
                stream_type_name.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_def"


    public static class column_constraint_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:412:1: column_constraint : ( CONSTRAINT name= id )? ( column_constraint_pk | column_constraint_not_null | column_constraint_null | column_constraint_unique | column_constraint_check | column_constraint_default | column_constraint_collate | fk_clause ) -> ^( COLUMN_CONSTRAINT ( column_constraint_pk )? ( column_constraint_not_null )? ( column_constraint_null )? ( column_constraint_unique )? ( column_constraint_check )? ( column_constraint_default )? ( column_constraint_collate )? ( fk_clause )? ( $name)? ) ;
    public final SqlParser.column_constraint_return column_constraint() throws RecognitionException {
        SqlParser.column_constraint_return retval = new SqlParser.column_constraint_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CONSTRAINT342=null;
        SqlParser.id_return name =null;

        SqlParser.column_constraint_pk_return column_constraint_pk343 =null;

        SqlParser.column_constraint_not_null_return column_constraint_not_null344 =null;

        SqlParser.column_constraint_null_return column_constraint_null345 =null;

        SqlParser.column_constraint_unique_return column_constraint_unique346 =null;

        SqlParser.column_constraint_check_return column_constraint_check347 =null;

        SqlParser.column_constraint_default_return column_constraint_default348 =null;

        SqlParser.column_constraint_collate_return column_constraint_collate349 =null;

        SqlParser.fk_clause_return fk_clause350 =null;


        Object CONSTRAINT342_tree=null;
        RewriteRuleTokenStream stream_CONSTRAINT=new RewriteRuleTokenStream(adaptor,"token CONSTRAINT");
        RewriteRuleSubtreeStream stream_column_constraint_not_null=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_not_null");
        RewriteRuleSubtreeStream stream_column_constraint_null=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_null");
        RewriteRuleSubtreeStream stream_fk_clause=new RewriteRuleSubtreeStream(adaptor,"rule fk_clause");
        RewriteRuleSubtreeStream stream_column_constraint_collate=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_collate");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_column_constraint_pk=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_pk");
        RewriteRuleSubtreeStream stream_column_constraint_unique=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_unique");
        RewriteRuleSubtreeStream stream_column_constraint_default=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_default");
        RewriteRuleSubtreeStream stream_column_constraint_check=new RewriteRuleSubtreeStream(adaptor,"rule column_constraint_check");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:412:18: ( ( CONSTRAINT name= id )? ( column_constraint_pk | column_constraint_not_null | column_constraint_null | column_constraint_unique | column_constraint_check | column_constraint_default | column_constraint_collate | fk_clause ) -> ^( COLUMN_CONSTRAINT ( column_constraint_pk )? ( column_constraint_not_null )? ( column_constraint_null )? ( column_constraint_unique )? ( column_constraint_check )? ( column_constraint_default )? ( column_constraint_collate )? ( fk_clause )? ( $name)? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:412:20: ( CONSTRAINT name= id )? ( column_constraint_pk | column_constraint_not_null | column_constraint_null | column_constraint_unique | column_constraint_check | column_constraint_default | column_constraint_collate | fk_clause )
            {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:412:20: ( CONSTRAINT name= id )?
            int alt130=2;
            int LA130_0 = input.LA(1);

            if ( (LA130_0==CONSTRAINT) ) {
                alt130=1;
            }
            switch (alt130) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:412:21: CONSTRAINT name= id
                    {
                    CONSTRAINT342=(Token)match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_column_constraint2990);  
                    stream_CONSTRAINT.add(CONSTRAINT342);


                    pushFollow(FOLLOW_id_in_column_constraint2994);
                    name=id();

                    state._fsp--;

                    stream_id.add(name.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:413:3: ( column_constraint_pk | column_constraint_not_null | column_constraint_null | column_constraint_unique | column_constraint_check | column_constraint_default | column_constraint_collate | fk_clause )
            int alt131=8;
            switch ( input.LA(1) ) {
            case PRIMARY:
                {
                alt131=1;
                }
                break;
            case NOT:
                {
                alt131=2;
                }
                break;
            case NULL:
                {
                alt131=3;
                }
                break;
            case UNIQUE:
                {
                alt131=4;
                }
                break;
            case CHECK:
                {
                alt131=5;
                }
                break;
            case DEFAULT:
                {
                alt131=6;
                }
                break;
            case COLLATE:
                {
                alt131=7;
                }
                break;
            case REFERENCES:
                {
                alt131=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 131, 0, input);

                throw nvae;

            }

            switch (alt131) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:413:5: column_constraint_pk
                    {
                    pushFollow(FOLLOW_column_constraint_pk_in_column_constraint3002);
                    column_constraint_pk343=column_constraint_pk();

                    state._fsp--;

                    stream_column_constraint_pk.add(column_constraint_pk343.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:414:5: column_constraint_not_null
                    {
                    pushFollow(FOLLOW_column_constraint_not_null_in_column_constraint3008);
                    column_constraint_not_null344=column_constraint_not_null();

                    state._fsp--;

                    stream_column_constraint_not_null.add(column_constraint_not_null344.getTree());

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:415:5: column_constraint_null
                    {
                    pushFollow(FOLLOW_column_constraint_null_in_column_constraint3014);
                    column_constraint_null345=column_constraint_null();

                    state._fsp--;

                    stream_column_constraint_null.add(column_constraint_null345.getTree());

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:416:5: column_constraint_unique
                    {
                    pushFollow(FOLLOW_column_constraint_unique_in_column_constraint3020);
                    column_constraint_unique346=column_constraint_unique();

                    state._fsp--;

                    stream_column_constraint_unique.add(column_constraint_unique346.getTree());

                    }
                    break;
                case 5 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:417:5: column_constraint_check
                    {
                    pushFollow(FOLLOW_column_constraint_check_in_column_constraint3026);
                    column_constraint_check347=column_constraint_check();

                    state._fsp--;

                    stream_column_constraint_check.add(column_constraint_check347.getTree());

                    }
                    break;
                case 6 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:418:5: column_constraint_default
                    {
                    pushFollow(FOLLOW_column_constraint_default_in_column_constraint3032);
                    column_constraint_default348=column_constraint_default();

                    state._fsp--;

                    stream_column_constraint_default.add(column_constraint_default348.getTree());

                    }
                    break;
                case 7 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:419:5: column_constraint_collate
                    {
                    pushFollow(FOLLOW_column_constraint_collate_in_column_constraint3038);
                    column_constraint_collate349=column_constraint_collate();

                    state._fsp--;

                    stream_column_constraint_collate.add(column_constraint_collate349.getTree());

                    }
                    break;
                case 8 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:420:5: fk_clause
                    {
                    pushFollow(FOLLOW_fk_clause_in_column_constraint3044);
                    fk_clause350=fk_clause();

                    state._fsp--;

                    stream_fk_clause.add(fk_clause350.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: column_constraint_unique, column_constraint_not_null, name, column_constraint_check, column_constraint_collate, column_constraint_default, column_constraint_null, fk_clause, column_constraint_pk
            // token labels: 
            // rule labels: name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 421:10: -> ^( COLUMN_CONSTRAINT ( column_constraint_pk )? ( column_constraint_not_null )? ( column_constraint_null )? ( column_constraint_unique )? ( column_constraint_check )? ( column_constraint_default )? ( column_constraint_collate )? ( fk_clause )? ( $name)? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:421:4: ^( COLUMN_CONSTRAINT ( column_constraint_pk )? ( column_constraint_not_null )? ( column_constraint_null )? ( column_constraint_unique )? ( column_constraint_check )? ( column_constraint_default )? ( column_constraint_collate )? ( fk_clause )? ( $name)? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMN_CONSTRAINT, "COLUMN_CONSTRAINT")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:422:3: ( column_constraint_pk )?
                if ( stream_column_constraint_pk.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_pk.nextTree());

                }
                stream_column_constraint_pk.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:423:3: ( column_constraint_not_null )?
                if ( stream_column_constraint_not_null.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_not_null.nextTree());

                }
                stream_column_constraint_not_null.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:424:3: ( column_constraint_null )?
                if ( stream_column_constraint_null.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_null.nextTree());

                }
                stream_column_constraint_null.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:425:3: ( column_constraint_unique )?
                if ( stream_column_constraint_unique.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_unique.nextTree());

                }
                stream_column_constraint_unique.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:426:3: ( column_constraint_check )?
                if ( stream_column_constraint_check.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_check.nextTree());

                }
                stream_column_constraint_check.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:427:3: ( column_constraint_default )?
                if ( stream_column_constraint_default.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_default.nextTree());

                }
                stream_column_constraint_default.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:428:3: ( column_constraint_collate )?
                if ( stream_column_constraint_collate.hasNext() ) {
                    adaptor.addChild(root_1, stream_column_constraint_collate.nextTree());

                }
                stream_column_constraint_collate.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:429:3: ( fk_clause )?
                if ( stream_fk_clause.hasNext() ) {
                    adaptor.addChild(root_1, stream_fk_clause.nextTree());

                }
                stream_fk_clause.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:430:4: ( $name)?
                if ( stream_name.hasNext() ) {
                    adaptor.addChild(root_1, stream_name.nextTree());

                }
                stream_name.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint"


    public static class column_constraint_pk_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_pk"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:1: column_constraint_pk : PRIMARY ^ KEY ! ( ASC | DESC )? ( table_conflict_clause )? ( AUTOINCREMENT )? ;
    public final SqlParser.column_constraint_pk_return column_constraint_pk() throws RecognitionException {
        SqlParser.column_constraint_pk_return retval = new SqlParser.column_constraint_pk_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PRIMARY351=null;
        Token KEY352=null;
        Token set353=null;
        Token AUTOINCREMENT355=null;
        SqlParser.table_conflict_clause_return table_conflict_clause354 =null;


        Object PRIMARY351_tree=null;
        Object KEY352_tree=null;
        Object set353_tree=null;
        Object AUTOINCREMENT355_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:21: ( PRIMARY ^ KEY ! ( ASC | DESC )? ( table_conflict_clause )? ( AUTOINCREMENT )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:23: PRIMARY ^ KEY ! ( ASC | DESC )? ( table_conflict_clause )? ( AUTOINCREMENT )?
            {
            root_0 = (Object)adaptor.nil();


            PRIMARY351=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_constraint_pk3104); 
            PRIMARY351_tree = 
            (Object)adaptor.create(PRIMARY351)
            ;
            root_0 = (Object)adaptor.becomeRoot(PRIMARY351_tree, root_0);


            KEY352=(Token)match(input,KEY,FOLLOW_KEY_in_column_constraint_pk3107); 

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:37: ( ASC | DESC )?
            int alt132=2;
            int LA132_0 = input.LA(1);

            if ( (LA132_0==ASC||LA132_0==DESC) ) {
                alt132=1;
            }
            switch (alt132) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
                    {
                    set353=(Token)input.LT(1);

                    if ( input.LA(1)==ASC||input.LA(1)==DESC ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set353)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:51: ( table_conflict_clause )?
            int alt133=2;
            int LA133_0 = input.LA(1);

            if ( (LA133_0==ON) ) {
                alt133=1;
            }
            switch (alt133) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:51: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_column_constraint_pk3119);
                    table_conflict_clause354=table_conflict_clause();

                    state._fsp--;

                    adaptor.addChild(root_0, table_conflict_clause354.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:74: ( AUTOINCREMENT )?
            int alt134=2;
            int LA134_0 = input.LA(1);

            if ( (LA134_0==AUTOINCREMENT) ) {
                alt134=1;
            }
            switch (alt134) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:432:75: AUTOINCREMENT
                    {
                    AUTOINCREMENT355=(Token)match(input,AUTOINCREMENT,FOLLOW_AUTOINCREMENT_in_column_constraint_pk3123); 
                    AUTOINCREMENT355_tree = 
                    (Object)adaptor.create(AUTOINCREMENT355)
                    ;
                    adaptor.addChild(root_0, AUTOINCREMENT355_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_pk"


    public static class column_constraint_not_null_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_not_null"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:1: column_constraint_not_null : NOT NULL ( table_conflict_clause )? -> ^( NOT_NULL ( table_conflict_clause )? ) ;
    public final SqlParser.column_constraint_not_null_return column_constraint_not_null() throws RecognitionException {
        SqlParser.column_constraint_not_null_return retval = new SqlParser.column_constraint_not_null_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token NOT356=null;
        Token NULL357=null;
        SqlParser.table_conflict_clause_return table_conflict_clause358 =null;


        Object NOT356_tree=null;
        Object NULL357_tree=null;
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_NULL=new RewriteRuleTokenStream(adaptor,"token NULL");
        RewriteRuleSubtreeStream stream_table_conflict_clause=new RewriteRuleSubtreeStream(adaptor,"rule table_conflict_clause");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:27: ( NOT NULL ( table_conflict_clause )? -> ^( NOT_NULL ( table_conflict_clause )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:29: NOT NULL ( table_conflict_clause )?
            {
            NOT356=(Token)match(input,NOT,FOLLOW_NOT_in_column_constraint_not_null3132);  
            stream_NOT.add(NOT356);


            NULL357=(Token)match(input,NULL,FOLLOW_NULL_in_column_constraint_not_null3134);  
            stream_NULL.add(NULL357);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:38: ( table_conflict_clause )?
            int alt135=2;
            int LA135_0 = input.LA(1);

            if ( (LA135_0==ON) ) {
                alt135=1;
            }
            switch (alt135) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:38: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_column_constraint_not_null3136);
                    table_conflict_clause358=table_conflict_clause();

                    state._fsp--;

                    stream_table_conflict_clause.add(table_conflict_clause358.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: table_conflict_clause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 434:61: -> ^( NOT_NULL ( table_conflict_clause )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:64: ^( NOT_NULL ( table_conflict_clause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(NOT_NULL, "NOT_NULL")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:434:75: ( table_conflict_clause )?
                if ( stream_table_conflict_clause.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_conflict_clause.nextTree());

                }
                stream_table_conflict_clause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_not_null"


    public static class column_constraint_null_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_null"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:1: column_constraint_null : NULL ( table_conflict_clause )? -> ^( IS_NULL ( table_conflict_clause )? ) ;
    public final SqlParser.column_constraint_null_return column_constraint_null() throws RecognitionException {
        SqlParser.column_constraint_null_return retval = new SqlParser.column_constraint_null_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token NULL359=null;
        SqlParser.table_conflict_clause_return table_conflict_clause360 =null;


        Object NULL359_tree=null;
        RewriteRuleTokenStream stream_NULL=new RewriteRuleTokenStream(adaptor,"token NULL");
        RewriteRuleSubtreeStream stream_table_conflict_clause=new RewriteRuleSubtreeStream(adaptor,"rule table_conflict_clause");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:23: ( NULL ( table_conflict_clause )? -> ^( IS_NULL ( table_conflict_clause )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:25: NULL ( table_conflict_clause )?
            {
            NULL359=(Token)match(input,NULL,FOLLOW_NULL_in_column_constraint_null3153);  
            stream_NULL.add(NULL359);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:30: ( table_conflict_clause )?
            int alt136=2;
            int LA136_0 = input.LA(1);

            if ( (LA136_0==ON) ) {
                alt136=1;
            }
            switch (alt136) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:30: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_column_constraint_null3155);
                    table_conflict_clause360=table_conflict_clause();

                    state._fsp--;

                    stream_table_conflict_clause.add(table_conflict_clause360.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: table_conflict_clause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 436:53: -> ^( IS_NULL ( table_conflict_clause )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:56: ^( IS_NULL ( table_conflict_clause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(IS_NULL, "IS_NULL")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:436:66: ( table_conflict_clause )?
                if ( stream_table_conflict_clause.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_conflict_clause.nextTree());

                }
                stream_table_conflict_clause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_null"


    public static class column_constraint_unique_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_unique"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:438:1: column_constraint_unique : UNIQUE ^ ( table_conflict_clause )? ;
    public final SqlParser.column_constraint_unique_return column_constraint_unique() throws RecognitionException {
        SqlParser.column_constraint_unique_return retval = new SqlParser.column_constraint_unique_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token UNIQUE361=null;
        SqlParser.table_conflict_clause_return table_conflict_clause362 =null;


        Object UNIQUE361_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:438:25: ( UNIQUE ^ ( table_conflict_clause )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:438:27: UNIQUE ^ ( table_conflict_clause )?
            {
            root_0 = (Object)adaptor.nil();


            UNIQUE361=(Token)match(input,UNIQUE,FOLLOW_UNIQUE_in_column_constraint_unique3172); 
            UNIQUE361_tree = 
            (Object)adaptor.create(UNIQUE361)
            ;
            root_0 = (Object)adaptor.becomeRoot(UNIQUE361_tree, root_0);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:438:35: ( table_conflict_clause )?
            int alt137=2;
            int LA137_0 = input.LA(1);

            if ( (LA137_0==ON) ) {
                alt137=1;
            }
            switch (alt137) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:438:35: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_column_constraint_unique3175);
                    table_conflict_clause362=table_conflict_clause();

                    state._fsp--;

                    adaptor.addChild(root_0, table_conflict_clause362.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_unique"


    public static class column_constraint_check_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_check"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:440:1: column_constraint_check : CHECK ^ LPAREN ! expr RPAREN !;
    public final SqlParser.column_constraint_check_return column_constraint_check() throws RecognitionException {
        SqlParser.column_constraint_check_return retval = new SqlParser.column_constraint_check_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CHECK363=null;
        Token LPAREN364=null;
        Token RPAREN366=null;
        SqlParser.expr_return expr365 =null;


        Object CHECK363_tree=null;
        Object LPAREN364_tree=null;
        Object RPAREN366_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:440:24: ( CHECK ^ LPAREN ! expr RPAREN !)
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:440:26: CHECK ^ LPAREN ! expr RPAREN !
            {
            root_0 = (Object)adaptor.nil();


            CHECK363=(Token)match(input,CHECK,FOLLOW_CHECK_in_column_constraint_check3183); 
            CHECK363_tree = 
            (Object)adaptor.create(CHECK363)
            ;
            root_0 = (Object)adaptor.becomeRoot(CHECK363_tree, root_0);


            LPAREN364=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_column_constraint_check3186); 

            pushFollow(FOLLOW_expr_in_column_constraint_check3189);
            expr365=expr();

            state._fsp--;

            adaptor.addChild(root_0, expr365.getTree());

            RPAREN366=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_column_constraint_check3191); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_check"


    public static class numeric_literal_value_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal_value"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:442:1: numeric_literal_value : ( INTEGER -> ^( INTEGER_LITERAL INTEGER ) | FLOAT -> ^( FLOAT_LITERAL FLOAT ) );
    public final SqlParser.numeric_literal_value_return numeric_literal_value() throws RecognitionException {
        SqlParser.numeric_literal_value_return retval = new SqlParser.numeric_literal_value_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTEGER367=null;
        Token FLOAT368=null;

        Object INTEGER367_tree=null;
        Object FLOAT368_tree=null;
        RewriteRuleTokenStream stream_FLOAT=new RewriteRuleTokenStream(adaptor,"token FLOAT");
        RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:443:3: ( INTEGER -> ^( INTEGER_LITERAL INTEGER ) | FLOAT -> ^( FLOAT_LITERAL FLOAT ) )
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==INTEGER) ) {
                alt138=1;
            }
            else if ( (LA138_0==FLOAT) ) {
                alt138=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;

            }
            switch (alt138) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:443:5: INTEGER
                    {
                    INTEGER367=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_numeric_literal_value3202);  
                    stream_INTEGER.add(INTEGER367);


                    // AST REWRITE
                    // elements: INTEGER
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 443:13: -> ^( INTEGER_LITERAL INTEGER )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:443:16: ^( INTEGER_LITERAL INTEGER )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(INTEGER_LITERAL, "INTEGER_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_INTEGER.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:444:5: FLOAT
                    {
                    FLOAT368=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_numeric_literal_value3216);  
                    stream_FLOAT.add(FLOAT368);


                    // AST REWRITE
                    // elements: FLOAT
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (Object)adaptor.nil();
                    // 444:11: -> ^( FLOAT_LITERAL FLOAT )
                    {
                        // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:444:14: ^( FLOAT_LITERAL FLOAT )
                        {
                        Object root_1 = (Object)adaptor.nil();
                        root_1 = (Object)adaptor.becomeRoot(
                        (Object)adaptor.create(FLOAT_LITERAL, "FLOAT_LITERAL")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_FLOAT.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal_value"


    public static class signed_default_number_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "signed_default_number"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:447:1: signed_default_number : ( PLUS | MINUS ) ^ numeric_literal_value ;
    public final SqlParser.signed_default_number_return signed_default_number() throws RecognitionException {
        SqlParser.signed_default_number_return retval = new SqlParser.signed_default_number_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set369=null;
        SqlParser.numeric_literal_value_return numeric_literal_value370 =null;


        Object set369_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:447:22: ( ( PLUS | MINUS ) ^ numeric_literal_value )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:447:24: ( PLUS | MINUS ) ^ numeric_literal_value
            {
            root_0 = (Object)adaptor.nil();


            set369=(Token)input.LT(1);

            set369=(Token)input.LT(1);

            if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
                input.consume();
                root_0 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(set369)
                , root_0);
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            pushFollow(FOLLOW_numeric_literal_value_in_signed_default_number3243);
            numeric_literal_value370=numeric_literal_value();

            state._fsp--;

            adaptor.addChild(root_0, numeric_literal_value370.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "signed_default_number"


    public static class column_constraint_default_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_default"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:1: column_constraint_default : DEFAULT ^ ( signed_default_number | literal_value | LPAREN ! expr RPAREN !) ;
    public final SqlParser.column_constraint_default_return column_constraint_default() throws RecognitionException {
        SqlParser.column_constraint_default_return retval = new SqlParser.column_constraint_default_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DEFAULT371=null;
        Token LPAREN374=null;
        Token RPAREN376=null;
        SqlParser.signed_default_number_return signed_default_number372 =null;

        SqlParser.literal_value_return literal_value373 =null;

        SqlParser.expr_return expr375 =null;


        Object DEFAULT371_tree=null;
        Object LPAREN374_tree=null;
        Object RPAREN376_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:26: ( DEFAULT ^ ( signed_default_number | literal_value | LPAREN ! expr RPAREN !) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:28: DEFAULT ^ ( signed_default_number | literal_value | LPAREN ! expr RPAREN !)
            {
            root_0 = (Object)adaptor.nil();


            DEFAULT371=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_column_constraint_default3251); 
            DEFAULT371_tree = 
            (Object)adaptor.create(DEFAULT371)
            ;
            root_0 = (Object)adaptor.becomeRoot(DEFAULT371_tree, root_0);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:37: ( signed_default_number | literal_value | LPAREN ! expr RPAREN !)
            int alt139=3;
            switch ( input.LA(1) ) {
            case MINUS:
            case PLUS:
                {
                alt139=1;
                }
                break;
            case BLOB:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case FALSE:
            case FLOAT:
            case INTEGER:
            case NULL:
            case STRING:
            case TRUE:
                {
                alt139=2;
                }
                break;
            case LPAREN:
                {
                alt139=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 139, 0, input);

                throw nvae;

            }

            switch (alt139) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:38: signed_default_number
                    {
                    pushFollow(FOLLOW_signed_default_number_in_column_constraint_default3255);
                    signed_default_number372=signed_default_number();

                    state._fsp--;

                    adaptor.addChild(root_0, signed_default_number372.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:62: literal_value
                    {
                    pushFollow(FOLLOW_literal_value_in_column_constraint_default3259);
                    literal_value373=literal_value();

                    state._fsp--;

                    adaptor.addChild(root_0, literal_value373.getTree());

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:450:78: LPAREN ! expr RPAREN !
                    {
                    LPAREN374=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_column_constraint_default3263); 

                    pushFollow(FOLLOW_expr_in_column_constraint_default3266);
                    expr375=expr();

                    state._fsp--;

                    adaptor.addChild(root_0, expr375.getTree());

                    RPAREN376=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_column_constraint_default3268); 

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_default"


    public static class column_constraint_collate_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "column_constraint_collate"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:452:1: column_constraint_collate : COLLATE ^collation_name= id ;
    public final SqlParser.column_constraint_collate_return column_constraint_collate() throws RecognitionException {
        SqlParser.column_constraint_collate_return retval = new SqlParser.column_constraint_collate_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COLLATE377=null;
        SqlParser.id_return collation_name =null;


        Object COLLATE377_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:452:26: ( COLLATE ^collation_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:452:28: COLLATE ^collation_name= id
            {
            root_0 = (Object)adaptor.nil();


            COLLATE377=(Token)match(input,COLLATE,FOLLOW_COLLATE_in_column_constraint_collate3278); 
            COLLATE377_tree = 
            (Object)adaptor.create(COLLATE377)
            ;
            root_0 = (Object)adaptor.becomeRoot(COLLATE377_tree, root_0);


            pushFollow(FOLLOW_id_in_column_constraint_collate3283);
            collation_name=id();

            state._fsp--;

            adaptor.addChild(root_0, collation_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column_constraint_collate"


    public static class table_constraint_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_constraint"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:454:1: table_constraint : ( CONSTRAINT name= id )? ( table_constraint_pk | table_constraint_unique | table_constraint_check | table_constraint_fk ) -> ^( TABLE_CONSTRAINT ( table_constraint_pk )? ( table_constraint_unique )? ( table_constraint_check )? ( table_constraint_fk )? ( $name)? ) ;
    public final SqlParser.table_constraint_return table_constraint() throws RecognitionException {
        SqlParser.table_constraint_return retval = new SqlParser.table_constraint_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CONSTRAINT378=null;
        SqlParser.id_return name =null;

        SqlParser.table_constraint_pk_return table_constraint_pk379 =null;

        SqlParser.table_constraint_unique_return table_constraint_unique380 =null;

        SqlParser.table_constraint_check_return table_constraint_check381 =null;

        SqlParser.table_constraint_fk_return table_constraint_fk382 =null;


        Object CONSTRAINT378_tree=null;
        RewriteRuleTokenStream stream_CONSTRAINT=new RewriteRuleTokenStream(adaptor,"token CONSTRAINT");
        RewriteRuleSubtreeStream stream_table_constraint_fk=new RewriteRuleSubtreeStream(adaptor,"rule table_constraint_fk");
        RewriteRuleSubtreeStream stream_table_constraint_unique=new RewriteRuleSubtreeStream(adaptor,"rule table_constraint_unique");
        RewriteRuleSubtreeStream stream_table_constraint_check=new RewriteRuleSubtreeStream(adaptor,"rule table_constraint_check");
        RewriteRuleSubtreeStream stream_table_constraint_pk=new RewriteRuleSubtreeStream(adaptor,"rule table_constraint_pk");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:454:17: ( ( CONSTRAINT name= id )? ( table_constraint_pk | table_constraint_unique | table_constraint_check | table_constraint_fk ) -> ^( TABLE_CONSTRAINT ( table_constraint_pk )? ( table_constraint_unique )? ( table_constraint_check )? ( table_constraint_fk )? ( $name)? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:454:19: ( CONSTRAINT name= id )? ( table_constraint_pk | table_constraint_unique | table_constraint_check | table_constraint_fk )
            {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:454:19: ( CONSTRAINT name= id )?
            int alt140=2;
            int LA140_0 = input.LA(1);

            if ( (LA140_0==CONSTRAINT) ) {
                alt140=1;
            }
            switch (alt140) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:454:20: CONSTRAINT name= id
                    {
                    CONSTRAINT378=(Token)match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_table_constraint3292);  
                    stream_CONSTRAINT.add(CONSTRAINT378);


                    pushFollow(FOLLOW_id_in_table_constraint3296);
                    name=id();

                    state._fsp--;

                    stream_id.add(name.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:455:3: ( table_constraint_pk | table_constraint_unique | table_constraint_check | table_constraint_fk )
            int alt141=4;
            switch ( input.LA(1) ) {
            case PRIMARY:
                {
                alt141=1;
                }
                break;
            case UNIQUE:
                {
                alt141=2;
                }
                break;
            case CHECK:
                {
                alt141=3;
                }
                break;
            case FOREIGN:
                {
                alt141=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 141, 0, input);

                throw nvae;

            }

            switch (alt141) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:455:5: table_constraint_pk
                    {
                    pushFollow(FOLLOW_table_constraint_pk_in_table_constraint3304);
                    table_constraint_pk379=table_constraint_pk();

                    state._fsp--;

                    stream_table_constraint_pk.add(table_constraint_pk379.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:456:5: table_constraint_unique
                    {
                    pushFollow(FOLLOW_table_constraint_unique_in_table_constraint3310);
                    table_constraint_unique380=table_constraint_unique();

                    state._fsp--;

                    stream_table_constraint_unique.add(table_constraint_unique380.getTree());

                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:457:5: table_constraint_check
                    {
                    pushFollow(FOLLOW_table_constraint_check_in_table_constraint3316);
                    table_constraint_check381=table_constraint_check();

                    state._fsp--;

                    stream_table_constraint_check.add(table_constraint_check381.getTree());

                    }
                    break;
                case 4 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:458:5: table_constraint_fk
                    {
                    pushFollow(FOLLOW_table_constraint_fk_in_table_constraint3322);
                    table_constraint_fk382=table_constraint_fk();

                    state._fsp--;

                    stream_table_constraint_fk.add(table_constraint_fk382.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: table_constraint_fk, name, table_constraint_unique, table_constraint_pk, table_constraint_check
            // token labels: 
            // rule labels: name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 459:10: -> ^( TABLE_CONSTRAINT ( table_constraint_pk )? ( table_constraint_unique )? ( table_constraint_check )? ( table_constraint_fk )? ( $name)? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:459:4: ^( TABLE_CONSTRAINT ( table_constraint_pk )? ( table_constraint_unique )? ( table_constraint_check )? ( table_constraint_fk )? ( $name)? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(TABLE_CONSTRAINT, "TABLE_CONSTRAINT")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:460:3: ( table_constraint_pk )?
                if ( stream_table_constraint_pk.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_constraint_pk.nextTree());

                }
                stream_table_constraint_pk.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:461:3: ( table_constraint_unique )?
                if ( stream_table_constraint_unique.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_constraint_unique.nextTree());

                }
                stream_table_constraint_unique.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:462:3: ( table_constraint_check )?
                if ( stream_table_constraint_check.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_constraint_check.nextTree());

                }
                stream_table_constraint_check.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:463:3: ( table_constraint_fk )?
                if ( stream_table_constraint_fk.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_constraint_fk.nextTree());

                }
                stream_table_constraint_fk.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:464:4: ( $name)?
                if ( stream_name.hasNext() ) {
                    adaptor.addChild(root_1, stream_name.nextTree());

                }
                stream_name.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_constraint"


    public static class table_constraint_pk_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_constraint_pk"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:466:1: table_constraint_pk : PRIMARY KEY LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )? -> ^( PRIMARY ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? ) ;
    public final SqlParser.table_constraint_pk_return table_constraint_pk() throws RecognitionException {
        SqlParser.table_constraint_pk_return retval = new SqlParser.table_constraint_pk_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PRIMARY383=null;
        Token KEY384=null;
        Token LPAREN385=null;
        Token COMMA386=null;
        Token RPAREN387=null;
        List list_indexed_columns=null;
        SqlParser.table_conflict_clause_return table_conflict_clause388 =null;

        RuleReturnScope indexed_columns = null;
        Object PRIMARY383_tree=null;
        Object KEY384_tree=null;
        Object LPAREN385_tree=null;
        Object COMMA386_tree=null;
        Object RPAREN387_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_PRIMARY=new RewriteRuleTokenStream(adaptor,"token PRIMARY");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KEY=new RewriteRuleTokenStream(adaptor,"token KEY");
        RewriteRuleSubtreeStream stream_table_conflict_clause=new RewriteRuleSubtreeStream(adaptor,"rule table_conflict_clause");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:466:20: ( PRIMARY KEY LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )? -> ^( PRIMARY ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:466:22: PRIMARY KEY LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )?
            {
            PRIMARY383=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_table_constraint_pk3362);  
            stream_PRIMARY.add(PRIMARY383);


            KEY384=(Token)match(input,KEY,FOLLOW_KEY_in_table_constraint_pk3364);  
            stream_KEY.add(KEY384);


            LPAREN385=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_table_constraint_pk3368);  
            stream_LPAREN.add(LPAREN385);


            pushFollow(FOLLOW_id_in_table_constraint_pk3372);
            indexed_columns=id();

            state._fsp--;

            stream_id.add(indexed_columns.getTree());
            if (list_indexed_columns==null) list_indexed_columns=new ArrayList();
            list_indexed_columns.add(indexed_columns.getTree());


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:467:30: ( COMMA indexed_columns+= id )*
            loop142:
            do {
                int alt142=2;
                int LA142_0 = input.LA(1);

                if ( (LA142_0==COMMA) ) {
                    alt142=1;
                }


                switch (alt142) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:467:31: COMMA indexed_columns+= id
            	    {
            	    COMMA386=(Token)match(input,COMMA,FOLLOW_COMMA_in_table_constraint_pk3375);  
            	    stream_COMMA.add(COMMA386);


            	    pushFollow(FOLLOW_id_in_table_constraint_pk3379);
            	    indexed_columns=id();

            	    state._fsp--;

            	    stream_id.add(indexed_columns.getTree());
            	    if (list_indexed_columns==null) list_indexed_columns=new ArrayList();
            	    list_indexed_columns.add(indexed_columns.getTree());


            	    }
            	    break;

            	default :
            	    break loop142;
                }
            } while (true);


            RPAREN387=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_table_constraint_pk3383);  
            stream_RPAREN.add(RPAREN387);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:467:66: ( table_conflict_clause )?
            int alt143=2;
            int LA143_0 = input.LA(1);

            if ( (LA143_0==ON) ) {
                alt143=1;
            }
            switch (alt143) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:467:66: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_table_constraint_pk3385);
                    table_conflict_clause388=table_conflict_clause();

                    state._fsp--;

                    stream_table_conflict_clause.add(table_conflict_clause388.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: table_conflict_clause, indexed_columns, PRIMARY
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: indexed_columns
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexed_columns=new RewriteRuleSubtreeStream(adaptor,"token indexed_columns",list_indexed_columns);
            root_0 = (Object)adaptor.nil();
            // 468:66: -> ^( PRIMARY ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:468:4: ^( PRIMARY ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_PRIMARY.nextNode()
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:468:14: ^( COLUMNS ( $indexed_columns)+ )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMNS, "COLUMNS")
                , root_2);

                if ( !(stream_indexed_columns.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_indexed_columns.hasNext() ) {
                    adaptor.addChild(root_2, stream_indexed_columns.nextTree());

                }
                stream_indexed_columns.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:468:43: ( table_conflict_clause )?
                if ( stream_table_conflict_clause.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_conflict_clause.nextTree());

                }
                stream_table_conflict_clause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_constraint_pk"


    public static class table_constraint_unique_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_constraint_unique"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:470:1: table_constraint_unique : UNIQUE LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )? -> ^( UNIQUE ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? ) ;
    public final SqlParser.table_constraint_unique_return table_constraint_unique() throws RecognitionException {
        SqlParser.table_constraint_unique_return retval = new SqlParser.table_constraint_unique_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token UNIQUE389=null;
        Token LPAREN390=null;
        Token COMMA391=null;
        Token RPAREN392=null;
        List list_indexed_columns=null;
        SqlParser.table_conflict_clause_return table_conflict_clause393 =null;

        RuleReturnScope indexed_columns = null;
        Object UNIQUE389_tree=null;
        Object LPAREN390_tree=null;
        Object COMMA391_tree=null;
        Object RPAREN392_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_UNIQUE=new RewriteRuleTokenStream(adaptor,"token UNIQUE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_table_conflict_clause=new RewriteRuleSubtreeStream(adaptor,"rule table_conflict_clause");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:470:24: ( UNIQUE LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )? -> ^( UNIQUE ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:470:26: UNIQUE LPAREN indexed_columns+= id ( COMMA indexed_columns+= id )* RPAREN ( table_conflict_clause )?
            {
            UNIQUE389=(Token)match(input,UNIQUE,FOLLOW_UNIQUE_in_table_constraint_unique3410);  
            stream_UNIQUE.add(UNIQUE389);


            LPAREN390=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_table_constraint_unique3414);  
            stream_LPAREN.add(LPAREN390);


            pushFollow(FOLLOW_id_in_table_constraint_unique3418);
            indexed_columns=id();

            state._fsp--;

            stream_id.add(indexed_columns.getTree());
            if (list_indexed_columns==null) list_indexed_columns=new ArrayList();
            list_indexed_columns.add(indexed_columns.getTree());


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:471:30: ( COMMA indexed_columns+= id )*
            loop144:
            do {
                int alt144=2;
                int LA144_0 = input.LA(1);

                if ( (LA144_0==COMMA) ) {
                    alt144=1;
                }


                switch (alt144) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:471:31: COMMA indexed_columns+= id
            	    {
            	    COMMA391=(Token)match(input,COMMA,FOLLOW_COMMA_in_table_constraint_unique3421);  
            	    stream_COMMA.add(COMMA391);


            	    pushFollow(FOLLOW_id_in_table_constraint_unique3425);
            	    indexed_columns=id();

            	    state._fsp--;

            	    stream_id.add(indexed_columns.getTree());
            	    if (list_indexed_columns==null) list_indexed_columns=new ArrayList();
            	    list_indexed_columns.add(indexed_columns.getTree());


            	    }
            	    break;

            	default :
            	    break loop144;
                }
            } while (true);


            RPAREN392=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_table_constraint_unique3429);  
            stream_RPAREN.add(RPAREN392);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:471:66: ( table_conflict_clause )?
            int alt145=2;
            int LA145_0 = input.LA(1);

            if ( (LA145_0==ON) ) {
                alt145=1;
            }
            switch (alt145) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:471:66: table_conflict_clause
                    {
                    pushFollow(FOLLOW_table_conflict_clause_in_table_constraint_unique3431);
                    table_conflict_clause393=table_conflict_clause();

                    state._fsp--;

                    stream_table_conflict_clause.add(table_conflict_clause393.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: indexed_columns, table_conflict_clause, UNIQUE
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: indexed_columns
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexed_columns=new RewriteRuleSubtreeStream(adaptor,"token indexed_columns",list_indexed_columns);
            root_0 = (Object)adaptor.nil();
            // 472:65: -> ^( UNIQUE ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:472:4: ^( UNIQUE ^( COLUMNS ( $indexed_columns)+ ) ( table_conflict_clause )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_UNIQUE.nextNode()
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:472:13: ^( COLUMNS ( $indexed_columns)+ )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMNS, "COLUMNS")
                , root_2);

                if ( !(stream_indexed_columns.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_indexed_columns.hasNext() ) {
                    adaptor.addChild(root_2, stream_indexed_columns.nextTree());

                }
                stream_indexed_columns.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:472:42: ( table_conflict_clause )?
                if ( stream_table_conflict_clause.hasNext() ) {
                    adaptor.addChild(root_1, stream_table_conflict_clause.nextTree());

                }
                stream_table_conflict_clause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_constraint_unique"


    public static class table_constraint_check_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_constraint_check"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:474:1: table_constraint_check : CHECK ^ LPAREN ! expr RPAREN !;
    public final SqlParser.table_constraint_check_return table_constraint_check() throws RecognitionException {
        SqlParser.table_constraint_check_return retval = new SqlParser.table_constraint_check_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CHECK394=null;
        Token LPAREN395=null;
        Token RPAREN397=null;
        SqlParser.expr_return expr396 =null;


        Object CHECK394_tree=null;
        Object LPAREN395_tree=null;
        Object RPAREN397_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:474:23: ( CHECK ^ LPAREN ! expr RPAREN !)
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:474:25: CHECK ^ LPAREN ! expr RPAREN !
            {
            root_0 = (Object)adaptor.nil();


            CHECK394=(Token)match(input,CHECK,FOLLOW_CHECK_in_table_constraint_check3456); 
            CHECK394_tree = 
            (Object)adaptor.create(CHECK394)
            ;
            root_0 = (Object)adaptor.becomeRoot(CHECK394_tree, root_0);


            LPAREN395=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_table_constraint_check3459); 

            pushFollow(FOLLOW_expr_in_table_constraint_check3462);
            expr396=expr();

            state._fsp--;

            adaptor.addChild(root_0, expr396.getTree());

            RPAREN397=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_table_constraint_check3464); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_constraint_check"


    public static class table_constraint_fk_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "table_constraint_fk"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:476:1: table_constraint_fk : FOREIGN KEY LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN fk_clause -> ^( FOREIGN ^( COLUMNS ( $column_names)+ ) fk_clause ) ;
    public final SqlParser.table_constraint_fk_return table_constraint_fk() throws RecognitionException {
        SqlParser.table_constraint_fk_return retval = new SqlParser.table_constraint_fk_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token FOREIGN398=null;
        Token KEY399=null;
        Token LPAREN400=null;
        Token COMMA401=null;
        Token RPAREN402=null;
        List list_column_names=null;
        SqlParser.fk_clause_return fk_clause403 =null;

        RuleReturnScope column_names = null;
        Object FOREIGN398_tree=null;
        Object KEY399_tree=null;
        Object LPAREN400_tree=null;
        Object COMMA401_tree=null;
        Object RPAREN402_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_FOREIGN=new RewriteRuleTokenStream(adaptor,"token FOREIGN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KEY=new RewriteRuleTokenStream(adaptor,"token KEY");
        RewriteRuleSubtreeStream stream_fk_clause=new RewriteRuleSubtreeStream(adaptor,"rule fk_clause");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:476:20: ( FOREIGN KEY LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN fk_clause -> ^( FOREIGN ^( COLUMNS ( $column_names)+ ) fk_clause ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:476:22: FOREIGN KEY LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN fk_clause
            {
            FOREIGN398=(Token)match(input,FOREIGN,FOLLOW_FOREIGN_in_table_constraint_fk3472);  
            stream_FOREIGN.add(FOREIGN398);


            KEY399=(Token)match(input,KEY,FOLLOW_KEY_in_table_constraint_fk3474);  
            stream_KEY.add(KEY399);


            LPAREN400=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_table_constraint_fk3476);  
            stream_LPAREN.add(LPAREN400);


            pushFollow(FOLLOW_id_in_table_constraint_fk3480);
            column_names=id();

            state._fsp--;

            stream_id.add(column_names.getTree());
            if (list_column_names==null) list_column_names=new ArrayList();
            list_column_names.add(column_names.getTree());


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:476:58: ( COMMA column_names+= id )*
            loop146:
            do {
                int alt146=2;
                int LA146_0 = input.LA(1);

                if ( (LA146_0==COMMA) ) {
                    alt146=1;
                }


                switch (alt146) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:476:59: COMMA column_names+= id
            	    {
            	    COMMA401=(Token)match(input,COMMA,FOLLOW_COMMA_in_table_constraint_fk3483);  
            	    stream_COMMA.add(COMMA401);


            	    pushFollow(FOLLOW_id_in_table_constraint_fk3487);
            	    column_names=id();

            	    state._fsp--;

            	    stream_id.add(column_names.getTree());
            	    if (list_column_names==null) list_column_names=new ArrayList();
            	    list_column_names.add(column_names.getTree());


            	    }
            	    break;

            	default :
            	    break loop146;
                }
            } while (true);


            RPAREN402=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_table_constraint_fk3491);  
            stream_RPAREN.add(RPAREN402);


            pushFollow(FOLLOW_fk_clause_in_table_constraint_fk3493);
            fk_clause403=fk_clause();

            state._fsp--;

            stream_fk_clause.add(fk_clause403.getTree());

            // AST REWRITE
            // elements: FOREIGN, column_names, fk_clause
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: column_names
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_column_names=new RewriteRuleSubtreeStream(adaptor,"token column_names",list_column_names);
            root_0 = (Object)adaptor.nil();
            // 477:50: -> ^( FOREIGN ^( COLUMNS ( $column_names)+ ) fk_clause )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:477:4: ^( FOREIGN ^( COLUMNS ( $column_names)+ ) fk_clause )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_FOREIGN.nextNode()
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:477:14: ^( COLUMNS ( $column_names)+ )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMNS, "COLUMNS")
                , root_2);

                if ( !(stream_column_names.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_column_names.hasNext() ) {
                    adaptor.addChild(root_2, stream_column_names.nextTree());

                }
                stream_column_names.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_1, stream_fk_clause.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "table_constraint_fk"


    public static class fk_clause_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fk_clause"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:1: fk_clause : REFERENCES foreign_table= id ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( fk_clause_action )* ( fk_clause_deferrable )? -> ^( REFERENCES $foreign_table ^( COLUMNS ( $column_names)+ ) ( fk_clause_action )* ( fk_clause_deferrable )? ) ;
    public final SqlParser.fk_clause_return fk_clause() throws RecognitionException {
        SqlParser.fk_clause_return retval = new SqlParser.fk_clause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REFERENCES404=null;
        Token LPAREN405=null;
        Token COMMA406=null;
        Token RPAREN407=null;
        List list_column_names=null;
        SqlParser.id_return foreign_table =null;

        SqlParser.fk_clause_action_return fk_clause_action408 =null;

        SqlParser.fk_clause_deferrable_return fk_clause_deferrable409 =null;

        RuleReturnScope column_names = null;
        Object REFERENCES404_tree=null;
        Object LPAREN405_tree=null;
        Object COMMA406_tree=null;
        Object RPAREN407_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_REFERENCES=new RewriteRuleTokenStream(adaptor,"token REFERENCES");
        RewriteRuleSubtreeStream stream_fk_clause_action=new RewriteRuleSubtreeStream(adaptor,"rule fk_clause_action");
        RewriteRuleSubtreeStream stream_fk_clause_deferrable=new RewriteRuleSubtreeStream(adaptor,"rule fk_clause_deferrable");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:10: ( REFERENCES foreign_table= id ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( fk_clause_action )* ( fk_clause_deferrable )? -> ^( REFERENCES $foreign_table ^( COLUMNS ( $column_names)+ ) ( fk_clause_action )* ( fk_clause_deferrable )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:12: REFERENCES foreign_table= id ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )? ( fk_clause_action )* ( fk_clause_deferrable )?
            {
            REFERENCES404=(Token)match(input,REFERENCES,FOLLOW_REFERENCES_in_fk_clause3516);  
            stream_REFERENCES.add(REFERENCES404);


            pushFollow(FOLLOW_id_in_fk_clause3520);
            foreign_table=id();

            state._fsp--;

            stream_id.add(foreign_table.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:40: ( LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN )?
            int alt148=2;
            int LA148_0 = input.LA(1);

            if ( (LA148_0==LPAREN) ) {
                alt148=1;
            }
            switch (alt148) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:41: LPAREN column_names+= id ( COMMA column_names+= id )* RPAREN
                    {
                    LPAREN405=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_fk_clause3523);  
                    stream_LPAREN.add(LPAREN405);


                    pushFollow(FOLLOW_id_in_fk_clause3527);
                    column_names=id();

                    state._fsp--;

                    stream_id.add(column_names.getTree());
                    if (list_column_names==null) list_column_names=new ArrayList();
                    list_column_names.add(column_names.getTree());


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:65: ( COMMA column_names+= id )*
                    loop147:
                    do {
                        int alt147=2;
                        int LA147_0 = input.LA(1);

                        if ( (LA147_0==COMMA) ) {
                            alt147=1;
                        }


                        switch (alt147) {
                    	case 1 :
                    	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:479:66: COMMA column_names+= id
                    	    {
                    	    COMMA406=(Token)match(input,COMMA,FOLLOW_COMMA_in_fk_clause3530);  
                    	    stream_COMMA.add(COMMA406);


                    	    pushFollow(FOLLOW_id_in_fk_clause3534);
                    	    column_names=id();

                    	    state._fsp--;

                    	    stream_id.add(column_names.getTree());
                    	    if (list_column_names==null) list_column_names=new ArrayList();
                    	    list_column_names.add(column_names.getTree());


                    	    }
                    	    break;

                    	default :
                    	    break loop147;
                        }
                    } while (true);


                    RPAREN407=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_fk_clause3538);  
                    stream_RPAREN.add(RPAREN407);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:480:3: ( fk_clause_action )*
            loop149:
            do {
                int alt149=2;
                int LA149_0 = input.LA(1);

                if ( (LA149_0==MATCH||LA149_0==ON) ) {
                    alt149=1;
                }


                switch (alt149) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:480:3: fk_clause_action
            	    {
            	    pushFollow(FOLLOW_fk_clause_action_in_fk_clause3544);
            	    fk_clause_action408=fk_clause_action();

            	    state._fsp--;

            	    stream_fk_clause_action.add(fk_clause_action408.getTree());

            	    }
            	    break;

            	default :
            	    break loop149;
                }
            } while (true);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:480:21: ( fk_clause_deferrable )?
            int alt150=2;
            int LA150_0 = input.LA(1);

            if ( (LA150_0==NOT) ) {
                int LA150_1 = input.LA(2);

                if ( (LA150_1==DEFERRABLE) ) {
                    alt150=1;
                }
            }
            else if ( (LA150_0==DEFERRABLE) ) {
                alt150=1;
            }
            switch (alt150) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:480:21: fk_clause_deferrable
                    {
                    pushFollow(FOLLOW_fk_clause_deferrable_in_fk_clause3547);
                    fk_clause_deferrable409=fk_clause_deferrable();

                    state._fsp--;

                    stream_fk_clause_deferrable.add(fk_clause_deferrable409.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: fk_clause_deferrable, REFERENCES, fk_clause_action, foreign_table, column_names
            // token labels: 
            // rule labels: foreign_table, retval
            // token list labels: 
            // rule list labels: column_names
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_foreign_table=new RewriteRuleSubtreeStream(adaptor,"rule foreign_table",foreign_table!=null?foreign_table.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_column_names=new RewriteRuleSubtreeStream(adaptor,"token column_names",list_column_names);
            root_0 = (Object)adaptor.nil();
            // 481:98: -> ^( REFERENCES $foreign_table ^( COLUMNS ( $column_names)+ ) ( fk_clause_action )* ( fk_clause_deferrable )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:481:4: ^( REFERENCES $foreign_table ^( COLUMNS ( $column_names)+ ) ( fk_clause_action )* ( fk_clause_deferrable )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                stream_REFERENCES.nextNode()
                , root_1);

                adaptor.addChild(root_1, stream_foreign_table.nextTree());

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:481:32: ^( COLUMNS ( $column_names)+ )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(COLUMNS, "COLUMNS")
                , root_2);

                if ( !(stream_column_names.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_column_names.hasNext() ) {
                    adaptor.addChild(root_2, stream_column_names.nextTree());

                }
                stream_column_names.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:481:58: ( fk_clause_action )*
                while ( stream_fk_clause_action.hasNext() ) {
                    adaptor.addChild(root_1, stream_fk_clause_action.nextTree());

                }
                stream_fk_clause_action.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:481:76: ( fk_clause_deferrable )?
                if ( stream_fk_clause_deferrable.hasNext() ) {
                    adaptor.addChild(root_1, stream_fk_clause_deferrable.nextTree());

                }
                stream_fk_clause_deferrable.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fk_clause"


    public static class fk_clause_action_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fk_clause_action"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:483:1: fk_clause_action : ( ON ^ ( DELETE | UPDATE | INSERT ) ( SET ! NULL | SET ! DEFAULT | CASCADE | RESTRICT ) | MATCH ^ id );
    public final SqlParser.fk_clause_action_return fk_clause_action() throws RecognitionException {
        SqlParser.fk_clause_action_return retval = new SqlParser.fk_clause_action_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ON410=null;
        Token set411=null;
        Token SET412=null;
        Token NULL413=null;
        Token SET414=null;
        Token DEFAULT415=null;
        Token CASCADE416=null;
        Token RESTRICT417=null;
        Token MATCH418=null;
        SqlParser.id_return id419 =null;


        Object ON410_tree=null;
        Object set411_tree=null;
        Object SET412_tree=null;
        Object NULL413_tree=null;
        Object SET414_tree=null;
        Object DEFAULT415_tree=null;
        Object CASCADE416_tree=null;
        Object RESTRICT417_tree=null;
        Object MATCH418_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:3: ( ON ^ ( DELETE | UPDATE | INSERT ) ( SET ! NULL | SET ! DEFAULT | CASCADE | RESTRICT ) | MATCH ^ id )
            int alt152=2;
            int LA152_0 = input.LA(1);

            if ( (LA152_0==ON) ) {
                alt152=1;
            }
            else if ( (LA152_0==MATCH) ) {
                alt152=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 152, 0, input);

                throw nvae;

            }
            switch (alt152) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:5: ON ^ ( DELETE | UPDATE | INSERT ) ( SET ! NULL | SET ! DEFAULT | CASCADE | RESTRICT )
                    {
                    root_0 = (Object)adaptor.nil();


                    ON410=(Token)match(input,ON,FOLLOW_ON_in_fk_clause_action3581); 
                    ON410_tree = 
                    (Object)adaptor.create(ON410)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(ON410_tree, root_0);


                    set411=(Token)input.LT(1);

                    if ( input.LA(1)==DELETE||input.LA(1)==INSERT||input.LA(1)==UPDATE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(set411)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:36: ( SET ! NULL | SET ! DEFAULT | CASCADE | RESTRICT )
                    int alt151=4;
                    switch ( input.LA(1) ) {
                    case SET:
                        {
                        int LA151_1 = input.LA(2);

                        if ( (LA151_1==NULL) ) {
                            alt151=1;
                        }
                        else if ( (LA151_1==DEFAULT) ) {
                            alt151=2;
                        }
                        else {
                            NoViableAltException nvae =
                                new NoViableAltException("", 151, 1, input);

                            throw nvae;

                        }
                        }
                        break;
                    case CASCADE:
                        {
                        alt151=3;
                        }
                        break;
                    case RESTRICT:
                        {
                        alt151=4;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 151, 0, input);

                        throw nvae;

                    }

                    switch (alt151) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:37: SET ! NULL
                            {
                            SET412=(Token)match(input,SET,FOLLOW_SET_in_fk_clause_action3597); 

                            NULL413=(Token)match(input,NULL,FOLLOW_NULL_in_fk_clause_action3600); 
                            NULL413_tree = 
                            (Object)adaptor.create(NULL413)
                            ;
                            adaptor.addChild(root_0, NULL413_tree);


                            }
                            break;
                        case 2 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:49: SET ! DEFAULT
                            {
                            SET414=(Token)match(input,SET,FOLLOW_SET_in_fk_clause_action3604); 

                            DEFAULT415=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_fk_clause_action3607); 
                            DEFAULT415_tree = 
                            (Object)adaptor.create(DEFAULT415)
                            ;
                            adaptor.addChild(root_0, DEFAULT415_tree);


                            }
                            break;
                        case 3 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:64: CASCADE
                            {
                            CASCADE416=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_fk_clause_action3611); 
                            CASCADE416_tree = 
                            (Object)adaptor.create(CASCADE416)
                            ;
                            adaptor.addChild(root_0, CASCADE416_tree);


                            }
                            break;
                        case 4 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:484:74: RESTRICT
                            {
                            RESTRICT417=(Token)match(input,RESTRICT,FOLLOW_RESTRICT_in_fk_clause_action3615); 
                            RESTRICT417_tree = 
                            (Object)adaptor.create(RESTRICT417)
                            ;
                            adaptor.addChild(root_0, RESTRICT417_tree);


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:485:5: MATCH ^ id
                    {
                    root_0 = (Object)adaptor.nil();


                    MATCH418=(Token)match(input,MATCH,FOLLOW_MATCH_in_fk_clause_action3622); 
                    MATCH418_tree = 
                    (Object)adaptor.create(MATCH418)
                    ;
                    root_0 = (Object)adaptor.becomeRoot(MATCH418_tree, root_0);


                    pushFollow(FOLLOW_id_in_fk_clause_action3625);
                    id419=id();

                    state._fsp--;

                    adaptor.addChild(root_0, id419.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fk_clause_action"


    public static class fk_clause_deferrable_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fk_clause_deferrable"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:1: fk_clause_deferrable : ( NOT )? DEFERRABLE ^ ( INITIALLY ! DEFERRED | INITIALLY ! IMMEDIATE )? ;
    public final SqlParser.fk_clause_deferrable_return fk_clause_deferrable() throws RecognitionException {
        SqlParser.fk_clause_deferrable_return retval = new SqlParser.fk_clause_deferrable_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token NOT420=null;
        Token DEFERRABLE421=null;
        Token INITIALLY422=null;
        Token DEFERRED423=null;
        Token INITIALLY424=null;
        Token IMMEDIATE425=null;

        Object NOT420_tree=null;
        Object DEFERRABLE421_tree=null;
        Object INITIALLY422_tree=null;
        Object DEFERRED423_tree=null;
        Object INITIALLY424_tree=null;
        Object IMMEDIATE425_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:21: ( ( NOT )? DEFERRABLE ^ ( INITIALLY ! DEFERRED | INITIALLY ! IMMEDIATE )? )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:23: ( NOT )? DEFERRABLE ^ ( INITIALLY ! DEFERRED | INITIALLY ! IMMEDIATE )?
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:23: ( NOT )?
            int alt153=2;
            int LA153_0 = input.LA(1);

            if ( (LA153_0==NOT) ) {
                alt153=1;
            }
            switch (alt153) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:24: NOT
                    {
                    NOT420=(Token)match(input,NOT,FOLLOW_NOT_in_fk_clause_deferrable3633); 
                    NOT420_tree = 
                    (Object)adaptor.create(NOT420)
                    ;
                    adaptor.addChild(root_0, NOT420_tree);


                    }
                    break;

            }


            DEFERRABLE421=(Token)match(input,DEFERRABLE,FOLLOW_DEFERRABLE_in_fk_clause_deferrable3637); 
            DEFERRABLE421_tree = 
            (Object)adaptor.create(DEFERRABLE421)
            ;
            root_0 = (Object)adaptor.becomeRoot(DEFERRABLE421_tree, root_0);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:42: ( INITIALLY ! DEFERRED | INITIALLY ! IMMEDIATE )?
            int alt154=3;
            int LA154_0 = input.LA(1);

            if ( (LA154_0==INITIALLY) ) {
                int LA154_1 = input.LA(2);

                if ( (LA154_1==DEFERRED) ) {
                    alt154=1;
                }
                else if ( (LA154_1==IMMEDIATE) ) {
                    alt154=2;
                }
            }
            switch (alt154) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:43: INITIALLY ! DEFERRED
                    {
                    INITIALLY422=(Token)match(input,INITIALLY,FOLLOW_INITIALLY_in_fk_clause_deferrable3641); 

                    DEFERRED423=(Token)match(input,DEFERRED,FOLLOW_DEFERRED_in_fk_clause_deferrable3644); 
                    DEFERRED423_tree = 
                    (Object)adaptor.create(DEFERRED423)
                    ;
                    adaptor.addChild(root_0, DEFERRED423_tree);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:487:65: INITIALLY ! IMMEDIATE
                    {
                    INITIALLY424=(Token)match(input,INITIALLY,FOLLOW_INITIALLY_in_fk_clause_deferrable3648); 

                    IMMEDIATE425=(Token)match(input,IMMEDIATE,FOLLOW_IMMEDIATE_in_fk_clause_deferrable3651); 
                    IMMEDIATE425_tree = 
                    (Object)adaptor.create(IMMEDIATE425)
                    ;
                    adaptor.addChild(root_0, IMMEDIATE425_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fk_clause_deferrable"


    public static class drop_table_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "drop_table_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:1: drop_table_stmt : DROP TABLE ( IF EXISTS )? (database_name= id DOT )? table_name= id -> ^( DROP_TABLE ^( OPTIONS ( EXISTS )? ) ^( $table_name ( $database_name)? ) ) ;
    public final SqlParser.drop_table_stmt_return drop_table_stmt() throws RecognitionException {
        SqlParser.drop_table_stmt_return retval = new SqlParser.drop_table_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DROP426=null;
        Token TABLE427=null;
        Token IF428=null;
        Token EXISTS429=null;
        Token DOT430=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;


        Object DROP426_tree=null;
        Object TABLE427_tree=null;
        Object IF428_tree=null;
        Object EXISTS429_tree=null;
        Object DOT430_tree=null;
        RewriteRuleTokenStream stream_TABLE=new RewriteRuleTokenStream(adaptor,"token TABLE");
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleTokenStream stream_DROP=new RewriteRuleTokenStream(adaptor,"token DROP");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:16: ( DROP TABLE ( IF EXISTS )? (database_name= id DOT )? table_name= id -> ^( DROP_TABLE ^( OPTIONS ( EXISTS )? ) ^( $table_name ( $database_name)? ) ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:18: DROP TABLE ( IF EXISTS )? (database_name= id DOT )? table_name= id
            {
            DROP426=(Token)match(input,DROP,FOLLOW_DROP_in_drop_table_stmt3661);  
            stream_DROP.add(DROP426);


            TABLE427=(Token)match(input,TABLE,FOLLOW_TABLE_in_drop_table_stmt3663);  
            stream_TABLE.add(TABLE427);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:29: ( IF EXISTS )?
            int alt155=2;
            int LA155_0 = input.LA(1);

            if ( (LA155_0==IF) ) {
                int LA155_1 = input.LA(2);

                if ( (LA155_1==EXISTS) ) {
                    alt155=1;
                }
            }
            switch (alt155) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:30: IF EXISTS
                    {
                    IF428=(Token)match(input,IF,FOLLOW_IF_in_drop_table_stmt3666);  
                    stream_IF.add(IF428);


                    EXISTS429=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_stmt3668);  
                    stream_EXISTS.add(EXISTS429);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:42: (database_name= id DOT )?
            int alt156=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA156_1 = input.LA(2);

                    if ( (LA156_1==DOT) ) {
                        alt156=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA156_2 = input.LA(2);

                    if ( (LA156_2==DOT) ) {
                        alt156=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA156_3 = input.LA(2);

                    if ( (LA156_3==DOT) ) {
                        alt156=1;
                    }
                    }
                    break;
            }

            switch (alt156) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:490:43: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_drop_table_stmt3675);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT430=(Token)match(input,DOT,FOLLOW_DOT_in_drop_table_stmt3677);  
                    stream_DOT.add(DOT430);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_drop_table_stmt3683);
            table_name=id();

            state._fsp--;

            stream_id.add(table_name.getTree());

            // AST REWRITE
            // elements: database_name, EXISTS, table_name
            // token labels: 
            // rule labels: database_name, table_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 491:67: -> ^( DROP_TABLE ^( OPTIONS ( EXISTS )? ) ^( $table_name ( $database_name)? ) )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:491:4: ^( DROP_TABLE ^( OPTIONS ( EXISTS )? ) ^( $table_name ( $database_name)? ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(DROP_TABLE, "DROP_TABLE")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:491:17: ^( OPTIONS ( EXISTS )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:491:27: ( EXISTS )?
                if ( stream_EXISTS.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_EXISTS.nextNode()
                    );

                }
                stream_EXISTS.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:491:36: ^( $table_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_table_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:491:51: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "drop_table_stmt"


    public static class alter_table_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alter_table_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:1: alter_table_stmt : ALTER TABLE (database_name= id DOT )? table_name= id ( RENAME TO new_table_name= id | ADD ( COLUMN )? column_def ) ;
    public final SqlParser.alter_table_stmt_return alter_table_stmt() throws RecognitionException {
        SqlParser.alter_table_stmt_return retval = new SqlParser.alter_table_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token ALTER431=null;
        Token TABLE432=null;
        Token DOT433=null;
        Token RENAME434=null;
        Token TO435=null;
        Token ADD436=null;
        Token COLUMN437=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.id_return new_table_name =null;

        SqlParser.column_def_return column_def438 =null;


        Object ALTER431_tree=null;
        Object TABLE432_tree=null;
        Object DOT433_tree=null;
        Object RENAME434_tree=null;
        Object TO435_tree=null;
        Object ADD436_tree=null;
        Object COLUMN437_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:17: ( ALTER TABLE (database_name= id DOT )? table_name= id ( RENAME TO new_table_name= id | ADD ( COLUMN )? column_def ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:19: ALTER TABLE (database_name= id DOT )? table_name= id ( RENAME TO new_table_name= id | ADD ( COLUMN )? column_def )
            {
            root_0 = (Object)adaptor.nil();


            ALTER431=(Token)match(input,ALTER,FOLLOW_ALTER_in_alter_table_stmt3713); 
            ALTER431_tree = 
            (Object)adaptor.create(ALTER431)
            ;
            adaptor.addChild(root_0, ALTER431_tree);


            TABLE432=(Token)match(input,TABLE,FOLLOW_TABLE_in_alter_table_stmt3715); 
            TABLE432_tree = 
            (Object)adaptor.create(TABLE432)
            ;
            adaptor.addChild(root_0, TABLE432_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:31: (database_name= id DOT )?
            int alt157=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA157_1 = input.LA(2);

                    if ( (LA157_1==DOT) ) {
                        alt157=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA157_2 = input.LA(2);

                    if ( (LA157_2==DOT) ) {
                        alt157=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA157_3 = input.LA(2);

                    if ( (LA157_3==DOT) ) {
                        alt157=1;
                    }
                    }
                    break;
            }

            switch (alt157) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:32: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_alter_table_stmt3720);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT433=(Token)match(input,DOT,FOLLOW_DOT_in_alter_table_stmt3722); 
                    DOT433_tree = 
                    (Object)adaptor.create(DOT433)
                    ;
                    adaptor.addChild(root_0, DOT433_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_alter_table_stmt3728);
            table_name=id();

            state._fsp--;

            adaptor.addChild(root_0, table_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:69: ( RENAME TO new_table_name= id | ADD ( COLUMN )? column_def )
            int alt159=2;
            int LA159_0 = input.LA(1);

            if ( (LA159_0==RENAME) ) {
                alt159=1;
            }
            else if ( (LA159_0==ADD) ) {
                alt159=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 159, 0, input);

                throw nvae;

            }
            switch (alt159) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:70: RENAME TO new_table_name= id
                    {
                    RENAME434=(Token)match(input,RENAME,FOLLOW_RENAME_in_alter_table_stmt3731); 
                    RENAME434_tree = 
                    (Object)adaptor.create(RENAME434)
                    ;
                    adaptor.addChild(root_0, RENAME434_tree);


                    TO435=(Token)match(input,TO,FOLLOW_TO_in_alter_table_stmt3733); 
                    TO435_tree = 
                    (Object)adaptor.create(TO435)
                    ;
                    adaptor.addChild(root_0, TO435_tree);


                    pushFollow(FOLLOW_id_in_alter_table_stmt3737);
                    new_table_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, new_table_name.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:100: ADD ( COLUMN )? column_def
                    {
                    ADD436=(Token)match(input,ADD,FOLLOW_ADD_in_alter_table_stmt3741); 
                    ADD436_tree = 
                    (Object)adaptor.create(ADD436)
                    ;
                    adaptor.addChild(root_0, ADD436_tree);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:104: ( COLUMN )?
                    int alt158=2;
                    int LA158_0 = input.LA(1);

                    if ( (LA158_0==COLUMN) ) {
                        alt158=1;
                    }
                    switch (alt158) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:494:105: COLUMN
                            {
                            COLUMN437=(Token)match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_stmt3744); 
                            COLUMN437_tree = 
                            (Object)adaptor.create(COLUMN437)
                            ;
                            adaptor.addChild(root_0, COLUMN437_tree);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_column_def_in_alter_table_stmt3748);
                    column_def438=column_def();

                    state._fsp--;

                    adaptor.addChild(root_0, column_def438.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alter_table_stmt"


    public static class create_view_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "create_view_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:1: create_view_stmt : CREATE ( TEMPORARY )? VIEW ( IF NOT EXISTS )? (database_name= id DOT )? view_name= id AS t= select_stmt -> ^( CREATE_VIEW ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $view_name ( $database_name)? ) ^( STATEMENT $t) ) ;
    public final SqlParser.create_view_stmt_return create_view_stmt() throws RecognitionException {
        SqlParser.create_view_stmt_return retval = new SqlParser.create_view_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CREATE439=null;
        Token TEMPORARY440=null;
        Token VIEW441=null;
        Token IF442=null;
        Token NOT443=null;
        Token EXISTS444=null;
        Token DOT445=null;
        Token AS446=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return view_name =null;

        SqlParser.select_stmt_return t =null;


        Object CREATE439_tree=null;
        Object TEMPORARY440_tree=null;
        Object VIEW441_tree=null;
        Object IF442_tree=null;
        Object NOT443_tree=null;
        Object EXISTS444_tree=null;
        Object DOT445_tree=null;
        Object AS446_tree=null;
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
        RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token TEMPORARY");
        RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_select_stmt=new RewriteRuleSubtreeStream(adaptor,"rule select_stmt");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:17: ( CREATE ( TEMPORARY )? VIEW ( IF NOT EXISTS )? (database_name= id DOT )? view_name= id AS t= select_stmt -> ^( CREATE_VIEW ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $view_name ( $database_name)? ) ^( STATEMENT $t) ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:19: CREATE ( TEMPORARY )? VIEW ( IF NOT EXISTS )? (database_name= id DOT )? view_name= id AS t= select_stmt
            {
            CREATE439=(Token)match(input,CREATE,FOLLOW_CREATE_in_create_view_stmt3757);  
            stream_CREATE.add(CREATE439);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:26: ( TEMPORARY )?
            int alt160=2;
            int LA160_0 = input.LA(1);

            if ( (LA160_0==TEMPORARY) ) {
                alt160=1;
            }
            switch (alt160) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:26: TEMPORARY
                    {
                    TEMPORARY440=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_view_stmt3759);  
                    stream_TEMPORARY.add(TEMPORARY440);


                    }
                    break;

            }


            VIEW441=(Token)match(input,VIEW,FOLLOW_VIEW_in_create_view_stmt3762);  
            stream_VIEW.add(VIEW441);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:42: ( IF NOT EXISTS )?
            int alt161=2;
            int LA161_0 = input.LA(1);

            if ( (LA161_0==IF) ) {
                int LA161_1 = input.LA(2);

                if ( (LA161_1==NOT) ) {
                    alt161=1;
                }
            }
            switch (alt161) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:43: IF NOT EXISTS
                    {
                    IF442=(Token)match(input,IF,FOLLOW_IF_in_create_view_stmt3765);  
                    stream_IF.add(IF442);


                    NOT443=(Token)match(input,NOT,FOLLOW_NOT_in_create_view_stmt3767);  
                    stream_NOT.add(NOT443);


                    EXISTS444=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_stmt3769);  
                    stream_EXISTS.add(EXISTS444);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:59: (database_name= id DOT )?
            int alt162=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA162_1 = input.LA(2);

                    if ( (LA162_1==DOT) ) {
                        alt162=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA162_2 = input.LA(2);

                    if ( (LA162_2==DOT) ) {
                        alt162=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA162_3 = input.LA(2);

                    if ( (LA162_3==DOT) ) {
                        alt162=1;
                    }
                    }
                    break;
            }

            switch (alt162) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:497:60: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_create_view_stmt3776);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT445=(Token)match(input,DOT,FOLLOW_DOT_in_create_view_stmt3778);  
                    stream_DOT.add(DOT445);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_create_view_stmt3784);
            view_name=id();

            state._fsp--;

            stream_id.add(view_name.getTree());

            AS446=(Token)match(input,AS,FOLLOW_AS_in_create_view_stmt3786);  
            stream_AS.add(AS446);


            pushFollow(FOLLOW_select_stmt_in_create_view_stmt3790);
            t=select_stmt();

            state._fsp--;

            stream_select_stmt.add(t.getTree());

            // AST REWRITE
            // elements: EXISTS, view_name, database_name, t, TEMPORARY
            // token labels: 
            // rule labels: database_name, t, retval, view_name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_t=new RewriteRuleSubtreeStream(adaptor,"rule t",t!=null?t.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_view_name=new RewriteRuleSubtreeStream(adaptor,"rule view_name",view_name!=null?view_name.tree:null);

            root_0 = (Object)adaptor.nil();
            // 498:94: -> ^( CREATE_VIEW ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $view_name ( $database_name)? ) ^( STATEMENT $t) )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:4: ^( CREATE_VIEW ^( OPTIONS ( TEMPORARY )? ( EXISTS )? ) ^( $view_name ( $database_name)? ) ^( STATEMENT $t) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CREATE_VIEW, "CREATE_VIEW")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:18: ^( OPTIONS ( TEMPORARY )? ( EXISTS )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:28: ( TEMPORARY )?
                if ( stream_TEMPORARY.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_TEMPORARY.nextNode()
                    );

                }
                stream_TEMPORARY.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:39: ( EXISTS )?
                if ( stream_EXISTS.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_EXISTS.nextNode()
                    );

                }
                stream_EXISTS.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:48: ^( $view_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_view_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:62: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:498:78: ^( STATEMENT $t)
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(STATEMENT, "STATEMENT")
                , root_2);

                adaptor.addChild(root_2, stream_t.nextTree());

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "create_view_stmt"


    public static class drop_view_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "drop_view_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:1: drop_view_stmt : DROP VIEW ( IF EXISTS )? (database_name= id DOT )? view_name= id ;
    public final SqlParser.drop_view_stmt_return drop_view_stmt() throws RecognitionException {
        SqlParser.drop_view_stmt_return retval = new SqlParser.drop_view_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DROP447=null;
        Token VIEW448=null;
        Token IF449=null;
        Token EXISTS450=null;
        Token DOT451=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return view_name =null;


        Object DROP447_tree=null;
        Object VIEW448_tree=null;
        Object IF449_tree=null;
        Object EXISTS450_tree=null;
        Object DOT451_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:15: ( DROP VIEW ( IF EXISTS )? (database_name= id DOT )? view_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:17: DROP VIEW ( IF EXISTS )? (database_name= id DOT )? view_name= id
            {
            root_0 = (Object)adaptor.nil();


            DROP447=(Token)match(input,DROP,FOLLOW_DROP_in_drop_view_stmt3831); 
            DROP447_tree = 
            (Object)adaptor.create(DROP447)
            ;
            adaptor.addChild(root_0, DROP447_tree);


            VIEW448=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_view_stmt3833); 
            VIEW448_tree = 
            (Object)adaptor.create(VIEW448)
            ;
            adaptor.addChild(root_0, VIEW448_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:27: ( IF EXISTS )?
            int alt163=2;
            int LA163_0 = input.LA(1);

            if ( (LA163_0==IF) ) {
                int LA163_1 = input.LA(2);

                if ( (LA163_1==EXISTS) ) {
                    alt163=1;
                }
            }
            switch (alt163) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:28: IF EXISTS
                    {
                    IF449=(Token)match(input,IF,FOLLOW_IF_in_drop_view_stmt3836); 
                    IF449_tree = 
                    (Object)adaptor.create(IF449)
                    ;
                    adaptor.addChild(root_0, IF449_tree);


                    EXISTS450=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_view_stmt3838); 
                    EXISTS450_tree = 
                    (Object)adaptor.create(EXISTS450)
                    ;
                    adaptor.addChild(root_0, EXISTS450_tree);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:40: (database_name= id DOT )?
            int alt164=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA164_1 = input.LA(2);

                    if ( (LA164_1==DOT) ) {
                        alt164=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA164_2 = input.LA(2);

                    if ( (LA164_2==DOT) ) {
                        alt164=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA164_3 = input.LA(2);

                    if ( (LA164_3==DOT) ) {
                        alt164=1;
                    }
                    }
                    break;
            }

            switch (alt164) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:502:41: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_drop_view_stmt3845);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT451=(Token)match(input,DOT,FOLLOW_DOT_in_drop_view_stmt3847); 
                    DOT451_tree = 
                    (Object)adaptor.create(DOT451)
                    ;
                    adaptor.addChild(root_0, DOT451_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_drop_view_stmt3853);
            view_name=id();

            state._fsp--;

            adaptor.addChild(root_0, view_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "drop_view_stmt"


    public static class create_index_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "create_index_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:1: create_index_stmt : CREATE ( UNIQUE )? INDEX ( IF NOT EXISTS )? (database_name= id DOT )? index_name= id ON table_name= id LPAREN columns+= indexed_column ( COMMA columns+= indexed_column )* RPAREN -> ^( CREATE_INDEX ^( OPTIONS ( UNIQUE )? ( EXISTS )? ) ^( $index_name ( $database_name)? ) $table_name ( ^( COLUMNS ( $columns)+ ) )? ) ;
    public final SqlParser.create_index_stmt_return create_index_stmt() throws RecognitionException {
        SqlParser.create_index_stmt_return retval = new SqlParser.create_index_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CREATE452=null;
        Token UNIQUE453=null;
        Token INDEX454=null;
        Token IF455=null;
        Token NOT456=null;
        Token EXISTS457=null;
        Token DOT458=null;
        Token ON459=null;
        Token LPAREN460=null;
        Token COMMA461=null;
        Token RPAREN462=null;
        List list_columns=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return index_name =null;

        SqlParser.id_return table_name =null;

        RuleReturnScope columns = null;
        Object CREATE452_tree=null;
        Object UNIQUE453_tree=null;
        Object INDEX454_tree=null;
        Object IF455_tree=null;
        Object NOT456_tree=null;
        Object EXISTS457_tree=null;
        Object DOT458_tree=null;
        Object ON459_tree=null;
        Object LPAREN460_tree=null;
        Object COMMA461_tree=null;
        Object RPAREN462_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_UNIQUE=new RewriteRuleTokenStream(adaptor,"token UNIQUE");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_INDEX=new RewriteRuleTokenStream(adaptor,"token INDEX");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleTokenStream stream_ON=new RewriteRuleTokenStream(adaptor,"token ON");
        RewriteRuleSubtreeStream stream_indexed_column=new RewriteRuleSubtreeStream(adaptor,"rule indexed_column");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:18: ( CREATE ( UNIQUE )? INDEX ( IF NOT EXISTS )? (database_name= id DOT )? index_name= id ON table_name= id LPAREN columns+= indexed_column ( COMMA columns+= indexed_column )* RPAREN -> ^( CREATE_INDEX ^( OPTIONS ( UNIQUE )? ( EXISTS )? ) ^( $index_name ( $database_name)? ) $table_name ( ^( COLUMNS ( $columns)+ ) )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:20: CREATE ( UNIQUE )? INDEX ( IF NOT EXISTS )? (database_name= id DOT )? index_name= id ON table_name= id LPAREN columns+= indexed_column ( COMMA columns+= indexed_column )* RPAREN
            {
            CREATE452=(Token)match(input,CREATE,FOLLOW_CREATE_in_create_index_stmt3861);  
            stream_CREATE.add(CREATE452);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:27: ( UNIQUE )?
            int alt165=2;
            int LA165_0 = input.LA(1);

            if ( (LA165_0==UNIQUE) ) {
                alt165=1;
            }
            switch (alt165) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:28: UNIQUE
                    {
                    UNIQUE453=(Token)match(input,UNIQUE,FOLLOW_UNIQUE_in_create_index_stmt3864);  
                    stream_UNIQUE.add(UNIQUE453);


                    }
                    break;

            }


            INDEX454=(Token)match(input,INDEX,FOLLOW_INDEX_in_create_index_stmt3868);  
            stream_INDEX.add(INDEX454);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:43: ( IF NOT EXISTS )?
            int alt166=2;
            int LA166_0 = input.LA(1);

            if ( (LA166_0==IF) ) {
                int LA166_1 = input.LA(2);

                if ( (LA166_1==NOT) ) {
                    alt166=1;
                }
            }
            switch (alt166) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:44: IF NOT EXISTS
                    {
                    IF455=(Token)match(input,IF,FOLLOW_IF_in_create_index_stmt3871);  
                    stream_IF.add(IF455);


                    NOT456=(Token)match(input,NOT,FOLLOW_NOT_in_create_index_stmt3873);  
                    stream_NOT.add(NOT456);


                    EXISTS457=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_stmt3875);  
                    stream_EXISTS.add(EXISTS457);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:60: (database_name= id DOT )?
            int alt167=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA167_1 = input.LA(2);

                    if ( (LA167_1==DOT) ) {
                        alt167=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA167_2 = input.LA(2);

                    if ( (LA167_2==DOT) ) {
                        alt167=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA167_3 = input.LA(2);

                    if ( (LA167_3==DOT) ) {
                        alt167=1;
                    }
                    }
                    break;
            }

            switch (alt167) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:505:61: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_create_index_stmt3882);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT458=(Token)match(input,DOT,FOLLOW_DOT_in_create_index_stmt3884);  
                    stream_DOT.add(DOT458);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_create_index_stmt3890);
            index_name=id();

            state._fsp--;

            stream_id.add(index_name.getTree());

            ON459=(Token)match(input,ON,FOLLOW_ON_in_create_index_stmt3894);  
            stream_ON.add(ON459);


            pushFollow(FOLLOW_id_in_create_index_stmt3898);
            table_name=id();

            state._fsp--;

            stream_id.add(table_name.getTree());

            LPAREN460=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_create_index_stmt3900);  
            stream_LPAREN.add(LPAREN460);


            pushFollow(FOLLOW_indexed_column_in_create_index_stmt3904);
            columns=indexed_column();

            state._fsp--;

            stream_indexed_column.add(columns.getTree());
            if (list_columns==null) list_columns=new ArrayList();
            list_columns.add(columns.getTree());


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:506:51: ( COMMA columns+= indexed_column )*
            loop168:
            do {
                int alt168=2;
                int LA168_0 = input.LA(1);

                if ( (LA168_0==COMMA) ) {
                    alt168=1;
                }


                switch (alt168) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:506:52: COMMA columns+= indexed_column
            	    {
            	    COMMA461=(Token)match(input,COMMA,FOLLOW_COMMA_in_create_index_stmt3907);  
            	    stream_COMMA.add(COMMA461);


            	    pushFollow(FOLLOW_indexed_column_in_create_index_stmt3911);
            	    columns=indexed_column();

            	    state._fsp--;

            	    stream_indexed_column.add(columns.getTree());
            	    if (list_columns==null) list_columns=new ArrayList();
            	    list_columns.add(columns.getTree());


            	    }
            	    break;

            	default :
            	    break loop168;
                }
            } while (true);


            RPAREN462=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_create_index_stmt3915);  
            stream_RPAREN.add(RPAREN462);


            // AST REWRITE
            // elements: EXISTS, index_name, UNIQUE, database_name, table_name, columns
            // token labels: 
            // rule labels: database_name, index_name, table_name, retval
            // token list labels: 
            // rule list labels: columns
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_index_name=new RewriteRuleSubtreeStream(adaptor,"rule index_name",index_name!=null?index_name.tree:null);
            RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_columns=new RewriteRuleSubtreeStream(adaptor,"token columns",list_columns);
            root_0 = (Object)adaptor.nil();
            // 507:111: -> ^( CREATE_INDEX ^( OPTIONS ( UNIQUE )? ( EXISTS )? ) ^( $index_name ( $database_name)? ) $table_name ( ^( COLUMNS ( $columns)+ ) )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:4: ^( CREATE_INDEX ^( OPTIONS ( UNIQUE )? ( EXISTS )? ) ^( $index_name ( $database_name)? ) $table_name ( ^( COLUMNS ( $columns)+ ) )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CREATE_INDEX, "CREATE_INDEX")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:19: ^( OPTIONS ( UNIQUE )? ( EXISTS )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:29: ( UNIQUE )?
                if ( stream_UNIQUE.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_UNIQUE.nextNode()
                    );

                }
                stream_UNIQUE.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:37: ( EXISTS )?
                if ( stream_EXISTS.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_EXISTS.nextNode()
                    );

                }
                stream_EXISTS.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:46: ^( $index_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_index_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:61: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_1, stream_table_name.nextTree());

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:89: ( ^( COLUMNS ( $columns)+ ) )?
                if ( stream_columns.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:507:89: ^( COLUMNS ( $columns)+ )
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    (Object)adaptor.create(COLUMNS, "COLUMNS")
                    , root_2);

                    if ( !(stream_columns.hasNext()) ) {
                        throw new RewriteEarlyExitException();
                    }
                    while ( stream_columns.hasNext() ) {
                        adaptor.addChild(root_2, stream_columns.nextTree());

                    }
                    stream_columns.reset();

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_columns.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "create_index_stmt"


    public static class indexed_column_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexed_column"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:1: indexed_column : column_name= id ( COLLATE collation_name= id )? ( ASC | DESC )? -> ^( $column_name ( ^( COLLATE $collation_name) )? ( ASC )? ( DESC )? ) ;
    public final SqlParser.indexed_column_return indexed_column() throws RecognitionException {
        SqlParser.indexed_column_return retval = new SqlParser.indexed_column_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token COLLATE463=null;
        Token ASC464=null;
        Token DESC465=null;
        SqlParser.id_return column_name =null;

        SqlParser.id_return collation_name =null;


        Object COLLATE463_tree=null;
        Object ASC464_tree=null;
        Object DESC465_tree=null;
        RewriteRuleTokenStream stream_ASC=new RewriteRuleTokenStream(adaptor,"token ASC");
        RewriteRuleTokenStream stream_COLLATE=new RewriteRuleTokenStream(adaptor,"token COLLATE");
        RewriteRuleTokenStream stream_DESC=new RewriteRuleTokenStream(adaptor,"token DESC");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:15: (column_name= id ( COLLATE collation_name= id )? ( ASC | DESC )? -> ^( $column_name ( ^( COLLATE $collation_name) )? ( ASC )? ( DESC )? ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:17: column_name= id ( COLLATE collation_name= id )? ( ASC | DESC )?
            {
            pushFollow(FOLLOW_id_in_indexed_column3961);
            column_name=id();

            state._fsp--;

            stream_id.add(column_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:32: ( COLLATE collation_name= id )?
            int alt169=2;
            int LA169_0 = input.LA(1);

            if ( (LA169_0==COLLATE) ) {
                alt169=1;
            }
            switch (alt169) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:33: COLLATE collation_name= id
                    {
                    COLLATE463=(Token)match(input,COLLATE,FOLLOW_COLLATE_in_indexed_column3964);  
                    stream_COLLATE.add(COLLATE463);


                    pushFollow(FOLLOW_id_in_indexed_column3968);
                    collation_name=id();

                    state._fsp--;

                    stream_id.add(collation_name.getTree());

                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:61: ( ASC | DESC )?
            int alt170=3;
            int LA170_0 = input.LA(1);

            if ( (LA170_0==ASC) ) {
                alt170=1;
            }
            else if ( (LA170_0==DESC) ) {
                alt170=2;
            }
            switch (alt170) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:62: ASC
                    {
                    ASC464=(Token)match(input,ASC,FOLLOW_ASC_in_indexed_column3973);  
                    stream_ASC.add(ASC464);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:509:68: DESC
                    {
                    DESC465=(Token)match(input,DESC,FOLLOW_DESC_in_indexed_column3977);  
                    stream_DESC.add(DESC465);


                    }
                    break;

            }


            // AST REWRITE
            // elements: ASC, column_name, collation_name, DESC, COLLATE
            // token labels: 
            // rule labels: column_name, collation_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_column_name=new RewriteRuleSubtreeStream(adaptor,"rule column_name",column_name!=null?column_name.tree:null);
            RewriteRuleSubtreeStream stream_collation_name=new RewriteRuleSubtreeStream(adaptor,"rule collation_name",collation_name!=null?collation_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 510:58: -> ^( $column_name ( ^( COLLATE $collation_name) )? ( ASC )? ( DESC )? )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:510:4: ^( $column_name ( ^( COLLATE $collation_name) )? ( ASC )? ( DESC )? )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(stream_column_name.nextNode(), root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:510:19: ( ^( COLLATE $collation_name) )?
                if ( stream_collation_name.hasNext()||stream_COLLATE.hasNext() ) {
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:510:19: ^( COLLATE $collation_name)
                    {
                    Object root_2 = (Object)adaptor.nil();
                    root_2 = (Object)adaptor.becomeRoot(
                    stream_COLLATE.nextNode()
                    , root_2);

                    adaptor.addChild(root_2, stream_collation_name.nextTree());

                    adaptor.addChild(root_1, root_2);
                    }

                }
                stream_collation_name.reset();
                stream_COLLATE.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:510:47: ( ASC )?
                if ( stream_ASC.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_ASC.nextNode()
                    );

                }
                stream_ASC.reset();

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:510:52: ( DESC )?
                if ( stream_DESC.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_DESC.nextNode()
                    );

                }
                stream_DESC.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexed_column"


    public static class drop_index_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "drop_index_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:1: drop_index_stmt : DROP INDEX ( IF EXISTS )? (database_name= id DOT )? index_name= id -> ^( DROP_INDEX ^( OPTIONS ( EXISTS )? ) ^( $index_name ( $database_name)? ) ) ;
    public final SqlParser.drop_index_stmt_return drop_index_stmt() throws RecognitionException {
        SqlParser.drop_index_stmt_return retval = new SqlParser.drop_index_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DROP466=null;
        Token INDEX467=null;
        Token IF468=null;
        Token EXISTS469=null;
        Token DOT470=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return index_name =null;


        Object DROP466_tree=null;
        Object INDEX467_tree=null;
        Object IF468_tree=null;
        Object EXISTS469_tree=null;
        Object DOT470_tree=null;
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_INDEX=new RewriteRuleTokenStream(adaptor,"token INDEX");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleTokenStream stream_DROP=new RewriteRuleTokenStream(adaptor,"token DROP");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:16: ( DROP INDEX ( IF EXISTS )? (database_name= id DOT )? index_name= id -> ^( DROP_INDEX ^( OPTIONS ( EXISTS )? ) ^( $index_name ( $database_name)? ) ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:18: DROP INDEX ( IF EXISTS )? (database_name= id DOT )? index_name= id
            {
            DROP466=(Token)match(input,DROP,FOLLOW_DROP_in_drop_index_stmt4008);  
            stream_DROP.add(DROP466);


            INDEX467=(Token)match(input,INDEX,FOLLOW_INDEX_in_drop_index_stmt4010);  
            stream_INDEX.add(INDEX467);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:29: ( IF EXISTS )?
            int alt171=2;
            int LA171_0 = input.LA(1);

            if ( (LA171_0==IF) ) {
                int LA171_1 = input.LA(2);

                if ( (LA171_1==EXISTS) ) {
                    alt171=1;
                }
            }
            switch (alt171) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:30: IF EXISTS
                    {
                    IF468=(Token)match(input,IF,FOLLOW_IF_in_drop_index_stmt4013);  
                    stream_IF.add(IF468);


                    EXISTS469=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_stmt4015);  
                    stream_EXISTS.add(EXISTS469);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:42: (database_name= id DOT )?
            int alt172=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA172_1 = input.LA(2);

                    if ( (LA172_1==DOT) ) {
                        alt172=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA172_2 = input.LA(2);

                    if ( (LA172_2==DOT) ) {
                        alt172=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA172_3 = input.LA(2);

                    if ( (LA172_3==DOT) ) {
                        alt172=1;
                    }
                    }
                    break;
            }

            switch (alt172) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:513:43: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_drop_index_stmt4022);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT470=(Token)match(input,DOT,FOLLOW_DOT_in_drop_index_stmt4024);  
                    stream_DOT.add(DOT470);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_drop_index_stmt4030);
            index_name=id();

            state._fsp--;

            stream_id.add(index_name.getTree());

            // AST REWRITE
            // elements: index_name, EXISTS, database_name
            // token labels: 
            // rule labels: database_name, index_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_index_name=new RewriteRuleSubtreeStream(adaptor,"rule index_name",index_name!=null?index_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 514:67: -> ^( DROP_INDEX ^( OPTIONS ( EXISTS )? ) ^( $index_name ( $database_name)? ) )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:514:4: ^( DROP_INDEX ^( OPTIONS ( EXISTS )? ) ^( $index_name ( $database_name)? ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(DROP_INDEX, "DROP_INDEX")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:514:17: ^( OPTIONS ( EXISTS )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:514:27: ( EXISTS )?
                if ( stream_EXISTS.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_EXISTS.nextNode()
                    );

                }
                stream_EXISTS.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:514:36: ^( $index_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_index_name.nextNode(), root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:514:51: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "drop_index_stmt"


    public static class create_trigger_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "create_trigger_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:1: create_trigger_stmt : CREATE ( TEMPORARY )? TRIGGER ( IF NOT EXISTS )? (database_name= id DOT )? trigger_name= id ( BEFORE | AFTER | INSTEAD OF )? ( DELETE | INSERT | UPDATE ( OF column_names+= id ( COMMA column_names+= id )* )? ) ON table_name= id ( FOR EACH ROW )? ( WHEN expr )? BEGIN ( ( update_stmt | insert_stmt | delete_stmt | select_stmt ) SEMI )+ END -> ^( CREATE_TRIGGER ^( OPTIONS ( TEMPORARY )? ) ^( $trigger_name $table_name ( $database_name)? ) ) ;
    public final SqlParser.create_trigger_stmt_return create_trigger_stmt() throws RecognitionException {
        SqlParser.create_trigger_stmt_return retval = new SqlParser.create_trigger_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CREATE471=null;
        Token TEMPORARY472=null;
        Token TRIGGER473=null;
        Token IF474=null;
        Token NOT475=null;
        Token EXISTS476=null;
        Token DOT477=null;
        Token BEFORE478=null;
        Token AFTER479=null;
        Token INSTEAD480=null;
        Token OF481=null;
        Token DELETE482=null;
        Token INSERT483=null;
        Token UPDATE484=null;
        Token OF485=null;
        Token COMMA486=null;
        Token ON487=null;
        Token FOR488=null;
        Token EACH489=null;
        Token ROW490=null;
        Token WHEN491=null;
        Token BEGIN493=null;
        Token SEMI498=null;
        Token END499=null;
        List list_column_names=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return trigger_name =null;

        SqlParser.id_return table_name =null;

        SqlParser.expr_return expr492 =null;

        SqlParser.update_stmt_return update_stmt494 =null;

        SqlParser.insert_stmt_return insert_stmt495 =null;

        SqlParser.delete_stmt_return delete_stmt496 =null;

        SqlParser.select_stmt_return select_stmt497 =null;

        RuleReturnScope column_names = null;
        Object CREATE471_tree=null;
        Object TEMPORARY472_tree=null;
        Object TRIGGER473_tree=null;
        Object IF474_tree=null;
        Object NOT475_tree=null;
        Object EXISTS476_tree=null;
        Object DOT477_tree=null;
        Object BEFORE478_tree=null;
        Object AFTER479_tree=null;
        Object INSTEAD480_tree=null;
        Object OF481_tree=null;
        Object DELETE482_tree=null;
        Object INSERT483_tree=null;
        Object UPDATE484_tree=null;
        Object OF485_tree=null;
        Object COMMA486_tree=null;
        Object ON487_tree=null;
        Object FOR488_tree=null;
        Object EACH489_tree=null;
        Object ROW490_tree=null;
        Object WHEN491_tree=null;
        Object BEGIN493_tree=null;
        Object SEMI498_tree=null;
        Object END499_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_EACH=new RewriteRuleTokenStream(adaptor,"token EACH");
        RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
        RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
        RewriteRuleTokenStream stream_TRIGGER=new RewriteRuleTokenStream(adaptor,"token TRIGGER");
        RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
        RewriteRuleTokenStream stream_FOR=new RewriteRuleTokenStream(adaptor,"token FOR");
        RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
        RewriteRuleTokenStream stream_AFTER=new RewriteRuleTokenStream(adaptor,"token AFTER");
        RewriteRuleTokenStream stream_BEGIN=new RewriteRuleTokenStream(adaptor,"token BEGIN");
        RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
        RewriteRuleTokenStream stream_BEFORE=new RewriteRuleTokenStream(adaptor,"token BEFORE");
        RewriteRuleTokenStream stream_DELETE=new RewriteRuleTokenStream(adaptor,"token DELETE");
        RewriteRuleTokenStream stream_WHEN=new RewriteRuleTokenStream(adaptor,"token WHEN");
        RewriteRuleTokenStream stream_OF=new RewriteRuleTokenStream(adaptor,"token OF");
        RewriteRuleTokenStream stream_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token TEMPORARY");
        RewriteRuleTokenStream stream_INSERT=new RewriteRuleTokenStream(adaptor,"token INSERT");
        RewriteRuleTokenStream stream_UPDATE=new RewriteRuleTokenStream(adaptor,"token UPDATE");
        RewriteRuleTokenStream stream_END=new RewriteRuleTokenStream(adaptor,"token END");
        RewriteRuleTokenStream stream_INSTEAD=new RewriteRuleTokenStream(adaptor,"token INSTEAD");
        RewriteRuleTokenStream stream_ROW=new RewriteRuleTokenStream(adaptor,"token ROW");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleTokenStream stream_ON=new RewriteRuleTokenStream(adaptor,"token ON");
        RewriteRuleSubtreeStream stream_insert_stmt=new RewriteRuleSubtreeStream(adaptor,"rule insert_stmt");
        RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");
        RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
        RewriteRuleSubtreeStream stream_select_stmt=new RewriteRuleSubtreeStream(adaptor,"rule select_stmt");
        RewriteRuleSubtreeStream stream_delete_stmt=new RewriteRuleSubtreeStream(adaptor,"rule delete_stmt");
        RewriteRuleSubtreeStream stream_update_stmt=new RewriteRuleSubtreeStream(adaptor,"rule update_stmt");
        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:20: ( CREATE ( TEMPORARY )? TRIGGER ( IF NOT EXISTS )? (database_name= id DOT )? trigger_name= id ( BEFORE | AFTER | INSTEAD OF )? ( DELETE | INSERT | UPDATE ( OF column_names+= id ( COMMA column_names+= id )* )? ) ON table_name= id ( FOR EACH ROW )? ( WHEN expr )? BEGIN ( ( update_stmt | insert_stmt | delete_stmt | select_stmt ) SEMI )+ END -> ^( CREATE_TRIGGER ^( OPTIONS ( TEMPORARY )? ) ^( $trigger_name $table_name ( $database_name)? ) ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:22: CREATE ( TEMPORARY )? TRIGGER ( IF NOT EXISTS )? (database_name= id DOT )? trigger_name= id ( BEFORE | AFTER | INSTEAD OF )? ( DELETE | INSERT | UPDATE ( OF column_names+= id ( COMMA column_names+= id )* )? ) ON table_name= id ( FOR EACH ROW )? ( WHEN expr )? BEGIN ( ( update_stmt | insert_stmt | delete_stmt | select_stmt ) SEMI )+ END
            {
            CREATE471=(Token)match(input,CREATE,FOLLOW_CREATE_in_create_trigger_stmt4060);  
            stream_CREATE.add(CREATE471);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:29: ( TEMPORARY )?
            int alt173=2;
            int LA173_0 = input.LA(1);

            if ( (LA173_0==TEMPORARY) ) {
                alt173=1;
            }
            switch (alt173) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:29: TEMPORARY
                    {
                    TEMPORARY472=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_trigger_stmt4062);  
                    stream_TEMPORARY.add(TEMPORARY472);


                    }
                    break;

            }


            TRIGGER473=(Token)match(input,TRIGGER,FOLLOW_TRIGGER_in_create_trigger_stmt4065);  
            stream_TRIGGER.add(TRIGGER473);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:48: ( IF NOT EXISTS )?
            int alt174=2;
            int LA174_0 = input.LA(1);

            if ( (LA174_0==IF) ) {
                int LA174_1 = input.LA(2);

                if ( (LA174_1==NOT) ) {
                    alt174=1;
                }
            }
            switch (alt174) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:49: IF NOT EXISTS
                    {
                    IF474=(Token)match(input,IF,FOLLOW_IF_in_create_trigger_stmt4068);  
                    stream_IF.add(IF474);


                    NOT475=(Token)match(input,NOT,FOLLOW_NOT_in_create_trigger_stmt4070);  
                    stream_NOT.add(NOT475);


                    EXISTS476=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_trigger_stmt4072);  
                    stream_EXISTS.add(EXISTS476);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:65: (database_name= id DOT )?
            int alt175=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA175_1 = input.LA(2);

                    if ( (LA175_1==DOT) ) {
                        alt175=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA175_2 = input.LA(2);

                    if ( (LA175_2==DOT) ) {
                        alt175=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA175_3 = input.LA(2);

                    if ( (LA175_3==DOT) ) {
                        alt175=1;
                    }
                    }
                    break;
            }

            switch (alt175) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:517:66: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_create_trigger_stmt4079);
                    database_name=id();

                    state._fsp--;

                    stream_id.add(database_name.getTree());

                    DOT477=(Token)match(input,DOT,FOLLOW_DOT_in_create_trigger_stmt4081);  
                    stream_DOT.add(DOT477);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_create_trigger_stmt4087);
            trigger_name=id();

            state._fsp--;

            stream_id.add(trigger_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:3: ( BEFORE | AFTER | INSTEAD OF )?
            int alt176=4;
            switch ( input.LA(1) ) {
                case BEFORE:
                    {
                    alt176=1;
                    }
                    break;
                case AFTER:
                    {
                    alt176=2;
                    }
                    break;
                case INSTEAD:
                    {
                    alt176=3;
                    }
                    break;
            }

            switch (alt176) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:4: BEFORE
                    {
                    BEFORE478=(Token)match(input,BEFORE,FOLLOW_BEFORE_in_create_trigger_stmt4092);  
                    stream_BEFORE.add(BEFORE478);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:13: AFTER
                    {
                    AFTER479=(Token)match(input,AFTER,FOLLOW_AFTER_in_create_trigger_stmt4096);  
                    stream_AFTER.add(AFTER479);


                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:21: INSTEAD OF
                    {
                    INSTEAD480=(Token)match(input,INSTEAD,FOLLOW_INSTEAD_in_create_trigger_stmt4100);  
                    stream_INSTEAD.add(INSTEAD480);


                    OF481=(Token)match(input,OF,FOLLOW_OF_in_create_trigger_stmt4102);  
                    stream_OF.add(OF481);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:34: ( DELETE | INSERT | UPDATE ( OF column_names+= id ( COMMA column_names+= id )* )? )
            int alt179=3;
            switch ( input.LA(1) ) {
            case DELETE:
                {
                alt179=1;
                }
                break;
            case INSERT:
                {
                alt179=2;
                }
                break;
            case UPDATE:
                {
                alt179=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 179, 0, input);

                throw nvae;

            }

            switch (alt179) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:35: DELETE
                    {
                    DELETE482=(Token)match(input,DELETE,FOLLOW_DELETE_in_create_trigger_stmt4107);  
                    stream_DELETE.add(DELETE482);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:44: INSERT
                    {
                    INSERT483=(Token)match(input,INSERT,FOLLOW_INSERT_in_create_trigger_stmt4111);  
                    stream_INSERT.add(INSERT483);


                    }
                    break;
                case 3 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:53: UPDATE ( OF column_names+= id ( COMMA column_names+= id )* )?
                    {
                    UPDATE484=(Token)match(input,UPDATE,FOLLOW_UPDATE_in_create_trigger_stmt4115);  
                    stream_UPDATE.add(UPDATE484);


                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:60: ( OF column_names+= id ( COMMA column_names+= id )* )?
                    int alt178=2;
                    int LA178_0 = input.LA(1);

                    if ( (LA178_0==OF) ) {
                        alt178=1;
                    }
                    switch (alt178) {
                        case 1 :
                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:61: OF column_names+= id ( COMMA column_names+= id )*
                            {
                            OF485=(Token)match(input,OF,FOLLOW_OF_in_create_trigger_stmt4118);  
                            stream_OF.add(OF485);


                            pushFollow(FOLLOW_id_in_create_trigger_stmt4122);
                            column_names=id();

                            state._fsp--;

                            stream_id.add(column_names.getTree());
                            if (list_column_names==null) list_column_names=new ArrayList();
                            list_column_names.add(column_names.getTree());


                            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:81: ( COMMA column_names+= id )*
                            loop177:
                            do {
                                int alt177=2;
                                int LA177_0 = input.LA(1);

                                if ( (LA177_0==COMMA) ) {
                                    alt177=1;
                                }


                                switch (alt177) {
                            	case 1 :
                            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:518:82: COMMA column_names+= id
                            	    {
                            	    COMMA486=(Token)match(input,COMMA,FOLLOW_COMMA_in_create_trigger_stmt4125);  
                            	    stream_COMMA.add(COMMA486);


                            	    pushFollow(FOLLOW_id_in_create_trigger_stmt4129);
                            	    column_names=id();

                            	    state._fsp--;

                            	    stream_id.add(column_names.getTree());
                            	    if (list_column_names==null) list_column_names=new ArrayList();
                            	    list_column_names.add(column_names.getTree());


                            	    }
                            	    break;

                            	default :
                            	    break loop177;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }


            ON487=(Token)match(input,ON,FOLLOW_ON_in_create_trigger_stmt4138);  
            stream_ON.add(ON487);


            pushFollow(FOLLOW_id_in_create_trigger_stmt4142);
            table_name=id();

            state._fsp--;

            stream_id.add(table_name.getTree());

            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:519:20: ( FOR EACH ROW )?
            int alt180=2;
            int LA180_0 = input.LA(1);

            if ( (LA180_0==FOR) ) {
                alt180=1;
            }
            switch (alt180) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:519:21: FOR EACH ROW
                    {
                    FOR488=(Token)match(input,FOR,FOLLOW_FOR_in_create_trigger_stmt4145);  
                    stream_FOR.add(FOR488);


                    EACH489=(Token)match(input,EACH,FOLLOW_EACH_in_create_trigger_stmt4147);  
                    stream_EACH.add(EACH489);


                    ROW490=(Token)match(input,ROW,FOLLOW_ROW_in_create_trigger_stmt4149);  
                    stream_ROW.add(ROW490);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:519:36: ( WHEN expr )?
            int alt181=2;
            int LA181_0 = input.LA(1);

            if ( (LA181_0==WHEN) ) {
                alt181=1;
            }
            switch (alt181) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:519:37: WHEN expr
                    {
                    WHEN491=(Token)match(input,WHEN,FOLLOW_WHEN_in_create_trigger_stmt4154);  
                    stream_WHEN.add(WHEN491);


                    pushFollow(FOLLOW_expr_in_create_trigger_stmt4156);
                    expr492=expr();

                    state._fsp--;

                    stream_expr.add(expr492.getTree());

                    }
                    break;

            }


            BEGIN493=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_create_trigger_stmt4162);  
            stream_BEGIN.add(BEGIN493);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:9: ( ( update_stmt | insert_stmt | delete_stmt | select_stmt ) SEMI )+
            int cnt183=0;
            loop183:
            do {
                int alt183=2;
                int LA183_0 = input.LA(1);

                if ( (LA183_0==DELETE||LA183_0==INSERT||LA183_0==REPLACE||LA183_0==SELECT||LA183_0==UPDATE) ) {
                    alt183=1;
                }


                switch (alt183) {
            	case 1 :
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:10: ( update_stmt | insert_stmt | delete_stmt | select_stmt ) SEMI
            	    {
            	    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:10: ( update_stmt | insert_stmt | delete_stmt | select_stmt )
            	    int alt182=4;
            	    switch ( input.LA(1) ) {
            	    case UPDATE:
            	        {
            	        alt182=1;
            	        }
            	        break;
            	    case INSERT:
            	    case REPLACE:
            	        {
            	        alt182=2;
            	        }
            	        break;
            	    case DELETE:
            	        {
            	        alt182=3;
            	        }
            	        break;
            	    case SELECT:
            	        {
            	        alt182=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 182, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt182) {
            	        case 1 :
            	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:11: update_stmt
            	            {
            	            pushFollow(FOLLOW_update_stmt_in_create_trigger_stmt4166);
            	            update_stmt494=update_stmt();

            	            state._fsp--;

            	            stream_update_stmt.add(update_stmt494.getTree());

            	            }
            	            break;
            	        case 2 :
            	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:25: insert_stmt
            	            {
            	            pushFollow(FOLLOW_insert_stmt_in_create_trigger_stmt4170);
            	            insert_stmt495=insert_stmt();

            	            state._fsp--;

            	            stream_insert_stmt.add(insert_stmt495.getTree());

            	            }
            	            break;
            	        case 3 :
            	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:39: delete_stmt
            	            {
            	            pushFollow(FOLLOW_delete_stmt_in_create_trigger_stmt4174);
            	            delete_stmt496=delete_stmt();

            	            state._fsp--;

            	            stream_delete_stmt.add(delete_stmt496.getTree());

            	            }
            	            break;
            	        case 4 :
            	            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:520:53: select_stmt
            	            {
            	            pushFollow(FOLLOW_select_stmt_in_create_trigger_stmt4178);
            	            select_stmt497=select_stmt();

            	            state._fsp--;

            	            stream_select_stmt.add(select_stmt497.getTree());

            	            }
            	            break;

            	    }


            	    SEMI498=(Token)match(input,SEMI,FOLLOW_SEMI_in_create_trigger_stmt4181);  
            	    stream_SEMI.add(SEMI498);


            	    }
            	    break;

            	default :
            	    if ( cnt183 >= 1 ) break loop183;
                        EarlyExitException eee =
                            new EarlyExitException(183, input);
                        throw eee;
                }
                cnt183++;
            } while (true);


            END499=(Token)match(input,END,FOLLOW_END_in_create_trigger_stmt4185);  
            stream_END.add(END499);


            // AST REWRITE
            // elements: table_name, trigger_name, TEMPORARY, database_name
            // token labels: 
            // rule labels: trigger_name, database_name, table_name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_trigger_name=new RewriteRuleSubtreeStream(adaptor,"rule trigger_name",trigger_name!=null?trigger_name.tree:null);
            RewriteRuleSubtreeStream stream_database_name=new RewriteRuleSubtreeStream(adaptor,"rule database_name",database_name!=null?database_name.tree:null);
            RewriteRuleSubtreeStream stream_table_name=new RewriteRuleSubtreeStream(adaptor,"rule table_name",table_name!=null?table_name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (Object)adaptor.nil();
            // 521:88: -> ^( CREATE_TRIGGER ^( OPTIONS ( TEMPORARY )? ) ^( $trigger_name $table_name ( $database_name)? ) )
            {
                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:521:4: ^( CREATE_TRIGGER ^( OPTIONS ( TEMPORARY )? ) ^( $trigger_name $table_name ( $database_name)? ) )
                {
                Object root_1 = (Object)adaptor.nil();
                root_1 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(CREATE_TRIGGER, "CREATE_TRIGGER")
                , root_1);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:521:21: ^( OPTIONS ( TEMPORARY )? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(
                (Object)adaptor.create(OPTIONS, "OPTIONS")
                , root_2);

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:521:31: ( TEMPORARY )?
                if ( stream_TEMPORARY.hasNext() ) {
                    adaptor.addChild(root_2, 
                    stream_TEMPORARY.nextNode()
                    );

                }
                stream_TEMPORARY.reset();

                adaptor.addChild(root_1, root_2);
                }

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:521:43: ^( $trigger_name $table_name ( $database_name)? )
                {
                Object root_2 = (Object)adaptor.nil();
                root_2 = (Object)adaptor.becomeRoot(stream_trigger_name.nextNode(), root_2);

                adaptor.addChild(root_2, stream_table_name.nextTree());

                // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:521:72: ( $database_name)?
                if ( stream_database_name.hasNext() ) {
                    adaptor.addChild(root_2, stream_database_name.nextTree());

                }
                stream_database_name.reset();

                adaptor.addChild(root_1, root_2);
                }

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "create_trigger_stmt"


    public static class drop_trigger_stmt_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "drop_trigger_stmt"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:1: drop_trigger_stmt : DROP TRIGGER ( IF EXISTS )? (database_name= id DOT )? trigger_name= id ;
    public final SqlParser.drop_trigger_stmt_return drop_trigger_stmt() throws RecognitionException {
        SqlParser.drop_trigger_stmt_return retval = new SqlParser.drop_trigger_stmt_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token DROP500=null;
        Token TRIGGER501=null;
        Token IF502=null;
        Token EXISTS503=null;
        Token DOT504=null;
        SqlParser.id_return database_name =null;

        SqlParser.id_return trigger_name =null;


        Object DROP500_tree=null;
        Object TRIGGER501_tree=null;
        Object IF502_tree=null;
        Object EXISTS503_tree=null;
        Object DOT504_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:18: ( DROP TRIGGER ( IF EXISTS )? (database_name= id DOT )? trigger_name= id )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:20: DROP TRIGGER ( IF EXISTS )? (database_name= id DOT )? trigger_name= id
            {
            root_0 = (Object)adaptor.nil();


            DROP500=(Token)match(input,DROP,FOLLOW_DROP_in_drop_trigger_stmt4218); 
            DROP500_tree = 
            (Object)adaptor.create(DROP500)
            ;
            adaptor.addChild(root_0, DROP500_tree);


            TRIGGER501=(Token)match(input,TRIGGER,FOLLOW_TRIGGER_in_drop_trigger_stmt4220); 
            TRIGGER501_tree = 
            (Object)adaptor.create(TRIGGER501)
            ;
            adaptor.addChild(root_0, TRIGGER501_tree);


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:33: ( IF EXISTS )?
            int alt184=2;
            int LA184_0 = input.LA(1);

            if ( (LA184_0==IF) ) {
                int LA184_1 = input.LA(2);

                if ( (LA184_1==EXISTS) ) {
                    alt184=1;
                }
            }
            switch (alt184) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:34: IF EXISTS
                    {
                    IF502=(Token)match(input,IF,FOLLOW_IF_in_drop_trigger_stmt4223); 
                    IF502_tree = 
                    (Object)adaptor.create(IF502)
                    ;
                    adaptor.addChild(root_0, IF502_tree);


                    EXISTS503=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_trigger_stmt4225); 
                    EXISTS503_tree = 
                    (Object)adaptor.create(EXISTS503)
                    ;
                    adaptor.addChild(root_0, EXISTS503_tree);


                    }
                    break;

            }


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:46: (database_name= id DOT )?
            int alt185=2;
            switch ( input.LA(1) ) {
                case ID:
                    {
                    int LA185_1 = input.LA(2);

                    if ( (LA185_1==DOT) ) {
                        alt185=1;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA185_2 = input.LA(2);

                    if ( (LA185_2==DOT) ) {
                        alt185=1;
                    }
                    }
                    break;
                case ABORT:
                case ADD:
                case AFTER:
                case ALL:
                case ALTER:
                case ANALYZE:
                case AND:
                case AS:
                case ASC:
                case ATTACH:
                case AUTOINCREMENT:
                case BEFORE:
                case BEGIN:
                case BETWEEN:
                case BY:
                case CASCADE:
                case CASE:
                case CAST:
                case CHECK:
                case COLLATE:
                case COLUMN:
                case COMMIT:
                case CONFLICT:
                case CONSTRAINT:
                case CREATE:
                case CROSS:
                case CURRENT_DATE:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case DATABASE:
                case DEFAULT:
                case DEFERRABLE:
                case DEFERRED:
                case DELETE:
                case DESC:
                case DETACH:
                case DISTINCT:
                case DROP:
                case EACH:
                case ELSE:
                case END:
                case ESCAPE:
                case EXCEPT:
                case EXCLUSIVE:
                case EXISTS:
                case EXPLAIN:
                case FAIL:
                case FOR:
                case FOREIGN:
                case FROM:
                case GROUP:
                case HAVING:
                case IF:
                case IGNORE:
                case IMMEDIATE:
                case INDEX:
                case INDEXED:
                case INITIALLY:
                case INNER:
                case INSERT:
                case INSTEAD:
                case INTERSECT:
                case INTO:
                case IS:
                case JOIN:
                case KEY:
                case LEFT:
                case LIMIT:
                case NATURAL:
                case NULL:
                case OF:
                case OFFSET:
                case ON:
                case OR:
                case ORDER:
                case OUTER:
                case PLAN:
                case PRAGMA:
                case PRIMARY:
                case QUERY:
                case RAISE:
                case REFERENCES:
                case REINDEX:
                case RELEASE:
                case RENAME:
                case REPLACE:
                case RESTRICT:
                case ROLLBACK:
                case ROW:
                case SAVEPOINT:
                case SELECT:
                case SET:
                case TABLE:
                case TEMPORARY:
                case THEN:
                case TO:
                case TRANSACTION:
                case TRIGGER:
                case UNION:
                case UNIQUE:
                case UPDATE:
                case USING:
                case VACUUM:
                case VALUES:
                case VIEW:
                case VIRTUAL:
                case WHEN:
                case WHERE:
                    {
                    int LA185_3 = input.LA(2);

                    if ( (LA185_3==DOT) ) {
                        alt185=1;
                    }
                    }
                    break;
            }

            switch (alt185) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:524:47: database_name= id DOT
                    {
                    pushFollow(FOLLOW_id_in_drop_trigger_stmt4232);
                    database_name=id();

                    state._fsp--;

                    adaptor.addChild(root_0, database_name.getTree());

                    DOT504=(Token)match(input,DOT,FOLLOW_DOT_in_drop_trigger_stmt4234); 
                    DOT504_tree = 
                    (Object)adaptor.create(DOT504)
                    ;
                    adaptor.addChild(root_0, DOT504_tree);


                    }
                    break;

            }


            pushFollow(FOLLOW_id_in_drop_trigger_stmt4240);
            trigger_name=id();

            state._fsp--;

            adaptor.addChild(root_0, trigger_name.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "drop_trigger_stmt"


    public static class id_core_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "id_core"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:1: id_core : str= ( ID | STRING ) ;
    public final SqlParser.id_core_return id_core() throws RecognitionException {
        SqlParser.id_core_return retval = new SqlParser.id_core_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token str=null;
        Token ID505=null;
        Token STRING506=null;

        Object str_tree=null;
        Object ID505_tree=null;
        Object STRING506_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:8: (str= ( ID | STRING ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:10: str= ( ID | STRING )
            {
            root_0 = (Object)adaptor.nil();


            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:14: ( ID | STRING )
            int alt186=2;
            int LA186_0 = input.LA(1);

            if ( (LA186_0==ID) ) {
                alt186=1;
            }
            else if ( (LA186_0==STRING) ) {
                alt186=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 186, 0, input);

                throw nvae;

            }
            switch (alt186) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:16: ID
                    {
                    ID505=(Token)match(input,ID,FOLLOW_ID_in_id_core4252); 
                    ID505_tree = 
                    new QuotedId(ID505) 
                    ;
                    adaptor.addChild(root_0, ID505_tree);


                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:527:31: STRING
                    {
                    STRING506=(Token)match(input,STRING,FOLLOW_STRING_in_id_core4259); 
                    STRING506_tree = 
                    new QuotedId(STRING506) 
                    ;
                    adaptor.addChild(root_0, STRING506_tree);


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "id_core"


    public static class id_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "id"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:531:1: id : ( id_core | keyword );
    public final SqlParser.id_return id() throws RecognitionException {
        SqlParser.id_return retval = new SqlParser.id_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.id_core_return id_core507 =null;

        SqlParser.keyword_return keyword508 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:531:3: ( id_core | keyword )
            int alt187=2;
            int LA187_0 = input.LA(1);

            if ( (LA187_0==ID||LA187_0==STRING) ) {
                alt187=1;
            }
            else if ( ((LA187_0 >= ABORT && LA187_0 <= AFTER)||(LA187_0 >= ALL && LA187_0 <= ALTER)||(LA187_0 >= ANALYZE && LA187_0 <= AND)||(LA187_0 >= AS && LA187_0 <= ASC)||(LA187_0 >= ATTACH && LA187_0 <= AUTOINCREMENT)||(LA187_0 >= BEFORE && LA187_0 <= BETWEEN)||LA187_0==BY||(LA187_0 >= CASCADE && LA187_0 <= COLLATE)||LA187_0==COLUMN||(LA187_0 >= COMMIT && LA187_0 <= CONSTRAINT)||LA187_0==CREATE||(LA187_0 >= CROSS && LA187_0 <= CURRENT_TIMESTAMP)||(LA187_0 >= DATABASE && LA187_0 <= DISTINCT)||LA187_0==DROP||(LA187_0 >= EACH && LA187_0 <= END)||(LA187_0 >= ESCAPE && LA187_0 <= EXPLAIN)||LA187_0==FAIL||(LA187_0 >= FOR && LA187_0 <= FROM)||LA187_0==GROUP||LA187_0==HAVING||(LA187_0 >= IF && LA187_0 <= IMMEDIATE)||(LA187_0 >= INDEX && LA187_0 <= INSTEAD)||(LA187_0 >= INTERSECT && LA187_0 <= INTO)||LA187_0==IS||LA187_0==JOIN||LA187_0==KEY||LA187_0==LEFT||LA187_0==LIMIT||LA187_0==NATURAL||LA187_0==NULL||(LA187_0 >= OF && LA187_0 <= ON)||(LA187_0 >= OR && LA187_0 <= ORDER)||LA187_0==OUTER||LA187_0==PLAN||(LA187_0 >= PRAGMA && LA187_0 <= PRIMARY)||LA187_0==QUERY||(LA187_0 >= RAISE && LA187_0 <= REFERENCES)||(LA187_0 >= REINDEX && LA187_0 <= ROW)||(LA187_0 >= SAVEPOINT && LA187_0 <= SELECT)||LA187_0==SET||LA187_0==TABLE||(LA187_0 >= TEMPORARY && LA187_0 <= THEN)||(LA187_0 >= TO && LA187_0 <= TRIGGER)||(LA187_0 >= UNION && LA187_0 <= USING)||(LA187_0 >= VACUUM && LA187_0 <= VIRTUAL)||(LA187_0 >= WHEN && LA187_0 <= WHERE)) ) {
                alt187=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 187, 0, input);

                throw nvae;

            }
            switch (alt187) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:531:5: id_core
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_id_core_in_id4273);
                    id_core507=id_core();

                    state._fsp--;

                    adaptor.addChild(root_0, id_core507.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:531:15: keyword
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_keyword_in_id4277);
                    keyword508=keyword();

                    state._fsp--;

                    adaptor.addChild(root_0, keyword508.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "id"


    public static class keyword_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyword"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:533:1: keyword : ( ABORT | ADD | AFTER | ALL | ALTER | ANALYZE | AND | AS | ASC | ATTACH | AUTOINCREMENT | BEFORE | BEGIN | BETWEEN | BY | CASCADE | CASE | CAST | CHECK | COLLATE | COLUMN | COMMIT | CONFLICT | CONSTRAINT | CREATE | CROSS | CURRENT_TIME | CURRENT_DATE | CURRENT_TIMESTAMP | DATABASE | DEFAULT | DEFERRABLE | DEFERRED | DELETE | DESC | DETACH | DISTINCT | DROP | EACH | ELSE | END | ESCAPE | EXCEPT | EXCLUSIVE | EXISTS | EXPLAIN | FAIL | FOR | FOREIGN | FROM | GROUP | HAVING | IF | IGNORE | IMMEDIATE | INDEX | INDEXED | INITIALLY | INNER | INSERT | INSTEAD | INTERSECT | INTO | IS | JOIN | KEY | LEFT | LIMIT | NATURAL | NULL | OF | OFFSET | ON | OR | ORDER | OUTER | PLAN | PRAGMA | PRIMARY | QUERY | RAISE | REFERENCES | REINDEX | RELEASE | RENAME | REPLACE | RESTRICT | ROLLBACK | ROW | SAVEPOINT | SELECT | SET | TABLE | TEMPORARY | THEN | TO | TRANSACTION | TRIGGER | UNION | UNIQUE | UPDATE | USING | VACUUM | VALUES | VIEW | VIRTUAL | WHEN | WHERE ) ;
    public final SqlParser.keyword_return keyword() throws RecognitionException {
        SqlParser.keyword_return retval = new SqlParser.keyword_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set509=null;

        Object set509_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:533:8: ( ( ABORT | ADD | AFTER | ALL | ALTER | ANALYZE | AND | AS | ASC | ATTACH | AUTOINCREMENT | BEFORE | BEGIN | BETWEEN | BY | CASCADE | CASE | CAST | CHECK | COLLATE | COLUMN | COMMIT | CONFLICT | CONSTRAINT | CREATE | CROSS | CURRENT_TIME | CURRENT_DATE | CURRENT_TIMESTAMP | DATABASE | DEFAULT | DEFERRABLE | DEFERRED | DELETE | DESC | DETACH | DISTINCT | DROP | EACH | ELSE | END | ESCAPE | EXCEPT | EXCLUSIVE | EXISTS | EXPLAIN | FAIL | FOR | FOREIGN | FROM | GROUP | HAVING | IF | IGNORE | IMMEDIATE | INDEX | INDEXED | INITIALLY | INNER | INSERT | INSTEAD | INTERSECT | INTO | IS | JOIN | KEY | LEFT | LIMIT | NATURAL | NULL | OF | OFFSET | ON | OR | ORDER | OUTER | PLAN | PRAGMA | PRIMARY | QUERY | RAISE | REFERENCES | REINDEX | RELEASE | RENAME | REPLACE | RESTRICT | ROLLBACK | ROW | SAVEPOINT | SELECT | SET | TABLE | TEMPORARY | THEN | TO | TRANSACTION | TRIGGER | UNION | UNIQUE | UPDATE | USING | VACUUM | VALUES | VIEW | VIRTUAL | WHEN | WHERE ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
            {
            root_0 = (Object)adaptor.nil();


            set509=(Token)input.LT(1);

            if ( (input.LA(1) >= ABORT && input.LA(1) <= AFTER)||(input.LA(1) >= ALL && input.LA(1) <= ALTER)||(input.LA(1) >= ANALYZE && input.LA(1) <= AND)||(input.LA(1) >= AS && input.LA(1) <= ASC)||(input.LA(1) >= ATTACH && input.LA(1) <= AUTOINCREMENT)||(input.LA(1) >= BEFORE && input.LA(1) <= BETWEEN)||input.LA(1)==BY||(input.LA(1) >= CASCADE && input.LA(1) <= COLLATE)||input.LA(1)==COLUMN||(input.LA(1) >= COMMIT && input.LA(1) <= CONSTRAINT)||input.LA(1)==CREATE||(input.LA(1) >= CROSS && input.LA(1) <= CURRENT_TIMESTAMP)||(input.LA(1) >= DATABASE && input.LA(1) <= DISTINCT)||input.LA(1)==DROP||(input.LA(1) >= EACH && input.LA(1) <= END)||(input.LA(1) >= ESCAPE && input.LA(1) <= EXPLAIN)||input.LA(1)==FAIL||(input.LA(1) >= FOR && input.LA(1) <= FROM)||input.LA(1)==GROUP||input.LA(1)==HAVING||(input.LA(1) >= IF && input.LA(1) <= IMMEDIATE)||(input.LA(1) >= INDEX && input.LA(1) <= INSTEAD)||(input.LA(1) >= INTERSECT && input.LA(1) <= INTO)||input.LA(1)==IS||input.LA(1)==JOIN||input.LA(1)==KEY||input.LA(1)==LEFT||input.LA(1)==LIMIT||input.LA(1)==NATURAL||input.LA(1)==NULL||(input.LA(1) >= OF && input.LA(1) <= ON)||(input.LA(1) >= OR && input.LA(1) <= ORDER)||input.LA(1)==OUTER||input.LA(1)==PLAN||(input.LA(1) >= PRAGMA && input.LA(1) <= PRIMARY)||input.LA(1)==QUERY||(input.LA(1) >= RAISE && input.LA(1) <= REFERENCES)||(input.LA(1) >= REINDEX && input.LA(1) <= ROW)||(input.LA(1) >= SAVEPOINT && input.LA(1) <= SELECT)||input.LA(1)==SET||input.LA(1)==TABLE||(input.LA(1) >= TEMPORARY && input.LA(1) <= THEN)||(input.LA(1) >= TO && input.LA(1) <= TRIGGER)||(input.LA(1) >= UNION && input.LA(1) <= USING)||(input.LA(1) >= VACUUM && input.LA(1) <= VIRTUAL)||(input.LA(1) >= WHEN && input.LA(1) <= WHERE) ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set509)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyword"


    public static class id_column_def_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "id_column_def"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:652:1: id_column_def : ( id_core | keyword_column_def );
    public final SqlParser.id_column_def_return id_column_def() throws RecognitionException {
        SqlParser.id_column_def_return retval = new SqlParser.id_column_def_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        SqlParser.id_core_return id_core510 =null;

        SqlParser.keyword_column_def_return keyword_column_def511 =null;



        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:652:14: ( id_core | keyword_column_def )
            int alt188=2;
            int LA188_0 = input.LA(1);

            if ( (LA188_0==ID||LA188_0==STRING) ) {
                alt188=1;
            }
            else if ( ((LA188_0 >= ABORT && LA188_0 <= AFTER)||(LA188_0 >= ALL && LA188_0 <= ALTER)||(LA188_0 >= ANALYZE && LA188_0 <= AND)||(LA188_0 >= AS && LA188_0 <= ASC)||(LA188_0 >= ATTACH && LA188_0 <= AUTOINCREMENT)||(LA188_0 >= BEFORE && LA188_0 <= BETWEEN)||LA188_0==BY||(LA188_0 >= CASCADE && LA188_0 <= COLLATE)||(LA188_0 >= COMMIT && LA188_0 <= CONFLICT)||LA188_0==CREATE||(LA188_0 >= CROSS && LA188_0 <= CURRENT_TIMESTAMP)||(LA188_0 >= DATABASE && LA188_0 <= DISTINCT)||LA188_0==DROP||(LA188_0 >= EACH && LA188_0 <= END)||(LA188_0 >= ESCAPE && LA188_0 <= EXPLAIN)||LA188_0==FAIL||(LA188_0 >= FOR && LA188_0 <= FROM)||LA188_0==GLOB||LA188_0==GROUP||LA188_0==HAVING||(LA188_0 >= IF && LA188_0 <= INSTEAD)||(LA188_0 >= INTERSECT && LA188_0 <= INTO)||(LA188_0 >= IS && LA188_0 <= ISNULL)||LA188_0==JOIN||LA188_0==KEY||LA188_0==LEFT||(LA188_0 >= LIKE && LA188_0 <= LIMIT)||LA188_0==MATCH||(LA188_0 >= NATURAL && LA188_0 <= NOTNULL)||LA188_0==NULL||(LA188_0 >= OF && LA188_0 <= ON)||(LA188_0 >= OR && LA188_0 <= ORDER)||LA188_0==OUTER||LA188_0==PLAN||(LA188_0 >= PRAGMA && LA188_0 <= PRIMARY)||LA188_0==QUERY||(LA188_0 >= RAISE && LA188_0 <= ROW)||(LA188_0 >= SAVEPOINT && LA188_0 <= SELECT)||LA188_0==SET||LA188_0==TABLE||(LA188_0 >= TEMPORARY && LA188_0 <= THEN)||(LA188_0 >= TO && LA188_0 <= TRIGGER)||(LA188_0 >= UNION && LA188_0 <= USING)||(LA188_0 >= VACUUM && LA188_0 <= VIRTUAL)||(LA188_0 >= WHEN && LA188_0 <= WHERE)) ) {
                alt188=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 188, 0, input);

                throw nvae;

            }
            switch (alt188) {
                case 1 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:652:16: id_core
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_id_core_in_id_column_def4951);
                    id_core510=id_core();

                    state._fsp--;

                    adaptor.addChild(root_0, id_core510.getTree());

                    }
                    break;
                case 2 :
                    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:652:26: keyword_column_def
                    {
                    root_0 = (Object)adaptor.nil();


                    pushFollow(FOLLOW_keyword_column_def_in_id_column_def4955);
                    keyword_column_def511=keyword_column_def();

                    state._fsp--;

                    adaptor.addChild(root_0, keyword_column_def511.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "id_column_def"


    public static class keyword_column_def_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyword_column_def"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:654:1: keyword_column_def : ( ABORT | ADD | AFTER | ALL | ALTER | ANALYZE | AND | AS | ASC | ATTACH | AUTOINCREMENT | BEFORE | BEGIN | BETWEEN | BY | CASCADE | CASE | CAST | CHECK | COLLATE | COMMIT | CONFLICT | CREATE | CROSS | CURRENT_TIME | CURRENT_DATE | CURRENT_TIMESTAMP | DATABASE | DEFAULT | DEFERRABLE | DEFERRED | DELETE | DESC | DETACH | DISTINCT | DROP | EACH | ELSE | END | ESCAPE | EXCEPT | EXCLUSIVE | EXISTS | EXPLAIN | FAIL | FOR | FOREIGN | FROM | GLOB | GROUP | HAVING | IF | IGNORE | IMMEDIATE | IN | INDEX | INDEXED | INITIALLY | INNER | INSERT | INSTEAD | INTERSECT | INTO | IS | ISNULL | JOIN | KEY | LEFT | LIKE | LIMIT | MATCH | NATURAL | NOT | NOTNULL | NULL | OF | OFFSET | ON | OR | ORDER | OUTER | PLAN | PRAGMA | PRIMARY | QUERY | RAISE | REFERENCES | REGEXP | REINDEX | RELEASE | RENAME | REPLACE | RESTRICT | ROLLBACK | ROW | SAVEPOINT | SELECT | SET | TABLE | TEMPORARY | THEN | TO | TRANSACTION | TRIGGER | UNION | UNIQUE | UPDATE | USING | VACUUM | VALUES | VIEW | VIRTUAL | WHEN | WHERE ) ;
    public final SqlParser.keyword_column_def_return keyword_column_def() throws RecognitionException {
        SqlParser.keyword_column_def_return retval = new SqlParser.keyword_column_def_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set512=null;

        Object set512_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:654:19: ( ( ABORT | ADD | AFTER | ALL | ALTER | ANALYZE | AND | AS | ASC | ATTACH | AUTOINCREMENT | BEFORE | BEGIN | BETWEEN | BY | CASCADE | CASE | CAST | CHECK | COLLATE | COMMIT | CONFLICT | CREATE | CROSS | CURRENT_TIME | CURRENT_DATE | CURRENT_TIMESTAMP | DATABASE | DEFAULT | DEFERRABLE | DEFERRED | DELETE | DESC | DETACH | DISTINCT | DROP | EACH | ELSE | END | ESCAPE | EXCEPT | EXCLUSIVE | EXISTS | EXPLAIN | FAIL | FOR | FOREIGN | FROM | GLOB | GROUP | HAVING | IF | IGNORE | IMMEDIATE | IN | INDEX | INDEXED | INITIALLY | INNER | INSERT | INSTEAD | INTERSECT | INTO | IS | ISNULL | JOIN | KEY | LEFT | LIKE | LIMIT | MATCH | NATURAL | NOT | NOTNULL | NULL | OF | OFFSET | ON | OR | ORDER | OUTER | PLAN | PRAGMA | PRIMARY | QUERY | RAISE | REFERENCES | REGEXP | REINDEX | RELEASE | RENAME | REPLACE | RESTRICT | ROLLBACK | ROW | SAVEPOINT | SELECT | SET | TABLE | TEMPORARY | THEN | TO | TRANSACTION | TRIGGER | UNION | UNIQUE | UPDATE | USING | VACUUM | VALUES | VIEW | VIRTUAL | WHEN | WHERE ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
            {
            root_0 = (Object)adaptor.nil();


            set512=(Token)input.LT(1);

            if ( (input.LA(1) >= ABORT && input.LA(1) <= AFTER)||(input.LA(1) >= ALL && input.LA(1) <= ALTER)||(input.LA(1) >= ANALYZE && input.LA(1) <= AND)||(input.LA(1) >= AS && input.LA(1) <= ASC)||(input.LA(1) >= ATTACH && input.LA(1) <= AUTOINCREMENT)||(input.LA(1) >= BEFORE && input.LA(1) <= BETWEEN)||input.LA(1)==BY||(input.LA(1) >= CASCADE && input.LA(1) <= COLLATE)||(input.LA(1) >= COMMIT && input.LA(1) <= CONFLICT)||input.LA(1)==CREATE||(input.LA(1) >= CROSS && input.LA(1) <= CURRENT_TIMESTAMP)||(input.LA(1) >= DATABASE && input.LA(1) <= DISTINCT)||input.LA(1)==DROP||(input.LA(1) >= EACH && input.LA(1) <= END)||(input.LA(1) >= ESCAPE && input.LA(1) <= EXPLAIN)||input.LA(1)==FAIL||(input.LA(1) >= FOR && input.LA(1) <= FROM)||input.LA(1)==GLOB||input.LA(1)==GROUP||input.LA(1)==HAVING||(input.LA(1) >= IF && input.LA(1) <= INSTEAD)||(input.LA(1) >= INTERSECT && input.LA(1) <= INTO)||(input.LA(1) >= IS && input.LA(1) <= ISNULL)||input.LA(1)==JOIN||input.LA(1)==KEY||input.LA(1)==LEFT||(input.LA(1) >= LIKE && input.LA(1) <= LIMIT)||input.LA(1)==MATCH||(input.LA(1) >= NATURAL && input.LA(1) <= NOTNULL)||input.LA(1)==NULL||(input.LA(1) >= OF && input.LA(1) <= ON)||(input.LA(1) >= OR && input.LA(1) <= ORDER)||input.LA(1)==OUTER||input.LA(1)==PLAN||(input.LA(1) >= PRAGMA && input.LA(1) <= PRIMARY)||input.LA(1)==QUERY||(input.LA(1) >= RAISE && input.LA(1) <= ROW)||(input.LA(1) >= SAVEPOINT && input.LA(1) <= SELECT)||input.LA(1)==SET||input.LA(1)==TABLE||(input.LA(1) >= TEMPORARY && input.LA(1) <= THEN)||(input.LA(1) >= TO && input.LA(1) <= TRIGGER)||(input.LA(1) >= UNION && input.LA(1) <= USING)||(input.LA(1) >= VACUUM && input.LA(1) <= VIRTUAL)||(input.LA(1) >= WHEN && input.LA(1) <= WHERE) ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set512)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyword_column_def"


    public static class bool_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bool"
    // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:960:1: bool : ( TRUE | FALSE ) ;
    public final SqlParser.bool_return bool() throws RecognitionException {
        SqlParser.bool_return retval = new SqlParser.bool_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token set513=null;

        Object set513_tree=null;

        try {
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:960:5: ( ( TRUE | FALSE ) )
            // /home/docker/project/sqljet/src/main/antlr/org/tmatesoft/sqljet/core/internal/lang/Sql.g:
            {
            root_0 = (Object)adaptor.nil();


            set513=(Token)input.LT(1);

            if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                input.consume();
                adaptor.addChild(root_0, 
                (Object)adaptor.create(set513)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bool"

    // Delegated rules


    protected DFA10 dfa10 = new DFA10(this);
    protected DFA11 dfa11 = new DFA11(this);
    protected DFA12 dfa12 = new DFA12(this);
    protected DFA26 dfa26 = new DFA26(this);
    protected DFA14 dfa14 = new DFA14(this);
    protected DFA18 dfa18 = new DFA18(this);
    protected DFA33 dfa33 = new DFA33(this);
    protected DFA44 dfa44 = new DFA44(this);
    protected DFA34 dfa34 = new DFA34(this);
    protected DFA71 dfa71 = new DFA71(this);
    protected DFA80 dfa80 = new DFA80(this);
    protected DFA79 dfa79 = new DFA79(this);
    protected DFA78 dfa78 = new DFA78(this);
    protected DFA124 dfa124 = new DFA124(this);
    protected DFA129 dfa129 = new DFA129(this);
    static final String DFA10_eotS =
        "\151\uffff";
    static final String DFA10_eofS =
        "\1\1\35\uffff\1\1\112\uffff";
    static final String DFA10_minS =
        "\1\5\35\uffff\1\5\2\uffff\2\5\1\36\1\11\2\103\1\36\1\103\100\uffff";
    static final String DFA10_maxS =
        "\1\u00eb\35\uffff\1\u00eb\2\uffff\2\u00eb\1\103\3\u00c1\1\103\1"+
        "\173\100\uffff";
    static final String DFA10_acceptS =
        "\1\uffff\1\2\52\uffff\1\1\74\uffff";
    static final String DFA10_specialS =
        "\151\uffff}>";
    static final String[] DFA10_transitionS = {
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\3\1\1\uffff\1\1\4\uffff\4\1\1\uffff\10\1\3\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\7\uffff"+
            "\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\1\36\1\1\1\uffff\1\1\3"+
            "\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff\10\1"+
            "\2\uffff\2\1\1\uffff\2\1\4\uffff\1\1\11\uffff\1\1\1\uffff\2"+
            "\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\54\1\uffff\2\54\1\uffff\2\54\1\uffff\2\54\1\uffff\3\54\2"+
            "\uffff\3\54\2\uffff\1\54\1\uffff\1\54\1\uffff\7\54\3\uffff\1"+
            "\1\1\uffff\3\54\1\uffff\1\54\4\uffff\4\54\1\uffff\10\54\3\uffff"+
            "\1\54\3\uffff\3\54\2\uffff\1\54\1\46\3\54\1\uffff\3\54\2\uffff"+
            "\2\54\1\41\6\uffff\1\43\1\uffff\1\54\1\uffff\1\54\12\uffff\3"+
            "\54\1\uffff\7\54\1\uffff\1\45\1\54\2\uffff\1\54\4\uffff\1\54"+
            "\1\uffff\1\54\1\uffff\1\54\3\uffff\1\50\1\uffff\1\54\3\uffff"+
            "\1\54\1\uffff\2\54\4\uffff\1\54\1\uffff\3\54\1\uffff\1\54\1"+
            "\47\1\uffff\1\54\3\uffff\4\54\1\uffff\2\54\3\uffff\2\54\1\uffff"+
            "\7\54\1\1\2\uffff\2\54\1\uffff\1\1\1\54\4\uffff\1\54\11\uffff"+
            "\1\54\1\uffff\7\54\4\uffff\1\44\3\54\1\uffff\4\54\1\uffff\1"+
            "\54\1\42",
            "",
            "",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\54\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\5\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\2\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\1\uffff\3\1\2\uffff"+
            "\3\1\2\uffff\1\1\1\uffff\1\1\1\uffff\7\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\54\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\3\1\2\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\7\1\1\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\4\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\2\1\1\uffff\1\1\3\uffff\4\1\1\uffff\2\1\3\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\7\1\4\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\1\1\44\uffff\1\54",
            "\1\1\71\uffff\1\54\175\uffff\1\1",
            "\1\54\175\uffff\1\1",
            "\1\54\175\uffff\1\1",
            "\1\1\44\uffff\1\54",
            "\1\54\67\uffff\1\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA10_eot = DFA.unpackEncodedString(DFA10_eotS);
    static final short[] DFA10_eof = DFA.unpackEncodedString(DFA10_eofS);
    static final char[] DFA10_min = DFA.unpackEncodedStringToUnsignedChars(DFA10_minS);
    static final char[] DFA10_max = DFA.unpackEncodedStringToUnsignedChars(DFA10_maxS);
    static final short[] DFA10_accept = DFA.unpackEncodedString(DFA10_acceptS);
    static final short[] DFA10_special = DFA.unpackEncodedString(DFA10_specialS);
    static final short[][] DFA10_transition;

    static {
        int numStates = DFA10_transitionS.length;
        DFA10_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA10_transition[i] = DFA.unpackEncodedString(DFA10_transitionS[i]);
        }
    }

    class DFA10 extends DFA {

        public DFA10(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 10;
            this.eot = DFA10_eot;
            this.eof = DFA10_eof;
            this.min = DFA10_min;
            this.max = DFA10_max;
            this.accept = DFA10_accept;
            this.special = DFA10_special;
            this.transition = DFA10_transition;
        }
        public String getDescription() {
            return "()* loopback of 199:18: ( OR ^ or_subexpr )*";
        }
    }
    static final String DFA11_eotS =
        "\152\uffff";
    static final String DFA11_eofS =
        "\1\1\36\uffff\1\1\112\uffff";
    static final String DFA11_minS =
        "\1\5\36\uffff\1\5\2\uffff\2\5\1\36\1\11\2\103\1\36\1\103\100\uffff";
    static final String DFA11_maxS =
        "\1\u00eb\36\uffff\1\u00eb\2\uffff\2\u00eb\1\103\3\u00c1\1\103\1"+
        "\173\100\uffff";
    static final String DFA11_acceptS =
        "\1\uffff\1\2\53\uffff\1\1\74\uffff";
    static final String DFA11_specialS =
        "\152\uffff}>";
    static final String[] DFA11_transitionS = {
            "\3\1\1\uffff\2\1\1\uffff\1\1\1\37\1\uffff\2\1\2\uffff\2\1\2"+
            "\uffff\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1"+
            "\uffff\3\1\1\uffff\1\1\4\uffff\4\1\1\uffff\10\1\3\uffff\1\1"+
            "\3\uffff\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1"+
            "\1\uffff\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2"+
            "\1\2\uffff\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1"+
            "\1\7\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\2\1\1\uffff\1"+
            "\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff\10"+
            "\1\2\uffff\2\1\1\uffff\2\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\55\1\uffff\2\55\1\uffff\2\55\1\uffff\2\55\1\uffff\3\55\2"+
            "\uffff\3\55\2\uffff\1\55\1\uffff\1\55\1\uffff\7\55\3\uffff\1"+
            "\1\1\uffff\3\55\1\uffff\1\55\4\uffff\4\55\1\uffff\10\55\3\uffff"+
            "\1\55\3\uffff\3\55\2\uffff\1\55\1\47\3\55\1\uffff\3\55\2\uffff"+
            "\2\55\1\42\6\uffff\1\44\1\uffff\1\55\1\uffff\1\55\12\uffff\3"+
            "\55\1\uffff\7\55\1\uffff\1\46\1\55\2\uffff\1\55\4\uffff\1\55"+
            "\1\uffff\1\55\1\uffff\1\55\3\uffff\1\51\1\uffff\1\55\3\uffff"+
            "\1\55\1\uffff\2\55\4\uffff\1\55\1\uffff\3\55\1\uffff\1\55\1"+
            "\50\1\uffff\1\55\3\uffff\4\55\1\uffff\2\55\3\uffff\2\55\1\uffff"+
            "\7\55\1\1\2\uffff\2\55\1\uffff\1\1\1\55\4\uffff\1\55\11\uffff"+
            "\1\55\1\uffff\7\55\4\uffff\1\45\3\55\1\uffff\4\55\1\uffff\1"+
            "\55\1\43",
            "",
            "",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\55\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\5\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\2\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\1\uffff\3\1\2\uffff"+
            "\3\1\2\uffff\1\1\1\uffff\1\1\1\uffff\7\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\55\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\3\1\2\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\7\1\1\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\4\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\2\1\1\uffff\1\1\3\uffff\4\1\1\uffff\2\1\3\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\7\1\4\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\1\1\44\uffff\1\55",
            "\1\1\71\uffff\1\55\175\uffff\1\1",
            "\1\55\175\uffff\1\1",
            "\1\55\175\uffff\1\1",
            "\1\1\44\uffff\1\55",
            "\1\55\67\uffff\1\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA11_eot = DFA.unpackEncodedString(DFA11_eotS);
    static final short[] DFA11_eof = DFA.unpackEncodedString(DFA11_eofS);
    static final char[] DFA11_min = DFA.unpackEncodedStringToUnsignedChars(DFA11_minS);
    static final char[] DFA11_max = DFA.unpackEncodedStringToUnsignedChars(DFA11_maxS);
    static final short[] DFA11_accept = DFA.unpackEncodedString(DFA11_acceptS);
    static final short[] DFA11_special = DFA.unpackEncodedString(DFA11_specialS);
    static final short[][] DFA11_transition;

    static {
        int numStates = DFA11_transitionS.length;
        DFA11_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA11_transition[i] = DFA.unpackEncodedString(DFA11_transitionS[i]);
        }
    }

    class DFA11 extends DFA {

        public DFA11(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 11;
            this.eot = DFA11_eot;
            this.eof = DFA11_eof;
            this.min = DFA11_min;
            this.max = DFA11_max;
            this.accept = DFA11_accept;
            this.special = DFA11_special;
            this.transition = DFA11_transition;
        }
        public String getDescription() {
            return "()* loopback of 201:25: ( AND ^ and_subexpr )*";
        }
    }
    static final String DFA12_eotS =
        "\u0081\uffff";
    static final String DFA12_eofS =
        "\1\12\6\uffff\2\12\170\uffff";
    static final String DFA12_minS =
        "\1\5\6\uffff\1\52\1\5\102\uffff\1\5\2\uffff\1\5\1\36\1\11\2\103"+
        "\1\36\1\103\54\uffff";
    static final String DFA12_maxS =
        "\1\u00eb\6\uffff\2\u00eb\102\uffff\1\u00eb\2\uffff\1\u00eb\1\103"+
        "\3\u00c1\1\103\1\173\54\uffff";
    static final String DFA12_acceptS =
        "\1\uffff\1\1\10\uffff\1\2\166\uffff";
    static final String DFA12_specialS =
        "\u0081\uffff}>";
    static final String[] DFA12_transitionS = {
            "\3\12\1\uffff\2\12\1\uffff\2\12\1\uffff\2\12\2\uffff\2\12\2"+
            "\uffff\2\12\1\10\4\uffff\1\12\1\uffff\5\12\1\uffff\1\12\3\uffff"+
            "\1\12\1\uffff\3\12\1\uffff\1\12\4\uffff\4\12\1\uffff\10\12\3"+
            "\uffff\1\12\3\uffff\3\12\2\1\5\12\1\uffff\1\12\4\uffff\3\12"+
            "\3\uffff\1\1\2\uffff\1\12\1\uffff\1\12\1\uffff\1\12\12\uffff"+
            "\3\12\1\1\6\12\2\uffff\2\12\2\uffff\1\7\1\1\3\uffff\1\12\1\uffff"+
            "\1\12\1\uffff\1\12\2\uffff\1\1\1\12\4\uffff\1\1\2\uffff\1\12"+
            "\4\1\1\uffff\1\12\1\uffff\3\12\1\uffff\2\12\1\uffff\1\12\3\uffff"+
            "\1\12\1\uffff\2\12\1\uffff\1\12\4\uffff\2\12\1\1\10\12\2\uffff"+
            "\2\12\1\uffff\2\12\4\uffff\1\12\11\uffff\1\12\1\uffff\2\12\1"+
            "\uffff\3\12\5\uffff\4\12\1\uffff\4\12\1\uffff\2\12",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\12\44\uffff\1\12\13\uffff\1\12\6\uffff\1\12\32\uffff\1\12"+
            "\20\uffff\1\12\10\uffff\1\1\4\uffff\1\1\6\uffff\1\12\31\uffff"+
            "\1\12\5\uffff\1\12\34\uffff\1\12\12\uffff\1\12",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\1\uffff\3\1\2\uffff"+
            "\3\1\2\uffff\1\1\1\uffff\1\1\1\uffff\7\1\3\uffff\1\12\1\uffff"+
            "\3\1\1\uffff\1\1\4\uffff\4\1\1\uffff\10\1\3\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\1\1\1\122\3\1\1\uffff\3\1\2\uffff\2\1\1\113\6\uffff"+
            "\1\117\1\uffff\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\7\1\1\uffff"+
            "\1\121\1\1\2\uffff\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3"+
            "\uffff\1\124\1\uffff\1\1\3\uffff\1\1\1\uffff\2\1\4\uffff\1\1"+
            "\1\uffff\3\1\1\uffff\1\1\1\123\1\uffff\1\1\3\uffff\4\1\1\uffff"+
            "\2\1\3\uffff\2\1\1\uffff\7\1\1\12\2\uffff\2\1\1\uffff\1\12\1"+
            "\1\4\uffff\1\1\11\uffff\1\1\1\uffff\7\1\4\uffff\1\120\3\1\1"+
            "\uffff\4\1\1\uffff\1\1\1\116",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\12\1\uffff\2\12\1\uffff\2\12\1\uffff\2\12\2\uffff\2\12\2"+
            "\uffff\3\12\4\uffff\1\12\1\uffff\5\12\1\uffff\1\12\5\uffff\3"+
            "\12\1\uffff\1\12\4\uffff\4\12\1\uffff\10\12\1\uffff\1\1\1\uffff"+
            "\1\12\3\uffff\3\12\2\uffff\5\12\1\uffff\1\12\4\uffff\3\12\6"+
            "\uffff\1\12\1\uffff\1\12\1\uffff\1\12\12\uffff\3\12\1\uffff"+
            "\6\12\2\uffff\2\12\2\uffff\1\12\4\uffff\1\12\1\uffff\1\12\1"+
            "\uffff\1\12\3\uffff\1\12\1\uffff\1\12\5\uffff\1\12\5\uffff\1"+
            "\12\1\uffff\3\12\1\uffff\2\12\1\uffff\1\12\3\uffff\1\12\1\uffff"+
            "\2\12\1\uffff\1\12\4\uffff\2\12\1\uffff\7\12\3\uffff\2\12\2"+
            "\uffff\1\12\4\uffff\1\12\11\uffff\1\12\1\uffff\2\12\1\uffff"+
            "\3\12\5\uffff\4\12\1\uffff\4\12\1\uffff\2\12",
            "",
            "",
            "\3\12\1\uffff\2\12\1\uffff\2\12\1\uffff\2\12\1\uffff\3\12\2"+
            "\uffff\3\12\2\uffff\1\12\1\uffff\1\12\1\uffff\7\12\5\uffff\3"+
            "\12\1\uffff\1\12\4\uffff\4\12\1\uffff\10\12\1\uffff\1\1\1\uffff"+
            "\1\12\3\uffff\3\12\2\uffff\5\12\1\uffff\3\12\2\uffff\3\12\6"+
            "\uffff\1\12\1\uffff\1\12\1\uffff\1\12\12\uffff\3\12\1\uffff"+
            "\7\12\1\uffff\2\12\2\uffff\1\12\4\uffff\1\12\1\uffff\1\12\1"+
            "\uffff\1\12\3\uffff\1\12\1\uffff\1\12\3\uffff\1\12\1\uffff\2"+
            "\12\4\uffff\1\12\1\uffff\3\12\1\uffff\2\12\1\uffff\1\12\3\uffff"+
            "\4\12\1\uffff\2\12\3\uffff\2\12\1\uffff\7\12\3\uffff\2\12\2"+
            "\uffff\1\12\4\uffff\1\12\11\uffff\1\12\1\uffff\7\12\4\uffff"+
            "\4\12\1\uffff\4\12\1\uffff\2\12",
            "\1\12\44\uffff\1\1",
            "\1\12\71\uffff\1\1\175\uffff\1\12",
            "\1\1\175\uffff\1\12",
            "\1\1\175\uffff\1\12",
            "\1\12\44\uffff\1\1",
            "\1\1\67\uffff\1\12",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA12_eot = DFA.unpackEncodedString(DFA12_eotS);
    static final short[] DFA12_eof = DFA.unpackEncodedString(DFA12_eofS);
    static final char[] DFA12_min = DFA.unpackEncodedStringToUnsignedChars(DFA12_minS);
    static final char[] DFA12_max = DFA.unpackEncodedStringToUnsignedChars(DFA12_maxS);
    static final short[] DFA12_accept = DFA.unpackEncodedString(DFA12_acceptS);
    static final short[] DFA12_special = DFA.unpackEncodedString(DFA12_specialS);
    static final short[][] DFA12_transition;

    static {
        int numStates = DFA12_transitionS.length;
        DFA12_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA12_transition[i] = DFA.unpackEncodedString(DFA12_transitionS[i]);
        }
    }

    class DFA12 extends DFA {

        public DFA12(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 12;
            this.eot = DFA12_eot;
            this.eof = DFA12_eof;
            this.min = DFA12_min;
            this.max = DFA12_max;
            this.accept = DFA12_accept;
            this.special = DFA12_special;
            this.transition = DFA12_transition;
        }
        public String getDescription() {
            return "203:34: ( cond_expr ^)?";
        }
    }
    static final String DFA26_eotS =
        "\u00ba\uffff";
    static final String DFA26_eofS =
        "\u00ba\uffff";
    static final String DFA26_minS =
        "\2\31\1\uffff\2\5\2\uffff\1\u0097\4\uffff\1\5\2\uffff\1\5\3\uffff"+
        "\1\5\25\uffff\2\5\26\uffff\1\5\3\uffff\1\5\164\uffff";
    static final String DFA26_maxS =
        "\2\u00b5\1\uffff\2\u00eb\2\uffff\1\u009c\4\uffff\1\u00eb\2\uffff"+
        "\1\u00eb\3\uffff\1\u00eb\25\uffff\2\u00eb\26\uffff\1\u00eb\3\uffff"+
        "\1\u00eb\164\uffff";
    static final String DFA26_acceptS =
        "\2\uffff\1\1\2\uffff\1\6\2\uffff\1\10\1\11\3\uffff\1\5\2\uffff\1"+
        "\3\35\uffff\1\2\25\uffff\1\4\27\uffff\1\6\1\7\46\uffff\1\2\34\uffff"+
        "\30\5\1\uffff";
    static final String DFA26_specialS =
        "\u00ba\uffff}>";
    static final String[] DFA26_transitionS = {
            "\1\10\62\uffff\1\4\1\11\21\uffff\1\2\24\uffff\1\3\14\uffff\1"+
            "\7\1\5\12\uffff\1\2\5\uffff\1\2\3\uffff\1\1\1\5\2\11\32\uffff"+
            "\1\2",
            "\1\10\62\uffff\1\15\22\uffff\1\2\24\uffff\1\14\30\uffff\1\2"+
            "\5\uffff\1\2\10\uffff\1\5\30\uffff\1\2",
            "",
            "\3\20\1\uffff\2\20\1\uffff\2\20\1\uffff\2\20\2\uffff\2\20\2"+
            "\uffff\3\20\4\uffff\1\20\1\uffff\5\20\1\uffff\1\20\5\uffff\3"+
            "\20\1\uffff\1\20\4\uffff\4\20\1\uffff\10\20\3\uffff\1\20\3\uffff"+
            "\3\20\2\uffff\5\20\1\uffff\1\20\4\uffff\3\20\6\uffff\1\20\1"+
            "\uffff\1\20\1\uffff\1\20\12\uffff\3\20\1\uffff\6\20\2\uffff"+
            "\2\20\2\uffff\1\20\4\uffff\1\20\1\uffff\1\20\1\uffff\1\20\3"+
            "\uffff\1\20\1\uffff\1\17\5\uffff\1\20\5\uffff\1\20\1\uffff\3"+
            "\20\1\uffff\2\20\1\uffff\1\20\3\uffff\1\20\1\uffff\2\20\1\uffff"+
            "\1\20\4\uffff\2\20\1\uffff\7\20\3\uffff\2\20\2\uffff\1\20\4"+
            "\uffff\1\20\11\uffff\1\20\1\uffff\2\20\1\uffff\3\20\5\uffff"+
            "\4\20\1\uffff\4\20\1\uffff\2\20",
            "\3\11\1\uffff\2\11\1\uffff\2\11\1\uffff\2\11\1\uffff\3\11\2"+
            "\uffff\3\11\2\uffff\1\11\1\uffff\1\11\1\uffff\7\11\5\uffff\3"+
            "\11\1\uffff\1\11\4\uffff\4\11\1\uffff\10\11\3\uffff\1\11\3\uffff"+
            "\3\11\2\uffff\5\11\1\uffff\3\11\2\uffff\3\11\6\uffff\1\11\1"+
            "\uffff\1\11\1\uffff\1\11\12\uffff\3\11\1\uffff\7\11\1\uffff"+
            "\2\11\2\uffff\1\11\4\uffff\1\11\1\uffff\1\11\1\uffff\1\11\3"+
            "\uffff\1\11\1\uffff\1\23\3\uffff\1\11\1\uffff\2\11\4\uffff\1"+
            "\11\1\uffff\3\11\1\uffff\2\11\1\uffff\1\11\3\uffff\4\11\1\uffff"+
            "\2\11\3\uffff\2\11\1\uffff\7\11\3\uffff\2\11\2\uffff\1\11\4"+
            "\uffff\1\11\11\uffff\1\11\1\uffff\7\11\4\uffff\4\11\1\uffff"+
            "\4\11\1\uffff\2\11",
            "",
            "",
            "\1\51\4\uffff\1\5",
            "",
            "",
            "",
            "",
            "\3\20\1\uffff\2\20\1\uffff\2\20\1\uffff\2\20\2\uffff\2\20\2"+
            "\uffff\3\20\4\uffff\1\20\1\uffff\5\20\1\uffff\1\20\5\uffff\3"+
            "\20\1\uffff\1\20\4\uffff\4\20\1\uffff\10\20\3\uffff\1\20\3\uffff"+
            "\3\20\2\uffff\5\20\1\uffff\1\20\4\uffff\3\20\6\uffff\1\20\1"+
            "\uffff\1\20\1\uffff\1\20\12\uffff\3\20\1\uffff\6\20\2\uffff"+
            "\2\20\2\uffff\1\20\4\uffff\1\20\1\uffff\1\20\1\uffff\1\20\3"+
            "\uffff\1\20\1\uffff\1\52\5\uffff\1\20\5\uffff\1\20\1\uffff\3"+
            "\20\1\uffff\2\20\1\uffff\1\20\3\uffff\1\20\1\uffff\2\20\1\uffff"+
            "\1\20\4\uffff\2\20\1\uffff\7\20\3\uffff\2\20\2\uffff\1\20\4"+
            "\uffff\1\20\11\uffff\1\20\1\uffff\2\20\1\uffff\3\20\5\uffff"+
            "\4\20\1\uffff\4\20\1\uffff\2\20",
            "",
            "",
            "\3\56\1\uffff\2\56\1\uffff\2\56\1\uffff\2\56\1\uffff\3\56\2"+
            "\uffff\3\56\2\uffff\1\56\1\uffff\1\56\1\uffff\7\56\5\uffff\3"+
            "\56\1\uffff\1\56\4\uffff\4\56\1\uffff\10\56\3\uffff\1\56\3\uffff"+
            "\3\56\2\uffff\5\56\1\uffff\3\56\2\uffff\3\56\6\uffff\1\56\1"+
            "\uffff\1\56\1\uffff\1\56\12\uffff\3\56\1\uffff\7\56\1\uffff"+
            "\2\56\2\uffff\1\56\4\uffff\1\56\1\uffff\1\56\1\uffff\1\56\3"+
            "\uffff\1\56\1\uffff\1\56\3\uffff\1\56\1\uffff\2\56\4\uffff\1"+
            "\56\1\uffff\3\56\1\uffff\2\56\1\uffff\1\56\3\uffff\4\56\1\uffff"+
            "\2\56\3\uffff\2\56\1\uffff\7\56\1\104\2\uffff\1\56\1\101\2\uffff"+
            "\1\56\4\uffff\1\56\11\uffff\1\56\1\uffff\7\56\4\uffff\4\56\1"+
            "\uffff\4\56\1\uffff\2\56",
            "",
            "",
            "",
            "\3\11\1\uffff\2\11\1\uffff\2\11\1\uffff\2\11\1\uffff\3\11\2"+
            "\uffff\3\11\2\uffff\1\11\1\uffff\1\11\1\uffff\7\11\5\uffff\3"+
            "\11\1\uffff\1\11\4\uffff\4\11\1\uffff\10\11\3\uffff\1\11\3\uffff"+
            "\3\11\2\uffff\5\11\1\uffff\3\11\2\uffff\3\11\6\uffff\1\11\1"+
            "\uffff\1\11\1\uffff\1\11\12\uffff\3\11\1\uffff\7\11\1\uffff"+
            "\2\11\2\uffff\1\11\4\uffff\1\11\1\uffff\1\11\1\uffff\1\11\3"+
            "\uffff\1\11\1\uffff\1\11\3\uffff\1\11\1\uffff\2\11\4\uffff\1"+
            "\11\1\uffff\3\11\1\uffff\2\11\1\uffff\1\11\3\uffff\4\11\1\uffff"+
            "\2\11\3\uffff\2\11\1\uffff\7\11\1\15\2\uffff\1\11\1\105\2\uffff"+
            "\1\11\4\uffff\1\11\11\uffff\1\11\1\uffff\7\11\4\uffff\4\11\1"+
            "\uffff\4\11\1\uffff\2\11",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\135\1\uffff\2\135\1\uffff\2\135\1\uffff\2\135\1\uffff\3"+
            "\135\2\uffff\3\135\2\uffff\1\135\1\uffff\1\135\1\uffff\7\135"+
            "\5\uffff\3\135\1\uffff\1\135\4\uffff\4\135\1\uffff\10\135\3"+
            "\uffff\1\135\3\uffff\3\135\2\uffff\5\135\1\uffff\3\135\2\uffff"+
            "\3\135\6\uffff\1\135\1\uffff\1\135\1\uffff\1\135\12\uffff\3"+
            "\135\1\uffff\7\135\1\uffff\2\135\2\uffff\1\135\4\uffff\1\135"+
            "\1\uffff\1\135\1\uffff\1\135\3\uffff\1\135\1\uffff\1\135\3\uffff"+
            "\1\135\1\uffff\2\135\4\uffff\1\134\1\uffff\3\135\1\uffff\2\135"+
            "\1\uffff\1\135\3\uffff\4\135\1\uffff\2\135\3\uffff\2\135\1\uffff"+
            "\7\135\3\uffff\2\135\2\uffff\1\135\4\uffff\1\135\11\uffff\1"+
            "\135\1\uffff\7\135\4\uffff\4\135\1\uffff\4\135\1\uffff\2\135",
            "\3\56\1\uffff\2\56\1\uffff\2\56\1\uffff\2\56\1\uffff\3\56\2"+
            "\uffff\3\56\2\uffff\1\56\1\uffff\1\56\1\uffff\7\56\5\uffff\3"+
            "\56\1\uffff\1\56\4\uffff\4\56\1\uffff\10\56\3\uffff\1\56\3\uffff"+
            "\3\56\2\uffff\5\56\1\uffff\3\56\2\uffff\3\56\6\uffff\1\56\1"+
            "\uffff\1\56\1\uffff\1\56\12\uffff\3\56\1\uffff\7\56\1\uffff"+
            "\2\56\2\uffff\1\56\4\uffff\1\56\1\uffff\1\56\1\uffff\1\56\3"+
            "\uffff\1\56\1\uffff\1\56\3\uffff\1\56\1\uffff\2\56\4\uffff\1"+
            "\56\1\uffff\3\56\1\uffff\2\56\1\uffff\1\56\3\uffff\4\56\1\uffff"+
            "\2\56\3\uffff\2\56\1\uffff\7\56\1\104\2\uffff\1\56\1\u0084\2"+
            "\uffff\1\56\4\uffff\1\56\11\uffff\1\56\1\uffff\7\56\4\uffff"+
            "\4\56\1\uffff\4\56\1\uffff\2\56",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\104\1\uffff\2\104\1\uffff\2\104\1\uffff\6\104\2\uffff\3"+
            "\104\2\uffff\1\104\1\uffff\1\104\1\uffff\7\104\5\uffff\3\104"+
            "\1\uffff\1\104\4\uffff\4\104\1\uffff\10\104\1\uffff\1\56\1\uffff"+
            "\1\104\3\uffff\3\104\2\uffff\5\104\1\uffff\3\104\2\uffff\3\104"+
            "\6\uffff\1\104\1\uffff\1\104\1\uffff\1\104\12\uffff\3\104\1"+
            "\uffff\7\104\1\uffff\2\104\2\uffff\1\104\4\uffff\1\104\1\uffff"+
            "\1\104\1\uffff\1\104\3\uffff\1\104\1\uffff\1\104\3\uffff\1\104"+
            "\1\uffff\2\104\4\uffff\1\104\1\uffff\3\104\1\uffff\2\104\1\uffff"+
            "\1\104\3\uffff\4\104\1\uffff\2\104\3\uffff\2\104\1\uffff\7\104"+
            "\3\uffff\2\104\2\uffff\1\104\4\uffff\1\104\11\uffff\1\104\1"+
            "\uffff\7\104\4\uffff\4\104\1\uffff\4\104\1\uffff\2\104",
            "",
            "",
            "",
            "\3\u00b7\1\uffff\1\u00a1\1\u00b7\1\uffff\2\u00b7\1\uffff\2"+
            "\u00b7\1\u00a3\1\u00b1\2\u00b7\2\uffff\3\u00b7\2\uffff\1\u00a9"+
            "\1\uffff\1\u00b7\1\uffff\1\u00b7\1\u00b5\1\u00ad\2\u00b7\1\u00b0"+
            "\1\u00b7\5\uffff\3\u00b7\1\uffff\1\u00b7\4\uffff\1\u00b7\1\u00ab"+
            "\1\u00aa\1\u00ac\1\uffff\7\u00b7\1\u00a2\1\uffff\1\11\1\uffff"+
            "\1\u00b7\3\uffff\3\u00b7\2\uffff\3\u00b7\1\u00b3\1\u00b7\1\uffff"+
            "\1\u00b7\1\u00ae\1\u00a8\2\uffff\3\u00b7\6\uffff\1\u00b7\1\uffff"+
            "\1\u00b7\1\uffff\1\u00a4\12\uffff\3\u00b7\1\uffff\6\u00b7\1"+
            "\u00a7\1\uffff\2\u00b7\2\uffff\1\u00b7\4\uffff\1\u00b7\1\uffff"+
            "\1\u00b7\1\uffff\1\u00b7\3\uffff\1\u00b7\1\uffff\1\u00b2\3\uffff"+
            "\1\u00b8\1\uffff\1\u00b7\1\u00b4\4\uffff\1\u00a6\1\uffff\3\u00b7"+
            "\1\uffff\2\u00b7\1\uffff\1\u00b7\3\uffff\1\u00b7\1\u00b8\2\u00b7"+
            "\1\uffff\1\u00b7\1\u00af\3\uffff\1\u00b6\1\u00b7\1\uffff\7\u00b7"+
            "\3\uffff\2\u00b7\2\uffff\1\u00b7\4\uffff\1\u00a5\11\uffff\1"+
            "\u00b7\1\uffff\2\u00b7\1\u00b8\3\u00b7\1\u00ae\4\uffff\4\u00b7"+
            "\1\uffff\4\u00b7\1\uffff\2\u00b7",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA26_eot = DFA.unpackEncodedString(DFA26_eotS);
    static final short[] DFA26_eof = DFA.unpackEncodedString(DFA26_eofS);
    static final char[] DFA26_min = DFA.unpackEncodedStringToUnsignedChars(DFA26_minS);
    static final char[] DFA26_max = DFA.unpackEncodedStringToUnsignedChars(DFA26_maxS);
    static final short[] DFA26_accept = DFA.unpackEncodedString(DFA26_acceptS);
    static final short[] DFA26_special = DFA.unpackEncodedString(DFA26_specialS);
    static final short[][] DFA26_transition;

    static {
        int numStates = DFA26_transitionS.length;
        DFA26_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA26_transition[i] = DFA.unpackEncodedString(DFA26_transitionS[i]);
        }
    }

    class DFA26 extends DFA {

        public DFA26(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 26;
            this.eot = DFA26_eot;
            this.eof = DFA26_eof;
            this.min = DFA26_min;
            this.max = DFA26_max;
            this.accept = DFA26_accept;
            this.special = DFA26_special;
            this.transition = DFA26_transition;
        }
        public String getDescription() {
            return "205:1: cond_expr : ( ( NOT )? match_op match_expr= eq_subexpr ( ESCAPE escape_expr= eq_subexpr )? -> ^( match_op $match_expr ( NOT )? ( ^( ESCAPE $escape_expr) )? ) | ( NOT )? IN LPAREN expr ( COMMA expr )* RPAREN -> ^( IN_VALUES ( NOT )? ^( IN ( expr )+ ) ) | ( NOT )? IN (database_name= id DOT )? table_name= id -> ^( IN_TABLE ( NOT )? ^( IN ^( $table_name ( $database_name)? ) ) ) | ( NOT )? IN ^ LPAREN ! ( select_stmt )? RPAREN !| ( NOT )? EQUALS ^ LPAREN ! ( select_stmt )? RPAREN !| ( ISNULL -> IS_NULL | NOTNULL -> NOT_NULL | IS NULL -> IS_NULL | NOT NULL -> NOT_NULL | IS NOT NULL -> NOT_NULL ) | IS NOT ^ eq_subexpr | ( NOT )? BETWEEN e1= eq_subexpr AND e2= eq_subexpr -> ^( BETWEEN ( NOT )? ^( AND $e1 $e2) ) | ( ( EQUALS | EQUALS2 | NOT_EQUALS | NOT_EQUALS2 ) ^ eq_subexpr )+ );";
        }
    }
    static final String DFA14_eotS =
        "\153\uffff";
    static final String DFA14_eofS =
        "\2\2\151\uffff";
    static final String DFA14_minS =
        "\2\5\63\uffff\1\5\2\uffff\1\5\1\36\1\11\2\103\1\36\1\103\54\uffff";
    static final String DFA14_maxS =
        "\2\u00eb\63\uffff\1\u00eb\2\uffff\1\u00eb\1\103\3\u00c1\1\103\1"+
        "\173\54\uffff";
    static final String DFA14_acceptS =
        "\2\uffff\1\2\37\uffff\1\1\110\uffff";
    static final String DFA14_specialS =
        "\153\uffff}>";
    static final String[] DFA14_transitionS = {
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\2\2\2\uffff\2\2\2\uffff"+
            "\3\2\4\uffff\1\2\1\uffff\5\2\1\uffff\1\2\3\uffff\1\2\1\uffff"+
            "\3\2\1\uffff\1\2\4\uffff\4\2\1\uffff\10\2\3\uffff\1\2\3\uffff"+
            "\3\2\2\uffff\1\1\4\2\1\uffff\1\2\4\uffff\3\2\6\uffff\1\2\1\uffff"+
            "\1\2\1\uffff\1\2\12\uffff\3\2\1\uffff\6\2\2\uffff\2\2\2\uffff"+
            "\1\2\4\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\1\2\7\uffff"+
            "\1\2\5\uffff\1\2\1\uffff\3\2\1\uffff\2\2\1\uffff\1\2\3\uffff"+
            "\1\2\1\uffff\2\2\1\uffff\1\2\4\uffff\2\2\1\uffff\10\2\2\uffff"+
            "\2\2\1\uffff\2\2\4\uffff\1\2\11\uffff\1\2\1\uffff\2\2\1\uffff"+
            "\3\2\5\uffff\4\2\1\uffff\4\2\1\uffff\2\2",
            "\3\42\1\uffff\2\42\1\uffff\2\42\1\uffff\2\42\1\uffff\3\42\2"+
            "\uffff\3\42\2\uffff\1\42\1\uffff\1\42\1\uffff\7\42\3\uffff\1"+
            "\2\1\uffff\3\42\1\uffff\1\42\4\uffff\4\42\1\uffff\10\42\3\uffff"+
            "\1\42\3\uffff\3\42\2\uffff\1\42\1\74\3\42\1\uffff\3\42\2\uffff"+
            "\2\42\1\65\6\uffff\1\71\1\uffff\1\42\1\uffff\1\42\12\uffff\3"+
            "\42\1\uffff\7\42\1\uffff\1\73\1\42\2\uffff\1\42\4\uffff\1\42"+
            "\1\uffff\1\42\1\uffff\1\42\3\uffff\1\76\1\uffff\1\42\3\uffff"+
            "\1\42\1\uffff\2\42\4\uffff\1\42\1\uffff\3\42\1\uffff\1\42\1"+
            "\75\1\uffff\1\42\3\uffff\4\42\1\uffff\2\42\3\uffff\2\42\1\uffff"+
            "\7\42\1\2\2\uffff\2\42\1\uffff\1\2\1\42\4\uffff\1\42\11\uffff"+
            "\1\42\1\uffff\7\42\4\uffff\1\72\3\42\1\uffff\4\42\1\uffff\1"+
            "\42\1\70",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\2\2\2\uffff\2\2\2\uffff"+
            "\3\2\4\uffff\1\2\1\uffff\5\2\1\uffff\1\2\5\uffff\3\2\1\uffff"+
            "\1\2\4\uffff\4\2\1\uffff\10\2\1\uffff\1\42\1\uffff\1\2\3\uffff"+
            "\3\2\2\uffff\5\2\1\uffff\1\2\4\uffff\3\2\6\uffff\1\2\1\uffff"+
            "\1\2\1\uffff\1\2\12\uffff\3\2\1\uffff\6\2\2\uffff\2\2\2\uffff"+
            "\1\2\4\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\1\2\1\uffff"+
            "\1\2\5\uffff\1\2\5\uffff\1\2\1\uffff\3\2\1\uffff\2\2\1\uffff"+
            "\1\2\3\uffff\1\2\1\uffff\2\2\1\uffff\1\2\4\uffff\2\2\1\uffff"+
            "\7\2\3\uffff\2\2\2\uffff\1\2\4\uffff\1\2\11\uffff\1\2\1\uffff"+
            "\2\2\1\uffff\3\2\5\uffff\4\2\1\uffff\4\2\1\uffff\2\2",
            "",
            "",
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\2\2\1\uffff\3\2\2\uffff"+
            "\3\2\2\uffff\1\2\1\uffff\1\2\1\uffff\7\2\5\uffff\3\2\1\uffff"+
            "\1\2\4\uffff\4\2\1\uffff\10\2\1\uffff\1\42\1\uffff\1\2\3\uffff"+
            "\3\2\2\uffff\5\2\1\uffff\3\2\2\uffff\3\2\6\uffff\1\2\1\uffff"+
            "\1\2\1\uffff\1\2\12\uffff\3\2\1\uffff\7\2\1\uffff\2\2\2\uffff"+
            "\1\2\4\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\1\2\1\uffff"+
            "\1\2\3\uffff\1\2\1\uffff\2\2\4\uffff\1\2\1\uffff\3\2\1\uffff"+
            "\2\2\1\uffff\1\2\3\uffff\4\2\1\uffff\2\2\3\uffff\2\2\1\uffff"+
            "\7\2\3\uffff\2\2\2\uffff\1\2\4\uffff\1\2\11\uffff\1\2\1\uffff"+
            "\7\2\4\uffff\4\2\1\uffff\4\2\1\uffff\2\2",
            "\1\2\44\uffff\1\42",
            "\1\2\71\uffff\1\42\175\uffff\1\2",
            "\1\42\175\uffff\1\2",
            "\1\42\175\uffff\1\2",
            "\1\2\44\uffff\1\42",
            "\1\42\67\uffff\1\2",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA14_eot = DFA.unpackEncodedString(DFA14_eotS);
    static final short[] DFA14_eof = DFA.unpackEncodedString(DFA14_eofS);
    static final char[] DFA14_min = DFA.unpackEncodedStringToUnsignedChars(DFA14_minS);
    static final char[] DFA14_max = DFA.unpackEncodedStringToUnsignedChars(DFA14_maxS);
    static final short[] DFA14_accept = DFA.unpackEncodedString(DFA14_acceptS);
    static final short[] DFA14_special = DFA.unpackEncodedString(DFA14_specialS);
    static final short[][] DFA14_transition;

    static {
        int numStates = DFA14_transitionS.length;
        DFA14_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA14_transition[i] = DFA.unpackEncodedString(DFA14_transitionS[i]);
        }
    }

    class DFA14 extends DFA {

        public DFA14(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 14;
            this.eot = DFA14_eot;
            this.eof = DFA14_eof;
            this.min = DFA14_min;
            this.max = DFA14_max;
            this.accept = DFA14_accept;
            this.special = DFA14_special;
            this.transition = DFA14_transition;
        }
        public String getDescription() {
            return "206:41: ( ESCAPE escape_expr= eq_subexpr )?";
        }
    }
    static final String DFA18_eotS =
        "\147\uffff";
    static final String DFA18_eofS =
        "\1\uffff\3\5\143\uffff";
    static final String DFA18_minS =
        "\4\5\143\uffff";
    static final String DFA18_maxS =
        "\4\u00eb\143\uffff";
    static final String DFA18_acceptS =
        "\4\uffff\1\1\1\2\141\uffff";
    static final String DFA18_specialS =
        "\147\uffff}>";
    static final String[] DFA18_transitionS = {
            "\3\3\1\uffff\2\3\1\uffff\2\3\1\uffff\2\3\2\uffff\2\3\2\uffff"+
            "\3\3\4\uffff\1\3\1\uffff\5\3\1\uffff\1\3\5\uffff\3\3\1\uffff"+
            "\1\3\4\uffff\4\3\1\uffff\10\3\3\uffff\1\3\3\uffff\3\3\2\uffff"+
            "\5\3\1\uffff\1\3\4\uffff\3\3\6\uffff\1\3\1\uffff\1\3\1\uffff"+
            "\1\1\12\uffff\3\3\1\uffff\6\3\2\uffff\2\3\2\uffff\1\3\4\uffff"+
            "\1\3\1\uffff\1\3\1\uffff\1\3\3\uffff\1\3\7\uffff\1\3\5\uffff"+
            "\1\3\1\uffff\3\3\1\uffff\2\3\1\uffff\1\3\3\uffff\1\3\1\uffff"+
            "\2\3\1\uffff\1\3\4\uffff\2\3\1\uffff\7\3\3\uffff\2\3\2\uffff"+
            "\1\3\4\uffff\1\2\11\uffff\1\3\1\uffff\2\3\1\uffff\3\3\5\uffff"+
            "\4\3\1\uffff\4\3\1\uffff\2\3",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\4\1\uffff"+
            "\1\5\3\uffff\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff"+
            "\1\5\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff"+
            "\1\5\7\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff"+
            "\10\5\2\uffff\2\5\1\uffff\2\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\4\1\uffff"+
            "\1\5\3\uffff\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff"+
            "\1\5\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff"+
            "\1\5\7\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff"+
            "\10\5\2\uffff\2\5\1\uffff\2\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\4\1\uffff"+
            "\1\5\3\uffff\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff"+
            "\1\5\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff"+
            "\1\5\7\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff"+
            "\10\5\2\uffff\2\5\1\uffff\2\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA18_eot = DFA.unpackEncodedString(DFA18_eotS);
    static final short[] DFA18_eof = DFA.unpackEncodedString(DFA18_eofS);
    static final char[] DFA18_min = DFA.unpackEncodedStringToUnsignedChars(DFA18_minS);
    static final char[] DFA18_max = DFA.unpackEncodedStringToUnsignedChars(DFA18_maxS);
    static final short[] DFA18_accept = DFA.unpackEncodedString(DFA18_acceptS);
    static final short[] DFA18_special = DFA.unpackEncodedString(DFA18_specialS);
    static final short[][] DFA18_transition;

    static {
        int numStates = DFA18_transitionS.length;
        DFA18_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA18_transition[i] = DFA.unpackEncodedString(DFA18_transitionS[i]);
        }
    }

    class DFA18 extends DFA {

        public DFA18(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 18;
            this.eot = DFA18_eot;
            this.eof = DFA18_eof;
            this.min = DFA18_min;
            this.max = DFA18_max;
            this.accept = DFA18_accept;
            this.special = DFA18_special;
            this.transition = DFA18_transition;
        }
        public String getDescription() {
            return "208:13: (database_name= id DOT )?";
        }
    }
    static final String DFA33_eotS =
        "\76\uffff";
    static final String DFA33_eofS =
        "\2\2\74\uffff";
    static final String DFA33_minS =
        "\1\5\1\52\74\uffff";
    static final String DFA33_maxS =
        "\2\u00eb\74\uffff";
    static final String DFA33_acceptS =
        "\2\uffff\1\2\56\uffff\1\1\14\uffff";
    static final String DFA33_specialS =
        "\76\uffff}>";
    static final String[] DFA33_transitionS = {
            "\3\2\1\uffff\5\2\1\uffff\3\2\1\uffff\2\2\2\uffff\3\2\4\uffff"+
            "\1\2\1\uffff\4\2\1\1\1\uffff\1\2\3\uffff\1\2\1\uffff\3\2\1\uffff"+
            "\1\2\4\uffff\4\2\1\uffff\10\2\2\uffff\2\2\3\uffff\12\2\1\uffff"+
            "\1\2\4\uffff\3\2\3\uffff\4\2\1\uffff\1\2\1\uffff\1\2\12\uffff"+
            "\12\2\2\uffff\2\2\2\uffff\2\2\3\uffff\1\2\1\uffff\1\2\1\uffff"+
            "\5\2\4\uffff\2\2\1\uffff\5\2\1\uffff\1\2\1\uffff\3\2\1\uffff"+
            "\2\2\1\uffff\1\2\1\uffff\6\2\1\uffff\1\2\4\uffff\13\2\2\uffff"+
            "\2\2\1\uffff\5\2\1\uffff\1\2\11\uffff\1\2\1\uffff\2\2\1\uffff"+
            "\3\2\5\uffff\4\2\1\uffff\4\2\1\uffff\2\2",
            "\1\2\44\uffff\1\2\13\uffff\1\2\6\uffff\1\2\3\uffff\1\61\26"+
            "\uffff\1\2\20\uffff\1\2\24\uffff\1\2\31\uffff\1\2\5\uffff\1"+
            "\2\34\uffff\1\2\12\uffff\1\2",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA33_eot = DFA.unpackEncodedString(DFA33_eotS);
    static final short[] DFA33_eof = DFA.unpackEncodedString(DFA33_eofS);
    static final char[] DFA33_min = DFA.unpackEncodedStringToUnsignedChars(DFA33_minS);
    static final char[] DFA33_max = DFA.unpackEncodedStringToUnsignedChars(DFA33_maxS);
    static final short[] DFA33_accept = DFA.unpackEncodedString(DFA33_acceptS);
    static final short[] DFA33_special = DFA.unpackEncodedString(DFA33_specialS);
    static final short[][] DFA33_transition;

    static {
        int numStates = DFA33_transitionS.length;
        DFA33_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA33_transition[i] = DFA.unpackEncodedString(DFA33_transitionS[i]);
        }
    }

    class DFA33 extends DFA {

        public DFA33(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 33;
            this.eot = DFA33_eot;
            this.eof = DFA33_eof;
            this.min = DFA33_min;
            this.max = DFA33_max;
            this.accept = DFA33_accept;
            this.special = DFA33_special;
            this.transition = DFA33_transition;
        }
        public String getDescription() {
            return "233:26: ( COLLATE ^collation_name= ID )?";
        }
    }
    static final String DFA44_eotS =
        "\u0188\uffff";
    static final String DFA44_eofS =
        "\3\uffff\1\1\1\uffff\4\1\4\uffff\1\24\u017a\uffff";
    static final String DFA44_minS =
        "\1\5\2\uffff\1\5\1\uffff\4\5\4\uffff\1\5\1\103\1\5\1\103\1\uffff"+
        "\1\5\1\103\u013d\uffff\1\5\66\uffff";
    static final String DFA44_maxS =
        "\1\u00eb\2\uffff\1\u00eb\1\uffff\4\u00eb\4\uffff\1\u00eb\1\u0090"+
        "\1\u00eb\1\u0090\1\uffff\1\u00eb\1\u0090\u013d\uffff\1\u00eb\66"+
        "\uffff";
    static final String DFA44_acceptS =
        "\1\uffff\1\1\10\uffff\1\2\6\uffff\1\7\2\uffff\1\3\u00f5\uffff\1"+
        "\4\61\uffff\1\6\1\uffff\1\5\30\uffff\1\10\25\uffff\1\11\32\uffff";
    static final String DFA44_specialS =
        "\u0188\uffff}>";
    static final String[] DFA44_transitionS = {
            "\3\24\1\uffff\2\24\1\uffff\2\24\1\uffff\2\24\1\uffff\1\12\2"+
            "\24\2\uffff\3\24\2\uffff\1\1\1\uffff\1\24\1\uffff\1\24\1\22"+
            "\1\16\2\24\1\12\1\24\5\uffff\3\24\1\uffff\1\24\4\uffff\1\24"+
            "\1\7\1\6\1\10\1\uffff\10\24\3\uffff\1\24\3\uffff\3\24\2\uffff"+
            "\3\24\1\20\1\24\1\uffff\1\24\2\1\2\uffff\3\24\6\uffff\1\24\1"+
            "\uffff\1\24\1\uffff\1\15\12\uffff\3\24\1\uffff\6\24\1\1\1\uffff"+
            "\2\24\2\uffff\1\24\4\uffff\1\24\1\uffff\1\24\1\uffff\1\24\3"+
            "\uffff\1\24\1\uffff\1\17\5\uffff\1\24\1\21\4\uffff\1\5\1\uffff"+
            "\3\24\1\uffff\2\24\1\uffff\1\24\3\uffff\1\24\1\uffff\2\24\1"+
            "\uffff\1\24\1\12\3\uffff\1\23\1\24\1\uffff\7\24\3\uffff\2\24"+
            "\2\uffff\1\24\4\uffff\1\3\11\uffff\1\24\1\uffff\2\24\1\uffff"+
            "\3\24\1\1\4\uffff\4\24\1\uffff\4\24\1\uffff\2\24",
            "",
            "",
            "\3\1\1\uffff\5\1\1\uffff\3\1\1\uffff\2\1\2\uffff\3\1\4\uffff"+
            "\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\24\2\1\3\uffff\12\1"+
            "\1\uffff\1\1\4\uffff\3\1\3\uffff\4\1\1\uffff\1\1\1\uffff\1\1"+
            "\12\uffff\12\1\2\uffff\2\1\2\uffff\2\1\3\uffff\1\1\1\uffff\1"+
            "\1\1\uffff\5\1\4\uffff\2\1\1\uffff\5\1\1\uffff\1\1\1\uffff\3"+
            "\1\1\uffff\2\1\1\uffff\1\1\1\uffff\6\1\1\uffff\1\1\4\uffff\13"+
            "\1\2\uffff\2\1\1\uffff\5\1\1\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "",
            "\3\1\1\uffff\5\1\1\uffff\3\1\1\uffff\2\1\2\uffff\3\1\4\uffff"+
            "\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\24\2\1\3\uffff\12\1"+
            "\1\uffff\1\1\4\uffff\3\1\3\uffff\4\1\1\uffff\1\1\1\uffff\1\1"+
            "\12\uffff\12\1\2\uffff\2\1\2\uffff\2\1\3\uffff\1\1\1\uffff\1"+
            "\1\1\uffff\5\1\4\uffff\2\1\1\uffff\5\1\1\uffff\1\1\1\uffff\3"+
            "\1\1\uffff\2\1\1\uffff\1\1\1\uffff\6\1\1\uffff\1\1\4\uffff\13"+
            "\1\2\uffff\2\1\1\uffff\5\1\1\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\5\1\1\uffff\3\1\1\uffff\2\1\2\uffff\3\1\4\uffff"+
            "\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\24\2\1\3\uffff\12\1"+
            "\1\uffff\1\1\4\uffff\3\1\3\uffff\4\1\1\uffff\1\1\1\uffff\1\1"+
            "\12\uffff\12\1\2\uffff\2\1\2\uffff\2\1\3\uffff\1\1\1\uffff\1"+
            "\1\1\uffff\5\1\4\uffff\2\1\1\uffff\5\1\1\uffff\1\1\1\uffff\3"+
            "\1\1\uffff\2\1\1\uffff\1\1\1\uffff\6\1\1\uffff\1\1\4\uffff\13"+
            "\1\2\uffff\2\1\1\uffff\5\1\1\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\5\1\1\uffff\3\1\1\uffff\2\1\2\uffff\3\1\4\uffff"+
            "\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\24\2\1\3\uffff\12\1"+
            "\1\uffff\1\1\4\uffff\3\1\3\uffff\4\1\1\uffff\1\1\1\uffff\1\1"+
            "\12\uffff\12\1\2\uffff\2\1\2\uffff\2\1\3\uffff\1\1\1\uffff\1"+
            "\1\1\uffff\5\1\4\uffff\2\1\1\uffff\5\1\1\uffff\1\1\1\uffff\3"+
            "\1\1\uffff\2\1\1\uffff\1\1\1\uffff\6\1\1\uffff\1\1\4\uffff\13"+
            "\1\2\uffff\2\1\1\uffff\5\1\1\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\5\1\1\uffff\3\1\1\uffff\2\1\2\uffff\3\1\4\uffff"+
            "\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\24\2\1\3\uffff\12\1"+
            "\1\uffff\1\1\4\uffff\3\1\3\uffff\4\1\1\uffff\1\1\1\uffff\1\1"+
            "\12\uffff\12\1\2\uffff\2\1\2\uffff\2\1\3\uffff\1\1\1\uffff\1"+
            "\1\1\uffff\5\1\4\uffff\2\1\1\uffff\5\1\1\uffff\1\1\1\uffff\3"+
            "\1\1\uffff\2\1\1\uffff\1\1\1\uffff\6\1\1\uffff\1\1\4\uffff\13"+
            "\1\2\uffff\2\1\1\uffff\5\1\1\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "",
            "",
            "",
            "",
            "\3\24\1\uffff\5\24\1\uffff\3\24\1\uffff\2\24\2\uffff\3\24\4"+
            "\uffff\1\24\1\uffff\5\24\1\uffff\1\24\3\uffff\1\24\1\uffff\3"+
            "\24\1\uffff\1\24\4\uffff\4\24\1\uffff\10\24\1\uffff\3\24\3\uffff"+
            "\12\24\1\uffff\1\24\4\uffff\3\24\3\uffff\4\24\1\uffff\1\24\1"+
            "\uffff\1\24\12\uffff\12\24\2\uffff\2\24\2\uffff\2\24\3\uffff"+
            "\1\24\1\uffff\1\24\1\uffff\5\24\1\uffff\1\u010a\2\uffff\2\24"+
            "\1\uffff\5\24\1\uffff\1\24\1\uffff\3\24\1\uffff\2\24\1\uffff"+
            "\1\24\1\uffff\6\24\1\uffff\1\24\4\uffff\13\24\2\uffff\2\24\1"+
            "\uffff\5\24\1\uffff\1\24\11\uffff\1\24\1\uffff\2\24\1\uffff"+
            "\3\24\5\uffff\4\24\1\uffff\4\24\1\uffff\2\24",
            "\1\24\114\uffff\1\u013c",
            "\3\u013e\1\uffff\2\u013e\1\uffff\2\u013e\1\uffff\2\u013e\1"+
            "\uffff\3\u013e\2\uffff\3\u013e\2\uffff\1\u013e\1\uffff\1\u013e"+
            "\1\uffff\7\u013e\5\uffff\3\u013e\1\uffff\1\u013e\4\uffff\4\u013e"+
            "\1\uffff\10\u013e\3\uffff\1\u013e\3\uffff\3\u013e\2\uffff\5"+
            "\u013e\1\uffff\3\u013e\2\uffff\3\u013e\6\uffff\1\u013e\1\uffff"+
            "\1\u013e\1\uffff\1\u013e\12\uffff\3\u013e\1\uffff\7\u013e\1"+
            "\uffff\2\u013e\2\uffff\1\u013e\4\uffff\1\u013e\1\uffff\1\u013e"+
            "\1\uffff\1\u013e\3\uffff\1\u013e\1\uffff\1\u013e\3\uffff\1\u013e"+
            "\1\uffff\2\u013e\4\uffff\1\u013e\1\uffff\3\u013e\1\uffff\2\u013e"+
            "\1\uffff\1\u013e\3\uffff\4\u013e\1\uffff\2\u013e\3\uffff\2\u013e"+
            "\1\uffff\7\u013e\3\uffff\1\u013e\1\u0151\2\uffff\1\u013e\4\uffff"+
            "\1\u013e\11\uffff\1\u013e\1\uffff\7\u013e\4\uffff\4\u013e\1"+
            "\uffff\4\u013e\1\uffff\2\u013e",
            "\1\24\114\uffff\1\21",
            "",
            "\3\u0157\1\uffff\2\u0157\1\uffff\2\u0157\1\uffff\2\u0157\1"+
            "\uffff\3\u0157\2\uffff\3\u0157\2\uffff\1\u0157\1\uffff\1\u0157"+
            "\1\uffff\7\u0157\5\uffff\3\u0157\1\uffff\1\u0157\4\uffff\4\u0157"+
            "\1\uffff\10\u0157\1\uffff\1\24\1\uffff\1\u0157\3\uffff\3\u0157"+
            "\2\uffff\5\u0157\1\uffff\3\u0157\2\uffff\3\u0157\6\uffff\1\u0157"+
            "\1\uffff\1\u0157\1\uffff\1\u0157\12\uffff\3\u0157\1\uffff\7"+
            "\u0157\1\uffff\2\u0157\2\uffff\1\u0157\4\uffff\1\u0157\1\uffff"+
            "\1\u0157\1\uffff\1\u0157\3\uffff\1\u0157\1\uffff\1\u0157\3\uffff"+
            "\1\u0157\1\uffff\2\u0157\4\uffff\1\u0157\1\uffff\3\u0157\1\uffff"+
            "\2\u0157\1\uffff\1\u0157\3\uffff\4\u0157\1\uffff\2\u0157\3\uffff"+
            "\2\u0157\1\uffff\7\u0157\3\uffff\2\u0157\2\uffff\1\u0157\4\uffff"+
            "\1\u0157\11\uffff\1\u0157\1\uffff\7\u0157\4\uffff\4\u0157\1"+
            "\uffff\4\u0157\1\uffff\2\u0157",
            "\1\24\114\uffff\1\u016d",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\21\1\uffff\2\21\1\uffff\2\21\1\uffff\6\21\2\uffff\3\21\2"+
            "\uffff\1\21\1\uffff\1\21\1\uffff\7\21\5\uffff\3\21\1\uffff\1"+
            "\21\4\uffff\4\21\1\uffff\10\21\1\uffff\1\u013e\1\uffff\1\21"+
            "\3\uffff\3\21\2\uffff\5\21\1\uffff\3\21\2\uffff\3\21\6\uffff"+
            "\1\21\1\uffff\1\21\1\uffff\1\21\12\uffff\3\21\1\uffff\7\21\1"+
            "\uffff\2\21\2\uffff\1\21\4\uffff\1\21\1\uffff\1\21\1\uffff\1"+
            "\21\3\uffff\1\21\1\uffff\1\21\3\uffff\1\21\1\uffff\2\21\4\uffff"+
            "\1\21\1\uffff\3\21\1\uffff\2\21\1\uffff\1\21\3\uffff\4\21\1"+
            "\uffff\2\21\3\uffff\2\21\1\uffff\7\21\3\uffff\2\21\2\uffff\1"+
            "\21\4\uffff\1\21\11\uffff\1\21\1\uffff\7\21\4\uffff\4\21\1\uffff"+
            "\4\21\1\uffff\2\21",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA44_eot = DFA.unpackEncodedString(DFA44_eotS);
    static final short[] DFA44_eof = DFA.unpackEncodedString(DFA44_eofS);
    static final char[] DFA44_min = DFA.unpackEncodedStringToUnsignedChars(DFA44_minS);
    static final char[] DFA44_max = DFA.unpackEncodedStringToUnsignedChars(DFA44_maxS);
    static final short[] DFA44_accept = DFA.unpackEncodedString(DFA44_acceptS);
    static final short[] DFA44_special = DFA.unpackEncodedString(DFA44_specialS);
    static final short[][] DFA44_transition;

    static {
        int numStates = DFA44_transitionS.length;
        DFA44_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA44_transition[i] = DFA.unpackEncodedString(DFA44_transitionS[i]);
        }
    }

    class DFA44 extends DFA {

        public DFA44(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 44;
            this.eot = DFA44_eot;
            this.eof = DFA44_eof;
            this.min = DFA44_min;
            this.max = DFA44_max;
            this.accept = DFA44_accept;
            this.special = DFA44_special;
            this.transition = DFA44_transition;
        }
        public String getDescription() {
            return "235:1: atom_expr : ( literal_value | bind_parameter | ( (database_name= id DOT )? table_name= id DOT )? column_name= ID -> ^( COLUMN_EXPRESSION ^( $column_name ( ^( $table_name ( $database_name)? ) )? ) ) |name= ID LPAREN ( ( DISTINCT )? args+= expr ( COMMA args+= expr )* | ASTERISK )? RPAREN -> ^( FUNCTION_EXPRESSION $name ( DISTINCT )? ( $args)* ( ASTERISK )? ) | LPAREN ! expr RPAREN !| CAST ^ LPAREN ! expr AS ! type_name RPAREN !| ( ( NOT )? EXISTS )? LPAREN select_stmt RPAREN | CASE (case_expr= expr )? ( when_expr )+ ( ELSE else_expr= expr )? END -> ^( CASE ( $case_expr)? ( when_expr )+ ( $else_expr)? ) | raise_function );";
        }
    }
    static final String DFA34_eotS =
        "\u00a3\uffff";
    static final String DFA34_eofS =
        "\7\uffff\1\21\2\uffff\1\21\2\uffff\1\21\u0095\uffff";
    static final String DFA34_minS =
        "\1\5\3\103\4\5\2\uffff\1\5\2\uffff\1\5\u0095\uffff";
    static final String DFA34_maxS =
        "\1\u00eb\3\103\4\u00eb\2\uffff\1\u00eb\2\uffff\1\u00eb\u0095\uffff";
    static final String DFA34_acceptS =
        "\10\uffff\1\1\10\uffff\1\2\u0091\uffff";
    static final String DFA34_specialS =
        "\u00a3\uffff}>";
    static final String[] DFA34_transitionS = {
            "\3\3\1\uffff\2\3\1\uffff\2\3\1\uffff\2\3\2\uffff\2\3\2\uffff"+
            "\3\3\4\uffff\1\3\1\uffff\5\3\1\uffff\1\3\5\uffff\3\3\1\uffff"+
            "\1\3\4\uffff\4\3\1\uffff\10\3\3\uffff\1\3\3\uffff\3\3\2\uffff"+
            "\5\3\1\uffff\1\3\4\uffff\3\3\6\uffff\1\3\1\uffff\1\3\1\uffff"+
            "\1\1\12\uffff\3\3\1\uffff\6\3\2\uffff\2\3\2\uffff\1\3\4\uffff"+
            "\1\3\1\uffff\1\3\1\uffff\1\3\3\uffff\1\3\7\uffff\1\3\5\uffff"+
            "\1\3\1\uffff\3\3\1\uffff\2\3\1\uffff\1\3\3\uffff\1\3\1\uffff"+
            "\2\3\1\uffff\1\3\4\uffff\2\3\1\uffff\7\3\3\uffff\2\3\2\uffff"+
            "\1\3\4\uffff\1\2\11\uffff\1\3\1\uffff\2\3\1\uffff\3\3\5\uffff"+
            "\4\3\1\uffff\4\3\1\uffff\2\3",
            "\1\4",
            "\1\5",
            "\1\6",
            "\3\10\1\uffff\2\10\1\uffff\2\10\1\uffff\2\10\2\uffff\2\10\2"+
            "\uffff\3\10\4\uffff\1\10\1\uffff\5\10\1\uffff\1\10\5\uffff\3"+
            "\10\1\uffff\1\10\4\uffff\4\10\1\uffff\10\10\3\uffff\1\10\3\uffff"+
            "\3\10\2\uffff\5\10\1\uffff\1\10\4\uffff\3\10\6\uffff\1\10\1"+
            "\uffff\1\10\1\uffff\1\7\12\uffff\3\10\1\uffff\6\10\2\uffff\2"+
            "\10\2\uffff\1\10\4\uffff\1\10\1\uffff\1\10\1\uffff\1\10\3\uffff"+
            "\1\10\7\uffff\1\10\5\uffff\1\10\1\uffff\3\10\1\uffff\2\10\1"+
            "\uffff\1\10\3\uffff\1\10\1\uffff\2\10\1\uffff\1\10\4\uffff\2"+
            "\10\1\uffff\7\10\3\uffff\2\10\2\uffff\1\10\4\uffff\1\10\11\uffff"+
            "\1\10\1\uffff\2\10\1\uffff\3\10\5\uffff\4\10\1\uffff\4\10\1"+
            "\uffff\2\10",
            "\3\10\1\uffff\2\10\1\uffff\2\10\1\uffff\2\10\2\uffff\2\10\2"+
            "\uffff\3\10\4\uffff\1\10\1\uffff\5\10\1\uffff\1\10\5\uffff\3"+
            "\10\1\uffff\1\10\4\uffff\4\10\1\uffff\10\10\3\uffff\1\10\3\uffff"+
            "\3\10\2\uffff\5\10\1\uffff\1\10\4\uffff\3\10\6\uffff\1\10\1"+
            "\uffff\1\10\1\uffff\1\12\12\uffff\3\10\1\uffff\6\10\2\uffff"+
            "\2\10\2\uffff\1\10\4\uffff\1\10\1\uffff\1\10\1\uffff\1\10\3"+
            "\uffff\1\10\7\uffff\1\10\5\uffff\1\10\1\uffff\3\10\1\uffff\2"+
            "\10\1\uffff\1\10\3\uffff\1\10\1\uffff\2\10\1\uffff\1\10\4\uffff"+
            "\2\10\1\uffff\7\10\3\uffff\2\10\2\uffff\1\10\4\uffff\1\10\11"+
            "\uffff\1\10\1\uffff\2\10\1\uffff\3\10\5\uffff\4\10\1\uffff\4"+
            "\10\1\uffff\2\10",
            "\3\10\1\uffff\2\10\1\uffff\2\10\1\uffff\2\10\2\uffff\2\10\2"+
            "\uffff\3\10\4\uffff\1\10\1\uffff\5\10\1\uffff\1\10\5\uffff\3"+
            "\10\1\uffff\1\10\4\uffff\4\10\1\uffff\10\10\3\uffff\1\10\3\uffff"+
            "\3\10\2\uffff\5\10\1\uffff\1\10\4\uffff\3\10\6\uffff\1\10\1"+
            "\uffff\1\10\1\uffff\1\15\12\uffff\3\10\1\uffff\6\10\2\uffff"+
            "\2\10\2\uffff\1\10\4\uffff\1\10\1\uffff\1\10\1\uffff\1\10\3"+
            "\uffff\1\10\7\uffff\1\10\5\uffff\1\10\1\uffff\3\10\1\uffff\2"+
            "\10\1\uffff\1\10\3\uffff\1\10\1\uffff\2\10\1\uffff\1\10\4\uffff"+
            "\2\10\1\uffff\7\10\3\uffff\2\10\2\uffff\1\10\4\uffff\1\10\11"+
            "\uffff\1\10\1\uffff\2\10\1\uffff\3\10\5\uffff\4\10\1\uffff\4"+
            "\10\1\uffff\2\10",
            "\3\21\1\uffff\5\21\1\uffff\3\21\1\uffff\2\21\2\uffff\3\21\4"+
            "\uffff\1\21\1\uffff\5\21\1\uffff\1\21\3\uffff\1\21\1\uffff\3"+
            "\21\1\uffff\1\21\4\uffff\4\21\1\uffff\10\21\1\uffff\1\10\2\21"+
            "\3\uffff\12\21\1\uffff\1\21\4\uffff\3\21\3\uffff\4\21\1\uffff"+
            "\1\21\1\uffff\1\21\12\uffff\12\21\2\uffff\2\21\2\uffff\2\21"+
            "\3\uffff\1\21\1\uffff\1\21\1\uffff\5\21\4\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\1\uffff\3\21\1\uffff\2\21\1\uffff\1\21\1"+
            "\uffff\6\21\1\uffff\1\21\4\uffff\13\21\2\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\11\uffff\1\21\1\uffff\2\21\1\uffff\3\21\5"+
            "\uffff\4\21\1\uffff\4\21\1\uffff\2\21",
            "",
            "",
            "\3\21\1\uffff\5\21\1\uffff\3\21\1\uffff\2\21\2\uffff\3\21\4"+
            "\uffff\1\21\1\uffff\5\21\1\uffff\1\21\3\uffff\1\21\1\uffff\3"+
            "\21\1\uffff\1\21\4\uffff\4\21\1\uffff\10\21\1\uffff\1\10\2\21"+
            "\3\uffff\12\21\1\uffff\1\21\4\uffff\3\21\3\uffff\4\21\1\uffff"+
            "\1\21\1\uffff\1\21\12\uffff\12\21\2\uffff\2\21\2\uffff\2\21"+
            "\3\uffff\1\21\1\uffff\1\21\1\uffff\5\21\4\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\1\uffff\3\21\1\uffff\2\21\1\uffff\1\21\1"+
            "\uffff\6\21\1\uffff\1\21\4\uffff\13\21\2\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\11\uffff\1\21\1\uffff\2\21\1\uffff\3\21\5"+
            "\uffff\4\21\1\uffff\4\21\1\uffff\2\21",
            "",
            "",
            "\3\21\1\uffff\5\21\1\uffff\3\21\1\uffff\2\21\2\uffff\3\21\4"+
            "\uffff\1\21\1\uffff\5\21\1\uffff\1\21\3\uffff\1\21\1\uffff\3"+
            "\21\1\uffff\1\21\4\uffff\4\21\1\uffff\10\21\1\uffff\1\10\2\21"+
            "\3\uffff\12\21\1\uffff\1\21\4\uffff\3\21\3\uffff\4\21\1\uffff"+
            "\1\21\1\uffff\1\21\12\uffff\12\21\2\uffff\2\21\2\uffff\2\21"+
            "\3\uffff\1\21\1\uffff\1\21\1\uffff\5\21\4\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\1\uffff\3\21\1\uffff\2\21\1\uffff\1\21\1"+
            "\uffff\6\21\1\uffff\1\21\4\uffff\13\21\2\uffff\2\21\1\uffff"+
            "\5\21\1\uffff\1\21\11\uffff\1\21\1\uffff\2\21\1\uffff\3\21\5"+
            "\uffff\4\21\1\uffff\4\21\1\uffff\2\21",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA34_eot = DFA.unpackEncodedString(DFA34_eotS);
    static final short[] DFA34_eof = DFA.unpackEncodedString(DFA34_eofS);
    static final char[] DFA34_min = DFA.unpackEncodedStringToUnsignedChars(DFA34_minS);
    static final char[] DFA34_max = DFA.unpackEncodedStringToUnsignedChars(DFA34_maxS);
    static final short[] DFA34_accept = DFA.unpackEncodedString(DFA34_acceptS);
    static final short[] DFA34_special = DFA.unpackEncodedString(DFA34_specialS);
    static final short[][] DFA34_transition;

    static {
        int numStates = DFA34_transitionS.length;
        DFA34_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA34_transition[i] = DFA.unpackEncodedString(DFA34_transitionS[i]);
        }
    }

    class DFA34 extends DFA {

        public DFA34(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 34;
            this.eot = DFA34_eot;
            this.eof = DFA34_eof;
            this.min = DFA34_min;
            this.max = DFA34_max;
            this.accept = DFA34_accept;
            this.special = DFA34_special;
            this.transition = DFA34_transition;
        }
        public String getDescription() {
            return "238:6: (database_name= id DOT )?";
        }
    }
    static final String DFA71_eotS =
        "\107\uffff";
    static final String DFA71_eofS =
        "\107\uffff";
    static final String DFA71_minS =
        "\3\5\104\uffff";
    static final String DFA71_maxS =
        "\3\u00eb\104\uffff";
    static final String DFA71_acceptS =
        "\3\uffff\1\3\25\uffff\1\1\26\uffff\1\2\26\uffff";
    static final String DFA71_specialS =
        "\107\uffff}>";
    static final String[] DFA71_transitionS = {
            "\3\3\1\uffff\1\1\1\3\1\uffff\2\3\1\uffff\6\3\2\uffff\3\3\2\uffff"+
            "\1\3\1\uffff\1\3\1\uffff\7\3\5\uffff\3\3\1\uffff\1\3\4\uffff"+
            "\4\3\1\uffff\7\3\1\2\3\uffff\1\3\3\uffff\3\3\2\uffff\5\3\1\uffff"+
            "\3\3\2\uffff\3\3\6\uffff\1\3\1\uffff\1\3\1\uffff\1\3\12\uffff"+
            "\3\3\1\uffff\7\3\1\uffff\2\3\2\uffff\1\3\4\uffff\1\3\1\uffff"+
            "\1\3\1\uffff\1\3\3\uffff\1\3\1\uffff\1\3\3\uffff\1\3\1\uffff"+
            "\2\3\4\uffff\1\3\1\uffff\3\3\1\uffff\2\3\1\uffff\1\3\3\uffff"+
            "\4\3\1\uffff\2\3\3\uffff\2\3\1\uffff\7\3\3\uffff\2\3\2\uffff"+
            "\1\3\4\uffff\1\3\11\uffff\1\3\1\uffff\7\3\4\uffff\4\3\1\uffff"+
            "\4\3\1\uffff\2\3",
            "\3\31\1\uffff\2\31\1\uffff\2\31\1\uffff\6\31\2\uffff\3\31\2"+
            "\uffff\1\31\1\uffff\1\31\1\uffff\7\31\5\uffff\3\31\1\uffff\1"+
            "\31\4\uffff\4\31\1\uffff\10\31\1\uffff\1\3\1\uffff\1\31\3\uffff"+
            "\3\31\2\uffff\5\31\1\uffff\3\31\2\uffff\3\31\6\uffff\1\31\1"+
            "\uffff\1\31\1\uffff\1\31\12\uffff\3\31\1\uffff\7\31\1\uffff"+
            "\2\31\2\uffff\1\31\4\uffff\1\31\1\uffff\1\31\1\uffff\1\31\3"+
            "\uffff\1\31\1\uffff\1\31\3\uffff\1\31\1\uffff\2\31\4\uffff\1"+
            "\31\1\uffff\3\31\1\uffff\2\31\1\uffff\1\31\3\uffff\4\31\1\uffff"+
            "\2\31\3\uffff\2\31\1\uffff\7\31\3\uffff\2\31\2\uffff\1\31\4"+
            "\uffff\1\31\11\uffff\1\31\1\uffff\7\31\4\uffff\4\31\1\uffff"+
            "\4\31\1\uffff\2\31",
            "\3\60\1\uffff\2\60\1\uffff\2\60\1\uffff\6\60\2\uffff\3\60\2"+
            "\uffff\1\60\1\uffff\1\60\1\uffff\7\60\5\uffff\3\60\1\uffff\1"+
            "\60\4\uffff\4\60\1\uffff\10\60\1\uffff\1\3\1\uffff\1\60\3\uffff"+
            "\3\60\2\uffff\5\60\1\uffff\3\60\2\uffff\3\60\6\uffff\1\60\1"+
            "\uffff\1\60\1\uffff\1\60\12\uffff\3\60\1\uffff\7\60\1\uffff"+
            "\2\60\2\uffff\1\60\4\uffff\1\60\1\uffff\1\60\1\uffff\1\60\3"+
            "\uffff\1\60\1\uffff\1\60\3\uffff\1\60\1\uffff\2\60\4\uffff\1"+
            "\60\1\uffff\3\60\1\uffff\2\60\1\uffff\1\60\3\uffff\4\60\1\uffff"+
            "\2\60\3\uffff\2\60\1\uffff\7\60\3\uffff\2\60\2\uffff\1\60\4"+
            "\uffff\1\60\11\uffff\1\60\1\uffff\7\60\4\uffff\4\60\1\uffff"+
            "\4\60\1\uffff\2\60",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA71_eot = DFA.unpackEncodedString(DFA71_eotS);
    static final short[] DFA71_eof = DFA.unpackEncodedString(DFA71_eofS);
    static final char[] DFA71_min = DFA.unpackEncodedStringToUnsignedChars(DFA71_minS);
    static final char[] DFA71_max = DFA.unpackEncodedStringToUnsignedChars(DFA71_maxS);
    static final short[] DFA71_accept = DFA.unpackEncodedString(DFA71_acceptS);
    static final short[] DFA71_special = DFA.unpackEncodedString(DFA71_specialS);
    static final short[][] DFA71_transition;

    static {
        int numStates = DFA71_transitionS.length;
        DFA71_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA71_transition[i] = DFA.unpackEncodedString(DFA71_transitionS[i]);
        }
    }

    class DFA71 extends DFA {

        public DFA71(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 71;
            this.eot = DFA71_eot;
            this.eof = DFA71_eof;
            this.min = DFA71_min;
            this.max = DFA71_max;
            this.accept = DFA71_accept;
            this.special = DFA71_special;
            this.transition = DFA71_transition;
        }
        public String getDescription() {
            return "330:10: ( ALL | DISTINCT )?";
        }
    }
    static final String DFA80_eotS =
        "\u012e\uffff";
    static final String DFA80_eofS =
        "\2\uffff\3\5\3\uffff\3\5\u0123\uffff";
    static final String DFA80_minS =
        "\1\5\1\uffff\3\5\3\uffff\3\5\1\103\5\uffff\1\103\1\uffff\1\5\2\103"+
        "\2\uffff\1\5\41\uffff\1\5\41\uffff\1\5\41\uffff\1\5\41\uffff\1\5"+
        "\41\uffff\1\5\42\uffff\2\5\1\uffff\1\5\27\uffff\2\5\54\uffff";
    static final String DFA80_maxS =
        "\1\u00eb\1\uffff\3\u00eb\3\uffff\3\u00eb\1\u0090\5\uffff\1\u0090"+
        "\1\uffff\1\u00eb\1\u0090\1\103\2\uffff\1\u00eb\41\uffff\1\u00eb"+
        "\41\uffff\1\u00eb\41\uffff\1\u00eb\41\uffff\1\u00eb\41\uffff\1\u00eb"+
        "\42\uffff\2\u00eb\1\uffff\1\u00eb\27\uffff\2\u00eb\54\uffff";
    static final String DFA80_acceptS =
        "\1\uffff\1\1\3\uffff\1\3\u00fc\uffff\1\2\53\uffff";
    static final String DFA80_specialS =
        "\u012e\uffff}>";
    static final String[] DFA80_transitionS = {
            "\3\25\1\uffff\2\25\1\uffff\2\25\1\uffff\2\25\1\1\1\5\2\25\2"+
            "\uffff\3\25\2\uffff\1\5\1\uffff\1\25\1\uffff\1\25\1\23\1\13"+
            "\2\25\1\5\1\25\5\uffff\3\25\1\uffff\1\25\4\uffff\1\25\1\11\1"+
            "\10\1\12\1\uffff\10\25\3\uffff\1\25\3\uffff\3\25\2\uffff\3\25"+
            "\1\21\1\25\1\uffff\1\25\2\5\2\uffff\3\25\6\uffff\1\25\1\uffff"+
            "\1\25\1\uffff\1\2\12\uffff\3\25\1\uffff\6\25\1\5\1\uffff\2\25"+
            "\2\uffff\1\25\4\uffff\1\25\1\uffff\1\25\1\uffff\1\25\3\uffff"+
            "\1\25\1\uffff\1\5\3\uffff\1\5\1\uffff\1\25\1\5\4\uffff\1\4\1"+
            "\uffff\3\25\1\uffff\2\25\1\uffff\1\25\3\uffff\1\25\1\5\2\25"+
            "\1\uffff\1\25\1\5\3\uffff\1\24\1\25\1\uffff\7\25\3\uffff\2\25"+
            "\2\uffff\1\25\4\uffff\1\3\11\uffff\1\25\1\uffff\2\25\1\5\3\25"+
            "\1\5\4\uffff\4\25\1\uffff\4\25\1\uffff\2\25",
            "",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\30\2\5\3\uffff\12\5"+
            "\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1\5"+
            "\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff\1"+
            "\5\1\uffff\5\5\1\uffff\1\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1"+
            "\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1"+
            "\5\4\uffff\13\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff"+
            "\2\5",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\72\2\5\3\uffff\12\5"+
            "\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1\5"+
            "\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff\1"+
            "\5\1\uffff\5\5\4\uffff\2\5\1\uffff\5\5\1\uffff\1\5\1\uffff\3"+
            "\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1\5\4\uffff\13"+
            "\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\134\2\5\3\uffff\12\5"+
            "\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1\5"+
            "\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff\1"+
            "\5\1\uffff\5\5\4\uffff\2\5\1\uffff\5\5\1\uffff\1\5\1\uffff\3"+
            "\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1\5\4\uffff\13"+
            "\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\176\2\5\3\uffff\12\5"+
            "\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1\5"+
            "\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff\1"+
            "\5\1\uffff\5\5\4\uffff\2\5\1\uffff\5\5\1\uffff\1\5\1\uffff\3"+
            "\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1\5\4\uffff\13"+
            "\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\u00a0\2\5\3\uffff\12"+
            "\5\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1"+
            "\5\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\5\5\4\uffff\2\5\1\uffff\5\5\1\uffff\1\5\1\uffff"+
            "\3\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1\5\4\uffff"+
            "\13\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\5\5\1\uffff\3\5\1\uffff\2\5\2\uffff\3\5\4\uffff"+
            "\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\u00c2\2\5\3\uffff\12"+
            "\5\1\uffff\1\5\4\uffff\3\5\3\uffff\4\5\1\uffff\1\5\1\uffff\1"+
            "\5\12\uffff\12\5\2\uffff\2\5\2\uffff\2\5\3\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\5\5\4\uffff\2\5\1\uffff\5\5\1\uffff\1\5\1\uffff"+
            "\3\5\1\uffff\2\5\1\uffff\1\5\1\uffff\6\5\1\uffff\1\5\4\uffff"+
            "\13\5\2\uffff\2\5\1\uffff\5\5\1\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\1\u00e5\114\uffff\1\5",
            "",
            "",
            "",
            "",
            "",
            "\1\u00e6\114\uffff\1\5",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\uffff\3\5\2\uffff"+
            "\3\5\2\uffff\1\5\1\uffff\1\5\1\uffff\7\5\5\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\u00e8\1\uffff\1\5\3"+
            "\uffff\3\5\2\uffff\5\5\1\uffff\3\5\2\uffff\3\5\6\uffff\1\5\1"+
            "\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\7\5\1\uffff\2\5"+
            "\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5"+
            "\1\uffff\1\5\3\uffff\1\5\1\uffff\2\5\4\uffff\1\5\1\uffff\3\5"+
            "\1\uffff\2\5\1\uffff\1\5\3\uffff\4\5\1\uffff\2\5\3\uffff\2\5"+
            "\1\uffff\7\5\3\uffff\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1"+
            "\5\1\uffff\7\5\4\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\1\u0100\114\uffff\1\5",
            "\1\u0101",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\u0102\1\uffff\2"+
            "\5\2\uffff\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3"+
            "\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\7\uffff"+
            "\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff\1\5\3\uffff"+
            "\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff\7\5\3\uffff"+
            "\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA80_eot = DFA.unpackEncodedString(DFA80_eotS);
    static final short[] DFA80_eof = DFA.unpackEncodedString(DFA80_eofS);
    static final char[] DFA80_min = DFA.unpackEncodedStringToUnsignedChars(DFA80_minS);
    static final char[] DFA80_max = DFA.unpackEncodedStringToUnsignedChars(DFA80_maxS);
    static final short[] DFA80_accept = DFA.unpackEncodedString(DFA80_acceptS);
    static final short[] DFA80_special = DFA.unpackEncodedString(DFA80_specialS);
    static final short[][] DFA80_transition;

    static {
        int numStates = DFA80_transitionS.length;
        DFA80_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA80_transition[i] = DFA.unpackEncodedString(DFA80_transitionS[i]);
        }
    }

    class DFA80 extends DFA {

        public DFA80(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 80;
            this.eot = DFA80_eot;
            this.eof = DFA80_eof;
            this.min = DFA80_min;
            this.max = DFA80_max;
            this.accept = DFA80_accept;
            this.special = DFA80_special;
            this.transition = DFA80_transition;
        }
        public String getDescription() {
            return "337:1: result_column : ( ASTERISK |table_name= id DOT ASTERISK -> ^( ASTERISK $table_name) | expr ( ( AS )? column_alias= id )? -> ^( ALIAS expr ( $column_alias)? ) );";
        }
    }
    static final String DFA79_eotS =
        "\u00e1\uffff";
    static final String DFA79_eofS =
        "\1\5\3\uffff\1\1\1\uffff\7\1\u00d4\uffff";
    static final String DFA79_minS =
        "\1\5\3\uffff\1\5\1\uffff\1\5\1\36\1\11\2\52\1\36\1\52\5\uffff\2"+
        "\5\1\36\1\11\2\103\1\36\1\103\10\uffff\2\5\1\36\1\11\2\103\1\36"+
        "\1\103\u00b7\uffff";
    static final String DFA79_maxS =
        "\1\u00eb\3\uffff\1\u00eb\1\uffff\7\u00eb\5\uffff\2\u00eb\1\103\3"+
        "\u00c1\1\103\1\173\10\uffff\2\u00eb\1\103\3\u00c1\1\103\1\173\u00b7"+
        "\uffff";
    static final String DFA79_acceptS =
        "\1\uffff\1\1\3\uffff\1\2\u00db\uffff";
    static final String DFA79_specialS =
        "\u00e1\uffff}>";
    static final String[] DFA79_transitionS = {
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\3\uffff\1\5\1\uffff"+
            "\3\1\1\uffff\1\1\4\uffff\4\1\1\uffff\10\1\3\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\1\1\1\12\3\1\1\uffff\1\1\4\uffff\2\1\1\4\6\uffff"+
            "\1\7\1\uffff\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff"+
            "\1\11\1\1\2\uffff\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3"+
            "\uffff\1\14\7\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\1\1"+
            "\1\13\1\uffff\1\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff"+
            "\2\1\1\uffff\7\1\1\5\2\uffff\2\1\1\uffff\1\5\1\1\4\uffff\1\1"+
            "\11\uffff\1\1\1\uffff\2\1\1\uffff\3\1\5\uffff\1\10\3\1\1\uffff"+
            "\4\1\1\uffff\1\1\1\6",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\1\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\1\5\1\27\3\5\1\uffff\1\5\4\uffff\2\5\1\22\6\uffff"+
            "\1\24\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff"+
            "\1\26\1\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3"+
            "\uffff\1\31\1\uffff\1\5\5\uffff\1\5\5\uffff\1\5\1\uffff\3\5"+
            "\1\uffff\1\5\1\30\1\uffff\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff"+
            "\1\5\4\uffff\2\5\1\uffff\7\5\1\1\2\uffff\2\5\1\uffff\1\1\1\5"+
            "\4\uffff\1\5\11\uffff\1\5\1\uffff\2\5\1\uffff\3\5\5\uffff\1"+
            "\25\3\5\1\uffff\4\5\1\uffff\1\5\1\23",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\uffff\3\5\2\uffff"+
            "\3\5\2\uffff\1\5\1\uffff\1\5\1\uffff\7\5\3\uffff\1\1\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\1\5\1\47\3\5\1\uffff\3\5\2\uffff\2\5\1\42\6\uffff"+
            "\1\44\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\7\5\1\uffff"+
            "\1\46\1\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3"+
            "\uffff\1\51\1\uffff\1\5\3\uffff\1\5\1\uffff\2\5\4\uffff\1\5"+
            "\1\uffff\3\5\1\uffff\1\5\1\50\1\uffff\1\5\3\uffff\4\5\1\uffff"+
            "\2\5\3\uffff\2\5\1\uffff\7\5\1\1\2\uffff\2\5\1\uffff\1\1\1\5"+
            "\4\uffff\1\5\11\uffff\1\5\1\uffff\7\5\4\uffff\1\45\3\5\1\uffff"+
            "\4\5\1\uffff\1\5\1\43",
            "\1\5\13\uffff\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\32"+
            "\uffff\1\1\20\uffff\1\1\24\uffff\1\1\31\uffff\1\1\5\uffff\1"+
            "\1\34\uffff\1\1\12\uffff\1\1",
            "\1\5\40\uffff\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\32"+
            "\uffff\1\1\20\uffff\1\1\24\uffff\1\1\31\uffff\1\1\3\uffff\1"+
            "\5\1\uffff\1\1\34\uffff\1\1\12\uffff\1\1",
            "\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\32\uffff\1\1\20"+
            "\uffff\1\1\24\uffff\1\1\31\uffff\1\1\3\uffff\1\5\1\uffff\1\1"+
            "\34\uffff\1\1\12\uffff\1\1",
            "\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\32\uffff\1\1\20"+
            "\uffff\1\1\24\uffff\1\1\31\uffff\1\1\3\uffff\1\5\1\uffff\1\1"+
            "\34\uffff\1\1\12\uffff\1\1",
            "\1\5\13\uffff\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\32"+
            "\uffff\1\1\20\uffff\1\1\24\uffff\1\1\31\uffff\1\1\5\uffff\1"+
            "\1\34\uffff\1\1\12\uffff\1\1",
            "\1\1\44\uffff\1\1\13\uffff\1\1\6\uffff\1\1\30\uffff\1\5\1\uffff"+
            "\1\1\20\uffff\1\1\24\uffff\1\1\31\uffff\1\1\5\uffff\1\1\34\uffff"+
            "\1\1\12\uffff\1\1",
            "",
            "",
            "",
            "",
            "",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\5\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\5\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\2\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\1\uffff\3\1\2\uffff"+
            "\3\1\2\uffff\1\1\1\uffff\1\1\1\uffff\7\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\5\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\3\1\2\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\7\1\1\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\4\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\2\1\1\uffff\1\1\3\uffff\4\1\1\uffff\2\1\3\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\7\1\4\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\1\1\44\uffff\1\5",
            "\1\1\71\uffff\1\5\175\uffff\1\1",
            "\1\5\175\uffff\1\1",
            "\1\5\175\uffff\1\1",
            "\1\1\44\uffff\1\5",
            "\1\5\67\uffff\1\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\2\uffff\2\1\2\uffff"+
            "\3\1\4\uffff\1\1\1\uffff\5\1\1\uffff\1\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\5\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\1\1\4\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\6\1\2\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\5\uffff\1\1\5\uffff\1\1\1\uffff\3\1\1\uffff\2\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\1\uffff\1\1\4\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\2\1\1\uffff\3\1\5\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\3\1\1\uffff\2\1\1\uffff\2\1\1\uffff\2\1\1\uffff\3\1\2\uffff"+
            "\3\1\2\uffff\1\1\1\uffff\1\1\1\uffff\7\1\5\uffff\3\1\1\uffff"+
            "\1\1\4\uffff\4\1\1\uffff\10\1\1\uffff\1\5\1\uffff\1\1\3\uffff"+
            "\3\1\2\uffff\5\1\1\uffff\3\1\2\uffff\3\1\6\uffff\1\1\1\uffff"+
            "\1\1\1\uffff\1\1\12\uffff\3\1\1\uffff\7\1\1\uffff\2\1\2\uffff"+
            "\1\1\4\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\1\1\1\uffff"+
            "\1\1\3\uffff\1\1\1\uffff\2\1\4\uffff\1\1\1\uffff\3\1\1\uffff"+
            "\2\1\1\uffff\1\1\3\uffff\4\1\1\uffff\2\1\3\uffff\2\1\1\uffff"+
            "\7\1\3\uffff\2\1\2\uffff\1\1\4\uffff\1\1\11\uffff\1\1\1\uffff"+
            "\7\1\4\uffff\4\1\1\uffff\4\1\1\uffff\2\1",
            "\1\1\44\uffff\1\5",
            "\1\1\71\uffff\1\5\175\uffff\1\1",
            "\1\5\175\uffff\1\1",
            "\1\5\175\uffff\1\1",
            "\1\1\44\uffff\1\5",
            "\1\5\67\uffff\1\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA79_eot = DFA.unpackEncodedString(DFA79_eotS);
    static final short[] DFA79_eof = DFA.unpackEncodedString(DFA79_eofS);
    static final char[] DFA79_min = DFA.unpackEncodedStringToUnsignedChars(DFA79_minS);
    static final char[] DFA79_max = DFA.unpackEncodedStringToUnsignedChars(DFA79_maxS);
    static final short[] DFA79_accept = DFA.unpackEncodedString(DFA79_acceptS);
    static final short[] DFA79_special = DFA.unpackEncodedString(DFA79_specialS);
    static final short[][] DFA79_transition;

    static {
        int numStates = DFA79_transitionS.length;
        DFA79_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA79_transition[i] = DFA.unpackEncodedString(DFA79_transitionS[i]);
        }
    }

    class DFA79 extends DFA {

        public DFA79(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 79;
            this.eot = DFA79_eot;
            this.eof = DFA79_eof;
            this.min = DFA79_min;
            this.max = DFA79_max;
            this.accept = DFA79_accept;
            this.special = DFA79_special;
            this.transition = DFA79_transition;
        }
        public String getDescription() {
            return "340:10: ( ( AS )? column_alias= id )?";
        }
    }
    static final String DFA78_eotS =
        "\u00e4\uffff";
    static final String DFA78_eofS =
        "\1\uffff\1\2\5\uffff\1\5\1\uffff\7\5\u00d4\uffff";
    static final String DFA78_minS =
        "\2\5\5\uffff\1\5\1\uffff\1\5\1\36\1\11\2\52\1\36\1\52\5\uffff\2"+
        "\5\1\36\1\11\2\103\1\36\1\103\10\uffff\2\5\1\36\1\11\2\103\1\36"+
        "\1\103\u00b7\uffff";
    static final String DFA78_maxS =
        "\2\u00eb\5\uffff\1\u00eb\1\uffff\7\u00eb\5\uffff\2\u00eb\1\103\3"+
        "\u00c1\1\103\1\173\10\uffff\2\u00eb\1\103\3\u00c1\1\103\1\173\u00b7"+
        "\uffff";
    static final String DFA78_acceptS =
        "\2\uffff\1\2\2\uffff\1\1\u00de\uffff";
    static final String DFA78_specialS =
        "\u00e4\uffff}>";
    static final String[] DFA78_transitionS = {
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\1\1\1\2\2\uffff\2\2\2\uffff"+
            "\3\2\4\uffff\1\2\1\uffff\5\2\1\uffff\1\2\5\uffff\3\2\1\uffff"+
            "\1\2\4\uffff\4\2\1\uffff\10\2\3\uffff\1\2\3\uffff\3\2\2\uffff"+
            "\5\2\1\uffff\1\2\4\uffff\3\2\6\uffff\1\2\1\uffff\1\2\1\uffff"+
            "\1\2\12\uffff\3\2\1\uffff\6\2\2\uffff\2\2\2\uffff\1\2\4\uffff"+
            "\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\1\2\7\uffff\1\2\5\uffff"+
            "\1\2\1\uffff\3\2\1\uffff\2\2\1\uffff\1\2\3\uffff\1\2\1\uffff"+
            "\2\2\1\uffff\1\2\4\uffff\2\2\1\uffff\7\2\3\uffff\2\2\2\uffff"+
            "\1\2\4\uffff\1\2\11\uffff\1\2\1\uffff\2\2\1\uffff\3\2\5\uffff"+
            "\4\2\1\uffff\4\2\1\uffff\2\2",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\3\uffff\1\2\1\uffff"+
            "\3\5\1\uffff\1\5\4\uffff\4\5\1\uffff\10\5\3\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\1\5\1\15\3\5\1\uffff\1\5\4\uffff\2\5\1\7\6\uffff"+
            "\1\12\1\uffff\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff"+
            "\1\14\1\5\2\uffff\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3"+
            "\uffff\1\17\7\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\1\5"+
            "\1\16\1\uffff\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff"+
            "\2\5\1\uffff\7\5\1\2\2\uffff\2\5\1\uffff\1\2\1\5\4\uffff\1\5"+
            "\11\uffff\1\5\1\uffff\2\5\1\uffff\3\5\5\uffff\1\13\3\5\1\uffff"+
            "\4\5\1\uffff\1\5\1\11",
            "",
            "",
            "",
            "",
            "",
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\2\2\2\uffff\2\2\2\uffff"+
            "\3\2\4\uffff\1\2\1\uffff\5\2\1\uffff\1\2\3\uffff\1\5\1\uffff"+
            "\3\2\1\uffff\1\2\4\uffff\4\2\1\uffff\10\2\3\uffff\1\2\3\uffff"+
            "\3\2\2\uffff\1\2\1\32\3\2\1\uffff\1\2\4\uffff\2\2\1\25\6\uffff"+
            "\1\27\1\uffff\1\2\1\uffff\1\2\12\uffff\3\2\1\uffff\6\2\2\uffff"+
            "\1\31\1\2\2\uffff\1\2\4\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3"+
            "\uffff\1\34\1\uffff\1\2\5\uffff\1\2\5\uffff\1\2\1\uffff\3\2"+
            "\1\uffff\1\2\1\33\1\uffff\1\2\3\uffff\1\2\1\uffff\2\2\1\uffff"+
            "\1\2\4\uffff\2\2\1\uffff\7\2\1\5\2\uffff\2\2\1\uffff\1\5\1\2"+
            "\4\uffff\1\2\11\uffff\1\2\1\uffff\2\2\1\uffff\3\2\5\uffff\1"+
            "\30\3\2\1\uffff\4\2\1\uffff\1\2\1\26",
            "",
            "\3\2\1\uffff\2\2\1\uffff\2\2\1\uffff\2\2\1\uffff\3\2\2\uffff"+
            "\3\2\2\uffff\1\2\1\uffff\1\2\1\uffff\7\2\3\uffff\1\5\1\uffff"+
            "\3\2\1\uffff\1\2\4\uffff\4\2\1\uffff\10\2\3\uffff\1\2\3\uffff"+
            "\3\2\2\uffff\1\2\1\52\3\2\1\uffff\3\2\2\uffff\2\2\1\45\6\uffff"+
            "\1\47\1\uffff\1\2\1\uffff\1\2\12\uffff\3\2\1\uffff\7\2\1\uffff"+
            "\1\51\1\2\2\uffff\1\2\4\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3"+
            "\uffff\1\54\1\uffff\1\2\3\uffff\1\2\1\uffff\2\2\4\uffff\1\2"+
            "\1\uffff\3\2\1\uffff\1\2\1\53\1\uffff\1\2\3\uffff\4\2\1\uffff"+
            "\2\2\3\uffff\2\2\1\uffff\7\2\1\5\2\uffff\2\2\1\uffff\1\5\1\2"+
            "\4\uffff\1\2\11\uffff\1\2\1\uffff\7\2\4\uffff\1\50\3\2\1\uffff"+
            "\4\2\1\uffff\1\2\1\46",
            "\1\2\13\uffff\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\32"+
            "\uffff\1\5\20\uffff\1\5\24\uffff\1\5\31\uffff\1\5\5\uffff\1"+
            "\5\34\uffff\1\5\12\uffff\1\5",
            "\1\2\40\uffff\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\32"+
            "\uffff\1\5\20\uffff\1\5\24\uffff\1\5\31\uffff\1\5\3\uffff\1"+
            "\2\1\uffff\1\5\34\uffff\1\5\12\uffff\1\5",
            "\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\32\uffff\1\5\20"+
            "\uffff\1\5\24\uffff\1\5\31\uffff\1\5\3\uffff\1\2\1\uffff\1\5"+
            "\34\uffff\1\5\12\uffff\1\5",
            "\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\32\uffff\1\5\20"+
            "\uffff\1\5\24\uffff\1\5\31\uffff\1\5\3\uffff\1\2\1\uffff\1\5"+
            "\34\uffff\1\5\12\uffff\1\5",
            "\1\2\13\uffff\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\32"+
            "\uffff\1\5\20\uffff\1\5\24\uffff\1\5\31\uffff\1\5\5\uffff\1"+
            "\5\34\uffff\1\5\12\uffff\1\5",
            "\1\5\44\uffff\1\5\13\uffff\1\5\6\uffff\1\5\30\uffff\1\2\1\uffff"+
            "\1\5\20\uffff\1\5\24\uffff\1\5\31\uffff\1\5\5\uffff\1\5\34\uffff"+
            "\1\5\12\uffff\1\5",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\2\1\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\1\5\5\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff"+
            "\7\5\3\uffff\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\uffff\3\5\2\uffff"+
            "\3\5\2\uffff\1\5\1\uffff\1\5\1\uffff\7\5\5\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\2\1\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\3\5\2\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\7\5\1\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\4\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\2\5\1\uffff\1\5\3\uffff\4\5\1\uffff\2\5\3\uffff\2\5\1\uffff"+
            "\7\5\3\uffff\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\7\5\4\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\1\5\44\uffff\1\2",
            "\1\5\71\uffff\1\2\175\uffff\1\5",
            "\1\2\175\uffff\1\5",
            "\1\2\175\uffff\1\5",
            "\1\5\44\uffff\1\2",
            "\1\2\67\uffff\1\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\2\uffff\2\5\2\uffff"+
            "\3\5\4\uffff\1\5\1\uffff\5\5\1\uffff\1\5\5\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\2\1\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\1\5\4\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\6\5\2\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\1\5\5\uffff\1\5\5\uffff\1\5\1\uffff\3\5\1\uffff\2\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\1\uffff\1\5\4\uffff\2\5\1\uffff"+
            "\7\5\3\uffff\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\2\5\1\uffff\3\5\5\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\3\5\1\uffff\2\5\1\uffff\2\5\1\uffff\2\5\1\uffff\3\5\2\uffff"+
            "\3\5\2\uffff\1\5\1\uffff\1\5\1\uffff\7\5\5\uffff\3\5\1\uffff"+
            "\1\5\4\uffff\4\5\1\uffff\10\5\1\uffff\1\2\1\uffff\1\5\3\uffff"+
            "\3\5\2\uffff\5\5\1\uffff\3\5\2\uffff\3\5\6\uffff\1\5\1\uffff"+
            "\1\5\1\uffff\1\5\12\uffff\3\5\1\uffff\7\5\1\uffff\2\5\2\uffff"+
            "\1\5\4\uffff\1\5\1\uffff\1\5\1\uffff\1\5\3\uffff\1\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\2\5\4\uffff\1\5\1\uffff\3\5\1\uffff"+
            "\2\5\1\uffff\1\5\3\uffff\4\5\1\uffff\2\5\3\uffff\2\5\1\uffff"+
            "\7\5\3\uffff\2\5\2\uffff\1\5\4\uffff\1\5\11\uffff\1\5\1\uffff"+
            "\7\5\4\uffff\4\5\1\uffff\4\5\1\uffff\2\5",
            "\1\5\44\uffff\1\2",
            "\1\5\71\uffff\1\2\175\uffff\1\5",
            "\1\2\175\uffff\1\5",
            "\1\2\175\uffff\1\5",
            "\1\5\44\uffff\1\2",
            "\1\2\67\uffff\1\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA78_eot = DFA.unpackEncodedString(DFA78_eotS);
    static final short[] DFA78_eof = DFA.unpackEncodedString(DFA78_eofS);
    static final char[] DFA78_min = DFA.unpackEncodedStringToUnsignedChars(DFA78_minS);
    static final char[] DFA78_max = DFA.unpackEncodedStringToUnsignedChars(DFA78_maxS);
    static final short[] DFA78_accept = DFA.unpackEncodedString(DFA78_acceptS);
    static final short[] DFA78_special = DFA.unpackEncodedString(DFA78_specialS);
    static final short[][] DFA78_transition;

    static {
        int numStates = DFA78_transitionS.length;
        DFA78_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA78_transition[i] = DFA.unpackEncodedString(DFA78_transitionS[i]);
        }
    }

    class DFA78 extends DFA {

        public DFA78(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 78;
            this.eot = DFA78_eot;
            this.eof = DFA78_eof;
            this.min = DFA78_min;
            this.max = DFA78_max;
            this.accept = DFA78_accept;
            this.special = DFA78_special;
            this.transition = DFA78_transition;
        }
        public String getDescription() {
            return "340:11: ( AS )?";
        }
    }
    static final String DFA124_eotS =
        "\110\uffff";
    static final String DFA124_eofS =
        "\110\uffff";
    static final String DFA124_minS =
        "\1\43\1\5\7\uffff\4\43\73\uffff";
    static final String DFA124_maxS =
        "\1\u00e1\1\u00eb\7\uffff\4\u00e1\73\uffff";
    static final String DFA124_acceptS =
        "\2\uffff\1\2\12\uffff\1\1\72\uffff";
    static final String DFA124_specialS =
        "\110\uffff}>";
    static final String[] DFA124_transitionS = {
            "\1\2\6\uffff\1\1\3\uffff\1\2\53\uffff\1\2\121\uffff\1\2\20\uffff"+
            "\1\2\43\uffff\1\2",
            "\3\15\1\uffff\2\15\1\uffff\2\15\1\uffff\2\15\2\uffff\2\15\2"+
            "\uffff\3\15\4\uffff\1\15\1\uffff\3\15\1\13\1\15\7\uffff\2\15"+
            "\1\2\1\uffff\1\15\4\uffff\4\15\1\uffff\10\15\3\uffff\1\15\3"+
            "\uffff\3\15\2\uffff\5\15\1\uffff\1\15\4\uffff\1\15\1\14\1\15"+
            "\3\uffff\1\15\2\uffff\1\15\1\uffff\1\15\1\uffff\1\15\12\uffff"+
            "\12\15\2\uffff\2\15\2\uffff\2\15\3\uffff\1\15\1\uffff\1\15\1"+
            "\uffff\1\15\2\uffff\2\15\4\uffff\1\15\2\uffff\3\15\3\uffff\1"+
            "\15\1\uffff\3\15\1\uffff\2\15\1\uffff\1\15\3\uffff\1\15\1\uffff"+
            "\1\15\1\11\1\uffff\1\15\4\uffff\12\15\3\uffff\2\15\2\uffff\1"+
            "\15\4\uffff\1\15\11\uffff\1\15\1\uffff\2\15\1\uffff\3\15\5\uffff"+
            "\1\15\1\12\2\15\1\uffff\4\15\1\uffff\2\15",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\2\15\5\uffff\1\15\3\uffff\1\15\14\uffff\1\15\36\uffff\1\15"+
            "\13\uffff\1\15\41\uffff\1\2\16\uffff\1\15\4\uffff\1\15\17\uffff"+
            "\1\15\7\uffff\1\15\10\uffff\1\15\43\uffff\1\15",
            "\2\15\5\uffff\1\15\3\uffff\1\15\14\uffff\1\15\36\uffff\1\15"+
            "\13\uffff\1\15\51\uffff\1\2\6\uffff\1\15\4\uffff\1\15\17\uffff"+
            "\1\15\7\uffff\1\15\10\uffff\1\15\43\uffff\1\15",
            "\2\15\5\uffff\1\15\3\uffff\1\15\14\uffff\1\15\36\uffff\1\15"+
            "\13\uffff\1\15\51\uffff\1\2\6\uffff\1\15\4\uffff\1\15\17\uffff"+
            "\1\15\7\uffff\1\15\10\uffff\1\15\43\uffff\1\15",
            "\2\15\5\uffff\1\15\3\uffff\1\15\14\uffff\1\15\36\uffff\1\15"+
            "\13\uffff\1\15\41\uffff\1\2\16\uffff\1\15\4\uffff\1\15\17\uffff"+
            "\1\15\7\uffff\1\15\10\uffff\1\15\43\uffff\1\15",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA124_eot = DFA.unpackEncodedString(DFA124_eotS);
    static final short[] DFA124_eof = DFA.unpackEncodedString(DFA124_eofS);
    static final char[] DFA124_min = DFA.unpackEncodedStringToUnsignedChars(DFA124_minS);
    static final char[] DFA124_max = DFA.unpackEncodedStringToUnsignedChars(DFA124_maxS);
    static final short[] DFA124_accept = DFA.unpackEncodedString(DFA124_acceptS);
    static final short[] DFA124_special = DFA.unpackEncodedString(DFA124_specialS);
    static final short[][] DFA124_transition;

    static {
        int numStates = DFA124_transitionS.length;
        DFA124_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA124_transition[i] = DFA.unpackEncodedString(DFA124_transitionS[i]);
        }
    }

    class DFA124 extends DFA {

        public DFA124(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 124;
            this.eot = DFA124_eot;
            this.eof = DFA124_eof;
            this.min = DFA124_min;
            this.max = DFA124_max;
            this.accept = DFA124_accept;
            this.special = DFA124_special;
            this.transition = DFA124_transition;
        }
        public String getDescription() {
            return "()* loopback of 404:23: ( COMMA column_def )*";
        }
    }
    static final String DFA129_eotS =
        "\u01cc\uffff";
    static final String DFA129_eofS =
        "\1\1\4\uffff\1\12\14\uffff\1\12\22\uffff\1\12\10\uffff\1\12\10\uffff"+
        "\1\12\u0194\uffff";
    static final String DFA129_minS =
        "\1\43\2\uffff\1\5\1\u0088\1\43\1\u0090\10\uffff\3\43\1\20\20\uffff"+
        "\1\5\1\u0088\1\43\1\u0090\6\uffff\1\u0088\1\43\1\u0090\6\uffff\1"+
        "\u0088\1\43\1\u0090\30\uffff\12\13\2\5\1\13\1\103\1\5\1\103\2\5"+
        "\2\103\1\5\u0166\uffff";
    static final String DFA129_maxS =
        "\1\u00e1\2\uffff\1\u00eb\1\u0088\1\u00e1\1\u0090\10\uffff\4\u00e1"+
        "\20\uffff\1\u00eb\1\u0088\1\u00e1\1\u0090\6\uffff\1\u0088\1\u00e1"+
        "\1\u0090\6\uffff\1\u0088\1\u00e1\1\u0090\30\uffff\12\u00c7\2\u00eb"+
        "\1\u00c7\1\u0090\1\u00eb\1\u0090\2\u00eb\1\u0090\1\103\1\u00eb\u0166"+
        "\uffff";
    static final String DFA129_acceptS =
        "\1\uffff\1\2\10\uffff\1\1\133\uffff\1\1\20\uffff\2\1\20\uffff\2"+
        "\1\20\uffff\u0131\1";
    static final String DFA129_specialS =
        "\u01cc\uffff}>";
    static final String[] DFA129_transitionS = {
            "\1\6\1\12\5\uffff\1\1\3\uffff\1\3\14\uffff\1\12\36\uffff\1\1"+
            "\74\uffff\1\12\4\uffff\1\12\17\uffff\1\4\7\uffff\1\12\10\uffff"+
            "\1\1\5\uffff\1\1\35\uffff\1\5",
            "",
            "",
            "\3\21\1\uffff\2\21\1\uffff\2\21\1\uffff\2\21\2\uffff\2\21\2"+
            "\uffff\3\21\4\uffff\1\21\1\uffff\5\21\1\uffff\1\21\5\uffff\3"+
            "\21\1\uffff\1\21\4\uffff\4\21\1\uffff\10\21\3\uffff\1\21\3\uffff"+
            "\3\21\2\uffff\5\21\1\uffff\1\21\4\uffff\3\21\6\uffff\1\21\1"+
            "\uffff\1\21\1\uffff\1\17\12\uffff\3\21\1\uffff\6\21\2\uffff"+
            "\2\21\2\uffff\1\21\4\uffff\1\21\1\uffff\1\21\1\uffff\1\21\3"+
            "\uffff\1\21\7\uffff\1\21\5\uffff\1\21\1\uffff\3\21\1\uffff\2"+
            "\21\1\uffff\1\21\3\uffff\1\21\1\uffff\2\21\1\uffff\1\21\4\uffff"+
            "\2\21\1\uffff\7\21\3\uffff\2\21\2\uffff\1\21\4\uffff\1\20\11"+
            "\uffff\1\21\1\uffff\2\21\1\uffff\3\21\5\uffff\4\21\1\uffff\4"+
            "\21\1\uffff\2\21",
            "\1\22",
            "\2\12\5\uffff\1\12\3\uffff\1\12\14\uffff\1\12\36\uffff\1\12"+
            "\65\uffff\1\1\6\uffff\1\12\4\uffff\1\12\3\uffff\1\12\13\uffff"+
            "\1\12\7\uffff\1\12\10\uffff\1\12\5\uffff\1\12\35\uffff\1\12",
            "\1\43",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\46\1\12\26\uffff\1\12\36\uffff\1\1\74\uffff\1\12\4\uffff"+
            "\1\12\17\uffff\1\44\7\uffff\1\12\54\uffff\1\45",
            "\1\57\1\12\26\uffff\1\12\36\uffff\1\1\74\uffff\1\12\4\uffff"+
            "\1\12\17\uffff\1\55\7\uffff\1\12\54\uffff\1\56",
            "\1\70\1\12\26\uffff\1\12\36\uffff\1\1\74\uffff\1\12\4\uffff"+
            "\1\12\17\uffff\1\66\7\uffff\1\12\54\uffff\1\67",
            "\1\12\3\uffff\1\12\16\uffff\2\12\5\uffff\1\12\3\uffff\1\12"+
            "\14\uffff\1\12\3\uffff\1\12\32\uffff\1\12\65\uffff\1\1\6\uffff"+
            "\1\12\4\uffff\1\12\3\uffff\1\12\13\uffff\1\12\7\uffff\1\12\10"+
            "\uffff\1\12\5\uffff\1\12\35\uffff\1\12",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\3\144\1\uffff\2\144\1\uffff\2\144\1\uffff\2\144\1\uffff\1"+
            "\134\2\144\2\uffff\3\144\2\uffff\1\124\1\uffff\1\144\1\uffff"+
            "\1\144\1\142\1\136\2\144\1\133\1\144\5\uffff\3\144\1\uffff\1"+
            "\144\4\uffff\1\144\1\127\1\126\1\130\1\uffff\10\144\3\uffff"+
            "\1\144\3\uffff\3\144\2\uffff\3\144\1\140\1\144\1\uffff\1\144"+
            "\1\131\1\122\2\uffff\3\144\6\uffff\1\144\1\uffff\1\144\1\uffff"+
            "\1\135\12\uffff\3\144\1\uffff\6\144\1\121\1\uffff\2\144\2\uffff"+
            "\1\144\4\uffff\1\144\1\uffff\1\144\1\uffff\1\144\3\uffff\1\144"+
            "\1\uffff\1\137\3\uffff\1\145\1\uffff\1\144\1\141\4\uffff\1\125"+
            "\1\uffff\3\144\1\uffff\2\144\1\uffff\1\144\3\uffff\1\144\1\145"+
            "\2\144\1\uffff\1\144\1\132\3\uffff\1\143\1\144\1\uffff\7\144"+
            "\3\uffff\2\144\2\uffff\1\144\4\uffff\1\123\11\uffff\1\144\1"+
            "\uffff\2\144\1\145\3\144\1\131\4\uffff\4\144\1\uffff\4\144\1"+
            "\uffff\2\144",
            "\1\146",
            "\2\12\5\uffff\1\12\3\uffff\1\12\14\uffff\1\12\36\uffff\1\12"+
            "\65\uffff\1\1\6\uffff\1\12\4\uffff\1\12\3\uffff\1\12\13\uffff"+
            "\1\12\7\uffff\1\12\10\uffff\1\12\5\uffff\1\12\35\uffff\1\12",
            "\1\167",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\170",
            "\2\12\5\uffff\1\12\3\uffff\1\12\14\uffff\1\12\36\uffff\1\12"+
            "\65\uffff\1\1\6\uffff\1\12\4\uffff\1\12\3\uffff\1\12\13\uffff"+
            "\1\12\7\uffff\1\12\10\uffff\1\12\5\uffff\1\12\35\uffff\1\12",
            "\1\u0089",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\u008a",
            "\2\12\5\uffff\1\12\3\uffff\1\12\14\uffff\1\12\36\uffff\1\12"+
            "\65\uffff\1\1\6\uffff\1\12\4\uffff\1\12\3\uffff\1\12\13\uffff"+
            "\1\12\7\uffff\1\12\10\uffff\1\12\5\uffff\1\12\35\uffff\1\12",
            "\1\u009b",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\u00a0\1\uffff\1\u00ab\3\uffff\1\u009e\7\uffff\1\u00a9\12"+
            "\uffff\1\u009c\37\uffff\1\u009d\7\uffff\1\u00a5\1\u00aa\21\uffff"+
            "\1\u00a3\2\u00a1\22\uffff\1\u00a4\14\uffff\1\u00a8\1\u00a6\10"+
            "\uffff\2\u00a1\1\u00a3\5\uffff\1\u00a3\1\u009f\2\uffff\1\u00a2"+
            "\1\u00a7\2\u00aa\7\uffff\1\u00ac\4\uffff\1\u009e\1\u00a0\1\uffff"+
            "\1\u009f\12\uffff\1\u00a3\7\uffff\1\u00ad\7\uffff\2\u00a0\1"+
            "\u009e",
            "\1\u00b2\1\uffff\1\u00bd\3\uffff\1\u00b0\7\uffff\1\u00bb\12"+
            "\uffff\1\u00ae\37\uffff\1\u00af\7\uffff\1\u00b7\1\u00bc\21\uffff"+
            "\1\u00b5\2\u00b3\22\uffff\1\u00b6\14\uffff\1\u00ba\1\u00b8\10"+
            "\uffff\2\u00b3\1\u00b5\5\uffff\1\u00b5\1\u00b1\2\uffff\1\u00b4"+
            "\1\u00b9\2\u00bc\7\uffff\1\u00be\4\uffff\1\u00b0\1\u00b2\1\uffff"+
            "\1\u00b1\12\uffff\1\u00b5\7\uffff\1\u00bf\7\uffff\2\u00b2\1"+
            "\u00b0",
            "\1\u00c4\1\uffff\1\u00cf\3\uffff\1\u00c2\7\uffff\1\u00cd\12"+
            "\uffff\1\u00c0\36\uffff\1\u00d2\1\u00c1\7\uffff\1\u00c9\1\u00ce"+
            "\21\uffff\1\u00c7\2\u00c5\22\uffff\1\u00c8\14\uffff\1\u00cc"+
            "\1\u00ca\10\uffff\2\u00c5\1\u00c7\5\uffff\1\u00c7\1\u00c3\2"+
            "\uffff\1\u00c6\1\u00cb\2\u00ce\7\uffff\1\u00d0\4\uffff\1\u00c2"+
            "\1\u00c4\1\uffff\1\u00c3\12\uffff\1\u00c7\7\uffff\1\u00d1\7"+
            "\uffff\2\u00c4\1\u00c2",
            "\1\u00d7\1\uffff\1\u00e2\3\uffff\1\u00d5\7\uffff\1\u00e0\12"+
            "\uffff\1\u00d3\37\uffff\1\u00d4\7\uffff\1\u00dc\1\u00e1\21\uffff"+
            "\1\u00da\2\u00d8\22\uffff\1\u00db\14\uffff\1\u00df\1\u00dd\10"+
            "\uffff\2\u00d8\1\u00da\5\uffff\1\u00da\1\u00d6\2\uffff\1\u00d9"+
            "\1\u00de\2\u00e1\7\uffff\1\u00e3\4\uffff\1\u00d5\1\u00d7\1\uffff"+
            "\1\u00d6\12\uffff\1\u00da\7\uffff\1\u00e4\7\uffff\2\u00d7\1"+
            "\u00d5",
            "\1\u00e9\1\uffff\1\u00f4\3\uffff\1\u00e7\7\uffff\1\u00f2\12"+
            "\uffff\1\u00e5\36\uffff\1\u00f7\1\u00e6\7\uffff\1\u00ee\1\u00f3"+
            "\21\uffff\1\u00ec\2\u00ea\22\uffff\1\u00ed\14\uffff\1\u00f1"+
            "\1\u00ef\10\uffff\2\u00ea\1\u00ec\5\uffff\1\u00ec\1\u00e8\2"+
            "\uffff\1\u00eb\1\u00f0\2\u00f3\7\uffff\1\u00f5\4\uffff\1\u00e7"+
            "\1\u00e9\1\uffff\1\u00e8\12\uffff\1\u00ec\7\uffff\1\u00f6\7"+
            "\uffff\2\u00e9\1\u00e7",
            "\1\u00fc\1\uffff\1\u0107\3\uffff\1\u00fa\7\uffff\1\u0105\12"+
            "\uffff\1\u00f8\36\uffff\1\u010a\1\u00f9\7\uffff\1\u0101\1\u0106"+
            "\21\uffff\1\u00ff\2\u00fd\22\uffff\1\u0100\14\uffff\1\u0104"+
            "\1\u0102\10\uffff\2\u00fd\1\u00ff\5\uffff\1\u00ff\1\u00fb\2"+
            "\uffff\1\u00fe\1\u0103\2\u0106\7\uffff\1\u0108\4\uffff\1\u00fa"+
            "\1\u00fc\1\uffff\1\u00fb\12\uffff\1\u00ff\7\uffff\1\u0109\7"+
            "\uffff\2\u00fc\1\u00fa",
            "\1\u010f\1\uffff\1\u011a\3\uffff\1\u010d\7\uffff\1\u0118\12"+
            "\uffff\1\u010b\36\uffff\1\u011d\1\u010c\7\uffff\1\u0114\1\u0119"+
            "\21\uffff\1\u0112\2\u0110\22\uffff\1\u0113\14\uffff\1\u0117"+
            "\1\u0115\10\uffff\2\u0110\1\u0112\5\uffff\1\u0112\1\u010e\2"+
            "\uffff\1\u0111\1\u0116\2\u0119\7\uffff\1\u011b\4\uffff\1\u010d"+
            "\1\u010f\1\uffff\1\u010e\12\uffff\1\u0112\7\uffff\1\u011c\7"+
            "\uffff\2\u010f\1\u010d",
            "\1\u0122\1\uffff\1\u012d\3\uffff\1\u0120\7\uffff\1\u012b\12"+
            "\uffff\1\u011e\36\uffff\1\u0130\1\u011f\7\uffff\1\u0127\1\u012c"+
            "\21\uffff\1\u0125\2\u0123\22\uffff\1\u0126\14\uffff\1\u012a"+
            "\1\u0128\10\uffff\2\u0123\1\u0125\5\uffff\1\u0125\1\u0121\2"+
            "\uffff\1\u0124\1\u0129\2\u012c\7\uffff\1\u012e\4\uffff\1\u0120"+
            "\1\u0122\1\uffff\1\u0121\12\uffff\1\u0125\7\uffff\1\u012f\7"+
            "\uffff\2\u0122\1\u0120",
            "\1\u0135\1\uffff\1\u0140\3\uffff\1\u0133\7\uffff\1\u013e\12"+
            "\uffff\1\u0131\37\uffff\1\u0132\7\uffff\1\u013a\1\u013f\21\uffff"+
            "\1\u0138\2\u0136\22\uffff\1\u0139\14\uffff\1\u013d\1\u013b\10"+
            "\uffff\2\u0136\1\u0138\5\uffff\1\u0138\1\u0134\2\uffff\1\u0137"+
            "\1\u013c\2\u013f\7\uffff\1\u0141\4\uffff\1\u0133\1\u0135\1\uffff"+
            "\1\u0134\12\uffff\1\u0138\7\uffff\1\u0142\7\uffff\2\u0135\1"+
            "\u0133",
            "\1\u0148\1\uffff\1\u0153\3\uffff\1\u0146\7\uffff\1\u0151\12"+
            "\uffff\1\u0144\37\uffff\1\u0145\7\uffff\1\u014d\1\u0152\21\uffff"+
            "\1\u014b\2\u0149\22\uffff\1\u014c\6\uffff\1\u0143\5\uffff\1"+
            "\u0150\1\u014e\10\uffff\2\u0149\1\u014b\5\uffff\1\u014b\1\u0147"+
            "\2\uffff\1\u014a\1\u014f\2\u0152\7\uffff\1\u0154\4\uffff\1\u0146"+
            "\1\u0148\1\uffff\1\u0147\12\uffff\1\u014b\7\uffff\1\u0155\7"+
            "\uffff\2\u0148\1\u0146",
            "\3\u0158\1\uffff\2\u0158\1\uffff\2\u0158\1\uffff\2\u0158\2"+
            "\uffff\2\u0158\2\uffff\3\u0158\4\uffff\1\u0158\1\uffff\5\u0158"+
            "\1\uffff\1\u0158\5\uffff\3\u0158\1\uffff\1\u0158\4\uffff\4\u0158"+
            "\1\uffff\10\u0158\3\uffff\1\u0158\3\uffff\3\u0158\2\uffff\5"+
            "\u0158\1\uffff\1\u0158\4\uffff\3\u0158\6\uffff\1\u0158\1\uffff"+
            "\1\u0158\1\uffff\1\u0156\12\uffff\3\u0158\1\uffff\6\u0158\2"+
            "\uffff\2\u0158\2\uffff\1\u0158\4\uffff\1\u0158\1\uffff\1\u0158"+
            "\1\uffff\1\u0158\3\uffff\1\u0158\7\uffff\1\u0158\5\uffff\1\u0158"+
            "\1\uffff\3\u0158\1\uffff\2\u0158\1\uffff\1\u0158\3\uffff\1\u0158"+
            "\1\uffff\2\u0158\1\uffff\1\u0158\4\uffff\2\u0158\1\uffff\7\u0158"+
            "\3\uffff\2\u0158\2\uffff\1\u0158\4\uffff\1\u0157\11\uffff\1"+
            "\u0158\1\uffff\2\u0158\1\uffff\3\u0158\5\uffff\4\u0158\1\uffff"+
            "\4\u0158\1\uffff\2\u0158",
            "\3\u015b\1\uffff\2\u015b\1\uffff\2\u015b\1\uffff\2\u015b\2"+
            "\uffff\2\u015b\2\uffff\3\u015b\4\uffff\1\u015b\1\uffff\5\u015b"+
            "\1\uffff\1\u015b\5\uffff\3\u015b\1\uffff\1\u015b\4\uffff\4\u015b"+
            "\1\uffff\10\u015b\3\uffff\1\u015b\3\uffff\3\u015b\2\uffff\5"+
            "\u015b\1\uffff\1\u015b\4\uffff\3\u015b\6\uffff\1\u015b\1\uffff"+
            "\1\u015b\1\uffff\1\u0159\12\uffff\3\u015b\1\uffff\6\u015b\2"+
            "\uffff\2\u015b\2\uffff\1\u015b\4\uffff\1\u015b\1\uffff\1\u015b"+
            "\1\uffff\1\u015b\3\uffff\1\u015b\7\uffff\1\u015b\5\uffff\1\u015b"+
            "\1\uffff\3\u015b\1\uffff\2\u015b\1\uffff\1\u015b\3\uffff\1\u015b"+
            "\1\uffff\2\u015b\1\uffff\1\u015b\4\uffff\2\u015b\1\uffff\7\u015b"+
            "\3\uffff\2\u015b\2\uffff\1\u015b\4\uffff\1\u015a\11\uffff\1"+
            "\u015b\1\uffff\2\u015b\1\uffff\3\u015b\5\uffff\4\u015b\1\uffff"+
            "\4\u015b\1\uffff\2\u015b",
            "\1\u0162\1\uffff\1\u016d\3\uffff\1\u0160\7\uffff\1\u016b\12"+
            "\uffff\1\u015e\36\uffff\1\u015d\1\u015f\7\uffff\1\u0167\1\u016c"+
            "\21\uffff\1\u0165\2\u0163\22\uffff\1\u0166\14\uffff\1\u016a"+
            "\1\u0168\10\uffff\2\u0163\1\u0165\2\uffff\1\u015c\2\uffff\1"+
            "\u0165\1\u0161\2\uffff\1\u0164\1\u0169\2\u016c\7\uffff\1\u016e"+
            "\4\uffff\1\u0160\1\u0162\1\uffff\1\u0161\12\uffff\1\u0165\7"+
            "\uffff\1\u016f\7\uffff\2\u0162\1\u0160",
            "\1\u0171\114\uffff\1\u0170",
            "\3\u0187\1\uffff\2\u0187\1\uffff\2\u0187\1\uffff\2\u0187\1"+
            "\uffff\1\u017d\2\u0187\2\uffff\3\u0187\2\uffff\1\u0175\1\uffff"+
            "\1\u0187\1\uffff\1\u0187\1\u0183\1\u017f\2\u0187\1\u017c\1\u0187"+
            "\5\uffff\3\u0187\1\uffff\1\u0187\4\uffff\1\u0187\1\u0178\1\u0177"+
            "\1\u0179\1\uffff\10\u0187\3\uffff\1\u0187\3\uffff\3\u0187\2"+
            "\uffff\3\u0187\1\u0181\1\u0187\1\uffff\1\u0187\1\u017a\1\u0173"+
            "\2\uffff\3\u0187\6\uffff\1\u0187\1\uffff\1\u0187\1\uffff\1\u017e"+
            "\12\uffff\3\u0187\1\uffff\6\u0187\1\u0172\1\uffff\2\u0187\2"+
            "\uffff\1\u0187\4\uffff\1\u0187\1\uffff\1\u0187\1\uffff\1\u0187"+
            "\3\uffff\1\u0187\1\uffff\1\u0180\3\uffff\1\u0186\1\uffff\1\u0187"+
            "\1\u0182\4\uffff\1\u0176\1\uffff\3\u0187\1\uffff\2\u0187\1\uffff"+
            "\1\u0187\3\uffff\1\u0187\1\u0186\2\u0187\1\uffff\1\u0187\1\u017b"+
            "\3\uffff\1\u0184\1\u0187\1\uffff\7\u0187\3\uffff\1\u0187\1\u0185"+
            "\2\uffff\1\u0187\4\uffff\1\u0174\11\uffff\1\u0187\1\uffff\2"+
            "\u0187\1\u0186\3\u0187\1\u017a\4\uffff\4\u0187\1\uffff\4\u0187"+
            "\1\uffff\2\u0187",
            "\1\u0188\114\uffff\1\u0189",
            "\3\u019d\1\uffff\2\u019d\1\uffff\2\u019d\1\uffff\2\u019d\1"+
            "\uffff\1\u0196\2\u019d\2\uffff\3\u019d\2\uffff\1\u018e\1\uffff"+
            "\1\u019d\1\uffff\1\u019d\1\u019a\1\u0198\2\u019d\1\u0195\1\u019d"+
            "\5\uffff\3\u019d\1\uffff\1\u019d\4\uffff\1\u019d\1\u0191\1\u0190"+
            "\1\u0192\1\uffff\10\u019d\3\uffff\1\u019d\3\uffff\3\u019d\2"+
            "\uffff\3\u019d\1\u018a\1\u019d\1\uffff\1\u019d\1\u0193\1\u018c"+
            "\2\uffff\3\u019d\6\uffff\1\u019d\1\uffff\1\u019d\1\uffff\1\u0197"+
            "\12\uffff\3\u019d\1\uffff\6\u019d\1\u018b\1\uffff\2\u019d\2"+
            "\uffff\1\u019d\4\uffff\1\u019d\1\uffff\1\u019d\1\uffff\1\u019d"+
            "\3\uffff\1\u019d\1\uffff\1\u0199\5\uffff\1\u019d\1\u019b\4\uffff"+
            "\1\u018f\1\uffff\3\u019d\1\uffff\2\u019d\1\uffff\1\u019d\3\uffff"+
            "\1\u019d\1\uffff\2\u019d\1\uffff\1\u019d\1\u0194\3\uffff\1\u019c"+
            "\1\u019d\1\uffff\7\u019d\3\uffff\2\u019d\2\uffff\1\u019d\4\uffff"+
            "\1\u018d\11\uffff\1\u019d\1\uffff\2\u019d\1\uffff\3\u019d\1"+
            "\u0193\4\uffff\4\u019d\1\uffff\4\u019d\1\uffff\2\u019d",
            "\3\u01b4\1\uffff\2\u01b4\1\uffff\2\u01b4\1\uffff\2\u01b4\1"+
            "\uffff\1\u01aa\2\u01b4\2\uffff\3\u01b4\2\uffff\1\u01a2\1\uffff"+
            "\1\u01b4\1\uffff\1\u01b4\1\u01b0\1\u01ac\2\u01b4\1\u01a9\1\u01b4"+
            "\5\uffff\3\u01b4\1\uffff\1\u01b4\4\uffff\1\u01b4\1\u01a5\1\u01a4"+
            "\1\u01a6\1\uffff\10\u01b4\1\uffff\1\u019e\1\uffff\1\u01b4\3"+
            "\uffff\3\u01b4\2\uffff\3\u01b4\1\u01ae\1\u01b4\1\uffff\1\u01b4"+
            "\1\u01a7\1\u01a0\2\uffff\3\u01b4\6\uffff\1\u01b4\1\uffff\1\u01b4"+
            "\1\uffff\1\u01ab\12\uffff\3\u01b4\1\uffff\6\u01b4\1\u019f\1"+
            "\uffff\2\u01b4\2\uffff\1\u01b4\4\uffff\1\u01b4\1\uffff\1\u01b4"+
            "\1\uffff\1\u01b4\3\uffff\1\u01b4\1\uffff\1\u01ad\3\uffff\1\u01b3"+
            "\1\uffff\1\u01b4\1\u01af\4\uffff\1\u01a3\1\uffff\3\u01b4\1\uffff"+
            "\2\u01b4\1\uffff\1\u01b4\3\uffff\1\u01b4\1\u01b3\2\u01b4\1\uffff"+
            "\1\u01b4\1\u01a8\3\uffff\1\u01b1\1\u01b4\1\uffff\7\u01b4\3\uffff"+
            "\2\u01b4\2\uffff\1\u01b4\4\uffff\1\u01a1\11\uffff\1\u01b4\1"+
            "\uffff\2\u01b4\1\u01b3\3\u01b4\1\u01a7\4\uffff\4\u01b4\1\uffff"+
            "\4\u01b4\1\uffff\1\u01b2\1\u01b4",
            "\1\u01b6\114\uffff\1\u01b5",
            "\1\u01b7",
            "\3\u01cb\1\uffff\2\u01cb\1\uffff\2\u01cb\1\uffff\2\u01cb\1"+
            "\uffff\1\u01c3\2\u01cb\2\uffff\3\u01cb\2\uffff\1\u01bb\1\uffff"+
            "\1\u01cb\1\uffff\1\u01cb\1\u01c9\1\u01c5\2\u01cb\1\u01c2\1\u01cb"+
            "\5\uffff\3\u01cb\1\uffff\1\u01cb\4\uffff\1\u01cb\1\u01be\1\u01bd"+
            "\1\u01bf\1\uffff\10\u01cb\3\uffff\1\u01cb\3\uffff\3\u01cb\2"+
            "\uffff\3\u01cb\1\u01c7\1\u01cb\1\uffff\1\u01cb\1\u01c0\1\u01b9"+
            "\2\uffff\3\u01cb\6\uffff\1\u01cb\1\uffff\1\u01cb\1\uffff\1\u01c4"+
            "\12\uffff\3\u01cb\1\uffff\6\u01cb\1\u01b8\1\uffff\2\u01cb\2"+
            "\uffff\1\u01cb\4\uffff\1\u01cb\1\uffff\1\u01cb\1\uffff\1\u01cb"+
            "\3\uffff\1\u01cb\1\uffff\1\u01c6\5\uffff\1\u01cb\1\u01c8\4\uffff"+
            "\1\u01bc\1\uffff\3\u01cb\1\uffff\2\u01cb\1\uffff\1\u01cb\3\uffff"+
            "\1\u01cb\1\uffff\2\u01cb\1\uffff\1\u01cb\1\u01c1\3\uffff\1\u01ca"+
            "\1\u01cb\1\uffff\7\u01cb\3\uffff\2\u01cb\2\uffff\1\u01cb\4\uffff"+
            "\1\u01ba\11\uffff\1\u01cb\1\uffff\2\u01cb\1\uffff\3\u01cb\1"+
            "\u01c0\4\uffff\4\u01cb\1\uffff\4\u01cb\1\uffff\2\u01cb",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA129_eot = DFA.unpackEncodedString(DFA129_eotS);
    static final short[] DFA129_eof = DFA.unpackEncodedString(DFA129_eofS);
    static final char[] DFA129_min = DFA.unpackEncodedStringToUnsignedChars(DFA129_minS);
    static final char[] DFA129_max = DFA.unpackEncodedStringToUnsignedChars(DFA129_maxS);
    static final short[] DFA129_accept = DFA.unpackEncodedString(DFA129_acceptS);
    static final short[] DFA129_special = DFA.unpackEncodedString(DFA129_specialS);
    static final short[][] DFA129_transition;

    static {
        int numStates = DFA129_transitionS.length;
        DFA129_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA129_transition[i] = DFA.unpackEncodedString(DFA129_transitionS[i]);
        }
    }

    class DFA129 extends DFA {

        public DFA129(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 129;
            this.eot = DFA129_eot;
            this.eof = DFA129_eof;
            this.min = DFA129_min;
            this.max = DFA129_max;
            this.accept = DFA129_accept;
            this.special = DFA129_special;
            this.transition = DFA129_transition;
        }
        public String getDescription() {
            return "()* loopback of 409:43: ( column_constraint )*";
        }
    }
 

    public static final BitSet FOLLOW_sql_stmt_in_sql_stmt_list223 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_SEMI_in_sql_stmt_list226 = new BitSet(new long[]{0x4001100001081400L,0x0200000000040821L,0x0AC0080000000000L,0x0000002400000003L});
    public static final BitSet FOLLOW_sql_stmt_in_sql_stmt_list230 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_SEMI_in_sql_stmt_list232 = new BitSet(new long[]{0x4001100001081400L,0x0200000000040821L,0x0AC0080000000000L,0x0000002400000003L});
    public static final BitSet FOLLOW_EOF_in_sql_stmt_list240 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sql_stmt_in_sql_stmt_itself248 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_SEMI_in_sql_stmt_itself251 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_sql_stmt_itself256 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPLAIN_in_sql_stmt265 = new BitSet(new long[]{0x4001100001081400L,0x0200000000000821L,0x0AC0480000000000L,0x0000002400000003L});
    public static final BitSet FOLLOW_QUERY_in_sql_stmt268 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000020000000000L});
    public static final BitSet FOLLOW_PLAN_in_sql_stmt270 = new BitSet(new long[]{0x4001100001081400L,0x0200000000000821L,0x0AC0080000000000L,0x0000002400000003L});
    public static final BitSet FOLLOW_sql_stmt_core_in_sql_stmt276 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pragma_stmt_in_sql_stmt_core286 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_attach_stmt_in_sql_stmt_core292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_detach_stmt_in_sql_stmt_core298 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_analyze_stmt_in_sql_stmt_core304 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_reindex_stmt_in_sql_stmt_core310 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_vacuum_stmt_in_sql_stmt_core316 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_sql_stmt_core323 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insert_stmt_in_sql_stmt_core329 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_update_stmt_in_sql_stmt_core335 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_delete_stmt_in_sql_stmt_core341 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_begin_stmt_in_sql_stmt_core347 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commit_stmt_in_sql_stmt_core353 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollback_stmt_in_sql_stmt_core359 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_savepoint_stmt_in_sql_stmt_core365 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_release_stmt_in_sql_stmt_core371 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_virtual_table_stmt_in_sql_stmt_core378 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_table_stmt_in_sql_stmt_core384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_drop_table_stmt_in_sql_stmt_core390 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alter_table_stmt_in_sql_stmt_core396 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_view_stmt_in_sql_stmt_core402 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_drop_view_stmt_in_sql_stmt_core408 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_index_stmt_in_sql_stmt_core414 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_drop_index_stmt_in_sql_stmt_core420 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_trigger_stmt_in_sql_stmt_core426 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_drop_trigger_stmt_in_sql_stmt_core432 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_virtual_table_stmt_in_schema_create_table_stmt442 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_create_table_stmt_in_schema_create_table_stmt446 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_in_qualified_table_name456 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_qualified_table_name458 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_qualified_table_name464 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_INDEXED_in_qualified_table_name467 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_BY_in_qualified_table_name469 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_qualified_table_name473 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_qualified_table_name477 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
    public static final BitSet FOLLOW_INDEXED_in_qualified_table_name479 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_or_subexpr_in_expr488 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000400000000L});
    public static final BitSet FOLLOW_OR_in_expr491 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_or_subexpr_in_expr494 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000400000000L});
    public static final BitSet FOLLOW_and_subexpr_in_or_subexpr503 = new BitSet(new long[]{0x0000000000002002L});
    public static final BitSet FOLLOW_AND_in_or_subexpr506 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_and_subexpr_in_or_subexpr509 = new BitSet(new long[]{0x0000000000002002L});
    public static final BitSet FOLLOW_eq_subexpr_in_and_subexpr518 = new BitSet(new long[]{0x0000000002000002L,0x0010000080003000L,0x0020000007882006L});
    public static final BitSet FOLLOW_cond_expr_in_and_subexpr520 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr532 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L,0x0020000000082000L});
    public static final BitSet FOLLOW_match_op_in_cond_expr535 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr539 = new BitSet(new long[]{0x0000000000000002L,0x0000000000004000L});
    public static final BitSet FOLLOW_ESCAPE_in_cond_expr542 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr546 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr574 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
    public static final BitSet FOLLOW_IN_in_cond_expr577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_cond_expr579 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_cond_expr581 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_cond_expr584 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_cond_expr586 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_cond_expr590 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr612 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
    public static final BitSet FOLLOW_IN_in_cond_expr615 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_cond_expr620 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_cond_expr622 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_cond_expr628 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr656 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
    public static final BitSet FOLLOW_IN_in_cond_expr659 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_cond_expr662 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_cond_expr665 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_cond_expr668 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr675 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_EQUALS_in_cond_expr678 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_cond_expr681 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_cond_expr684 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_cond_expr687 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ISNULL_in_cond_expr695 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOTNULL_in_cond_expr703 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IS_in_cond_expr711 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_NULL_in_cond_expr713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr721 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_NULL_in_cond_expr723 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IS_in_cond_expr731 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_NOT_in_cond_expr733 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_NULL_in_cond_expr735 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IS_in_cond_expr746 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_NOT_in_cond_expr748 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr751 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_cond_expr757 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_BETWEEN_in_cond_expr760 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr764 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_AND_in_cond_expr766 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr770 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_cond_expr796 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_eq_subexpr_in_cond_expr813 = new BitSet(new long[]{0x0000000000000002L,0x0000000000003000L,0x0000000006000000L});
    public static final BitSet FOLLOW_neq_subexpr_in_eq_subexpr846 = new BitSet(new long[]{0x0000000000000002L,0x0000000300000000L,0x0000000000001800L});
    public static final BitSet FOLLOW_set_in_eq_subexpr849 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_neq_subexpr_in_eq_subexpr866 = new BitSet(new long[]{0x0000000000000002L,0x0000000300000000L,0x0000000000001800L});
    public static final BitSet FOLLOW_bit_subexpr_in_neq_subexpr875 = new BitSet(new long[]{0x0000000000000802L,0x0000000000000000L,0x0000010000000000L,0x0000000000000060L});
    public static final BitSet FOLLOW_set_in_neq_subexpr878 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_bit_subexpr_in_neq_subexpr895 = new BitSet(new long[]{0x0000000000000802L,0x0000000000000000L,0x0000010000000000L,0x0000000000000060L});
    public static final BitSet FOLLOW_add_subexpr_in_bit_subexpr904 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000040000100000L});
    public static final BitSet FOLLOW_set_in_bit_subexpr907 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_add_subexpr_in_bit_subexpr916 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000040000100000L});
    public static final BitSet FOLLOW_mul_subexpr_in_add_subexpr925 = new BitSet(new long[]{0x0000000000020002L,0x0000000000000000L,0x0000008000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_set_in_add_subexpr928 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_mul_subexpr_in_add_subexpr941 = new BitSet(new long[]{0x0000000000020002L,0x0000000000000000L,0x0000008000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_con_subexpr_in_mul_subexpr950 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
    public static final BitSet FOLLOW_DOUBLE_PIPE_in_mul_subexpr953 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_con_subexpr_in_mul_subexpr956 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
    public static final BitSet FOLLOW_unary_subexpr_in_con_subexpr965 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unary_op_in_con_subexpr969 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DA2DD0C14542L,0x00000DEF0F680213L});
    public static final BitSet FOLLOW_unary_subexpr_in_con_subexpr971 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_atom_expr_in_unary_subexpr1005 = new BitSet(new long[]{0x0000001000000002L});
    public static final BitSet FOLLOW_COLLATE_in_unary_subexpr1008 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_ID_in_unary_subexpr1013 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_value_in_atom_expr1025 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bind_parameter_in_atom_expr1031 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_in_atom_expr1041 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_atom_expr1043 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_atom_expr1049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_atom_expr1051 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_ID_in_atom_expr1057 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_atom_expr1086 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_atom_expr1088 = new BitSet(new long[]{0xFDE1707F539FB6E0L,0x6FEE00540E77CE23L,0x3FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_DISTINCT_in_atom_expr1091 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1096 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_atom_expr1099 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1103 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_ASTERISK_in_atom_expr1109 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_atom_expr1113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_atom_expr1138 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1141 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_atom_expr1143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CAST_in_atom_expr1150 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_atom_expr1153 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1156 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_AS_in_atom_expr1158 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_type_name_in_atom_expr1161 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_atom_expr1163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_atom_expr1172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_EXISTS_in_atom_expr1176 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_atom_expr1180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_atom_expr1182 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_atom_expr1184 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CASE_in_atom_expr1190 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000040000000000L});
    public static final BitSet FOLLOW_when_expr_in_atom_expr1199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000C00L,0x0000000000000000L,0x0000040000000000L});
    public static final BitSet FOLLOW_ELSE_in_atom_expr1203 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_atom_expr1207 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_END_in_atom_expr1211 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_raise_function_in_atom_expr1234 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHEN_in_when_expr1244 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_when_expr1248 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_THEN_in_when_expr1250 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_when_expr1254 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_literal_value1276 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_in_literal_value1290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_literal_value1304 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BLOB_in_literal_value1318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal_value1332 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIME_in_literal_value1338 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_DATE_in_literal_value1352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_literal_value1366 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bool_in_literal_value1380 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUESTION_in_bind_parameter1393 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUESTION_in_bind_parameter1403 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_INTEGER_in_bind_parameter1407 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_bind_parameter1422 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_bind_parameter1426 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_bind_parameter1441 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_bind_parameter1445 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RAISE_in_raise_function1466 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_raise_function1469 = new BitSet(new long[]{0x0000000000000020L,0x0004000000100000L,0x0800000000000000L});
    public static final BitSet FOLLOW_IGNORE_in_raise_function1473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_set_in_raise_function1477 = new BitSet(new long[]{0x0000040000000000L});
    public static final BitSet FOLLOW_COMMA_in_raise_function1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_STRING_in_raise_function1494 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_raise_function1497 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_type_name1507 = new BitSet(new long[]{0x0000000000000002L,0x0000004000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_type_name1511 = new BitSet(new long[]{0x0000000000000000L,0x0800000000400000L,0x0000040000100000L});
    public static final BitSet FOLLOW_signed_number_in_type_name1515 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_type_name1518 = new BitSet(new long[]{0x0000000000000000L,0x0800000000400000L,0x0000040000100000L});
    public static final BitSet FOLLOW_signed_number_in_type_name1522 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_type_name1526 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_signed_number1566 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PRAGMA_in_pragma_stmt1580 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_pragma_stmt1585 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_pragma_stmt1587 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_pragma_stmt1593 = new BitSet(new long[]{0x0000000000000002L,0x0000000000001000L,0x0000000000010000L});
    public static final BitSet FOLLOW_EQUALS_in_pragma_stmt1596 = new BitSet(new long[]{0x0000000000000000L,0x0800004000600000L,0x0000040000100000L,0x0000000008000200L});
    public static final BitSet FOLLOW_pragma_value_in_pragma_stmt1598 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_pragma_stmt1602 = new BitSet(new long[]{0x0000000000000000L,0x0800004000600000L,0x0000040000100000L,0x0000000008000200L});
    public static final BitSet FOLLOW_pragma_value_in_pragma_stmt1604 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_pragma_stmt1606 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_signed_number_in_pragma_value1635 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_pragma_value1648 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_pragma_value1661 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bool_in_pragma_value1674 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ATTACH_in_attach_stmt1684 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_DATABASE_in_attach_stmt1687 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_attach_stmt1693 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_AS_in_attach_stmt1695 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_attach_stmt1699 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DETACH_in_detach_stmt1707 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_DATABASE_in_detach_stmt1710 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_detach_stmt1716 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ANALYZE_in_analyze_stmt1724 = new BitSet(new long[]{0xFDE1705F4399B6E2L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_analyze_stmt1729 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_in_analyze_stmt1735 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_analyze_stmt1737 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_analyze_stmt1741 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REINDEX_in_reindex_stmt1751 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_reindex_stmt1756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_reindex_stmt1758 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_reindex_stmt1764 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VACUUM_in_vacuum_stmt1772 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OR_in_operation_conflict_clause1783 = new BitSet(new long[]{0x0000000000000020L,0x0004000000100000L,0x0A00000000000000L});
    public static final BitSet FOLLOW_set_in_operation_conflict_clause1785 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expr_in_ordering_term1810 = new BitSet(new long[]{0x8000000000010002L});
    public static final BitSet FOLLOW_ASC_in_ordering_term1815 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DESC_in_ordering_term1819 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ORDER_in_operation_limited_clause1849 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_BY_in_operation_limited_clause1851 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_operation_limited_clause1853 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_COMMA_in_operation_limited_clause1856 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_operation_limited_clause1858 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_LIMIT_in_operation_limited_clause1866 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_INTEGER_in_operation_limited_clause1870 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000080000000L});
    public static final BitSet FOLLOW_set_in_operation_limited_clause1873 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_INTEGER_in_operation_limited_clause1883 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_select_list_in_select_stmt1893 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800004000L});
    public static final BitSet FOLLOW_ORDER_in_select_stmt1898 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_BY_in_select_stmt1900 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_select_stmt1902 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_COMMA_in_select_stmt1905 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_select_stmt1907 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_LIMIT_in_select_stmt1916 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_INTEGER_in_select_stmt1920 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000080000000L});
    public static final BitSet FOLLOW_OFFSET_in_select_stmt1924 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_COMMA_in_select_stmt1928 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_INTEGER_in_select_stmt1933 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_select_core_in_select_list1978 = new BitSet(new long[]{0x0000000000000002L,0x2000000000008000L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_select_op_in_select_list1981 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_core_in_select_list1984 = new BitSet(new long[]{0x0000000000000002L,0x2000000000008000L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_UNION_in_select_op1993 = new BitSet(new long[]{0x0000000000000202L});
    public static final BitSet FOLLOW_ALL_in_select_op1997 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTERSECT_in_select_op2003 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXCEPT_in_select_op2007 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SELECT_in_select_core2016 = new BitSet(new long[]{0xFDE1707F539FB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ALL_in_select_core2019 = new BitSet(new long[]{0xFDE1707F539FB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_DISTINCT_in_select_core2023 = new BitSet(new long[]{0xFDE1707F539FB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_result_column_in_select_core2027 = new BitSet(new long[]{0x0000040000000002L,0x0000000408000000L,0x0000000000000000L,0x0000080000000000L});
    public static final BitSet FOLLOW_COMMA_in_select_core2030 = new BitSet(new long[]{0xFDE1707F539FB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_result_column_in_select_core2032 = new BitSet(new long[]{0x0000040000000002L,0x0000000408000000L,0x0000000000000000L,0x0000080000000000L});
    public static final BitSet FOLLOW_FROM_in_select_core2037 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0414542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_join_source_in_select_core2039 = new BitSet(new long[]{0x0000000000000002L,0x0000000400000000L,0x0000000000000000L,0x0000080000000000L});
    public static final BitSet FOLLOW_WHERE_in_select_core2044 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_select_core2048 = new BitSet(new long[]{0x0000000000000002L,0x0000000400000000L});
    public static final BitSet FOLLOW_GROUP_in_select_core2056 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_BY_in_select_core2058 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_select_core2060 = new BitSet(new long[]{0x0000040000000002L,0x0000001000000000L});
    public static final BitSet FOLLOW_COMMA_in_select_core2063 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_ordering_term_in_select_core2065 = new BitSet(new long[]{0x0000040000000002L,0x0000001000000000L});
    public static final BitSet FOLLOW_HAVING_in_select_core2070 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_select_core2074 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ASTERISK_in_result_column2144 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_in_result_column2152 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_result_column2154 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_ASTERISK_in_result_column2156 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expr_in_result_column2171 = new BitSet(new long[]{0xFDE1705F4399B6E2L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_AS_in_result_column2175 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_result_column2181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_single_source_in_join_source2202 = new BitSet(new long[]{0x0020040000000002L,0x0100000000000000L,0x0000002000400440L});
    public static final BitSet FOLLOW_join_op_in_join_source2205 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0414542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_single_source_in_join_source2208 = new BitSet(new long[]{0x0020040000000002L,0x0100000000000000L,0x0000002100400440L,0x0000000800000000L});
    public static final BitSet FOLLOW_join_constraint_in_join_source2211 = new BitSet(new long[]{0x0020040000000002L,0x0100000000000000L,0x0000002000400440L});
    public static final BitSet FOLLOW_id_in_single_source2228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_single_source2230 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_ID_in_single_source2236 = new BitSet(new long[]{0x0000000000008002L,0x0040004000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_AS_in_single_source2240 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_ID_in_single_source2246 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_INDEXED_in_single_source2251 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_BY_in_single_source2253 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_single_source2257 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_single_source2261 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
    public static final BitSet FOLLOW_INDEXED_in_single_source2263 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_single_source2304 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_single_source2306 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_single_source2308 = new BitSet(new long[]{0x0000000000008002L,0x0000004000000000L});
    public static final BitSet FOLLOW_AS_in_single_source2312 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_ID_in_single_source2318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_single_source2340 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0414542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_join_source_in_single_source2343 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_single_source2345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMA_in_join_op2356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NATURAL_in_join_op2363 = new BitSet(new long[]{0x0020000000000000L,0x0100000000000000L,0x0000002000000440L});
    public static final BitSet FOLLOW_LEFT_in_join_op2369 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000040L});
    public static final BitSet FOLLOW_OUTER_in_join_op2374 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_INNER_in_join_op2380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_CROSS_in_join_op2384 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_JOIN_in_join_op2387 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ON_in_join_constraint2398 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_join_constraint2401 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_USING_in_join_constraint2407 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_join_constraint2409 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_join_constraint2413 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_join_constraint2416 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_join_constraint2420 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_join_constraint2424 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INSERT_in_insert_stmt2443 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000400000000L});
    public static final BitSet FOLLOW_operation_conflict_clause_in_insert_stmt2446 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
    public static final BitSet FOLLOW_REPLACE_in_insert_stmt2452 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L});
    public static final BitSet FOLLOW_INTO_in_insert_stmt2455 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_insert_stmt2460 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_insert_stmt2462 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_insert_stmt2468 = new BitSet(new long[]{0x0800000000000000L,0x0000000000000000L,0x0000000000010000L,0x0000004000000002L});
    public static final BitSet FOLLOW_LPAREN_in_insert_stmt2475 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_insert_stmt2479 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_insert_stmt2482 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_insert_stmt2486 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_insert_stmt2490 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000002L});
    public static final BitSet FOLLOW_VALUES_in_insert_stmt2499 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_insert_stmt2501 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_insert_stmt2505 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_insert_stmt2508 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_insert_stmt2512 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_insert_stmt2516 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_insert_stmt2520 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DEFAULT_in_insert_stmt2527 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
    public static final BitSet FOLLOW_VALUES_in_insert_stmt2529 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPDATE_in_update_stmt2539 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_operation_conflict_clause_in_update_stmt2542 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_qualified_table_name_in_update_stmt2546 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_SET_in_update_stmt2550 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_update_set_in_update_stmt2554 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000800004000L,0x0000080000000000L});
    public static final BitSet FOLLOW_COMMA_in_update_stmt2557 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_update_set_in_update_stmt2561 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000800004000L,0x0000080000000000L});
    public static final BitSet FOLLOW_WHERE_in_update_stmt2566 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_update_stmt2568 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800004000L});
    public static final BitSet FOLLOW_operation_limited_clause_in_update_stmt2573 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_in_update_set2584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_EQUALS_in_update_set2586 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_update_set2588 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DELETE_in_delete_stmt2596 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
    public static final BitSet FOLLOW_FROM_in_delete_stmt2598 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_qualified_table_name_in_delete_stmt2600 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800004000L,0x0000080000000000L});
    public static final BitSet FOLLOW_WHERE_in_delete_stmt2603 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_delete_stmt2605 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800004000L});
    public static final BitSet FOLLOW_operation_limited_clause_in_delete_stmt2610 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_begin_stmt2620 = new BitSet(new long[]{0x2000000000000002L,0x0008000000010000L,0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_TRANSACTION_in_begin_stmt2636 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_commit_stmt2646 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_TRANSACTION_in_commit_stmt2655 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollback_stmt2665 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000003000000L});
    public static final BitSet FOLLOW_TRANSACTION_in_rollback_stmt2668 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_TO_in_rollback_stmt2673 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_SAVEPOINT_in_rollback_stmt2676 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_rollback_stmt2682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SAVEPOINT_in_savepoint_stmt2692 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_savepoint_stmt2696 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RELEASE_in_release_stmt2704 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_SAVEPOINT_in_release_stmt2707 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_release_stmt2713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ON_in_table_conflict_clause2725 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_CONFLICT_in_table_conflict_clause2728 = new BitSet(new long[]{0x0000000000000020L,0x0004000000100000L,0x0A00000000000000L});
    public static final BitSet FOLLOW_set_in_table_conflict_clause2731 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_create_virtual_table_stmt2758 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000010000000000L});
    public static final BitSet FOLLOW_VIRTUAL_in_create_virtual_table_stmt2760 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_TABLE_in_create_virtual_table_stmt2762 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_virtual_table_stmt2767 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_create_virtual_table_stmt2769 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_virtual_table_stmt2775 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
    public static final BitSet FOLLOW_USING_in_create_virtual_table_stmt2779 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_virtual_table_stmt2783 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_create_virtual_table_stmt2786 = new BitSet(new long[]{0xFDE1301F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_column_def_in_create_virtual_table_stmt2788 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_create_virtual_table_stmt2791 = new BitSet(new long[]{0xFDE1301F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_column_def_in_create_virtual_table_stmt2793 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_create_virtual_table_stmt2797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_create_table_stmt2843 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000280000L});
    public static final BitSet FOLLOW_TEMPORARY_in_create_table_stmt2845 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_TABLE_in_create_table_stmt2848 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_IF_in_create_table_stmt2851 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_NOT_in_create_table_stmt2853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_EXISTS_in_create_table_stmt2855 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_table_stmt2862 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_create_table_stmt2864 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_table_stmt2870 = new BitSet(new long[]{0x0000000000008000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_create_table_stmt2876 = new BitSet(new long[]{0xFDE1301F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_column_def_in_create_table_stmt2878 = new BitSet(new long[]{0x0000440800000000L,0x0000000004000000L,0x2000100000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_COMMA_in_create_table_stmt2881 = new BitSet(new long[]{0xFDE1301F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_column_def_in_create_table_stmt2883 = new BitSet(new long[]{0x0000440800000000L,0x0000000004000000L,0x2000100000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_COMMA_in_create_table_stmt2888 = new BitSet(new long[]{0x0000400800000000L,0x0000000004000000L,0x0000100000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_table_constraint_in_create_table_stmt2891 = new BitSet(new long[]{0x0000440800000000L,0x0000000004000000L,0x2000100000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_RPAREN_in_create_table_stmt2895 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AS_in_create_table_stmt2901 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_create_table_stmt2903 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_id_column_def_in_column_def2959 = new BitSet(new long[]{0x0800401800000002L,0x0000004000000000L,0x0010100010800000L,0x0000000200000000L});
    public static final BitSet FOLLOW_type_name_in_column_def2961 = new BitSet(new long[]{0x0800401800000002L,0x0000000000000000L,0x0010100010800000L,0x0000000200000000L});
    public static final BitSet FOLLOW_column_constraint_in_column_def2964 = new BitSet(new long[]{0x0800401800000002L,0x0000000000000000L,0x0010100010800000L,0x0000000200000000L});
    public static final BitSet FOLLOW_CONSTRAINT_in_column_constraint2990 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_column_constraint2994 = new BitSet(new long[]{0x0800001800000000L,0x0000000000000000L,0x0010100010800000L,0x0000000200000000L});
    public static final BitSet FOLLOW_column_constraint_pk_in_column_constraint3002 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_not_null_in_column_constraint3008 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_null_in_column_constraint3014 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_unique_in_column_constraint3020 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_check_in_column_constraint3026 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_default_in_column_constraint3032 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_constraint_collate_in_column_constraint3038 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_fk_clause_in_column_constraint3044 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PRIMARY_in_column_constraint_pk3104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_KEY_in_column_constraint_pk3107 = new BitSet(new long[]{0x8000000000110002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_column_constraint_pk3119 = new BitSet(new long[]{0x0000000000100002L});
    public static final BitSet FOLLOW_AUTOINCREMENT_in_column_constraint_pk3123 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_column_constraint_not_null3132 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_NULL_in_column_constraint_not_null3134 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_column_constraint_not_null3136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_column_constraint_null3153 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_column_constraint_null3155 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UNIQUE_in_column_constraint_unique3172 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_column_constraint_unique3175 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHECK_in_column_constraint_check3183 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_column_constraint_check3186 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_column_constraint_check3189 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_column_constraint_check3191 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_numeric_literal_value3202 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_in_numeric_literal_value3216 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_signed_default_number3234 = new BitSet(new long[]{0x0000000000000000L,0x0800000000400000L});
    public static final BitSet FOLLOW_numeric_literal_value_in_signed_default_number3243 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DEFAULT_in_column_constraint_default3251 = new BitSet(new long[]{0x01C0000010000000L,0x0800000000600000L,0x0000040010110000L,0x0000000008000200L});
    public static final BitSet FOLLOW_signed_default_number_in_column_constraint_default3255 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_value_in_column_constraint_default3259 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_column_constraint_default3263 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_column_constraint_default3266 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_column_constraint_default3268 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLLATE_in_column_constraint_collate3278 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_column_constraint_collate3283 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONSTRAINT_in_table_constraint3292 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint3296 = new BitSet(new long[]{0x0000000800000000L,0x0000000004000000L,0x0000100000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_table_constraint_pk_in_table_constraint3304 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_table_constraint_unique_in_table_constraint3310 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_table_constraint_check_in_table_constraint3316 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_table_constraint_fk_in_table_constraint3322 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PRIMARY_in_table_constraint_pk3362 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_KEY_in_table_constraint_pk3364 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_table_constraint_pk3368 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_pk3372 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_table_constraint_pk3375 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_pk3379 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_table_constraint_pk3383 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_table_constraint_pk3385 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UNIQUE_in_table_constraint_unique3410 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_table_constraint_unique3414 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_unique3418 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_table_constraint_unique3421 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_unique3425 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_table_constraint_unique3429 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_table_conflict_clause_in_table_constraint_unique3431 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHECK_in_table_constraint_check3456 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_table_constraint_check3459 = new BitSet(new long[]{0xFDE1707F539DB6E0L,0x6FEE00540E77CE23L,0x1FD8DE2DD0D14542L,0x00000DEF0FE80213L});
    public static final BitSet FOLLOW_expr_in_table_constraint_check3462 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_table_constraint_check3464 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FOREIGN_in_table_constraint_fk3472 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_KEY_in_table_constraint_fk3474 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_LPAREN_in_table_constraint_fk3476 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_fk3480 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_table_constraint_fk3483 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_table_constraint_fk3487 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_table_constraint_fk3491 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
    public static final BitSet FOLLOW_fk_clause_in_table_constraint_fk3493 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REFERENCES_in_fk_clause3516 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_fk_clause3520 = new BitSet(new long[]{0x1000000000000002L,0x0000000000000000L,0x0000000100890000L});
    public static final BitSet FOLLOW_LPAREN_in_fk_clause3523 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_fk_clause3527 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_COMMA_in_fk_clause3530 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_fk_clause3534 = new BitSet(new long[]{0x0000040000000000L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_RPAREN_in_fk_clause3538 = new BitSet(new long[]{0x1000000000000002L,0x0000000000000000L,0x0000000100880000L});
    public static final BitSet FOLLOW_fk_clause_action_in_fk_clause3544 = new BitSet(new long[]{0x1000000000000002L,0x0000000000000000L,0x0000000100880000L});
    public static final BitSet FOLLOW_fk_clause_deferrable_in_fk_clause3547 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ON_in_fk_clause_action3581 = new BitSet(new long[]{0x4000000000000000L,0x0200000000000000L,0x0000000000000000L,0x0000000400000000L});
    public static final BitSet FOLLOW_set_in_fk_clause_action3584 = new BitSet(new long[]{0x0000000100000000L,0x0000000000000000L,0x0400000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_SET_in_fk_clause_action3597 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
    public static final BitSet FOLLOW_NULL_in_fk_clause_action3600 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SET_in_fk_clause_action3604 = new BitSet(new long[]{0x0800000000000000L});
    public static final BitSet FOLLOW_DEFAULT_in_fk_clause_action3607 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CASCADE_in_fk_clause_action3611 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RESTRICT_in_fk_clause_action3615 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MATCH_in_fk_clause_action3622 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_fk_clause_action3625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_fk_clause_deferrable3633 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_DEFERRABLE_in_fk_clause_deferrable3637 = new BitSet(new long[]{0x0000000000000002L,0x0080000000000000L});
    public static final BitSet FOLLOW_INITIALLY_in_fk_clause_deferrable3641 = new BitSet(new long[]{0x2000000000000000L});
    public static final BitSet FOLLOW_DEFERRED_in_fk_clause_deferrable3644 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INITIALLY_in_fk_clause_deferrable3648 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
    public static final BitSet FOLLOW_IMMEDIATE_in_fk_clause_deferrable3651 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DROP_in_drop_table_stmt3661 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_TABLE_in_drop_table_stmt3663 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_IF_in_drop_table_stmt3666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_EXISTS_in_drop_table_stmt3668 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_drop_table_stmt3675 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_drop_table_stmt3677 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_drop_table_stmt3683 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ALTER_in_alter_table_stmt3713 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_TABLE_in_alter_table_stmt3715 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_alter_table_stmt3720 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_alter_table_stmt3722 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_alter_table_stmt3728 = new BitSet(new long[]{0x0000000000000040L,0x0000000000000000L,0x0100000000000000L});
    public static final BitSet FOLLOW_RENAME_in_alter_table_stmt3731 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_TO_in_alter_table_stmt3733 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_alter_table_stmt3737 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ADD_in_alter_table_stmt3741 = new BitSet(new long[]{0xFDE1305F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_COLUMN_in_alter_table_stmt3744 = new BitSet(new long[]{0xFDE1301F4399B6E0L,0x67FE00548E17CE23L,0x1FF85A2DD1C86546L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_column_def_in_alter_table_stmt3748 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_create_view_stmt3757 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000008000200000L});
    public static final BitSet FOLLOW_TEMPORARY_in_create_view_stmt3759 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
    public static final BitSet FOLLOW_VIEW_in_create_view_stmt3762 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_IF_in_create_view_stmt3765 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_NOT_in_create_view_stmt3767 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_EXISTS_in_create_view_stmt3769 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_view_stmt3776 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_create_view_stmt3778 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_id_in_create_view_stmt3784 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_AS_in_create_view_stmt3786 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_select_stmt_in_create_view_stmt3790 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DROP_in_drop_view_stmt3831 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
    public static final BitSet FOLLOW_VIEW_in_drop_view_stmt3833 = new BitSet(new long[]{0xFDE1705F4399B6E0L,0x67EE00540E17CE23L,0x1FD85A2DD0404542L,0x00000DEF07680213L});
    public static final BitSet FOLLOW_IF_in_drop_view_stmt3836 = new BitSet(new long[]{0x0000000000000000