/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.lineage;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.client.lineage.DummyFileOutputStream;
import tachyon.client.lineage.LineageContext;
import tachyon.client.lineage.LineageFileOutStream;
import tachyon.client.lineage.LineageMasterClient;
import tachyon.exception.LineageDoesNotExistException;
import tachyon.exception.TachyonException;

public class TachyonLineageFileSystem
extends TachyonFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static TachyonLineageFileSystem sTachyonFileSystem;
    private LineageContext mContext = LineageContext.INSTANCE;

    public static synchronized TachyonLineageFileSystem get() {
        if (sTachyonFileSystem == null) {
            sTachyonFileSystem = new TachyonLineageFileSystem();
        }
        return sTachyonFileSystem;
    }

    protected TachyonLineageFileSystem() {
    }

    private long reinitializeFile(TachyonURI path, OutStreamOptions options) throws LineageDoesNotExistException, IOException, TachyonException {
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long fileId;
            long l = fileId = masterClient.reinitializeFile(path.getPath(), options.getBlockSizeBytes(), options.getTTL());
            return l;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, LineageDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public FileOutStream getOutStream(TachyonURI path, OutStreamOptions options) throws IOException, TachyonException {
        long fileId;
        try {
            fileId = this.reinitializeFile(path, options);
        }
        catch (LineageDoesNotExistException e) {
            return super.getOutStream(path, options);
        }
        if (fileId == -1L) {
            return new DummyFileOutputStream(fileId, options);
        }
        return new LineageFileOutStream(fileId, options);
    }
}

