/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SaajContentHandler
implements ContentHandler {
    private SOAPElement element;
    private final SOAPEnvelope envelope;
    private Map<String, String> namespaces = new LinkedHashMap<String, String>();

    public SaajContentHandler(SOAPElement element) {
        Assert.notNull((Object)element, (String)"element must not be null");
        this.envelope = element instanceof SOAPEnvelope ? (SOAPEnvelope)element : SaajUtils.getEnvelope(element);
        this.element = element;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String text = new String(ch, start, length);
            this.element.addTextNode(text);
        }
        catch (SOAPException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            String childPrefix = this.getPrefix(qName);
            SOAPElement child = this.element.addChildElement(localName, childPrefix, uri);
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!StringUtils.hasLength((String)atts.getLocalName(i))) continue;
                String attributePrefix = this.getPrefix(atts.getQName(i));
                if ("xmlns".equals(atts.getLocalName(i)) || "xmlns".equals(attributePrefix)) continue;
                Name attributeName = this.envelope.createName(atts.getLocalName(i), attributePrefix, atts.getURI(i));
                child.addAttribute(attributeName, atts.getValue(i));
            }
            for (String namespacePrefix : this.namespaces.keySet()) {
                String namespaceUri;
                if (this.findParentNamespaceDeclaration(child, namespacePrefix, namespaceUri = this.namespaces.get(namespacePrefix))) continue;
                child.addNamespaceDeclaration(namespacePrefix, namespaceUri);
            }
            this.element = child;
        }
        catch (SOAPException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
    }

    private boolean findParentNamespaceDeclaration(SOAPElement element, String prefix, String namespaceUri) {
        String result = element.getNamespaceURI(prefix);
        if (namespaceUri.equals(result)) {
            return true;
        }
        try {
            SOAPElement parent = element.getParentElement();
            if (parent != null) {
                return this.findParentNamespaceDeclaration(parent, prefix, namespaceUri);
            }
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        return false;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Assert.isTrue((boolean)localName.equals(this.element.getElementName().getLocalName()), (String)"Invalid element on stack");
        Assert.isTrue((boolean)uri.equals(this.element.getElementName().getURI()), (String)"Invalid element on stack");
        this.element = this.element.getParentElement();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private String getPrefix(String qName) {
        int idx = qName.indexOf(58);
        if (idx != -1) {
            return qName.substring(0, idx);
        }
        return null;
    }
}

