/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.EntityResponse;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

class ResourceHandlerFunction
implements HandlerFunction<ServerResponse> {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    private final Resource resource;
    private final BiConsumer<Resource, HttpHeaders> headersConsumer;

    public ResourceHandlerFunction(Resource resource2, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        this.resource = resource2;
        this.headersConsumer = headersConsumer;
    }

    @Override
    public Mono<ServerResponse> handle(ServerRequest request) {
        HttpMethod method = request.method();
        if (HttpMethod.GET.equals((Object)method)) {
            return EntityResponse.fromObject(this.resource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build().map(response -> response);
        }
        if (HttpMethod.HEAD.equals((Object)method)) {
            HeadMethodResource headResource = new HeadMethodResource(this.resource);
            return EntityResponse.fromObject(headResource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build().map(response -> response);
        }
        if (HttpMethod.OPTIONS.equals((Object)method)) {
            return ((ServerResponse.BodyBuilder)ServerResponse.ok().allow(SUPPORTED_METHODS)).body(BodyInserters.empty());
        }
        return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).allow(SUPPORTED_METHODS)).body(BodyInserters.empty());
    }

    private static class HeadMethodResource
    implements Resource {
        private static final byte[] EMPTY = new byte[0];
        private final Resource delegate;

        public HeadMethodResource(Resource delegate) {
            this.delegate = delegate;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(EMPTY);
        }

        public boolean exists() {
            return this.delegate.exists();
        }

        public URL getURL() throws IOException {
            return this.delegate.getURL();
        }

        public URI getURI() throws IOException {
            return this.delegate.getURI();
        }

        public File getFile() throws IOException {
            return this.delegate.getFile();
        }

        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        public long lastModified() throws IOException {
            return this.delegate.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.delegate.createRelative(relativePath);
        }

        @Nullable
        public String getFilename() {
            return this.delegate.getFilename();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }
    }
}

