/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class AssertionErrors {
    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail(String message, @Nullable Object expected, @Nullable Object actual) {
        throw new AssertionError((Object)(message + " expected:<" + String.valueOf(expected) + "> but was:<" + String.valueOf(actual) + ">"));
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertionErrors.fail(message);
        }
    }

    public static void assertFalse(String message, boolean condition) {
        if (condition) {
            AssertionErrors.fail(message);
        }
    }

    public static void assertNull(String message, @Nullable Object object) {
        AssertionErrors.assertTrue(message, object == null);
    }

    public static void assertNotNull(String message, @Nullable Object object) {
        AssertionErrors.assertTrue(message, object != null);
    }

    public static void assertEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)actual)) {
            AssertionErrors.fail(message, ObjectUtils.nullSafeToString((Object)expected), ObjectUtils.nullSafeToString((Object)actual));
        }
    }

    public static void assertNotEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (ObjectUtils.nullSafeEquals((Object)expected, (Object)actual)) {
            throw new AssertionError((Object)(message + " was not expected to be:<" + ObjectUtils.nullSafeToString((Object)actual) + ">"));
        }
    }
}

