/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public abstract class AbstractJmsListeningContainer
extends JmsDestinationAccessor
implements BeanNameAware,
DisposableBean,
SmartLifecycle {
    @Nullable
    private String clientId;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    @Nullable
    private String beanName;
    @Nullable
    private Connection sharedConnection;
    private boolean sharedConnectionStarted = false;
    protected final Lock sharedConnectionLock = new ReentrantLock();
    private boolean active = false;
    private volatile boolean running;
    private final List<Object> pausedTasks = new ArrayList<Object>();
    protected final Lock lifecycleLock = new ReentrantLock();
    protected final Condition lifecycleCondition = this.lifecycleLock.newCondition();

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    @Nullable
    protected final String getBeanName() {
        return this.beanName;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.validateConfiguration();
        this.initialize();
    }

    protected void validateConfiguration() {
    }

    public void destroy() {
        this.shutdown();
    }

    public void initialize() throws JmsException {
        try {
            this.lifecycleLock.lock();
            try {
                this.active = true;
                this.lifecycleCondition.signalAll();
            }
            finally {
                this.lifecycleLock.unlock();
            }
            this.doInitialize();
        }
        catch (JMSException ex) {
            this.releaseSharedConnection();
            throw this.convertJmsAccessException(ex);
        }
    }

    public void shutdown() throws JmsException {
        boolean wasRunning;
        this.logger.debug((Object)"Shutting down JMS listener container");
        this.lifecycleLock.lock();
        try {
            wasRunning = this.running;
            this.running = false;
            this.active = false;
            this.pausedTasks.clear();
            this.lifecycleCondition.signalAll();
        }
        finally {
            this.lifecycleLock.unlock();
        }
        if (wasRunning && this.sharedConnectionEnabled()) {
            try {
                this.stopSharedConnection();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not stop JMS Connection on shutdown", ex);
            }
        }
        try {
            this.doShutdown();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
        finally {
            if (this.sharedConnectionEnabled()) {
                this.releaseSharedConnection();
            }
        }
    }

    public final boolean isActive() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.active;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void start() throws JmsException {
        try {
            this.doStart();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    protected void doStart() throws JMSException {
        if (this.sharedConnectionEnabled()) {
            this.establishSharedConnection();
        }
        this.lifecycleLock.lock();
        try {
            this.running = true;
            this.lifecycleCondition.signalAll();
            this.resumePausedTasks();
        }
        finally {
            this.lifecycleLock.unlock();
        }
        if (this.sharedConnectionEnabled()) {
            this.startSharedConnection();
        }
    }

    public void stop() throws JmsException {
        try {
            this.doStop();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    protected void doStop() throws JMSException {
        this.lifecycleLock.lock();
        try {
            this.running = false;
            this.lifecycleCondition.signalAll();
        }
        finally {
            this.lifecycleLock.unlock();
        }
        if (this.sharedConnectionEnabled()) {
            this.stopSharedConnection();
        }
    }

    public final boolean isRunning() {
        return this.running && this.runningAllowed();
    }

    protected boolean runningAllowed() {
        return true;
    }

    protected void establishSharedConnection() throws JMSException {
        this.sharedConnectionLock.lock();
        try {
            if (this.sharedConnection == null) {
                this.sharedConnection = this.createSharedConnection();
                this.logger.debug((Object)"Established shared JMS Connection");
            }
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected final void refreshSharedConnection() throws JMSException {
        this.sharedConnectionLock.lock();
        try {
            this.releaseSharedConnection();
            this.sharedConnection = this.createSharedConnection();
            if (this.sharedConnectionStarted) {
                this.sharedConnection.start();
            }
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected Connection createSharedConnection() throws JMSException {
        Connection con = this.createConnection();
        try {
            this.prepareSharedConnection(con);
            return con;
        }
        catch (JMSException ex) {
            JmsUtils.closeConnection(con);
            throw ex;
        }
    }

    protected void prepareSharedConnection(Connection connection) throws JMSException {
        String clientId = this.getClientId();
        if (clientId != null) {
            connection.setClientID(clientId);
        }
    }

    protected void startSharedConnection() throws JMSException {
        this.sharedConnectionLock.lock();
        try {
            this.sharedConnectionStarted = true;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.start();
                }
                catch (jakarta.jms.IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection start exception - assuming already started: " + ex));
                }
            }
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected void stopSharedConnection() throws JMSException {
        this.sharedConnectionLock.lock();
        try {
            this.sharedConnectionStarted = false;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.stop();
                }
                catch (jakarta.jms.IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection stop exception - assuming already stopped: " + ex));
                }
            }
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected final void releaseSharedConnection() {
        this.sharedConnectionLock.lock();
        try {
            ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), this.sharedConnectionStarted);
            this.sharedConnection = null;
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected final Connection getSharedConnection() {
        if (!this.sharedConnectionEnabled()) {
            throw new IllegalStateException("This listener container does not maintain a shared Connection");
        }
        this.sharedConnectionLock.lock();
        try {
            if (this.sharedConnection == null) {
                throw new SharedConnectionNotInitializedException("This listener container's shared Connection has not been initialized yet");
            }
            Connection connection = this.sharedConnection;
            return connection;
        }
        finally {
            this.sharedConnectionLock.unlock();
        }
    }

    protected final boolean rescheduleTaskIfNecessary(Object task) {
        if (this.running) {
            try {
                this.doRescheduleTask(task);
            }
            catch (RuntimeException ex) {
                this.logRejectedTask(task, ex);
                this.pausedTasks.add(task);
            }
            return true;
        }
        if (this.active) {
            this.pausedTasks.add(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumePausedTasks() {
        this.lifecycleLock.lock();
        try {
            if (!this.pausedTasks.isEmpty()) {
                Iterator<Object> it = this.pausedTasks.iterator();
                while (it.hasNext()) {
                    Object task = it.next();
                    try {
                        this.doRescheduleTask(task);
                        it.remove();
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Resumed paused task: " + task));
                    }
                    catch (RuntimeException ex) {
                        this.logRejectedTask(task, ex);
                    }
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public int getPausedTaskCount() {
        this.lifecycleLock.lock();
        try {
            int n = this.pausedTasks.size();
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doRescheduleTask(Object task) {
        throw new UnsupportedOperationException(ClassUtils.getShortName(this.getClass()) + " does not support rescheduling of tasks");
    }

    protected void logRejectedTask(Object task, RuntimeException ex) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener container task [" + task + "] has been rejected and paused: " + ex));
        }
    }

    protected abstract boolean sharedConnectionEnabled();

    protected abstract void doInitialize() throws JMSException;

    protected abstract void doShutdown() throws JMSException;

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

