/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.KotlinDetector;

class KotlinReflectionBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    KotlinReflectionBeanRegistrationAotProcessor() {
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (KotlinDetector.isKotlinType((Class)beanClass)) {
            return new AotContribution(beanClass);
        }
        return null;
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> beanClass;

        public AotContribution(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            this.registerHints(this.beanClass, generationContext.getRuntimeHints());
        }

        private void registerHints(Class<?> type, RuntimeHints runtimeHints) {
            Class<?> enclosingClass;
            Class<?> superClass;
            if (KotlinDetector.isKotlinType(type)) {
                runtimeHints.reflection().registerType(type, new MemberCategory[0]);
            }
            if ((superClass = type.getSuperclass()) != null) {
                this.registerHints(superClass, runtimeHints);
            }
            if ((enclosingClass = type.getEnclosingClass()) != null) {
                runtimeHints.reflection().registerType(enclosingClass, new MemberCategory[0]);
            }
        }
    }
}

