/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.CursoredList;
import org.springframework.social.twitter.api.FriendOperations;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.ArrayUtils;
import org.springframework.social.twitter.api.impl.CursorUtils;
import org.springframework.social.twitter.api.impl.CursoredLongList;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendTemplate
extends AbstractTwitterOperations
implements FriendOperations {
    private final RestTemplate restTemplate;
    private static final MultiValueMap<String, Object> EMPTY_DATA = new LinkedMultiValueMap();

    public FriendTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public CursoredList<TwitterProfile> getFriends() {
        return this.getFriendsInCursor(-1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFriendsInCursor(long cursor) {
        CursoredList<Long> friendIds = this.getFriendIdsInCursor(cursor);
        return this.getCursoredProfileList(friendIds, friendIds.getPreviousCursor(), friendIds.getNextCursor());
    }

    @Override
    public CursoredList<TwitterProfile> getFriends(long userId) {
        return this.getFriendsInCursor(userId, -1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFriendsInCursor(long userId, long cursor) {
        CursoredList<Long> friendIds = this.getFriendIdsInCursor(userId, cursor);
        return this.getCursoredProfileList(friendIds, friendIds.getPreviousCursor(), friendIds.getNextCursor());
    }

    @Override
    public CursoredList<TwitterProfile> getFriends(String screenName) {
        return this.getFriendsInCursor(screenName, -1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFriendsInCursor(String screenName, long cursor) {
        CursoredList<Long> friendIds = this.getFriendIdsInCursor(screenName, cursor);
        return this.getCursoredProfileList(friendIds, friendIds.getPreviousCursor(), friendIds.getNextCursor());
    }

    @Override
    public CursoredList<Long> getFriendIds() {
        return this.getFriendIdsInCursor(-1L);
    }

    @Override
    public CursoredList<Long> getFriendIdsInCursor(long cursor) {
        this.requireAuthorization();
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", "cursor", String.valueOf(cursor)), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<Long> getFriendIds(long userId) {
        return this.getFriendIdsInCursor(userId, -1L);
    }

    @Override
    public CursoredList<Long> getFriendIdsInCursor(long userId, long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<Long> getFriendIds(String screenName) {
        return this.getFriendIdsInCursor(screenName, -1L);
    }

    @Override
    public CursoredList<Long> getFriendIdsInCursor(String screenName, long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("friends/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<TwitterProfile> getFollowers() {
        return this.getFollowersInCursor(-1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFollowersInCursor(long cursor) {
        CursoredList<Long> followerIds = this.getFollowerIdsInCursor(cursor);
        return this.getCursoredProfileList(followerIds, followerIds.getPreviousCursor(), followerIds.getNextCursor());
    }

    @Override
    public CursoredList<TwitterProfile> getFollowers(long userId) {
        return this.getFollowersInCursor(userId, -1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFollowersInCursor(long userId, long cursor) {
        CursoredList<Long> followerIds = this.getFollowerIdsInCursor(userId, cursor);
        return this.getCursoredProfileList(followerIds, followerIds.getPreviousCursor(), followerIds.getNextCursor());
    }

    @Override
    public CursoredList<TwitterProfile> getFollowers(String screenName) {
        return this.getFollowersInCursor(screenName, -1L);
    }

    @Override
    public CursoredList<TwitterProfile> getFollowersInCursor(String screenName, long cursor) {
        CursoredList<Long> followerIds = this.getFollowerIdsInCursor(screenName, cursor);
        return this.getCursoredProfileList(followerIds, followerIds.getPreviousCursor(), followerIds.getNextCursor());
    }

    @Override
    public CursoredList<Long> getFollowerIds() {
        return this.getFollowerIdsInCursor(-1L);
    }

    @Override
    public CursoredList<Long> getFollowerIdsInCursor(long cursor) {
        this.requireAuthorization();
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", "cursor", String.valueOf(cursor)), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<Long> getFollowerIds(long userId) {
        return this.getFollowerIdsInCursor(userId, -1L);
    }

    @Override
    public CursoredList<Long> getFollowerIdsInCursor(long userId, long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<Long> getFollowerIds(String screenName) {
        return this.getFollowerIdsInCursor(screenName, -1L);
    }

    @Override
    public CursoredList<Long> getFollowerIdsInCursor(String screenName, long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        parameters.set((Object)"screen_name", (Object)screenName);
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("followers/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }

    @Override
    public String follow(long userId) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/create.json", "user_id", String.valueOf(userId)), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String follow(String screenName) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/create.json", "screen_name", screenName), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String unfollow(long userId) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/destroy.json", "user_id", String.valueOf(userId)), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public String unfollow(String screenName) {
        this.requireAuthorization();
        return (String)((Map)this.restTemplate.postForObject(this.buildUri("friendships/destroy.json", "screen_name", screenName), EMPTY_DATA, Map.class)).get("screen_name");
    }

    @Override
    public TwitterProfile enableNotifications(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"user_id", (Object)String.valueOf(userId));
        params.set((Object)"device", (Object)"true");
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("friendships/update.json", (MultiValueMap<String, String>)params), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile enableNotifications(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"screen_name", (Object)screenName);
        params.set((Object)"device", (Object)"true");
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("friendships/update.json", (MultiValueMap<String, String>)params), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile disableNotifications(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"user_id", (Object)String.valueOf(userId));
        params.set((Object)"device", (Object)"false");
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("friendships/update.json", (MultiValueMap<String, String>)params), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public TwitterProfile disableNotifications(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"screen_name", (Object)screenName);
        params.set((Object)"device", (Object)"false");
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("friendships/update.json", (MultiValueMap<String, String>)params), EMPTY_DATA, TwitterProfile.class);
    }

    @Override
    public CursoredList<Long> getIncomingFriendships() {
        return this.getIncomingFriendships(-1L);
    }

    @Override
    public CursoredList<Long> getIncomingFriendships(long cursor) {
        this.requireAuthorization();
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("friendships/incoming.json", "cursor", String.valueOf(cursor)), CursoredLongList.class)).getList();
    }

    @Override
    public CursoredList<Long> getOutgoingFriendships() {
        return this.getOutgoingFriendships(-1L);
    }

    @Override
    public CursoredList<Long> getOutgoingFriendships(long cursor) {
        this.requireAuthorization();
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("friendships/outgoing.json", "cursor", String.valueOf(cursor)), CursoredLongList.class)).getList();
    }

    private CursoredList<TwitterProfile> getCursoredProfileList(List<Long> userIds, long previousCursor, long nextCursor) {
        List<List<Long>> chunks = CursorUtils.chunkList(userIds, 100);
        CursoredList<TwitterProfile> users = new CursoredList<TwitterProfile>(userIds.size(), previousCursor, nextCursor);
        for (List<Long> userIdChunk : chunks) {
            String joinedIds = ArrayUtils.join(userIdChunk.toArray());
            users.addAll((Collection)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "user_id", joinedIds), TwitterProfileList.class));
        }
        return users;
    }
}

