/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class OAuth2AuthorizationCodeGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final OAuth2AuthorizationExchange authorizationExchange;

    public OAuth2AuthorizationCodeGrantRequest(ClientRegistration clientRegistration, OAuth2AuthorizationExchange authorizationExchange) {
        super(AuthorizationGrantType.AUTHORIZATION_CODE, clientRegistration);
        Assert.notNull((Object)authorizationExchange, (String)"authorizationExchange cannot be null");
        this.authorizationExchange = authorizationExchange;
    }

    public OAuth2AuthorizationExchange getAuthorizationExchange() {
        return this.authorizationExchange;
    }

    static MultiValueMap<String, String> defaultParameters(OAuth2AuthorizationCodeGrantRequest grantRequest) {
        String codeVerifier;
        OAuth2AuthorizationExchange authorizationExchange = grantRequest.getAuthorizationExchange();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"code", (Object)authorizationExchange.getAuthorizationResponse().getCode());
        String redirectUri = authorizationExchange.getAuthorizationRequest().getRedirectUri();
        if (redirectUri != null) {
            parameters.set((Object)"redirect_uri", (Object)redirectUri);
        }
        if ((codeVerifier = (String)authorizationExchange.getAuthorizationRequest().getAttribute("code_verifier")) != null) {
            parameters.set((Object)"code_verifier", (Object)codeVerifier);
        }
        return parameters;
    }
}

