/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka;

import org.springframework.core.NestedRuntimeException;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class KafkaException
extends NestedRuntimeException {
    private final Level logLevel;

    public KafkaException(String message) {
        this(message, Level.ERROR, null);
    }

    public KafkaException(String message, @Nullable Throwable cause) {
        this(message, Level.ERROR, cause);
    }

    public KafkaException(String message, Level level, @Nullable Throwable cause) {
        super(message, cause);
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.logLevel = level;
    }

    public void selfLog(String message, LogAccessor logger) {
        switch (this.logLevel) {
            case FATAL: {
                logger.fatal((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case ERROR: {
                logger.error((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case WARN: {
                logger.warn((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case INFO: {
                logger.info((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case DEBUG: {
                logger.debug((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case TRACE: {
                logger.trace((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            default: {
                logger.error((Throwable)((Object)this), (CharSequence)message);
            }
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

