/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.kafka.core.KafkaStreamsCustomizer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StreamsBuilderFactoryBean
extends AbstractFactoryBean<StreamsBuilder>
implements SmartLifecycle {
    private static final int DEFAULT_CLOSE_TIMEOUT = 10;
    private KafkaClientSupplier clientSupplier = new DefaultKafkaClientSupplier();
    private StreamsConfig streamsConfig;
    private final CleanupConfig cleanupConfig;
    private KafkaStreamsCustomizer kafkaStreamsCustomizer;
    private KafkaStreams.StateListener stateListener;
    private StateRestoreListener stateRestoreListener;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private int closeTimeout = 10;
    private KafkaStreams kafkaStreams;
    private volatile boolean running;

    public StreamsBuilderFactoryBean() {
        this.cleanupConfig = new CleanupConfig();
    }

    public StreamsBuilderFactoryBean(StreamsConfig streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    public StreamsBuilderFactoryBean(StreamsConfig streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull((Object)streamsConfig, (String)"'streamsConfig' must not be null");
        Assert.notNull((Object)cleanupConfig, (String)"'cleanupConfig' must not be null");
        this.streamsConfig = streamsConfig;
        this.cleanupConfig = cleanupConfig;
    }

    public StreamsBuilderFactoryBean(Map<String, Object> streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    public StreamsBuilderFactoryBean(Map<String, Object> streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull(streamsConfig, (String)"'streamsConfig' must not be null");
        Assert.notNull((Object)cleanupConfig, (String)"'cleanupConfig' must not be null");
        this.streamsConfig = new StreamsConfig(streamsConfig);
        this.cleanupConfig = cleanupConfig;
    }

    public void setStreamsConfig(StreamsConfig streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)"'streamsConfig' must not be null");
        this.streamsConfig = streamsConfig;
    }

    @Nullable
    public StreamsConfig getStreamsConfig() {
        return this.streamsConfig;
    }

    public void setClientSupplier(KafkaClientSupplier clientSupplier) {
        Assert.notNull((Object)clientSupplier, (String)"'clientSupplier' must not be null");
        this.clientSupplier = clientSupplier;
    }

    public void setKafkaStreamsCustomizer(KafkaStreamsCustomizer kafkaStreamsCustomizer) {
        Assert.notNull((Object)kafkaStreamsCustomizer, (String)"'kafkaStreamsCustomizer' must not be null");
        this.kafkaStreamsCustomizer = kafkaStreamsCustomizer;
    }

    public void setStateListener(KafkaStreams.StateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    public void setStateRestoreListener(StateRestoreListener stateRestoreListener) {
        this.stateRestoreListener = stateRestoreListener;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public Class<?> getObjectType() {
        return StreamsBuilder.class;
    }

    protected StreamsBuilder createInstance() throws Exception {
        if (this.autoStartup) {
            Assert.notNull((Object)this.streamsConfig, (String)"'streamsConfig' must not be null");
        }
        return new StreamsBuilder();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Assert.notNull((Object)this.streamsConfig, (String)"'streamsConfig' must not be null");
                Topology topology = ((StreamsBuilder)this.getObject()).build();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)topology.describe());
                }
                this.kafkaStreams = new KafkaStreams(topology, this.streamsConfig, this.clientSupplier);
                this.kafkaStreams.setStateListener(this.stateListener);
                this.kafkaStreams.setGlobalStateRestoreListener(this.stateRestoreListener);
                this.kafkaStreams.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                if (this.kafkaStreamsCustomizer != null) {
                    this.kafkaStreamsCustomizer.customize(this.kafkaStreams);
                }
                if (this.cleanupConfig.cleanupOnStart()) {
                    this.kafkaStreams.cleanUp();
                }
                this.kafkaStreams.start();
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                if (this.kafkaStreams != null) {
                    this.kafkaStreams.close((long)this.closeTimeout, TimeUnit.SECONDS);
                    if (this.cleanupConfig.cleanupOnStop()) {
                        this.kafkaStreams.cleanUp();
                    }
                    this.kafkaStreams = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }
}

