/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Closeable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public interface RedisOperations<K, V> {
    @Nullable
    public <T> T execute(RedisCallback<T> var1);

    @Nullable
    public <T> T execute(SessionCallback<T> var1);

    public List<Object> executePipelined(RedisCallback<?> var1);

    public List<Object> executePipelined(RedisCallback<?> var1, RedisSerializer<?> var2);

    public List<Object> executePipelined(SessionCallback<?> var1);

    public List<Object> executePipelined(SessionCallback<?> var1, RedisSerializer<?> var2);

    @Nullable
    public <T> T execute(RedisScript<T> var1, List<K> var2, Object ... var3);

    @Nullable
    public <T> T execute(RedisScript<T> var1, RedisSerializer<?> var2, RedisSerializer<T> var3, List<K> var4, Object ... var5);

    @Nullable
    public <T extends Closeable> T executeWithStickyConnection(RedisCallback<T> var1);

    @Nullable
    public Boolean hasKey(K var1);

    @Nullable
    public Long countExistingKeys(Collection<K> var1);

    @Nullable
    public Boolean delete(K var1);

    @Nullable
    public Long delete(Collection<K> var1);

    @Nullable
    public Boolean unlink(K var1);

    @Nullable
    public Long unlink(Collection<K> var1);

    @Nullable
    public DataType type(K var1);

    @Nullable
    public Set<K> keys(K var1);

    @Nullable
    public K randomKey();

    public void rename(K var1, K var2);

    @Nullable
    public Boolean renameIfAbsent(K var1, K var2);

    @Nullable
    public Boolean expire(K var1, long var2, TimeUnit var4);

    @Nullable
    public Boolean expireAt(K var1, Date var2);

    @Nullable
    public Boolean persist(K var1);

    @Nullable
    public Boolean move(K var1, int var2);

    @Nullable
    public byte[] dump(K var1);

    default public void restore(K key, byte[] value, long timeToLive, TimeUnit unit) {
        this.restore(key, value, timeToLive, unit, false);
    }

    public void restore(K var1, byte[] var2, long var3, TimeUnit var5, boolean var6);

    @Nullable
    public Long getExpire(K var1);

    @Nullable
    public Long getExpire(K var1, TimeUnit var2);

    @Nullable
    public List<V> sort(SortQuery<K> var1);

    @Nullable
    public <T> List<T> sort(SortQuery<K> var1, RedisSerializer<T> var2);

    @Nullable
    public <T> List<T> sort(SortQuery<K> var1, BulkMapper<T, V> var2);

    @Nullable
    public <T, S> List<T> sort(SortQuery<K> var1, BulkMapper<T, S> var2, RedisSerializer<S> var3);

    @Nullable
    public Long sort(SortQuery<K> var1, K var2);

    public void watch(K var1);

    public void watch(Collection<K> var1);

    public void unwatch();

    public void multi();

    public void discard();

    public List<Object> exec();

    public List<Object> exec(RedisSerializer<?> var1);

    @Nullable
    public List<RedisClientInfo> getClientList();

    public void killClient(String var1, int var2);

    public void slaveOf(String var1, int var2);

    public void slaveOfNoOne();

    public void convertAndSend(String var1, Object var2);

    public ClusterOperations<K, V> opsForCluster();

    public GeoOperations<K, V> opsForGeo();

    public BoundGeoOperations<K, V> boundGeoOps(K var1);

    public <HK, HV> HashOperations<K, HK, HV> opsForHash();

    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K var1);

    public HyperLogLogOperations<K, V> opsForHyperLogLog();

    public ListOperations<K, V> opsForList();

    public BoundListOperations<K, V> boundListOps(K var1);

    public SetOperations<K, V> opsForSet();

    public BoundSetOperations<K, V> boundSetOps(K var1);

    public <HK, HV> StreamOperations<K, HK, HV> opsForStream();

    public <HK, HV> StreamOperations<K, HK, HV> opsForStream(HashMapper<? super K, ? super HK, ? super HV> var1);

    public <HK, HV> BoundStreamOperations<K, HK, HV> boundStreamOps(K var1);

    public ValueOperations<K, V> opsForValue();

    public BoundValueOperations<K, V> boundValueOps(K var1);

    public ZSetOperations<K, V> opsForZSet();

    public BoundZSetOperations<K, V> boundZSetOps(K var1);

    public RedisSerializer<?> getKeySerializer();

    public RedisSerializer<?> getValueSerializer();

    public RedisSerializer<?> getHashKeySerializer();

    public RedisSerializer<?> getHashValueSerializer();
}

