/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.NamedNode;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisNode
implements NamedNode {
    private String name;
    private String host;
    private int port;

    public RedisNode(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null!");
        this.host = host;
        this.port = port;
    }

    protected RedisNode() {
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String asString() {
        return this.host + ":" + this.port;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.host);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.port);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RedisNode)) {
            return false;
        }
        RedisNode other = (RedisNode)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.host, (Object)other.host)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.port, (Object)other.port)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
    }

    public static class RedisNodeBuilder {
        private RedisNode node = new RedisNode();

        public RedisNodeBuilder withName(String name) {
            this.node.name = name;
            return this;
        }

        public RedisNodeBuilder listeningAt(String host, int port) {
            Assert.hasText((String)host, (String)"Hostname must not be empty or null.");
            this.node.host = host;
            this.node.port = port;
            return this;
        }

        public RedisNode build() {
            return this.node;
        }
    }
}

