/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Meta {
    private final Map<String, Object> values = new LinkedHashMap<String, Object>(2);
    private final Set<CursorOption> flags = new LinkedHashSet<CursorOption>();

    public Long getMaxTimeMsec() {
        return (Long)this.getValue(MetaKey.MAX_TIME_MS.key);
    }

    public void setMaxTimeMsec(long maxTimeMsec) {
        this.setMaxTime(maxTimeMsec, TimeUnit.MILLISECONDS);
    }

    public void setMaxTime(long timeout, TimeUnit timeUnit) {
        this.setValue(MetaKey.MAX_TIME_MS.key, (timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS).toMillis(timeout));
    }

    public Long getMaxScan() {
        return (Long)this.getValue(MetaKey.MAX_SCAN.key);
    }

    public void setMaxScan(long maxScan) {
        this.setValue(MetaKey.MAX_SCAN.key, maxScan);
    }

    public void setComment(String comment) {
        this.setValue(MetaKey.COMMENT.key, comment);
    }

    public String getComment() {
        return (String)this.getValue(MetaKey.COMMENT.key);
    }

    public void setSnapshot(boolean useSnapshot) {
        this.setValue(MetaKey.SNAPSHOT.key, useSnapshot);
    }

    public boolean getSnapshot() {
        return this.getValue(MetaKey.SNAPSHOT.key, false);
    }

    public boolean addFlag(CursorOption option) {
        Assert.notNull((Object)((Object)option), (String)"CursorOption must not be null!");
        return this.flags.add(option);
    }

    public Set<CursorOption> getFlags() {
        return this.flags;
    }

    public boolean hasValues() {
        return !this.values.isEmpty() || !this.flags.isEmpty();
    }

    public Iterable<Map.Entry<String, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    private void setValue(String key, Object value) {
        Assert.hasText((String)key, (String)"Meta key must not be 'null' or blank.");
        if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.values.remove(key);
        }
        this.values.put(key, value);
    }

    private <T> T getValue(String key) {
        return (T)this.values.get(key);
    }

    private <T> T getValue(String key, T defaultValue) {
        T value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public int hashCode() {
        int hash = ObjectUtils.nullSafeHashCode(this.values);
        return hash += ObjectUtils.nullSafeHashCode(this.flags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)obj;
        if (!ObjectUtils.nullSafeEquals(this.values, other.values)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.flags, other.flags);
    }

    public static enum CursorOption {
        NO_TIMEOUT,
        EXHAUST,
        SLAVE_OK,
        PARTIAL;

    }

    private static enum MetaKey {
        MAX_TIME_MS("$maxTimeMS"),
        MAX_SCAN("$maxScan"),
        COMMENT("$comment"),
        SNAPSHOT("$snapshot");

        private String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }
}

