/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsImpl;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SearchHitMapping<T> {
    private final Class<T> type;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    private SearchHitMapping(Class<T> type, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
        Assert.notNull(type, (String)"type is null");
        Assert.notNull(context, (String)"context is null");
        this.type = type;
        this.mappingContext = context;
    }

    static <T> SearchHitMapping<T> mappingFor(Class<T> entityClass, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
        return new SearchHitMapping<T>(entityClass, context);
    }

    SearchHit<T> mapHit(SearchDocument searchDocument, T content) {
        Assert.notNull((Object)searchDocument, (String)"searchDocument is null");
        Assert.notNull(content, (String)"content is null");
        String id = searchDocument.hasId() ? searchDocument.getId() : null;
        float score = searchDocument.getScore();
        Object[] sortValues = searchDocument.getSortValues();
        Map<String, List<String>> highlightFields = this.getHighlightsAndRemapFieldNames(searchDocument);
        return new SearchHit<T>(id, score, sortValues, highlightFields, content);
    }

    SearchHits<T> mapHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    SearchScrollHits<T> mapScrollHits(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        return this.mapHitsFromResponse(searchDocumentResponse, contents);
    }

    private SearchHitsImpl<T> mapHitsFromResponse(SearchDocumentResponse searchDocumentResponse, List<T> contents) {
        Assert.notNull((Object)searchDocumentResponse, (String)"searchDocumentResponse is null");
        Assert.notNull(contents, (String)"contents is null");
        Assert.isTrue((searchDocumentResponse.getSearchDocuments().size() == contents.size() ? 1 : 0) != 0, (String)"Count of documents must match the count of entities");
        long totalHits = searchDocumentResponse.getTotalHits();
        float maxScore = searchDocumentResponse.getMaxScore();
        String scrollId = searchDocumentResponse.getScrollId();
        ArrayList<SearchHit<T>> searchHits = new ArrayList<SearchHit<T>>();
        List<SearchDocument> searchDocuments = searchDocumentResponse.getSearchDocuments();
        for (int i = 0; i < searchDocuments.size(); ++i) {
            SearchDocument document = searchDocuments.get(i);
            T content = contents.get(i);
            SearchHit<T> hit = this.mapHit(document, content);
            searchHits.add(hit);
        }
        Aggregations aggregations = searchDocumentResponse.getAggregations();
        TotalHitsRelation totalHitsRelation = TotalHitsRelation.valueOf(searchDocumentResponse.getTotalHitsRelation());
        return new SearchHitsImpl(totalHits, totalHitsRelation, maxScore, scrollId, searchHits, aggregations);
    }

    @Nullable
    private Map<String, List<String>> getHighlightsAndRemapFieldNames(SearchDocument searchDocument) {
        Map<String, List<String>> highlightFields = searchDocument.getHighlightFields();
        if (highlightFields == null) {
            return null;
        }
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(this.type);
        if (persistentEntity == null) {
            return highlightFields;
        }
        return highlightFields.entrySet().stream().collect(Collectors.toMap(entry -> {
            ElasticsearchPersistentProperty property = persistentEntity.getPersistentPropertyWithFieldName((String)entry.getKey());
            return property != null ? property.getName() : (String)entry.getKey();
        }, Map.Entry::getValue));
    }
}

