/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

abstract class AbstractDefaultIndexOperations
implements IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDefaultIndexOperations.class);
    protected final ElasticsearchConverter elasticsearchConverter;
    protected final RequestFactory requestFactory;
    @Nullable
    protected final Class<?> boundClass;
    private final IndexCoordinates boundIndex;

    public AbstractDefaultIndexOperations(ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = boundClass;
        this.boundIndex = this.getIndexCoordinatesFor(boundClass);
    }

    public AbstractDefaultIndexOperations(ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        this.elasticsearchConverter = elasticsearchConverter;
        this.requestFactory = new RequestFactory(elasticsearchConverter);
        this.boundClass = null;
        this.boundIndex = boundIndex;
    }

    protected Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }

    @Override
    public boolean create() {
        if (this.boundClass != null) {
            Class<?> clazz = this.boundClass;
            String indexName = this.getIndexCoordinates().getIndexName();
            if (clazz.isAnnotationPresent(Setting.class)) {
                String settingPath = clazz.getAnnotation(Setting.class).settingPath();
                if (StringUtils.hasText((String)settingPath)) {
                    String settings = ResourceUtil.readFileFromClasspath(settingPath);
                    if (StringUtils.hasText((String)settings)) {
                        return this.doCreate(indexName, Document.parse(settings));
                    }
                } else {
                    LOGGER.info("settingPath in @Setting has to be defined. Using default instead.");
                }
            }
            return this.doCreate(indexName, this.getDefaultSettings(this.getRequiredPersistentEntity(clazz)));
        }
        return this.doCreate(this.getIndexCoordinates().getIndexName(), null);
    }

    @Override
    public boolean create(Document settings) {
        return this.doCreate(this.getIndexCoordinates().getIndexName(), settings);
    }

    protected abstract boolean doCreate(String var1, @Nullable Document var2);

    @Override
    public boolean delete() {
        return this.doDelete(this.getIndexCoordinates().getIndexName());
    }

    protected abstract boolean doDelete(String var1);

    @Override
    public boolean exists() {
        return this.doExists(this.getIndexCoordinates().getIndexName());
    }

    protected abstract boolean doExists(String var1);

    @Override
    public boolean putMapping(Document mapping) {
        return this.doPutMapping(this.getIndexCoordinates(), mapping);
    }

    protected abstract boolean doPutMapping(IndexCoordinates var1, Document var2);

    @Override
    public Map<String, Object> getMapping() {
        return this.doGetMapping(this.getIndexCoordinates());
    }

    protected abstract Map<String, Object> doGetMapping(IndexCoordinates var1);

    @Override
    public Map<String, Object> getSettings() {
        return this.getSettings(false);
    }

    @Override
    public Map<String, Object> getSettings(boolean includeDefaults) {
        return this.doGetSettings(this.getIndexCoordinates().getIndexName(), includeDefaults);
    }

    protected abstract Map<String, Object> doGetSettings(String var1, boolean var2);

    @Override
    public void refresh() {
        this.doRefresh(this.getIndexCoordinates());
    }

    protected abstract void doRefresh(IndexCoordinates var1);

    @Override
    public boolean addAlias(AliasQuery query) {
        return this.doAddAlias(query, this.getIndexCoordinates());
    }

    protected abstract boolean doAddAlias(AliasQuery var1, IndexCoordinates var2);

    @Override
    public List<AliasMetaData> queryForAlias() {
        return this.doQueryForAlias(this.getIndexCoordinates().getIndexName());
    }

    protected abstract List<AliasMetaData> doQueryForAlias(String var1);

    @Override
    public boolean removeAlias(AliasQuery query) {
        return this.doRemoveAlias(query, this.getIndexCoordinates());
    }

    protected abstract boolean doRemoveAlias(AliasQuery var1, IndexCoordinates var2);

    @Override
    public Document createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Document createMapping(Class<?> clazz) {
        return this.buildMapping(clazz);
    }

    protected Document buildMapping(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Mapping.class)) {
            String mappingPath = clazz.getAnnotation(Mapping.class).mappingPath();
            if (!StringUtils.isEmpty((Object)mappingPath)) {
                String mappings = ResourceUtil.readFileFromClasspath(mappingPath);
                if (!StringUtils.isEmpty((Object)mappings)) {
                    return Document.parse(mappings);
                }
            } else {
                LOGGER.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        try {
            String mapping = new MappingBuilder(this.elasticsearchConverter).buildPropertyMapping(clazz);
            return Document.parse(mapping);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    private <T> Document getDefaultSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        if (persistentEntity.isUseServerConfiguration()) {
            return Document.create();
        }
        Map map = new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
        return Document.from(map);
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    protected IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : this.boundIndex;
    }

    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }

    protected Map<String, Object> convertSettingsResponseToMap(GetSettingsResponse response, String indexName) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (!response.getIndexToDefaultSettings().isEmpty()) {
            Settings defaultSettings = (Settings)response.getIndexToDefaultSettings().get((Object)indexName);
            for (String key : defaultSettings.keySet()) {
                settings.put(key, defaultSettings.get(key));
            }
        }
        if (!response.getIndexToSettings().isEmpty()) {
            Settings customSettings = (Settings)response.getIndexToSettings().get((Object)indexName);
            for (String key : customSettings.keySet()) {
                settings.put(key, customSettings.get(key));
            }
        }
        return settings;
    }
}

