/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerEagerLoadProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerBeanPostProcessorAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.aot.LoadBalancerChildContextInitializer;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.loadbalancer.support.LoadBalancerEagerContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@LoadBalancerClients
@EnableConfigurationProperties(value={LoadBalancerClientsProperties.class, LoadBalancerEagerLoadProperties.class})
@AutoConfigureBefore(value={ReactorLoadBalancerClientAutoConfiguration.class, LoadBalancerBeanPostProcessorAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
public class LoadBalancerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LoadBalancerZoneConfig zoneConfig(Environment environment) {
        return new LoadBalancerZoneConfig(environment.getProperty("spring.cloud.loadbalancer.zone"));
    }

    @ConditionalOnMissingBean
    @Bean
    public LoadBalancerClientFactory loadBalancerClientFactory(LoadBalancerClientsProperties properties, ObjectProvider<List<LoadBalancerClientSpecification>> configurations) {
        LoadBalancerClientFactory clientFactory = new LoadBalancerClientFactory(properties);
        clientFactory.setConfigurations((List)configurations.getIfAvailable(Collections::emptyList));
        return clientFactory;
    }

    @Bean
    public LoadBalancerEagerContextInitializer loadBalancerEagerContextInitializer(LoadBalancerClientFactory clientFactory, LoadBalancerEagerLoadProperties properties) {
        return new LoadBalancerEagerContextInitializer(clientFactory, properties.getClients());
    }

    @Bean
    static LoadBalancerChildContextInitializer loadBalancerChildContextInitializer(LoadBalancerClientFactory loadBalancerClientFactory, ApplicationContext parentContext) {
        return new LoadBalancerChildContextInitializer(loadBalancerClientFactory, parentContext);
    }
}

