/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive.server;

import java.util.List;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.reactive.server.WebTestClientContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class WebTestClientContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final boolean reactorClientPresent;
    private static final boolean jettyClientPresent;
    private static final boolean httpComponentsClientPresent;
    private static final boolean webClientPresent;

    WebTestClientContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        SpringBootTest springBootTest = (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
        return springBootTest != null && webClientPresent && (reactorClientPresent || jettyClientPresent || httpComponentsClientPresent) ? new WebTestClientContextCustomizer() : null;
    }

    static {
        ClassLoader loader = WebTestClientContextCustomizerFactory.class.getClassLoader();
        reactorClientPresent = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)loader);
        jettyClientPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.client.HttpClient", (ClassLoader)loader);
        httpComponentsClientPresent = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient", (ClassLoader)loader) && ClassUtils.isPresent((String)"org.apache.hc.core5.reactive.ReactiveDataConsumer", (ClassLoader)loader);
        webClientPresent = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", (ClassLoader)loader);
    }
}

