/*
 *
 *  *
 *  *  *
 *  *  *  *
 *  *  *  *  *
 *  *  *  *  *  * Copyright 2019-2024 the original author or authors.
 *  *  *  *  *  *
 *  *  *  *  *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  *  *  *  *  * you may not use this file except in compliance with the License.
 *  *  *  *  *  * You may obtain a copy of the License at
 *  *  *  *  *  *
 *  *  *  *  *  *      https://www.apache.org/licenses/LICENSE-2.0
 *  *  *  *  *  *
 *  *  *  *  *  * Unless required by applicable law or agreed to in writing, software
 *  *  *  *  *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  *  *  *  *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *  *  *  *  * See the License for the specific language governing permissions and
 *  *  *  *  *  * limitations under the License.
 *  *  *  *  *
 *  *  *  *
 *  *  *
 *  *
 *  
 */

package org.springdoc.core.fn;

import java.util.function.Consumer;

import org.springdoc.core.fn.builders.operation.Builder;

/**
 * The type Abstract springdoc route builder.
 *
 * @author bnasslahsen
 */
public abstract class AbstractSpringdocRouteBuilder {

	/**
	 * Gets operation builder.
	 *
	 * @param operationsConsumer the operations consumer
	 * @return the operation builder
	 */
	protected Builder getOperationBuilder(Consumer<Builder> operationsConsumer) {
		Builder builder = Builder.operationBuilder();
		operationsConsumer.accept(builder);
		return builder;
	}

}
