/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Splitter;

@Immutable
public class Version
implements Comparable<Version> {
    private static final String QUALIFIER_SEPARATOR = "-";
    private static final char SEQUENCE_SEPARATOR = '.';
    private static final Splitter SEQUENCE_SPLITTER = Splitter.on('.');
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    private Version(int major, int minor, int patch, String qualifier) {
        Objects.requireNonNull(qualifier, "Version qualifier must not be null");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public static Version parse(String text) {
        String s = StringUtils.trimToEmpty(text);
        String qualifier = StringUtils.substringAfter(s, QUALIFIER_SEPARATOR);
        if (!qualifier.isEmpty()) {
            s = StringUtils.substringBefore(s, QUALIFIER_SEPARATOR);
        }
        List<String> split = SEQUENCE_SPLITTER.splitToList(s);
        int major = 0;
        int minor = 0;
        int patch = 0;
        int size = split.size();
        if (size > 0) {
            major = Version.parseSequence(split.get(0));
            if (size > 1) {
                minor = Version.parseSequence(split.get(1));
                if (size > 2) {
                    patch = Version.parseSequence(split.get(2));
                    if (size > 3) {
                        throw new IllegalArgumentException("Only 3 sequences are accepted");
                    }
                }
            }
        }
        return new Version(major, minor, patch, qualifier);
    }

    public static Version create(int major, int minor) {
        return new Version(major, minor, 0, "");
    }

    public static Version create(int major, int minor, int patch) {
        return new Version(major, minor, patch, "");
    }

    public static Version create(int major, int minor, int patch, String qualifier) {
        return new Version(major, minor, patch, qualifier);
    }

    private static int parseSequence(String sequence) {
        if (sequence.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(sequence);
    }

    public boolean isGreaterThanOrEqual(Version than) {
        return this.compareTo(than) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.major - other.major;
        if (c == 0 && (c = this.minor - other.minor) == 0) {
            c = this.patch - other.patch;
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor);
        if (this.patch > 0) {
            sb.append('.').append(this.patch);
        }
        if (!this.qualifier.isEmpty()) {
            sb.append(QUALIFIER_SEPARATOR).append(this.qualifier);
        }
        return sb.toString();
    }
}

