/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.HashCodeBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringStyle;
import org.sonar.api.internal.google.common.base.Joiner;
import org.sonar.api.internal.google.common.collect.ImmutableSet;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Cardinality;

public class Rule {
    public static final String STATUS_BETA = "BETA";
    public static final String STATUS_DEPRECATED = "DEPRECATED";
    public static final String STATUS_READY = "READY";
    public static final String STATUS_REMOVED = "REMOVED";
    private static final Set<String> STATUS_LIST = ImmutableSet.of("READY", "BETA", "DEPRECATED", "REMOVED");
    private Integer id;
    public static final RulePriority DEFAULT_PRIORITY = RulePriority.MAJOR;
    private String name;
    private String key;
    private String configKey;
    private RulePriority priority = DEFAULT_PRIORITY;
    private String description;
    private String pluginName;
    private boolean isTemplate = false;
    private String status = "READY";
    private String language;
    private Rule template = null;
    private List<RuleParam> params = new ArrayList<RuleParam>();
    private Date createdAt;
    private Date updatedAt;
    private String tags;
    private String systemTags;

    @Deprecated
    public Rule() {
    }

    @Deprecated
    public Rule(String pluginName, String key) {
        this.pluginName = pluginName;
        this.key = key;
        this.configKey = key;
    }

    public Integer getId() {
        return this.id;
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Rule setName(String name) {
        this.name = Rule.removeNewLineCharacters(name);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Rule setKey(String key) {
        this.key = key;
        return this;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public Rule setConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Rule setDescription(String description) {
        this.description = StringUtils.strip(description);
        return this;
    }

    public Boolean isEnabled() {
        return !STATUS_REMOVED.equals(this.status);
    }

    public List<RuleParam> getParams() {
        return this.params;
    }

    public RuleParam getParam(String key) {
        for (RuleParam param : this.params) {
            if (!StringUtils.equals(key, param.getKey())) continue;
            return param;
        }
        return null;
    }

    public Rule setParams(List<RuleParam> params) {
        this.params.clear();
        for (RuleParam param : params) {
            param.setRule(this);
            this.params.add(param);
        }
        return this;
    }

    public RuleParam createParameter() {
        RuleParam parameter = new RuleParam().setRule(this);
        this.params.add(parameter);
        return parameter;
    }

    public RuleParam createParameter(String key) {
        RuleParam parameter = new RuleParam().setKey(key).setRule(this);
        this.params.add(parameter);
        return parameter;
    }

    public RulePriority getSeverity() {
        return this.priority;
    }

    public Rule setSeverity(RulePriority severity) {
        this.priority = severity == null ? DEFAULT_PRIORITY : severity;
        return this;
    }

    public String getRepositoryKey() {
        return this.pluginName;
    }

    public Rule setRepositoryKey(String s) {
        this.pluginName = s;
        return this;
    }

    public Rule setUniqueKey(String repositoryKey, String key) {
        return this.setRepositoryKey(repositoryKey).setKey(key).setConfigKey(key);
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public Rule setIsTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
        return this;
    }

    @Deprecated
    public Cardinality getCardinality() {
        return this.isTemplate ? Cardinality.MULTIPLE : Cardinality.SINGLE;
    }

    @Deprecated
    public Rule setCardinality(Cardinality c) {
        this.isTemplate = Cardinality.MULTIPLE.equals((Object)c);
        return this;
    }

    @Deprecated
    public Rule getParent() {
        return this.template;
    }

    @Deprecated
    public Rule setParent(Rule parent) {
        this.template = parent;
        return this;
    }

    public Rule getTemplate() {
        return this.template;
    }

    public Rule setTemplate(Rule template) {
        this.template = template;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Rule setStatus(String status) {
        if (!STATUS_LIST.contains(status)) {
            throw new SonarException("The status of a rule can only contain : " + Joiner.on(", ").join(STATUS_LIST));
        }
        this.status = status;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Rule setCreatedAt(Date d) {
        this.createdAt = d;
        return this;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Rule setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Rule setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String[] getTags() {
        return this.tags == null ? new String[]{} : StringUtils.split(this.tags, ',');
    }

    public Rule setTags(String[] tags) {
        this.tags = tags == null ? null : StringUtils.join((Object[])tags, ',');
        return this;
    }

    public String[] getSystemTags() {
        return this.systemTags == null ? new String[]{} : StringUtils.split(this.systemTags, ',');
    }

    @CheckForNull
    @Deprecated
    public Integer getCharacteristicId() {
        return null;
    }

    @Deprecated
    public Rule setCharacteristicId(@Nullable Integer characteristicId) {
        return this;
    }

    @CheckForNull
    @Deprecated
    public Integer getDefaultCharacteristicId() {
        return null;
    }

    @Deprecated
    public Rule setDefaultCharacteristicId(@Nullable Integer defaultCharacteristicId) {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Rule other = (Rule)obj;
        return new EqualsBuilder().append(this.pluginName, other.getRepositoryKey()).append(this.key, other.getKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.pluginName).append(this.key).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("name", this.name).append("key", this.key).append("configKey", this.configKey).append("plugin", this.pluginName).append("severity", (Object)this.priority).append("isTemplate", this.isTemplate()).append("status", this.status).append("language", this.language).append("template", this.template).toString();
    }

    @CheckForNull
    private static String removeNewLineCharacters(@Nullable String text) {
        String removedCRLF = StringUtils.remove(text, "\n");
        removedCRLF = StringUtils.remove(removedCRLF, "\r");
        removedCRLF = StringUtils.remove(removedCRLF, "\n\r");
        removedCRLF = StringUtils.remove(removedCRLF, "\r\n");
        return removedCRLF;
    }

    public static Rule create() {
        return new Rule();
    }

    public static Rule create(String repositoryKey, String key, String name) {
        return new Rule().setUniqueKey(repositoryKey, key).setName(name);
    }

    public static Rule create(String repositoryKey, String key) {
        return new Rule().setUniqueKey(repositoryKey, key);
    }

    public RuleKey ruleKey() {
        return RuleKey.of(this.getRepositoryKey(), this.getKey());
    }

    @CheckForNull
    @Deprecated
    public String getDefaultCharacteristicKey() {
        return null;
    }

    @Deprecated
    public Rule setDefaultCharacteristicKey(@Nullable String defaultCharacteristicKey) {
        return this;
    }

    @CheckForNull
    @Deprecated
    public String getDefaultSubCharacteristicKey() {
        return null;
    }

    @Deprecated
    public Rule setDefaultSubCharacteristicKey(@Nullable String defaultSubCharacteristicKey) {
        return this;
    }

    @CheckForNull
    @Deprecated
    public String getCharacteristicKey() {
        return null;
    }

    @Deprecated
    public Rule setCharacteristicKey(@Nullable String characteristicKey) {
        return this;
    }

    @CheckForNull
    @Deprecated
    public String getSubCharacteristicKey() {
        return null;
    }

    @Deprecated
    public Rule setSubCharacteristicKey(@Nullable String subCharacteristicKey) {
        return this;
    }
}

