/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;

@Immutable
public class TestIssue
implements Issue {
    private String key;
    private String status;
    private String resolution;
    private String severity;
    private RuleKey ruleKey;
    private Duration effort;
    private RuleType type;

    private TestIssue(Builder builder) {
        this.key = builder.key;
        this.status = builder.status;
        this.resolution = builder.resolution;
        this.severity = builder.severity;
        this.ruleKey = builder.ruleKey;
        this.effort = builder.effort;
        this.type = builder.type;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    @CheckForNull
    public String resolution() {
        return this.resolution;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    @CheckForNull
    @Deprecated
    public Duration debt() {
        return this.effort();
    }

    @Override
    public Duration effort() {
        return this.effort;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public static class Builder {
        private String key;
        private String status;
        private String resolution;
        private String severity;
        private RuleKey ruleKey;
        private Duration effort;
        private RuleType type;

        public Builder setKey(String key) {
            this.key = Builder.validateKey(key);
            return this;
        }

        public Builder setResolution(@Nullable String resolution) {
            this.resolution = Builder.validateResolution(resolution);
            return this;
        }

        public Builder setSeverity(String severity) {
            this.severity = Builder.validateSeverity(severity);
            return this;
        }

        public Builder setStatus(String status) {
            this.status = Builder.validateStatus(status);
            return this;
        }

        public Builder setRuleKey(RuleKey ruleKey) {
            this.ruleKey = Builder.validateRuleKey(ruleKey);
            return this;
        }

        @Deprecated
        public Builder setDebt(@Nullable Duration debt) {
            return this.setEffort(debt);
        }

        public Builder setEffort(@Nullable Duration effort) {
            this.effort = effort;
            return this;
        }

        public Builder setType(RuleType type) {
            this.type = Builder.validateType(type);
            return this;
        }

        private static String validateKey(String key) {
            Preconditions.checkNotNull(key, "key cannot be null");
            return key;
        }

        private static RuleKey validateRuleKey(RuleKey ruleKey) {
            Preconditions.checkNotNull(ruleKey, "ruleKey cannot be null");
            return ruleKey;
        }

        private static String validateResolution(@Nullable String resolution) {
            Preconditions.checkArgument(resolution == null || org.sonar.api.issue.Issue.RESOLUTIONS.contains(resolution), String.format("resolution '%s' is invalid", resolution));
            return resolution;
        }

        private static String validateSeverity(String severity) {
            Preconditions.checkNotNull(severity, "severity cannot be null");
            Preconditions.checkArgument(Severity.ALL.contains(severity), String.format("severity '%s' is invalid", severity));
            return severity;
        }

        private static String validateStatus(String status) {
            Preconditions.checkNotNull(status, "status cannot be null");
            Preconditions.checkArgument(org.sonar.api.issue.Issue.STATUSES.contains(status), String.format("status '%s' is invalid", status));
            return status;
        }

        private static RuleType validateType(RuleType type) {
            Preconditions.checkNotNull(type, "type cannot be null");
            return type;
        }

        public Issue build() {
            Builder.validateKey(this.key);
            Builder.validateResolution(this.resolution);
            Builder.validateSeverity(this.severity);
            Builder.validateStatus(this.status);
            Builder.validateRuleKey(this.ruleKey);
            Builder.validateType(this.type);
            return new TestIssue(this);
        }
    }
}

