/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.jms.WikittyActionMessage;
import org.sharengo.wikitty.jms.WikittyJMSUtil;

public class WikittyExtensionSubscriberJMS
implements MessageListener {
    private static final Log log = LogFactory.getLog(WikittyExtensionSubscriberJMS.class);
    protected final TopicConnectionFactory connectionFactory;
    protected final TopicConnection topicConnection;
    protected final Topic topic;
    protected final TopicSession topicSession;
    protected final TopicSubscriber topicSubscriber;
    protected final WikittyExtensionStorage delegateExtensionStorage;

    public WikittyExtensionSubscriberJMS(WikittyExtensionStorage delegateExtensionStorage, Properties properties) throws NamingException, JMSException {
        if (delegateExtensionStorage == null) {
            throw new IllegalArgumentException("delegateExtensionStorage is null");
        }
        this.delegateExtensionStorage = delegateExtensionStorage;
        this.topic = new ActiveMQTopic("WikittyExtensionStorageTopic");
        String provider = properties.getProperty("java.naming.provider.url");
        this.connectionFactory = new ActiveMQConnectionFactory(provider);
        this.topicConnection = this.connectionFactory.createTopicConnection();
        this.topicConnection.setClientID("WikittyExtensionSubscriberJMS");
        this.topicSession = this.topicConnection.createTopicSession(true, 0);
        this.topicSubscriber = this.topicSession.createDurableSubscriber(this.topic, "WikittyExtensionSubscriberJMS");
        this.topicSubscriber.setMessageListener((MessageListener)this);
    }

    public void start() throws Exception {
        this.topicConnection.start();
    }

    public void stop() throws Exception {
        this.topicConnection.stop();
    }

    public void close() throws JMSException {
        this.topicConnection.close();
    }

    protected void finalize() throws Throwable {
        this.topicConnection.close();
    }

    public void onMessage(Message message) {
        WikittyTransaction transaction = new WikittyTransaction();
        boolean sessionCommit = false;
        try {
            transaction.begin();
            if (log.isDebugEnabled()) {
                WikittyJMSUtil.logMessageHeaders(log, message);
            }
            if (!(message instanceof ObjectMessage)) {
                throw new WikittyException("Unsupported message: " + message.getClass().getName());
            }
            WikittyActionMessage actionMessage = WikittyActionMessage.createReceiveMessage((ObjectMessage)message);
            this.onActionMessage(transaction, actionMessage);
            transaction.commit();
            sessionCommit = true;
        }
        catch (Exception e) {
            log.error((Object)"Exception while message dispatch", (Throwable)e);
            try {
                transaction.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception while transaction rollback", (Throwable)e1);
            }
            try {
                this.topicSession.rollback();
            }
            catch (JMSException e1) {
                log.error((Object)"JMSException while session rollback", (Throwable)e1);
            }
        }
        if (sessionCommit) {
            try {
                this.topicSession.commit();
            }
            catch (JMSException e) {
                log.error((Object)"JMSException while session commit", (Throwable)e);
            }
        }
    }

    protected void onActionMessage(WikittyTransaction transaction, WikittyActionMessage message) {
        block4: {
            try {
                String action = message.getAction();
                if ("store".equals(action)) {
                    this.actionStore(transaction, message);
                    break block4;
                }
                if ("clear".equals(action)) {
                    this.actionClear(transaction, message);
                    break block4;
                }
                throw new UnsupportedOperationException("Unsupported action: " + action);
            }
            catch (Exception e) {
                throw new WikittyException(e);
            }
        }
    }

    protected void actionStore(WikittyTransaction transaction, WikittyActionMessage message) throws JMSException {
        ArrayList extensions = (ArrayList)message.getParameter("extensions");
        this.delegateExtensionStorage.store(transaction, (Collection)extensions);
    }

    protected void actionClear(WikittyTransaction transaction, WikittyActionMessage message) {
        this.delegateExtensionStorage.clear(transaction);
    }
}

