/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.renderer.ErrorJsonResult;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class JsonErrorExceptionResult
extends ErrorJsonResult {
    private final ErrorCodes errorCodes;
    private final String exceptionName;

    public JsonErrorExceptionResult(String exceptionName, String responseOn) {
        super(responseOn);
        this.exceptionName = exceptionName.substring(1);
        this.errorCodes = new ErrorCodes();
    }

    @Override
    public void render(HttpRequest request, HttpResponse response, RestishHandler handler) throws Exception {
        Response res = this.prepareResponseObject(request);
        request.setAttribute(this.propertyName, res);
        super.render(request, response, handler);
    }

    public Response prepareResponseObject(HttpRequest request) throws JSONException {
        Throwable thrown = (Throwable)request.getAttribute(this.exceptionName);
        Response res = new Response();
        res.setStatus(this.errorCodes.toStatusCode(thrown));
        res.setState(this.errorCodes.toState(res.getStatus()));
        String sessionId = HttpSessionId.getSessionId((String)request.getUri());
        res.setSessionId(sessionId != null ? sessionId : "");
        if (thrown != null) {
            String raw = new BeanToJsonConverter().convert((Object)thrown);
            JSONObject error = new JSONObject(raw);
            error.put("screen", request.getAttribute("screen"));
            res.setValue((Object)error);
        }
        return res;
    }
}

