/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.client.AdapterFactory;
import org.openqa.selenium.docker.client.ApiVersionAdapter;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class InspectContainer {
    private static final Logger LOG = Logger.getLogger(InspectContainer.class.getName());
    private static final Json JSON = new Json();
    private final HttpHandler client;
    private final String apiVersion;
    private final ApiVersionAdapter adapter;

    public InspectContainer(HttpHandler client, String apiVersion) {
        this(client, apiVersion, AdapterFactory.createAdapter(apiVersion));
    }

    public InspectContainer(HttpHandler client, String apiVersion, ApiVersionAdapter adapter) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
        this.adapter = (ApiVersionAdapter)Require.nonNull((String)"API version adapter", (Object)adapter);
    }

    public ContainerInfo apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        HttpResponse res = this.client.execute((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/containers/%s/json", this.apiVersion, id)).addHeader("Content-Type", "text/plain"));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to inspect container " + String.valueOf(id));
        }
        Map<String, Object> rawInspectInfo = (Map<String, Object>)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
        rawInspectInfo = this.adapter.adaptContainerInspectResponse(rawInspectInfo);
        Map networkSettings = (Map)rawInspectInfo.get("NetworkSettings");
        Map networks = (Map)networkSettings.get("Networks");
        Map.Entry firstNetworkEntry = networks.entrySet().iterator().next();
        Map networkValues = (Map)firstNetworkEntry.getValue();
        String networkName = (String)firstNetworkEntry.getKey();
        String ip = networkValues.get("IPAddress").toString();
        ArrayList mounts = (ArrayList)rawInspectInfo.get("Mounts");
        List<Map<String, Object>> mountedVolumes = mounts.stream().map(mount -> (Map)mount).collect(Collectors.toList());
        Map<String, Object> hostConfig = rawInspectInfo.getOrDefault("HostConfig", Collections.emptyMap());
        Map config = rawInspectInfo.getOrDefault("Config", Collections.emptyMap());
        Map<String, String> labels = config.getOrDefault("Labels", Collections.emptyMap());
        return new ContainerInfo(id, ip, mountedVolumes, networkName, hostConfig, labels);
    }
}

