/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.FirefoxWebElement;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final boolean DEFAULT_ENABLE_NATIVE_EVENTS = Platform.getCurrent().is(Platform.WINDOWS);
    public static final boolean ACCEPT_UNTRUSTED_CERTIFICATES = true;
    public static final boolean ASSUME_UNTRUSTED_ISSUER = true;
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxBinary(), null);
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxBinary(), profile);
    }

    public FirefoxDriver(Capabilities capabilities) {
        this(FirefoxDriver.getBinary(capabilities), FirefoxDriver.extractProfile(capabilities));
    }

    private static FirefoxProfile extractProfile(Capabilities capabilities) {
        FirefoxProfile profile = new FirefoxProfile();
        if (capabilities.getCapability(PROFILE) != null) {
            Object raw = capabilities.getCapability(PROFILE);
            if (raw instanceof FirefoxProfile) {
                profile = (FirefoxProfile)raw;
            } else if (raw instanceof String) {
                try {
                    profile = FirefoxProfile.fromJson((String)raw);
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }
        if (capabilities.getCapability("proxy") != null) {
            Proxy proxy = Proxies.extractProxy((Capabilities)capabilities);
            profile.setProxyPreferences(proxy);
        }
        if (capabilities.getCapability("acceptSslCerts") != null) {
            Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
            profile.setAcceptUntrustedCertificates(acceptCerts);
        }
        return profile;
    }

    private static FirefoxBinary getBinary(Capabilities capabilities) {
        if (capabilities.getCapability(BINARY) != null) {
            File file = new File((String)capabilities.getCapability(BINARY));
            return new FirefoxBinary(file);
        }
        return new FirefoxBinary();
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        super((CommandExecutor)new LazyCommandExecutor(binary, profile), (Capabilities)DesiredCapabilities.firefox());
        this.binary = binary;
        this.setElementConverter(new JsonToWebElementConverter(this){

            protected RemoteWebElement newRemoteWebElement() {
                return new FirefoxWebElement(FirefoxDriver.this);
            }
        });
    }

    protected void startClient() {
        LazyCommandExecutor exe = (LazyCommandExecutor)this.getCommandExecutor();
        FirefoxProfile profileToUse = this.getProfile(exe.profile);
        profileToUse.addWebDriverExtensionIfNeeded();
        ExtensionConnection connection = this.connectTo(exe.binary, profileToUse, "localhost");
        exe.setConnection(connection);
        try {
            connection.start();
        }
        catch (IOException e) {
            throw new WebDriverException("An error occurred while connecting to Firefox", (Throwable)e);
        }
    }

    private FirefoxProfile getProfile(FirefoxProfile profile) {
        FirefoxProfile profileToUse = profile;
        String suggestedProfile = System.getProperty("webdriver.firefox.profile");
        if (profileToUse == null && suggestedProfile != null) {
            profileToUse = new ProfilesIni().getProfile(suggestedProfile);
            if (profileToUse == null) {
                throw new WebDriverException("Firefox profile '" + suggestedProfile + "' named in system property 'webdriver.firefox.profile' not found");
            }
        } else if (profileToUse == null) {
            profileToUse = new FirefoxProfile();
        }
        return profileToUse;
    }

    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        Lock lock = this.obtainLock();
        try {
            FirefoxBinary bin = binary == null ? new FirefoxBinary() : binary;
            NewProfileExtensionConnection newProfileExtensionConnection = new NewProfileExtensionConnection(lock, bin, profile, host);
            return newProfileExtensionConnection;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    protected Lock obtainLock() {
        return new SocketLock();
    }

    protected void stopClient() {
        ((LazyCommandExecutor)this.getCommandExecutor()).quit();
    }

    protected FirefoxWebElement newRemoteWebElement() {
        return new FirefoxWebElement(this);
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    @Deprecated
    public void saveScreenshot(File pngFile) {
        if (pngFile == null) {
            throw new IllegalArgumentException("Method parameter pngFile must not be null");
        }
        File tmpfile = (File)this.getScreenshotAs(OutputType.FILE);
        File dir = pngFile.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new WebDriverException("Could not create directory " + dir.getAbsolutePath());
        }
        try {
            FileHandler.copy((File)tmpfile, (File)pngFile);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private static class LazyCommandExecutor
    implements CommandExecutor {
        private ExtensionConnection connection;
        private final FirefoxBinary binary;
        private final FirefoxProfile profile;

        private LazyCommandExecutor(FirefoxBinary binary, FirefoxProfile profile) {
            this.binary = binary;
            this.profile = profile;
        }

        public void setConnection(ExtensionConnection connection) {
            this.connection = connection;
        }

        public void quit() {
            if (this.connection != null) {
                this.connection.quit();
                this.connection = null;
            }
        }

        public Response execute(Command command) throws IOException {
            if (this.connection == null) {
                if (command.getName().equals("quit")) {
                    return null;
                }
                throw new WebDriverException("The FirefoxDriver cannot be used after quit() was called.");
            }
            return this.connection.execute(command);
        }
    }
}

